PROGRAM PlayAMD;

USES CRT;


{$F+}
{$L AMDOBJ.OBJ}
PROCEDURE _AdlibPlayer; near; EXTERNAL;
PROCEDURE _StopAdlib; near; EXTERNAL;
PROCEDURE _InitAdlib; near; EXTERNAL;
{$F-}


type AMD_Song = record
              filename : string;
              filesize : integer;
              SongOK   : boolean;
              Song     : pointer;
              MyBuff   : pointer;
     end;

var Musik : AMD_Song;


PROCEDURE LoadSong (VAR Dest : AMD_Song);
  VAR F : FILE;
  BEGIN
    ASSIGN (F,Dest.Filename);
    {$I-} RESET (F,1); {$I+}
    IF IORESULT <> 0
      THEN Dest.SongOK := FALSE
      ELSE
        BEGIN
          Dest.filesize := FILESIZE (F);
          GETMEM (Dest.Song,Dest.filesize);
          GETMEM (Dest.MyBuff,1314);
          BLOCKREAD (F,Dest.Song^,Dest.filesize);
          Dest.SongOK := TRUE;
          CLOSE (F)
        END
  END;

PROCEDURE ClearSong (VAR Dest : AMD_Song);
  BEGIN
    Dest.SongOK := FALSE;
    FREEMEM (Dest.Song,Dest.filesize);
    FREEMEM (Dest.MyBuff,1314);
    Dest.filesize := 0
  END;

var i : byte;


BEGIN
  IF PARAMCOUNT = 1
    THEN
      BEGIN
        Musik.filename := PARAMSTR (1);
        LoadSong (Musik);
        IF Musik.SongOK
          THEN
            BEGIN
              writeln('AMD Player (Pascal Interface)');
              asm
                 push   ds
                 push   es
                 les    di,Musik.MyBuff
                 lds    si,Musik.Song
                 xor    al,al           (* irqmode!! *)
                 call   _InitAdlib
                 pop    es
                 pop    ds
              end;
              repeat until keypressed;

              asm
                 call   _StopAdlib
              end;

              ClearSong (Musik);
            END
          ELSE
            BEGIN
              WRITELN ('ERROR: Couldn''t find the specified file!');
            END;
      END
    ELSE
      BEGIN
        WRITELN ('ERROR: Syntax is PLAYAMD filename.amd !');
      END;
END.
