#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "file.h"
#include "key.h"
#include "copro.h"
#include "rxm.h"

//#define WAV_CONVERT

int dflags = df16bit | dfStereo;
int vol = 12*8;
int amp = 0;
int mixrate = 44100;
int iwflag = 1;
int mastervol = 0;
int maxpat = 0;
int rxmconvert = 0;

//extern char mucke;


float U[] = {
  0.124996, -0.250000, 0.249061, -0.234831,
  0.176782, -0.085736, 0.021643, -0.001933};

#define PBlocks 16
typedef struct {
  float C[512];
  float M[32][64];
  float buf[512];
  float st[PBlocks][32];
} tpackdata;

struct tsearch search;
file f;
char *tune;
tpackdata packdata;

void *allocmem(int size) {
  void * mem;
  mem = (void *) malloc(size);
  if (!mem) m_err();
  return (mem);
};

void m_err() {
  printf("Out of memory!");
  exit(1);
};


int parse(char *s, int mul) {
  int r = 0;

  while (*s && (*s < '0' || *s > '9')) s++;
  while (*s >= '0' && *s <= '9') {
    r *= mul;
    r += *s - '0';
    s++;
  }
  return r;
}


int checkenv(tdinfo *dinfo) {
  int i;
  i = dinfo->base >= 0x200 && dinfo->base <= 0x290;
  i &= dinfo->irq >= 2 && dinfo->irq <= 15;
  i &= dinfo->dma1 <= 7;
  i &= dinfo->dma2 <= 7;
  return i;
}

int gusenv(tdinfo *dinfo, int flags, int iwflag) {
  char *s;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("ULTRASND");
  dinfo->base = parse(s,16);
  s = strchr(s,',');
  if (!s) return 0;
  dinfo->dma1 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->dma2 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->irq = parse(s,10);

  if (iwflag >= 2 || (iwflag == 1 && getenv("INTERWAVE"))) dinfo->flags |= gus_iw;
  dinfo->flags |= flags;

  return checkenv(dinfo);
}

int sbenv(tdinfo *dinfo, int rate, int flags) {
  char *s;
  char *v;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("BLASTER");
  v = strchr(s,'A');
  if (v) dinfo->base = parse(v,16);
  v = strchr(s,'I');
  if (v) dinfo->irq = parse(v,10);
  v = strchr(s,'D');
  if (!v) return 0;
  dinfo->dma1 = parse(v,10);
  v = strchr(s,'H');
  if (v) dinfo->dma2 = parse(v,10);
  dinfo->rate = rate;
  dinfo->flags = flags;
  return checkenv(dinfo);
}


void initdepack(tpackdata *p) {
  int i, k, n;
  float DO, f;

  //calc C
  DO = 2.0*pi/512.0;
  for (k = 0; k < 512; k++) {
    f = 0.0;
    for (n = 0; n < 8; n++) f += U[n]*cos((k)*n*DO);
    if (k & 64) f = -f;
    p->C[k] = f;
  }

  //calc M
  for (i = 0; i < 32; i++) {
    for (k = 0; k < 64; k++) {
      p->M[i][k] = cos((2*i + 1)*(k - 16)*pi/64.0);
    }
  }

  memset(p->buf,0,512*4);
}

int readst(tpackdata *p, signed char *pdata, int blocks) {
  signed char *pbegin;
  int ctrl1, ctrl2, ctrl3;
  int i, z, bit;
  int bits, shift;//, mask;
  int c, s;
  signed char byte;

  pbegin = pdata;

  ctrl1 = *(int *) pdata;
  pdata += 4;
  ctrl2 = *(int *) pdata;
  pdata += 4;
  ctrl3 = *(int *) pdata;
  pdata += 4;

  for (i = 0; i < 32; i++) {
    bit = 1 << i;

    if (ctrl1 & bit && ctrl2 & bit) {
      bits = 4;
      shift = 4;
    } else if (ctrl1 & bit && ctrl3 & bit) {
      bits = 4;
      shift = 3;
    } else if (ctrl2 & bit && ctrl3 & bit) {
      bits = 4;
      shift = 2;
    } else if (ctrl1 & bit) {
      bits = 2;//4;
      shift = 2;//1;
    } else if (ctrl2 & bit) {
      bits = 2;
      shift = 1;
    } else if (ctrl3 & bit) {
      bits = 2;
      shift = 0;
    } else {
      bits = 0;
    }

    if (bits > 0) {
      c = 0;
      for (z = 0; z < blocks; z++) {
        if (c == 0) {
          byte = *pdata;
          pdata++;
          c = 8;
        }
        c -= bits;
        s = byte;
        s = (((s << bits) & ~0xFF) | 0x80) << shift;
        p->st[z][i] = s/256.0;
        byte <<= bits;
      }
    } else {
      for (z = 0; z < blocks; z++) p->st[z][i] = 0.0;
    }
  }

  return pdata - pbegin;
}

void calcout(tpackdata *p, float *st) {
  int k, i, j;
  float f;

  for (k = 0; k < 64; k++) {
    f = 0.0;
    for (i = 0; i < 32; i++) f += st[i]*p->M[i][k];
    for (j = 0; j < 8; j++) p->buf[k + 64*j] += p->C[k + 64*j]*f;
  }
}

void depack(tpackdata *p, char *tune) {
  int datalen;
  int blocks;
  signed char *pdata;
  signed char *sdata, *sdpos;
  int stpos, z, s;

  datalen = *(int *) tune;
  blocks = *(int *) (tune + 4 + datalen);
  pdata = (signed char *) (tune + 4 + datalen + 4);

  sdpos = sdata = (signed char *) allocmem(blocks*32);

  initdepack(p);

  stpos = PBlocks;
  while (blocks > 0) {
    if (stpos == PBlocks) {
      pdata += readst(p,pdata,(blocks > PBlocks) ? PBlocks : blocks);
      stpos = 0;
    }

    calcout(p,p->st[stpos]);
    for (z = 0; z < 32; z++) {
      s = floor(p->buf[511 - z]);
      if (s > 127) s = 127;
      if (s < -128) s = -128;
//printf("%4d",s);
      *sdpos = s;
      sdpos++;
    }
    for (z = 512 - 32 - 1; z >= 0; z--) {
      p->buf[z + 32] = p->buf[z];
    }
    for (z = 0; z < 32; z++) p->buf[z] = 0.0;

    stpos++;
    blocks--;
  }

  //write samples
//  f_open(&f,"samples.raw",ofCreate);
//  f_write(&f,sdata,sdpos - sdata);
  //read samples
//  f_open(&f,"samples.raw",ofRead);
//  f_read(&f,sdata,blocks*32);

//  f_close(&f);

  rxmplay(tune + 4,sdata);
}


int playrxm() {
  int t;
  tdinfo dinfo;
  void *drv_mem = NULL;
  int c;

  rxminit();

  t = 0;
  //gus
  if (gusenv(&dinfo,dflags,iwflag)) t = u_test(&dinfo);
  //sb
  if (!t && sbenv(&dinfo,mixrate,dflags)) {
    if (dflags & sb_awe) t = a_test(&dinfo);
    if (!t) t = sb_test(&dinfo);
  }
  //no sound
  if (!t) n_test(&dinfo);

  if (dinfo.mem) drv_mem = allocmem(dinfo.mem);
  if (dinfo.dmabuf) {
    if (!(dinfo.dmabuf = getdmabuf(dinfo.dmabuf))) {
      printf("Not enough low mem");
      exit(1);
    }
  }

  dinfo.mastervol = mastervol;

  i8_init();
  t = rxmdevinit(&dinfo,drv_mem);
  if (t) {
    if (t == 1) printf("DMA error\n");
    if (t == 2) printf("IRQ error\n");
    i8_done();
    exit(1);
  }


  rxmsetvol(vol);
//  rxmplay(&mucke,0);
  depack(&packdata,tune);

  do {
    c = readchar();
    switch (c) {
     case -75 : rxmskip(-1);
                break;
     case -77 : rxmskip(1);
                break;
    }
  } while (c != 27 && c != 32);
  rxmstop(xmStop);


  rxmdevdone();
  i8_done();

  if (drv_mem) free(drv_mem);
  freedmabuf();

  return c;
}

void main(int argc, char**argv) {
  int doserr;

  doserr = f_findfirst((argc < 2) ? "2nd_pm.bin" : argv[1],faArchive,&search);
  if (!doserr) {
    tune = allocmem(search.size);
    f_open(&f,search.name,ofRead);
    f_read(&f,tune,search.size);
    f_close(&f);

    playrxm();
  }
}
