	INCLUDE equates.h

	EXPORT hvl_mixchunk_ch0_asm
	EXPORT hvl_mixchunk_asm
	EXPORT hvl_downsample_asm
	EXPORT hvl_malloc
	EXPORT hvl_free


	AREA rom_code, CODE, READONLY

;@----------------------------------------------------------------------------
hvl_mixchunk_ch0_asm	;@ struct hvl_voice *hv, uint32 const samples, int32 *buf
;@----------------------------------------------------------------------------
	ldr r12,=mix_test_ch0
	bx r12
;@----------------------------------------------------------------------------
hvl_mixchunk_asm		;@ struct hvl_voice *hv, uint32 const samples, int32 *buf
;@----------------------------------------------------------------------------
	ldr r12,=mix_test
	bx r12
;@----------------------------------------------------------------------------
hvl_downsample_asm		;@ uint32 const samples, int8 *buf1, int8 *buf2, int32 *mixbuf
;@----------------------------------------------------------------------------
	ldr r12,=downsample_test
	bx r12
;@----------------------------------------------------------------------------
hvl_malloc	; in r0 = size, out  r0 = mem pointer
;@----------------------------------------------------------------------------
	mov r11,r11
	mov r0,#0x02000000
	add r0,r0,#0x2000
	bx lr
;@----------------------------------------------------------------------------
hvl_free	; r0 = mem pointer
;@----------------------------------------------------------------------------
	mov r11,r11
	bx lr
;@----------------------------------------------------------------------------




	AREA wram_code2, CODE, READWRITE

;@----------------------------------------------------------------------------
;hvl_mixchunk_asm	;@ struct hvl_voice *hv, uint32 const samples, int32 *buf, int32 mixgain
;@----------------------------------------------------------------------------
mix_test
	stmfd sp!,{r4-r11,lr}

	add r0,r0,#0x24				;@ go to vc_SamplePos
	ldmia r0,{r4-r12}			;@ samplepos, delta, mixsource, ringsamplepos, ringdelta, ringmixsource, panmultleft, panmultright, volume
	and r12,r12,#0xFF
	mul r3,r12,r3				;@  8bit x 8bit = 16bit
	mul r10,r3,r10				;@ 16bit x 6bit = 22bit
	mul r11,r3,r11

	cmp r9,#0
	beq mixloop
	mov r10,r10,asr#7
	mov r11,r11,asr#7
ringmodloop
	add r3,r6,r4,lsr#16
	ldrsb r3,[r3]

	add r4,r4,r5
	cmp r4,#0x2800000
	subpl r4,r4,#0x2800000
	add r12,r9,r7,lsr#16
	ldrsb r12,[r12]

	add r7,r7,r8
	cmp r7,#0x2800000
	subpl r7,r7,#0x2800000
	mul r3,r12,r3

	ldr r12,[r2,#WAVBUFSIZE*4]
	mla r12,r11,r3,r12
	str r12,[r2,#WAVBUFSIZE*4]
	ldr r12,[r2]
	mla r12,r10,r3,r12
	str r12,[r2],#4
	subs r1,r1,#1
	bne ringmodloop
	str r7,[r0,#12]
	b mixend

mixloop
	add r3,r6,r4,lsr#16
	ldrsb r3,[r3]

	add r4,r4,r5
	cmp r4,#0x2800000
	subpl r4,r4,#0x2800000

	ldr r12,[r2,#WAVBUFSIZE*4]
	mla r12,r11,r3,r12
	str r12,[r2,#WAVBUFSIZE*4]
	ldr r12,[r2]
	mla r12,r10,r3,r12
	str r12,[r2],#4
	subs r1,r1,#1
	bne mixloop
mixend
	str r4,[r0,#0]

	ldmfd sp!,{r4-r11,lr}
	bx lr
;@----------------------------------------------------------------------------
;hvl_mixchunk_ch0_asm	;@ struct hvl_voice *hv, uint32 const samples, int32 *buf, int32 mixgain
;@----------------------------------------------------------------------------
mix_test_ch0
	stmfd sp!,{r4-r11,lr}

	add r0,r0,#0x24				;@ go to vc_SamplePos
	ldmia r0,{r4-r12}			;@ samplepos, delta, mixsource, ringsamplepos, ringdelta, ringmixsource, panmultleft, panmultright, volume
	and r12,r12,#0xFF
	mul r3,r12,r3				;@  8bit x 8bit = 16bit
	mul r10,r3,r10				;@ 16bit x 6bit = 22bit
	mul r11,r3,r11

	cmp r9,#0
	beq mixloop0
	mov r10,r10,asr#7
	mov r11,r11,asr#7
ringmodloop0
	add r3,r6,r4,lsr#16
	ldrsb r3,[r3]

	add r4,r4,r5
	cmp r4,#0x2800000
	subpl r4,r4,#0x2800000

	add r12,r9,r7,lsr#16
	ldrsb r12,[r12]

	add r7,r7,r8
	cmp r7,#0x2800000
	subpl r7,r7,#0x2800000
	mul r3,r12,r3			;@ 7bit x 7bit = 14bit

	mul r12,r11,r3
	str r12,[r2,#WAVBUFSIZE*4]
	mul r3,r10,r3
	str r3,[r2],#4
	subs r1,r1,#1
	bne ringmodloop0
	str r7,[r0,#12]
	b mixend0

mixloop0
	add r3,r6,r4,lsr#16
	ldrsb r3,[r3]			;@ 7bit

	add r4,r4,r5
	cmp r4,#0x2800000
	subpl r4,r4,#0x2800000

	mul r12,r11,r3
	str r12,[r2,#WAVBUFSIZE*4]
	mul r3,r10,r3
	str r3,[r2],#4
	subs r1,r1,#1
	bne mixloop0
mixend0
	str r4,[r0,#0]

	ldmfd sp!,{r4-r11,lr}
	bx lr
;@----------------------------------------------------------------------------
;hvl_downsample_asm	; uint32 samples, int8 *buf1, int8 *buf2, int32 *mixbuf
;@----------------------------------------------------------------------------
downsample_test

down_loop
	ldr r12,[r3,#WAVBUFSIZE*4]
	mov r12,r12,asr#23			;@ should this be 24?
	strb r12,[r2],#1
	ldr r12,[r3],#4
	mov r12,r12,asr#23			;@ should this be 24?
	strb r12,[r1],#1
	subs r0,r0,#1
	bne down_loop

	bx lr

;@----------------------------------------------------------------------------
	END
