;**************************************************************************
;*	mini player de mod sur le PC speaker ou le port parallle
;*
;* Programm par Sbastien Granjoux
;* Commenc en fvrier 93
;* Dernire modif 11/01/93


IDEAL

P386N
MODEL	SMALL

PUBLIC	main
PUBLIC	CHRONO


EXTRN	putbar:near
EXTRN	puttxt:near
EXTRN	setmode:near
EXTRN	resetmode:near
EXTRN	getname:near
EXTRN	getinst:near
EXTRN	getdevice:near
EXTRN	getmaxseq:near
EXTRN	dectostr:near
EXTRN	gettempo:near
EXTRN	getpattern:near
EXTRN	getvoice:near
EXTRN	gonextpos:near

EXTRN	CHANGEVOL:far
EXTRN	DETECTSND:far
EXTRN	MLOADMOD:far
EXTRN	FLOADMOD:far
EXTRN	OLOADMOD:far
EXTRN	UNLOADMOD:far
EXTRN	SETMOD:far
EXTRN	MAKEMOD:far
EXTRN	STARTMOD:far
EXTRN	STOPMOD:far
EXTRN	Timer:dword
EXTRN	Nb_voice:far

INCLUDE "CRYSTAL.INC"

DATASEG

VERSION_MSG	DB 0,0,1bh,'Crystal Player Version 2.50 Programm par Sbastien Granjoux         le 11/01/95',0
MUSIQUE_MSG	DB 2,1,07h,'Musique :',0
MUSIQUE_NAME	DB 12,1,0bh,'                    ',0
DEVICE_MSG	DB 34,1,07h,'Sur',0
DEVICE_NAME	DB 38,1,0bh,'                                ',0
PATTERN_MSG	DB 2,2,07h,'Pattern :',0
PATTERN_NB	DB 12,2,0bh,'  4',0
SEQUENCE_MSG	DB 16,2,07h,'Sequence :',0
SEQUENCE_NB	DB 27,2,0bh,'  2/  8',0
LIGNE_MSG	DB 36,2,07h,'Ligne :',0
LIGNE_NB	DB 43,2,0bh,' 12',0
TEMPO_MSG	DB 48,2,07h,'Tempo :',0
TEMPO_NB	DB 55,2,0bh,' 32/125',0
VOICE_BOX1	DB 0,03,9h,'Ŀ',0
VOICE_BOX2	DB 0,04,9h,'                                                                          ',0
VOICE_BOX3	DB 0,05,9h,'                                                                          ',0
VOICE_BOX4	DB 0,06,9h,'                                                                          ',0
VOICE_BOX5	DB 0,07,9h,'                                                                          ',0
VOICE_BOX6	DB 0,08,9h,'                                                                          ',0
VOICE_BOX7	DB 0,09,9h,'                                                                          ',0
VOICE_BOX8	DB 0,10,9h,'                                                                          ',0
VOICE_BOX9	DB 0,11,9h,'                                                                          ',0
VOICE_BOX10	DB 0,12,9h,'',0
INSTRUMENTV1	DB 2,04,0fh,'                      ',0
VOLUMEV1	DB 26,04,03h,' 64',0
NOTEV1		DB 32,04,0ah,'   ',0
EFFETV1		DB 38,04,05h,'                ',0
INSTRUMENTV2	DB 2,05,0fh,'                      ',0
VOLUMEV2	DB 26,05,03h,' 64',0
NOTEV2		DB 32,05,0ah,'   ',0
EFFETV2		DB 38,05,05h,'                ',0
INSTRUMENTV3	DB 2,06,0fh,'                      ',0
VOLUMEV3	DB 26,06,03h,' 64',0
NOTEV3		DB 32,06h,0ah,'   ',0
EFFETV3		DB 38,06,05h,'                ',0
INSTRUMENTV4	DB 2,07,0fh,'                      ',0
VOLUMEV4	DB 26,07,03h,' 64',0
NOTEV4		DB 32,07,0ah,'   ',0
EFFETV4		DB 38,07,05h,'                ',0
INSTRUMENTV5	DB 2,08,0fh,'                      ',0
VOLUMEV5	DB 26,08,03h,' 64',0
NOTEV5		DB 32,08,0ah,'   ',0
EFFETV5		DB 38,08,05h,'                ',0
INSTRUMENTV6	DB 2,09,0fh,'                      ',0
VOLUMEV6	DB 26,09,03h,' 64',0
NOTEV6		DB 32,09,0ah,'   ',0
EFFETV6		DB 38,09,05h,'                ',0
INSTRUMENTV7	DB 2,10,0fh,'                      ',0
VOLUMEV7	DB 26,10,03h,' 64',0
NOTEV7		DB 32,10,0ah,'   ',0
EFFETV7		DB 38,10,05h,'                ',0
INSTRUMENTV8	DB 2,11,0fh,'                      ',0
VOLUMEV8	DB 26,11,03h,' 64',0
NOTEV8		DB 32,11,0ah,'   ',0
EFFETV8		DB 38,11,05h,'                ',0
AIDES		DB 0,24,1bh,'      Sortir du programme      Stopper la musique         Changer de position   ',0
AIDES_PAUSED	DB 0,24,1bh,'      Sortir du programme      Reprendre la musique       Changer de position   ',0
STOPPER		DB 2,24,1ah,'Esc',0
PAUSER		DB 29,24,1ah,'P',0
CHANGER		DB 56,24,1ah,'+',0
INSTRUMENT1	DB 4,13,0bh,'instrument1           ',0
INSTRUMENT2	DB 4,14,0bh,'instrument2           ',0
INSTRUMENT3	DB 4,15,0bh,'instrument3           ',0
INSTRUMENT4	DB 4,16,0bh,'instrument4           ',0
INSTRUMENT5	DB 4,17,0bh,'instrument5           ',0
INSTRUMENT6	DB 4,18,0bh,'instrument6           ',0
INSTRUMENT7	DB 4,19,0bh,'instrument7           ',0
INSTRUMENT8	DB 4,20,0bh,'instrument8           ',0
INSTRUMENT9	DB 4,21,0bh,'instrument9           ',0
INSTRUMENT10	DB 4,22,0bh,'instrument10          ',0
INSTRUMENT11	DB 4,23,0bh,'instrument11          ',0
INSTRUMENT12	DB 31,13,0bh,'instrument12          ',0
INSTRUMENT13	DB 31,14,0bh,'instrument13          ',0
INSTRUMENT14	DB 31,15,0bh,'instrument14          ',0
INSTRUMENT15	DB 31,16,0bh,'instrument15          ',0
INSTRUMENT16	DB 31,17,0bh,'instrument16          ',0
INSTRUMENT17	DB 31,18,0bh,'instrument17          ',0
INSTRUMENT18	DB 31,19,0bh,'instrument18          ',0
INSTRUMENT19	DB 31,20,0bh,'instrument19          ',0
INSTRUMENT20	DB 31,21,0bh,'instrument20          ',0
INSTRUMENT21	DB 31,22,0bh,'instrument21          ',0
INSTRUMENT22	DB 58,13,0bh,'instrument22          ',0
INSTRUMENT23	DB 58,14,0bh,'instrument23          ',0
INSTRUMENT24	DB 58,15,0bh,'instrument24          ',0
INSTRUMENT25	DB 58,16,0bh,'instrument25          ',0
INSTRUMENT26	DB 58,17,0bh,'instrument26          ',0
INSTRUMENT27	DB 58,18,0bh,'instrument27          ',0
INSTRUMENT28	DB 58,19,0bh,'instrument28          ',0
INSTRUMENT29	DB 58,20,0bh,'instrument29          ',0
INSTRUMENT30	DB 58,21,0bh,'instrument30          ',0
INSTRUMENT31	DB 58,22,0bh,'instrument31          ',0

PAGE2		EQU	200h

NB_MSG		EQU	70+20
NB_REFRESH	EQU	20+16
NB_HELP		EQU	4

LIST_MSG        DW OFFSET PATTERN_NB
		DW OFFSET SEQUENCE_NB
		DW OFFSET LIGNE_NB
		DW OFFSET TEMPO_NB
		DW OFFSET INSTRUMENTV1
		DW OFFSET VOLUMEV1
		DW OFFSET NOTEV1
		DW OFFSET EFFETV1
		DW OFFSET INSTRUMENTV2
		DW OFFSET VOLUMEV2
		DW OFFSET NOTEV2
		DW OFFSET EFFETV2
		DW OFFSET INSTRUMENTV3
		DW OFFSET VOLUMEV3
		DW OFFSET NOTEV3
		DW OFFSET EFFETV3
		DW OFFSET INSTRUMENTV4
		DW OFFSET VOLUMEV4
		DW OFFSET NOTEV4
		DW OFFSET EFFETV4
		DW OFFSET INSTRUMENTV5
		DW OFFSET VOLUMEV5
		DW OFFSET NOTEV5
		DW OFFSET EFFETV5
		DW OFFSET INSTRUMENTV6
		DW OFFSET VOLUMEV6
		DW OFFSET NOTEV6
		DW OFFSET EFFETV6
                DW OFFSET INSTRUMENTV7
		DW OFFSET VOLUMEV7
		DW OFFSET NOTEV7
		DW OFFSET EFFETV7
		DW OFFSET INSTRUMENTV8
		DW OFFSET VOLUMEV8
		DW OFFSET NOTEV8
		DW OFFSET EFFETV8
		DW OFFSET VOICE_BOX2
		DW OFFSET VOICE_BOX3
		DW OFFSET VOICE_BOX4
		DW OFFSET VOICE_BOX5
                DW OFFSET VOICE_BOX6
		DW OFFSET VOICE_BOX7
		DW OFFSET VOICE_BOX8
		DW OFFSET VOICE_BOX9
		DW OFFSET VERSION_MSG
		DW OFFSET MUSIQUE_MSG
		DW OFFSET MUSIQUE_NAME
		DW OFFSET DEVICE_MSG
		DW OFFSET DEVICE_NAME
		DW OFFSET PATTERN_MSG
		DW OFFSET SEQUENCE_MSG
		DW OFFSET LIGNE_MSG
		DW OFFSET TEMPO_MSG
		DW OFFSET VOICE_BOX1
		DW OFFSET VOICE_BOX10
BARRE_HELP	DW OFFSET AIDES
		DW OFFSET STOPPER
		DW OFFSET PAUSER
		DW OFFSET CHANGER
		DW OFFSET INSTRUMENT1
		DW OFFSET INSTRUMENT2
		DW OFFSET INSTRUMENT3
		DW OFFSET INSTRUMENT4
		DW OFFSET INSTRUMENT5
		DW OFFSET INSTRUMENT6
		DW OFFSET INSTRUMENT7
		DW OFFSET INSTRUMENT8
		DW OFFSET INSTRUMENT9
		DW OFFSET INSTRUMENT10
		DW OFFSET INSTRUMENT11
		DW OFFSET INSTRUMENT12
		DW OFFSET INSTRUMENT13
		DW OFFSET INSTRUMENT14
		DW OFFSET INSTRUMENT15
		DW OFFSET INSTRUMENT16
		DW OFFSET INSTRUMENT17
		DW OFFSET INSTRUMENT18
		DW OFFSET INSTRUMENT19
		DW OFFSET INSTRUMENT20
		DW OFFSET INSTRUMENT21
		DW OFFSET INSTRUMENT22
		DW OFFSET INSTRUMENT23
		DW OFFSET INSTRUMENT24
		DW OFFSET INSTRUMENT25
		DW OFFSET INSTRUMENT26
		DW OFFSET INSTRUMENT27
		DW OFFSET INSTRUMENT28
		DW OFFSET INSTRUMENT29
		DW OFFSET INSTRUMENT30
		DW OFFSET INSTRUMENT31

LIST_NOTES      DB 'C-0',0,'C#0',0,'D-0',0,'D#0',0,'E-0',0,'F-0',0,'F#0',0
		DB 'G-0',0,'G#0',0,'A-0',0,'A#0',0,'B-0',0
		DB 'C-1',0,'C#1',0,'D-1',0,'D#1',0,'E-1',0,'F-1',0,'F#1',0
		DB 'G-1',0,'G#1',0,'A-1',0,'A#1',0,'B-1',0
		DB 'C-2',0,'C#2',0,'D-2',0,'D#2',0,'E-2',0,'F-2',0,'F#2',0
		DB 'G-2',0,'G#2',0,'A-2',0,'A#2',0,'B-2',0,'   ',0

		DB 'C-3',0,'C#3',0,'D-3',0,'D#3',0,'E-3',0,'F-3',0,'F#3',0
		DB 'G-3',0,'G#3',0,'A-3',0,'A#3',0,'B-3',0
		DB 'C-4',0,'C#4',0,'D-4',0,'D#4',0,'E-4',0,'F-4',0,'F#4',0
		DB 'G-4',0,'G#4',0,'A-4',0,'A#4',0,'B-4',0
		DB 'C-5',0,'C#5',0,'D-5',0,'D#5',0,'E-5',0,'F-5',0,'F#5',0
		DB 'G-5',0,'G#5',0,'A-5',0,'A#5',0,'B-5',0,'   ',0

		DB 'C-6',0,'C#6',0,'D-6',0,'D#6',0,'E-6',0,'F-6',0,'F#6',0
		DB 'G-6',0,'G#6',0,'A-6',0,'A#6',0,'B-6',0
		DB 'C-7',0,'C#7',0,'D-7',0,'D#7',0,'E-7',0,'F-7',0,'F#7',0
		DB 'G-7',0,'G#7',0,'A-7',0,'A#7',0,'B-7',0,'   ',0

LIST_EFFET	DB 'ARPEGGIO        '
		DB 'PORTAMENTO UP   '
		DB 'PORTAMENTO DOWN '
		DB 'TONE PORTAMENTO '
		DB 'VIBRATO         '
		DB 'PORTAMENTO+SLIDE'
		DB 'VIBRATO+SLIDE   '
		DB 'TREMOLO         '
		DB 'PHASOR EFFECT   '
		DB 'PLAY SAMPLE PART'
		DB 'VOLUME SLIDE    '
		DB 'POSITION JUMP   '
		DB 'SET VOLUME      '
		DB 'PATTERN BREAK   '
		DB '                '
		DB 'SET SPEED       '
		DB 'SET FILTER      '
		DB 'FINE PORT UP    '
		DB 'FINE PORT DOWN  '
		DB 'SET GLISSANDO   '
		DB 'SET VIBRATO     '
		DB 'SET FINETUNE    '
		DB 'LOOP            '
		DB 'SET TREMOLO     '
		DB 'STOP            '
		DB 'RETTRIG SAMPLE  '
		DB 'FINE SLIDE UP   '
		DB 'FINE SLIDE DOWN '
		DB 'NOTE CUT        '
		DB 'NOTE DELAY      '
		DB 'PATTERN DELAY   '
		DB '                '

PROGRAM_MSG	DB 'Crystal Player V2.50 Par Sbastien Granjoux',09h,09h,09h,09h,'11/01/95',0dh,0ah
		DB 0ah,0dh
		DB 'Ce programme est un freeware permettant de jouer des fichiers MOD.',0ah,0dh
		DB 'La musique peut tre sortie sur le PC speaker, un DAC sur un port parallle,',0ah,0dh
		DB 'une soundblaster ou une Gravis Ultra Sound.',0ah,0dh
		DB 'Il s''utilise de la manire suivante :',0dh,0ah,0dh,0ah
		DB 09h,'CRYS [/SK] [/DCl] [/SBp,i] [GSp] [/FRf] nom du fichier mod',0dh,0ah
                DB 0ah,0dh
                DB 09h,'  /SK permet d''utiliser le speaker',0dh,0ah
		DB 09h,'  /DCl permet d''utiliser un DAC sur le port parallle l(1-4)',0dh,0ah
		DB 09h,'  /SBp,i permet d''utiliser une soundblaster sur le port p avec l''irq i',0dh,0ah
		DB 09h,'  /GSp permet d''utiliser une GUS sur le port p',0dh,0ah
		DB 09h,'  /FRf permet de donner la frquence de mixage en centaine de Hz',0dh,0ah
		DB 0dh,0ah,'Par dfaut le player recherche dans les variables d''environnement la carte',0dh,0ah
                DB 'sonore  utiliser ou les paramtres manquant et joue  19kHZ.',0dh,0ah
		DB 0dh,0ah
		DB '$'


FIRST_ERROR	EQU	1
LAST_ERROR	EQU	17

UNKNOW_ERROR	DB	'Erreur inconnu$'
ERROR1		DB	'Fonction inconnu$'
ERROR2		DB	'Fichier introuvable$'
ERROR3		DB	'Chemin introuvable$'
ERROR4		DB	'Trop de fichier ouvert$'
ERROR5		DB	'Accs refus$'
ERROR6		DB	'Handle inconnu$'
ERROR7		DB	'Bloc de contrle mmoire dtruit$'
ERROR8		DB	'Mmoire insuffisante$'
ERROR9		DB	'Adresse mmoire incorrect$'
ERROR10		DB	'Environnement incorrect$'
ERROR11		DB	'Trop de pattern$'
ERROR12		DB	'Sample trop grand$'
ERROR13		DB	'Port parallle introuvable$'
ERROR14		DB	'Sound blaster introuvable$'
ERROR15		DB	'GUS introuvable$'
ERROR16		DB	'Pas assez de mmoire sur la GUS$'

MSG_ERROR	DW	OFFSET ERROR1
		DW	OFFSET ERROR2
		DW	OFFSET ERROR3
		DW	OFFSET ERROR4
		DW	OFFSET ERROR5
		DW	OFFSET ERROR6
		DW	OFFSET ERROR7
		DW	OFFSET ERROR8
		DW	OFFSET ERROR9
		DW	OFFSET ERROR10
		DW	OFFSET ERROR11
		DW	OFFSET ERROR12
		DW	OFFSET ERROR13
		DW	OFFSET ERROR14
		DW	OFFSET ERROR15
		DW	OFFSET ERROR16
		DW	OFFSET PROGRAM_MSG

BAD_ARG		EQU	17

TNOMBRE         EQU 12

NOMBRE          DB TNOMBRE DUP (0)
		DB '$'

T_INITIAL       DD 0
CHRONO          DD 0
PASSAGE         DD 0
Old_int9	DD 0

Device		DB THE_BEST
Port		DW 0
Irq		DB 0
Dma		DB 0
MixSpeed	DW 0

USINGMSG	DB	'Utilisation $'
DEVICEMSG	DW	OFFSET NOS_DEV,0
		DW	OFFSET SPK_DEV,0
		DW	OFFSET DAC_DEV,1
		DW	OFFSET SB_DEV,3
		DW	OFFSET GUS_DEV,1

NOS_DEV		DB	'd''aucun son $'
SPK_DEV		DB	'du haut parleur interne $'
DAC_DEV		DB	'd''un DAC sur le port parallle $'
SB_DEV		DB	'd''une SoundBlaster  l''adresse $'
GUS_DEV		DB	'd''une Gravis Ultra Sound  l''adresse $'

IRQMSG		DB	' utilisant l''IRQ $'
DMAMSG		DB	' et le DMA 1$'
NEWLINE		DB	0ah,0dh,'$'
GUSMSG		DB	'Chargement des samples ...',0ah,0dh,'$'

Pause		DB 0
MVol		DB 255

Filename	DB 128+4 DUP (0);

CODESEG

PROC	main


	push	es
	push	ds
	pop	es
	pop	ds
	mov	si,80h
	mov	di,OFFSET Filename
	call	getarg
	push	es
	pop	ds
	cmp	al,1
	jae	@@mod_file_ok
	mov	ax,BAD_ARG
	jmp	error
@@mod_file_ok:

	mov	si,OFFSET Filename
	mov	di,si
	mov	bx,OFFSET Irq
@@get_arg:
	lodsb
        cmp	al,'-'
        je	@@get_switch
	cmp	al,','
	je	@@get_sup
        or	al,al
	je	@@line_used

@@get_file:
        stosb
	lodsb
	or	al,al
	jne	@@get_file
        jmp	@@get_arg

@@get_sup:
	mov	ax,BAD_ARG
	cmp	bx,OFFSET Dma
	ja	error
	call	get_dec
	jc	@@no_sup
        mov	[bx],al
@@no_sup:
	inc	si
	inc	bx
        jmp	@@get_arg

@@get_switch:
	mov	bx,OFFSET Irq
        lodsw
	cmp	ax,'RF'
	je	@@get_freq
	cmp	ax,'BS'
        je	@@get_sb
        cmp	ax,'KS'
	je	@@get_spk
	cmp	ax,'CD'
        je	@@get_dac
        cmp	ax,'SG'
	je	@@get_gus
	mov	ax,BAD_ARG
        jmp	error
@@get_freq:
	call	get_dec
	inc	si
	mov	[MixSpeed],ax
        jmp	@@get_arg
@@get_spk:
	mov	[Device],PC_SPEAKER
	lodsb
	or	al,al
	je	@@get_arg
	mov	ax,BAD_ARG
        jmp	error
@@get_dac:
	mov	[Device],DAC_ON_LPT
	jmp	@@get_device
@@get_sb:
	mov	[Device],SOUNDBLASTER
	jmp	@@get_device
@@get_gus2:
	mov	[Device],GUS+1
	jmp	@@get_device
@@get_gus:
	mov	[Device],GUS
@@get_device:
	call	get_hex
	inc	si
	jc	@@get_arg
        mov	[Port],ax
        jmp	@@get_arg

@@line_used:
	mov	eax,[ds:di-4]
@@search_ext:
	cmp	al,'.'
	je	@@find_ext
	shr	eax,8
	jne	@@search_ext
	mov	[dword ptr ds:di],'DOM.'
	add	di,4
@@find_ext:
	xor	al,al
	stosb

	push    ds
	push	OFFSET Device
	push	ds
	push	OFFSET Port
	push	ds
	push	OFFSET Irq
	push	ds
	push	OFFSET Dma
	call	Detectsnd

	cmp	[byte ptr ds:Device],5
	jb	@@device_found
	mov	[byte ptr ds:Device],1
@@device_found:

	push	ds
	push	OFFSET Filename
	call      far Floadmod
	jc	error

	mov	[dword ptr cs:OFFSET Timer],0
	mov	[dword ptr ds:OFFSET PASSAGE],0
	mov	[dword ptr ds:OFFSET  CHRONO],0

	call	putcard

	push	[MixSpeed]
	push	[word ptr ds:OFFSET Device]
	push	[word ptr ds:OFFSET Port]
	push	[word ptr ds:OFFSET Irq]

	call	far Setmod
	jc	error

	mov	ax,ds
	mov	es,ax
	mov	di,OFFSET MUSIQUE_NAME+3
	call	getname

	mov	di,OFFSET DEVICE_NAME+3
	mov	dl,[Device]
	call	getdevice

	call	getmaxseq
	mov	di,OFFSET SEQUENCE_NB+7
	call	dectostr

	mov	di,OFFSET INSTRUMENT1+3
	mov	cl,31
@@next_inst:
	push	cx
	push	di
	call	getinst
	pop	di

	push	es
	mov	ax,ds
	mov	es,ax
	mov	cx,23
	xor	al,al
@@continue:
	repne	scasb
	or	cx,cx
	je	@@fin_remplacement
	mov	[byte ptr es:di-1],' '
	jmp	@@continue
@@fin_remplacement:
	pop	es
	add	di,3
	pop	cx
	dec	cl
	jne	@@next_inst

	call	setmode

	mov	cx,NB_MSG
	mov	bx,OFFSET LIST_MSG
@@next_msg:
	mov	si,[ds:bx]
	add	bx,2
	mov    	dx,[ds:si]
	mov	ah,[ds:si+2]
	add	si,3
	call	puttxt
	dec	cx
	jne	@@next_msg

	mov	cx,NB_MSG
	mov	bx,OFFSET LIST_MSG
@@next_msg2:
	mov	si,[ds:bx]
	add	bx,2
	mov    	dx,[ds:si]
	mov	ah,[ds:si+2]
	add	si,3
	call	puttxt
	dec	cx
	jne	@@next_msg2

      call	far Makemod
      call	far Makemod

      push	es
      mov	ax,3509h
      int       21h
      mov       [word ptr ds:OFFSET Old_int9],bx
      mov       [word ptr ds:OFFSET Old_int9+2],es
      cli
      pop	es
      push	ds
      mov	ax,cs
      mov	ds,ax
      mov       dx,OFFSET hitkey
      mov	ax,2509h
      int       21h
      pop	ds

      sti

      call      far Startmod

boucle:

      call	refresh

      push	es
      mov	ax,SEG Timer
      mov	es,ax
      mov       eax,[dword ptr es:OFFSET Timer]
      mov       [dword ptr ds:T_INITIAL],eax
	call      far MAKEMOD
      mov	ax,SEG Timer
      mov	es,ax
      mov       eax,[dword ptr es:OFFSET Timer]
      pop	es

      sub       eax,[dword ptr ds:T_INITIAL]
      cmp       eax,[dword ptr ds:CHRONO]
      jbe       plus_court
      mov       [dword ptr ds:CHRONO],eax
plus_court:

	mov	al,[cs:Key]
	cmp	al,1
	je	@@exit
	cmp	al,25
	je	@@pause
	cmp	al,78
	je	@@next_pos
	cmp	al,74
	je	@@vol_down

	jmp	boucle


	mov	ax,3100h
	int	21h


@@pause:
      cmp	[Pause],0
      je	@@start_pause

      mov	[Pause],0
      call	far Startmod
      mov	[word ptr ds:OFFSET BARRE_HELP],OFFSET AIDES
      jmp	@@show_help_bar

@@start_pause:
      mov	[Pause],1
      call	far Stopmod
      mov	[word ptr ds:OFFSET BARRE_HELP],OFFSET AIDES_PAUSED

@@show_help_bar:

	mov	cx,NB_HELP
	mov	bx,OFFSET BARRE_HELP
@@next_msg3:
	mov	si,[ds:bx]
	add	bx,2
	mov    	dx,[ds:si]
	mov	ah,[ds:si+2]
	add	si,3
	call	puttxt
	dec	cx
	jne	@@next_msg3

	mov	[cs:Key],0
	jmp	boucle

@@next_pos:
	mov	[cs:Key],0

	call	gonextpos

	jmp	boucle
@@vol_down:
	mov	[cs:Key],0
	dec	[ds:MVol]
	mov	al,[ds:MVol]
	push	ax
	call	CHANGEVOL
	jmp	boucle

@@exit:
	cli

      call      far Stopmod
      push	ds
      mov	ax,2509h
      lds       dx,[dword ptr ds:OFFSET Old_int9]
      int       21h
      pop	ds
      sti

      call	resetmode

      call      Unloadmod

      mov       cx,TNOMBRE
      mov       di,OFFSET NOMBRE+TNOMBRE-1

      mov       eax,[ds:OFFSET CHRONO]
      xor       edx,edx
      mov       ebx,10
affiche:
      div       ebx
      add       dl,'0'
      mov       [ds:di],dl
      dec       di
      xor       edx,edx
      loop      affiche

      mov       ah,09h
      mov       dx,di
      int       21h

      mov       ax,4c00h
      int       21h

no_arg:

	mov	dx,OFFSET PROGRAM_MSG
	mov	ah,09h
	int	21h

	mov	ax,4c13h
	int	21h

error:
	cmp	ax,256
        jbe	@@dos_error
	sub	ax,246
@@dos_error:
	mov	bx,_DATA
	mov	ds,bx
	sub	ax,FIRST_ERROR
	jb	@@unknow
	cmp	ax,LAST_ERROR
	ja	@@unknow
	mov	bx,ax
	shl	bx,1
	mov     dx,[ds:bx+MSG_ERROR]
	mov	ah,09h
	int	21h
	mov	ax,bx
	shl	bx,1
	mov	ah,4ch
	int	21h

@@unknow:
	mov	dx,OFFSET UNKNOW_ERROR
	mov	ah,09h
	int	21h
	mov	ax,4cffh
	int	21h

ENDP

;***************************************************************************
;*	Convertit un nombre sous forme de chaine de caractre en ds:si
;*	en binaire dans ax,ds:si pointant sur la fin du nombre
;*
;* Entre:
;*	DS:SI	reprsentation dcimal du nombre
;* Sortie:
;*	AX	nombre
;*	C=1	si la chaine n'est pas un nombre

PROC	get_dec

	xor	ax,ax
	xor	dh,dh
	mov	dl,[ds:si]
	sub	dl,'0'
	jl	@@error
	cmp	dl,9
	ja	@@error

@@next_digit:
	inc	si

	lea	ax,[eax*4+eax]
	shl	ax,1
	add     ax,dx

	mov	dl,[ds:si]
	sub	dl,'0'
	jl	@@no_digit
	cmp	dl,9
	jbe	@@next_digit

@@no_digit:
	clc
	ret
@@error:
	stc
	ret
ENDP

;***************************************************************************
;*	Convertit un nombre sous forme de chaine de caractre en ds:si
;*	en binaire dans ax,ds:si pointant sur la fin du nombre
;*
;* Entre:
;*	DS:SI	reprsentation hexadcimal du nombre
;* Sortie:
;*	AX	nombre
;*	C=1	si la chaine n'est pas un nombre

PROC	get_hex

	xor	ax,ax
	xor	dh,dh
	mov	dl,[ds:si]
	sub	dl,'0'
	jl	@@error
	cmp	dl,9
	jbe	@@next_digit
        and	dl,1fh
        xor	dl,18h
	inc	dl
	cmp	dl,0fh
        ja	@@error
@@next_digit:
	inc	si

	shl	ax,4
	add     ax,dx

	mov	dl,[ds:si]
	sub	dl,'0'
	jl	@@no_digit
	cmp	dl,9
	jbe	@@next_digit
        and	dl,1fh
        xor	dl,18h
        inc	dl
	cmp	dl,0fh
        jbe	@@next_digit
@@no_digit:
	clc
	ret
@@error:
	stc
	ret
ENDP


Key	DB	0

;***************************************************************************
;*      interruption qui remplace l'interruption 09 et permet de sortir du
;*              programme quand on frappe une touche

PROC    hitkey FAR

	push    ax

	in      al,60h
	or      al,al
	js      @@relache

	mov     [cs:OFFSET Key],al

	mov     al,20h
	out     20h,al

	pop     ax
	iret

@@relache:
	mov     al,20h
	out     20h,al

	pop     ax
	iret

ENDP

;*************************************************************************
;*	Rafraichit l'ecran

PROC	refresh

	call	gettempo
	push	ax
	mov	di,OFFSET TEMPO_NB+3
	call	dectostr
	pop	ax
	mov	al,ah
	mov	di,OFFSET TEMPO_NB+7
	call	dectostr

	call	getpattern
	push	ax
	mov	al,dl
	mov	di,OFFSET LIGNE_NB+3
	call	dectostr
	pop	ax
	push	ax
	mov	di,OFFSET SEQUENCE_NB+3
	call	dectostr
	pop	ax
	mov	al,ah
	mov	di,OFFSET PATTERN_NB+3
	call	dectostr

        push	ds
        mov	ax,SEG Nb_voice
        mov	ds,ax
        ASSUME	ds:SEG Nb_voice
	mov	cl,[ds:OFFSET Nb_voice]
	pop	ds
        ASSUME ds:_DATA
	mov	di,OFFSET INSTRUMENTV1
@@next_voice:
	push	cx
	push	di
	call	putvoice
        pop	di
	add	di,OFFSET INSTRUMENTV2-OFFSET INSTRUMENTV1
        pop	cx
        dec	cl
        jne	@@next_voice

	mov	cx,NB_REFRESH
	mov	bx,OFFSET LIST_MSG
@@next_msg2:
	mov	si,[ds:bx]
	add	bx,2
	mov    	dx,[ds:si]
	mov	ah,[ds:si+2]
	add	si,3
	call	puttxt
	dec	cx
	jne	@@next_msg2

	ret

ENDP

;**************************************************************************
;*	Place les informations des 4 voix
;*
;* Entre:
;*	DS:DI	position des instruments de la voix

PROC	putvoice
LOCAL	voice:WORD,instrument:BYTE,volume:BYTE,note:BYTE,effet:BYTE=varloc

	enter	varloc,0

	mov	[voice],di
	call	getvoice
	mov	[volume],ah
	mov	[note],bl
	mov	[effet],bh
	mov	[instrument],al
	mov	di,[voice]
	mov	dx,[word ptr ds:di]
	mov	dl,39h
	mov	al,''
;	shr	cl,2
	call	putbar
	movzx	bx,[instrument]
	or	bx,bx
	je	@@no_inst
	add	bx,NB_MSG-32
	shl	bx,1
	add	bx,OFFSET LIST_MSG
	mov	si,[ds:bx]
	add	si,3
	mov	di,[voice]
	add	di,3
	mov	cx,11
	push	es
	mov	ax,ds
	mov     es,ax
	rep	movsw
	pop	es
@@no_inst:
	mov	al,[volume]
	mov	di,[voice]
	add	di,26+3
	call	dectostr

	movzx	bx,[note]
	shl	bx,1
	add	bx,OFFSET LIST_NOTES
	mov	eax,[ds:bx]
	mov	di,[voice]
	add	di,26+3+7
	mov	[ds:di],eax

	movzx	si,[effet]
	shl	si,4
	add	si,OFFSET LIST_EFFET
	mov	cx,8
	mov	di,[voice]
	add	di,26+3+7+7
	push	es
	mov	ax,ds
	mov	es,ax
	rep	movsw
	pop	es

	leave

	ret

ENDP


SCREEN_POS	DW 640

;***************************************************************************
;*	Ecrit un nombre en EAX sur 32 bits en chaine de caractre
;*	correspondant  se reprsentation hexadcimal
;*
;* Entre:
;*	EDX	nombre  convertir

PROC	writelong

	push	es
	mov	ax,0b800h
	mov	es,ax
	mov	di,[cs:SCREEN_POS]
	add	di,16

	mov	ax,'h'
	std
	stosb

	mov	cl,4
@@next_digit:
	movzx	ax,dl
	shr	edx,8
	shl	ax,4
	shr	al,4
	xchg	al,ah
	and	ax,0f0fh
	add	ax,3030h
	cmp	al,3Ah
	jb	@@al_ok
	add	al,7
@@al_ok:
	cmp	ah,3Ah
	jb	@@ah_ok
	add	ah,7
@@ah_ok:
	xchg	al,ah
	dec	di
	stosb
	dec	di
	mov	al,ah
	stosb
	dec	cl
	jne	@@next_digit

	cld

	add	di,19
	mov	al,' '
	stosb
	inc	di

	pop	es

	cmp	di,4000
	jb	@@ok
	mov	di,0
@@ok:
	mov	[cs:SCREEN_POS],di


	ret

ENDP



;***************************************************************************
;*	Cette routine spare les arguments de la ligne de commande par un
;*	zero,deplus les switchs sont mis en majuscule.Les switchs doivents
;*	commencer par '-','/' ou '+' et le '/' est toujours transform en '-'
;*	deplus les virgules se retrouve toujours en dbut de mots.Enfin
;*	si une chaine est mis entre '"' elle n'est pas modifi.
;*
;* Entre:
;*	DS:SI	adresse de la ligne de commande
;*      ES:DI	adresse du buffer devant contenir la ligne modifi
;* Sortie:
;*	AL	nombre d'arguments sans les switchs

PROC	getarg

	lodsb
	mov	cl,al
        xor	ch,ch

@@search_letter:
	dec	cl
	jl	@@nothing_left
	lodsb
	cmp	al,' '
	je	@@search_letter
	cmp	al,09
	je	@@search_letter
	inc	ch
	cmp	al,'+'
	je	@@switch
	cmp	al,'-'
	je	@@switch
	cmp	al,'/'
	jne	@@letter
	mov	al,'-'
@@switch:
	stosb
	dec	ch

@@majuscule:
	dec	cl
	jl	@@nothing_left
	lodsb
	mov	ah,al
	and	ah,0dfh
	cmp	ah,'A'
	jb	@@search_white
	cmp	ah,'Z'
	ja	@@search_white
	mov	al,ah
	stosb
	jmp	@@majuscule

@@string:
	stosb
	dec	cl
	jl	@@nothing_left
	lodsb
	cmp	al,'"'
	jne	@@string

@@letter:
	stosb
	lodsb
	dec	cl
	jl	@@nothing_left

@@search_white:
	cmp	al,'"'
	je	@@string
	cmp	al,' '
	je	@@find_white
	cmp	al,09
	je	@@find_white
	cmp	al,','
	jne	@@letter
	mov	ah,al
	xor	al,al
	stosw
        cmp	[byte ptr ds:si],','
        jne	@@search_letter
        stosb
	jmp	@@search_letter

@@find_white:
	xor	al,al
	stosb
	jmp	@@search_letter

@@nothing_left:
	xor	ax,ax
	stosw
	mov	al,ch

	ret

ENDP

;**************************************************************************
;*	Affiche une ligne de texte donnant la carte sonore utilis
;*
;* Attention:
;*	Les variables Device,Port,Irq et DMA doivent tre dfinis ainsi
;*	que des messages

PROC	putcard

	mov	ah,09h
	mov	dx,OFFSET USINGMSG
	int	21h

	mov	bl,[byte ptr ds:OFFSET Device]
	xor	bh,bh
	shl	bx,2
	add	bx,OFFSET DEVICEMSG
	mov	dx,[ds:bx]
	mov	ah,09h
	int	21h

	mov	cl,[ds:bx+2]
	or	cl,cl
	je	@@thats_all

	mov	bx,[ds:Port]
	or	bh,bh
	je	@@no_first_digit

	mov	dl,bh
	add	dl,'0'
	mov	ah,02h
	int	21h

	mov	dl,bl
	shr	dl,4
	and	dl,0fh
	add	dl,'0'
	cmp	dl,'9'
	jbe	@@no_hexa
	add	dl,7
@@no_hexa:
	mov	ah,02h
	int	21h

	and	bl,0fh
@@no_first_digit:
	mov	dl,bl
	add	dl,'0'
	mov	ah,02h
	int	21h

	dec	cl
	je	@@thats_all

	mov	ah,09h
	mov	dx,OFFSET IRQMSG
	int	21h

	mov	dl,[ds:Irq]
	add	dl,'0'
	mov	ah,02h
	int	21h

	dec	cl
	je	@@thats_all

	mov	ah,09h
	mov	dx,OFFSET DMAMSG
	int	21h

@@thats_all:

	mov	ah,09h
	mov	dx,OFFSET NEWLINE
	int	21h

	cmp	[ds:Device],4
	je	@@loadsamp

	ret
@@loadsamp:

	mov	ah,09h
	mov	dx,OFFSET GUSMSG
	int	21h

	ret

ENDP

ENDS

STACK	400h

END

