;**************************************************************************
;*	mini player de mod sur le PC speaker ou le port parallle ou mme
;*	 une sound blaster
;* Programm par Sbastien Granjoux
;* Commenc en fvrier 93
;* Dernire modif 11/01/95
;*

IDEAL
P386N

INCLUDE "CRYSTAL.INC"


PUBLIC	CutVoice
PUBLIC	MasterVol

PUBLIC	FLOADMOD
PUBLIC	MLOADMOD
PUBLIC	OLOADMOD
PUBLIC	MAKEMOD

PUBLIC	UNLOADMOD
PUBLIC  STARTMOD
PUBLIC	STOPMOD
PUBLIC	SETMOD
PUBLIC	DETECTSND

PUBLIC	CHANGEVOL

PUBLIC	Nb_voice
PUBLIC	Voix1
PUBLIC	Timer
PUBLIC	TAB_ARPEGE
PUBLIC	Partition
PUBLIC	Position
PUBLIC	Ligne
PUBLIC	Music
PUBLIC	Instruments
PUBLIC	Sequence
PUBLIC	Tempo
PUBLIC	Speed

SEGMENT CSEG PARA PRIVATE USE16 'CODE'

ASSUME	cs:CSEG,ds:CSEG

BUF_LEN		EQU 512*2*2

BUF_SOUND	DB BUF_LEN DUP(?)
		DB BUF_LEN DUP(?)
BUF_SOUNDBIS	DB BUF_LEN DUP(?)

Ptr_sound       DW OFFSET BUF_SOUND+BUF_LEN
Page_sound	DW OFFSET BUF_SOUND
Page_end	DD ?

SAMPLE_BORDER	EQU	732+32	;permet d'viter les grsillements

STRUC INSTRUMENT
	iname	DB 22 DUP (0)
	length  DW 0
	volume  DB 0
	fintune DB 0
	adrseg	DW 0	; correspond  l'adresse de rptition au dbut
	lenrep  DW 0
	adr	DW 0	; non utilis
ENDS

Instruments INSTRUMENT 31 DUP (?)
Nb_instrument	DB ?
Nb_voice	DW 0204h	;puissance de deux et nombre de voix

Sequence	DB 130 DUP (?)      ;sequence
Partition       DW ?

Music		DB 20 DUP(?)

;***************************************************************************
;*	Charge un fichier MOD en mmoire
;*
;* Entre:
;*	DS:DX	adresse longue du nom du fichier mod
;*
;* Sortie:
;*	AX	code d'erreur si C=1
;*

PROC    Floadmod FAR
LOCAL	posseq:WORD,pospat:WORD,nulsamp:WORD=locvar

	mov     al,00h
usemodfile:
	enter	locvar,0
	push	ds
	push	si
	push	di

	lds	dx,[ss:bp+6]

	mov     ah,3dh        ;ouvre la fichier
	call	fileint
	jc      @@error

	mov	bx,ax

	mov	ax,CSEG
	mov	ds,ax

	mov	[word ptr cs:Ligne],1024
	mov	[word ptr cs:Position],255
	mov     [byte ptr cs:Tempo],06h
	mov	[byte ptr cs:PatternDelay],0
	mov	[word ptr cs:Time],0100h
	mov	[word ptr cs:Speed],256

	mov	ah,3fh
	mov	cx,20
	mov	dx,OFFSET Music
	call	fileint
	jc	@@error

	mov	ax,4200h
	xor	cx,cx
	mov	dx,438h
	call	fileint
	jc	@@error

	mov	ah,3fh
	mov	cx,4
	mov	dx,OFFSET Sequence
	call	fileint
	jc	@@error
	mov	[Nb_voice],0204h
	cmp	[dword ptr ds:OFFSET Sequence],'.K.M'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Sequence],'4TLF'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Sequence],'8TLF'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Sequence],'NHC8'
        je	@@mode8
	cmp	[dword ptr ds:OFFSET Sequence],'NHC6'
	je	@@mode6
	mov	[Nb_instrument],15
	mov	[posseq],1d6h
	mov	[pospat],258h
	jmp	@@loadinst
@@mode6:
	mov	[Nb_voice],0006h
	jmp	@@mod31
@@mode8:
	mov	[Nb_voice],0308h
@@mod31:
	mov	[Nb_instrument],31
	mov	[posseq],3b6h
	mov	[pospat],43ch

@@loadinst:

	mov     ax,4200h	; se place sur les instruments
	xor	cx,cx
	mov	dx,20
	call	fileint
	jc	@@error

	mov	cl,[Nb_instrument]
	mov	di,OFFSET Instruments
@@next_inst:
	shl	ecx,16
	mov     ah,3fh
	mov	cx,30
	mov	dx,di
	call	fileint
	jc	@@error

	rol	[(INSTRUMENT PTR ds:di).length],8	; passe en notation intel
	cmp	[(INSTRUMENT PTR ds:di).length],32768-SAMPLE_BORDER/2
	jb	@@no_big_sample
	mov	ax,TOO_BIG_SAMP
	stc
	jmp	@@error
@@no_big_sample:
	shl	[(INSTRUMENT PTR ds:di).length],1

	rol	[word ptr ((INSTRUMENT PTR ds:di).volume)],8
	sar	[(INSTRUMENT PTR ds:di).fintune],4

	rol	[(INSTRUMENT PTR ds:di).lenrep],8
	shl	[(INSTRUMENT PTR ds:di).lenrep],1
	cmp	[(INSTRUMENT PTR ds:di).lenrep],2
	jbe	@@no_repeat

	rol	[(INSTRUMENT PTR ds:di).adrseg],8
	shl	[(INSTRUMENT PTR ds:di).adrseg],1

	mov	ax,[(INSTRUMENT PTR ds:di).length]
	sub	ax,[(INSTRUMENT PTR ds:di).lenrep]
	mov	[(INSTRUMENT PTR ds:di).adrseg],ax

	jmp	@@end_inst

@@no_repeat:

	mov	ax,[(INSTRUMENT PTR ds:di).length]
	dec	ax
	mov	[(INSTRUMENT PTR ds:di).adrseg],ax

@@end_inst:
	add	di,SIZE INSTRUMENT
	shr	ecx,16
	dec	cl
	jne	@@next_inst

	mov	ax,4200h
	xor	cx,cx
	mov	dx,[posseq]
	call	fileint
	jc	@@error

	mov	si,OFFSET Sequence
	mov     ah,3fh  ;lecture sequence
	mov     cx,130
	mov     dx,si
	call	fileint
	shl     ebx,16   ;compte le nombre de pattern dans la sequence


	mov     cl,128	; pour certain mod [ds:si] n'est pas significatif (PRELUDE)
	add     si,2
@@nb_pattern:
	lods    [byte ptr ds:si]
	cmp     bl,al
	jae     @@no_new_pattern
	mov     bl,al
@@no_new_pattern:
	dec     cl
	jne     @@nb_pattern

	inc     bl
	cmp	bl,64
	jbe	@@no_too_many_pat
	mov	ax,TOO_MANY_PAT
	stc
	jmp	@@error
@@no_too_many_pat:
	mov	al,[ds:OFFSET Nb_voice]
	mul	bl
	mov	cl,4
	shl	ax,cl
	mov	bx,ax

	push	ds
	mov     ah,48h  ;reserve de la place pour les patterns
	int	21h
        jc      @@error
	mov	[Partition],ax
	mov	ds,ax

	mov	cx,bx
	shl	ecx,20

	shr	ebx,16	;se place sur les patterns
	mov	ax,4200h
	xor	cx,cx
	mov	dx,[pospat]
	call	fileint

	mov     ah,3fh		; lecture des patterns
	shr	ecx,16
	xor	dx,dx
	call	fileint
	jc      @@error

	shr     cx,2		; adaptation des notes
	xor     si,si		;  inversion des voix

@@frequence:
	rol     ecx,16
	lods    [dword ptr ds:si]
	rol     ax,8
	rol	eax,16
	mov     [dword ptr ds:si-4],eax
	rol     ecx,16
	dec	cx
	jne	@@frequence


	shl	ebx,16

	mov	bx,SAMPLE_BORDER  ;crer un sample nul
	add	bx,15
	shr	bx,4
	mov	ah,48h
	int	21h
	jc	@@error

	push	di
	mov	es,ax
	mov	[nulsamp],ax

	mov	cx,SAMPLE_BORDER
	rep	movsb

	pop	di
	pop	es		; chargement des samples

	mov	di,OFFSET Instruments
	mov     cl,[es:Nb_instrument]           ;lecture des samples
@@sample:
	shl     ecx,16
	mov	cx,[(INSTRUMENT PTR es:di).length]
	or	cx,cx
	jne	@@res_mem

	mov	ax,[nulsamp]
	mov	[(INSTRUMENT PTR es:di).adrseg],ax
	mov	[(INSTRUMENT PTR es:di).lenrep],32
	mov	[(INSTRUMENT PTR es:di).length],32
	jmp	@@no_sample
@@res_mem:
	mov	bx,cx
	add	bx,SAMPLE_BORDER
	add	bx,15
	shr	bx,4
	mov	ah,48h
	int	21h
	jc	@@error

	shr	ebx,16
	mov	ds,ax
	mov     ah,3fh
	xor	dx,dx
	call	fileint
	jc      @@error
	shl	ebx,16

	mov	cx,SAMPLE_BORDER
	mov	si,[(INSTRUMENT PTR es:di).adrseg]
	mov	bx,[(INSTRUMENT PTR es:di).length]

	cmp	[(INSTRUMENT PTR es:di).lenrep],2
	ja	@@next_byte
	mov	[byte ptr ds:si],0
	mov	[(INSTRUMENT PTR es:di).lenrep],32
@@next_byte:
	lodsb
	mov	[ds:bx],al
	inc	bx
	dec	cx
	jne	@@next_byte

	mov	[(INSTRUMENT PTR es:di).adrseg],ds

	dec	bx
	cmp	bx,si
	jne	@@no_sample
	add	[(INSTRUMENT PTR es:di).length],32

@@no_sample:
	add     di,SIZE INSTRUMENT
	shr     ecx,16
	dec     cl
	jne     @@sample

	shr	ebx,16
	mov     ah,3eh  ;fermeture du fichier
	call	fileint
	jc      @@error

	xor	ax,ax
	clc
@@error:
	pop	di
	pop	si
	pop	ds

	leave
	ret	4

ENDP

filepos		DD	0
filestart	DD	0
Handle		DW	0

;***************************************************************************
;*
;*	Cette fonction permet de prparer un fichier mod dj charg en
;*	mmoire  tre jouer
;*
;* Entre:
;*	dans la pile adresse de la zone o on a dj charger le mod

PROC	Mloadmod FAR
LOCAL	posseq:WORD,pospat:WORD,nulsamp:WORD=locvar

	mov	al,3
	jmp	usemodfile

ENDP

;***************************************************************************
;*
;*	Cette fonction permet de prparer un fichier mod plac en overlay
;*	 tre jouer
;*
;* Entre:
;*	dans la pile position de l'overlay par rapport au dbut du fichier

PROC	Oloadmod FAR
LOCAL	posseq:WORD,pospat:WORD,nulsamp:WORD=locvar

	mov	al,4
	jmp	usemodfile

ENDP

;***************************************************************************
;*	Cette procdure remplace les fonctions de DOS pour l'acces aux
;*	fichier et permette d'accder  un fichier dj charg en mmoire
;*	de manire transparente,les arguments sont les mme que les
;*	fonctions DOS correspondante sauf pour open o DS:DX ne reprsente
;*	pas le nom du fichier mais l'adresse o est dj charg le fichier
;*	et AL doit contenir 3 pour avoir un mode en lecture avec ce nouveau
;*	mode,deplus on ne peut avoir qu'un fichier ouvert dans ce mode
;* ATTENTION la fonction seek ne peut se dplacer par rapport  la fin
;*	du fichier,deplus les fichiers sont limit  1Mo, et les lecture
;*	ne peuvent lire des blocs de plus de 65520 octet


PROC	fileint

	cmp     ah,3dh
	jne	@@not_open

	cmp	al,03h
	je	@@openmem
	cmp	al,04h
	je	@@openovl
	int	21h
	ret

@@openovl:
	push	ds
	mov	[word ptr cs:OFFSET filestart],dx
	mov	[word ptr cs:OFFSET filestart+2],ds

	mov	ah,51h
	int	21h
	jc	@@ovl_error
	mov	ds,bx
	mov	ax,[ds:2Ch]
	mov	ds,ax
	push	es
	mov	dx,di
	mov	es,ax
	xor	di,di
	mov	cx,8000h
	xor	al,al
@@next_envstr:
	repne	scasb
	cmp	[byte ptr es:di],0
	jne	@@next_envstr
	pop	es
	mov	ax,[ds:di+1]
	xchg	di,dx
	or	ax,ax
	je	@@ovl_error
	add	dx,3
	mov    	ax,3d00h
	int	21h
	jnc	@@ok
@@ovl_error:
	pop	ds
	mov	[cs:filestart],0
	ret
@@ok:
	mov	bx,ax
	mov	ax,4200h
	mov	dx,[word ptr cs:OFFSET filestart]
	mov	cx,[word ptr cs:OFFSET filestart+2]
	int	21h
	jc	@@ovl_error
	pop	ds
	mov	ax,bx
	ret

@@openmem:
	cmp	[cs:Handle],0
	jne	@@no_handle

	mov	ax,dx
	and	ax,0fh
	mov	[word ptr cs:OFFSET filepos],ax
	mov	[word ptr cs:OFFSET filestart],ax
	mov	ax,ds
	shr	dx,4
	add	ax,dx
	mov	[word ptr cs:OFFSET filepos+2],ax
	mov	[word ptr cs:OFFSET filestart+2],ax

	mov	ax,0ffffh
	mov	[cs:Handle],ax
	clc
	ret

@@no_handle:
	stc
	mov	ax,4
	ret

@@not_open:
	cmp	bx,[cs:Handle]
	je	@@memint
	cmp	ax,4200h
	jne	@@no_begin_seek
	add	dx,[cs:OFFSET filestart]
	adc	cx,[cs:OFFSET filestart+2]
@@no_begin_seek:
	int	21h
	ret

@@memint:
	cmp	ah,3fh
	je	@@fread
	cmp	ah,42h
	je	@@fseek
	cmp	ah,3eh
	je	@@fclose

	int	21h
	ret

@@fclose:

	mov	[cs:filestart],0
	mov	[cs:Handle],0
	clc
	ret

@@fread:
	push	cx
	push	di
	push	si
	push	es
	push	ds
	mov	ax,ds
	mov	di,dx
	shr	di,4
	add	ax,di
	mov	es,ax

	lds	ax,[dword ptr cs:OFFSET filepos]
	mov	si,ax

	add	ax,cx
	mov	di,ax
	and	ax,0fh
	mov	[word ptr cs:OFFSET filepos],ax
	shr	di,4
	add	[word ptr cs:OFFSET filepos+2],di

	mov	di,dx
	and	di,000fh

	rep	movsb

	pop	ds
	pop	es
	pop	si
	pop	di
	pop	cx

	clc
	ret

@@fseek:
	cmp	al,0
	jne	@@from_current
	mov	ax,[word ptr cs:OFFSET filestart]
	mov	[word ptr cs:OFFSET filepos],ax
	mov	ax,[word ptr cs:OFFSET filestart+2]
	mov	[word ptr cs:OFFSET filepos+2],ax
@@from_current:
	push	cx
	add	dx,[word ptr cs:OFFSET filepos]
	adc	cx,0
	mov	ax,dx
	and	ax,0fh
	mov	[word ptr cs:OFFSET filepos],ax
	shr	dx,4
	shl	cx,12
	or	dx,cx
	add	[word ptr cs:OFFSET filepos+2],dx
	pop	cx

	mov	ax,[word ptr cs:OFFSET filepos+2]
	mov	dx,ax
	shl	ax,4
	or	ax,[word ptr cs:OFFSET filepos]
	shr	dx,12

	clc
	ret
ENDP

;***************************************************************************
;*      Libre la mmoire prise par la fonction loadmod utilise en ds:di
;*      l'adresse des instruments et en ds:si l'adresse de la partition

PROC    Unloadmod FAR

	push	ds
	push	es
	push	si
	push	di
	mov	ax,CSEG
	mov	ds,ax

	mov     ax,[Partition]
	mov	es,ax
	mov	ah,49h
	int	21h

	mov	di,OFFSET Instruments
	mov	cl,[Nb_instrument]
@@sample:
	mov     ax,[(INSTRUMENT PTR ds:di).adrseg]
	or	ax,ax
	je      @@no_sample
	mov     es,ax
	mov	ah,49h
	int     21h
@@no_sample:
	add       di,SIZE INSTRUMENT
	dec	cl
	jne	@@sample

	pop	di
	pop	si
	pop	es
	pop	ds

	ret

ENDP

STRUC DEVICE
	detect	DB 18 DUP (0)
	init	DW 0
	start	DW 0
	sound	DW 0
	stop	DW 0
	make	DW 0
	port	DW 0
	irq	DB 0
	dma	DB 0
ENDS

Devices:        DEVICE <'$',OFFSET setnul,OFFSET soundnul,OFFSET soundnul,OFFSET soundnul,OFFSET soundnul,0,0,0>
		DEVICE <'$',OFFSET setspk,OFFSET startspk,OFFSET soundspk,OFFSET stopspk,OFFSET makespk,0,0,0>
		DEVICE <'DACs=p$',OFFSET setlpt,OFFSET startlpt,OFFSET soundlpt,OFFSET stoplpt,OFFSET makelpt,0,0,0>
		DEVICE <'BLASTERs=ApIiDd$',OFFSET setsb,OFFSET startsb,0,OFFSET stopsb,OFFSET makelpt,0,0,1>
		DEVICE <'ULTRASNDs=p,d,i$',OFFSET setgus,OFFSET startgus,OFFSET soundgus1,OFFSET stopgus,OFFSET makegus,0,0,0>


;**************************************************************************
;*	Cette routine recherche la prsence d'une carte sonore dans les
;*	variables d'environnement et renvoit la carte trouv avec ses
;*	paramtre
;*
;* Entre:
;*	AL	numero de la carte voulus
;*
;* Sortie:
;*	AL	numero de la carte trouv
;*	DL	irq utilis
;*	DH	dma utilis
;*	BX	port utilis

PROC	Detectsnd FAR
LOCAL	port:WORD,irq:BYTE,dma:BYTE,dev:BYTE=varloc

	enter	varloc,0
        push	es
	push	ds
	push	di
        push	si

        lds	di,[ss:bp+18]
        mov	al,[ds:di]
        mov	[dev],al
        mov	ax,CSEG
	mov	ds,ax
	ASSUME	ds:CSEG

	mov	ah,62h
        int	21h
	mov	es,bx
	mov	bx,[es:2Ch]
	mov	es,bx

	mov	cx,0ffffh
	movzx	bx,[dev]

	shl	bx,5	; car SIZE DEVICE=32
	add	bx,OFFSET Devices
	cmp	bx,OFFSET Devices+32*5
	jae	@@not_found

@@search_dev:
	xor	di,di
@@next_var:
	mov	si,bx
	lodsb
@@get_next:
	scasb
        je	@@find_one
@@not_dev:
        dec	di
	xor	al,al
        repne	scasb
	cmp	[byte ptr es:di],0
        je	@@not_found
	jmp	@@next_var

@@find_one:
	repe	cmpsb
        dec	di
        lodsb
        cmp	al,'='
        jne	@@not_dev
@@search_char:
	cmp	[byte ptr es:di],0
	je	@@not_dev
	mov	ah,[es:di]
        inc	di
	cmp	ah,'a'
	jb	@@no_maj
        cmp	ah,'z'
        ja	@@no_maj
        sub	ah,20h
@@no_maj:
	cmp     ah,al
	jne	@@search_char
@@get_par:
	lodsb
        cmp	al,'p'
	je	@@get_info
        cmp	al,'i'
	je	@@get_info
	cmp	al,'d'
        je	@@get_info
        cmp	al,'$'
        je	@@find_all
        jmp	@@search_char
@@get_info:
        mov	ah,[es:di]
	inc	di
	or	ah,ah
        je	@@not_dev
	cmp	ah,'0'
	jb	@@get_info
	cmp	ah,'9'
	ja	@@get_info

        dec	di
	cmp	al,'p'
	je	@@get_port
        cmp	al,'i'
	je	@@get_irq
        cmp	al,'d'
	je	@@get_dma
@@get_port:
	xor	dx,dx
	xor	ah,ah
@@next_digit:
	mov	al,[es:di]
        sub	al,'0'
        jl	@@no_digit
	cmp	al,'9'
        jbe	@@under10
	sub	al,6
        cmp	al,10
        jb	@@no_digit
	cmp	al,16
	jae	@@no_digit
@@under10:
        shl     dx,4
	add	dx,ax
	inc	di
	jmp    	@@next_digit

@@no_digit:
	mov	[port],dx
        jmp	@@get_par

@@get_dma:
	mov	al,[es:di]
        sub	al,'0'
	mov	[dma],al
        jmp	@@get_par

@@get_irq:
	mov	ax,[es:di]
        sub	ax,'00'
	cmp	ah,9
        ja	@@no_2digit
	mov	al,ah
        add	al,10
@@no_2digit:
	mov	[irq],al
        jmp	@@get_par

@@find_all:

	sub	bx,OFFSET Devices
        shr	bx,5

        lds	di,[ss:bp+18]
        mov	[ds:di],bl

	mov	bx,[port]
        lds	di,[ss:bp+14]
	mov	[ds:di],bx

	mov	dl,[irq]
        lds	di,[ss:bp+10]
	mov	[ds:di],dl

	mov     dh,[dma]
        lds	di,[ss:bp+6]
        mov	[ds:di],dh

@@found:
	pop	si
	pop	di
        pop	ds
	pop	es
	leave
	clc
	ret	4*4

@@not_found:
	cmp	[dev],5
	jne	@@error

	sub	bx,32
	cmp	bx,OFFSET Devices+32*2
	jae	@@search_dev

	lds	di,[ss:bp+18]
	mov	[byte ptr ds:di],1	; si on a rien trouv utilise le speaker
	jmp	@@found

@@error:
	sub	bx,OFFSET Devices
	shr	bx,5
	mov	al,bl

	pop	si
	pop	di
	pop	ds
	pop	es
        leave
	stc

	ret	4*4

ENDP

DEFAULT_FRQ	EQU 186

Used_device	DW 0

Play_rate	DW 0
Voicelen	DW 0

LOW_NOTE	EQU	1Ch
HIGH_NOTE	EQU	1AC0h

Notes		DW HIGH_NOTE+39 DUP (?)		;tables de conversion des note amiga
Volume_tab	DB 65*256 DUP (?)       ;tables de multiplication


;***************************************************************************
;*	Cette fonction initialise les tables du programme suivant les
;*	paramtre pass par le programme principale
;*
;* Entre:
;*
;*	Dans la pile en suivant cet ordre (en pascal)
;*
;*      CX	frequence en centaine de Hz (0 valeur par dfaut)
;*      BL	numero de l'appareil de sortie du son
;*      BH	numero du port de l'appareil
;*	DL	numero de l'irq (0 valeur par dfaut)

PROC	Setmod FAR

	push	bp
	mov	bp,sp

	push	ds
	push	es
	push	si
	push	di
	mov	ax,CSEG
	mov	ds,ax
	ASSUME  cs:CSEG

	mov	[cs:Ptr_sound],OFFSET BUF_SOUND+BUF_LEN
	mov	[cs:Page_sound],OFFSET BUF_SOUND

	mov     dl,[ss:bp+6]
	mov     ax,[ss:bp+8]
	mov	bl,[ss:bp+10]
	mov	cx,[ss:bp+12]

	mov	[byte ptr cs:OFFSET start_mksnd],01eh

	xor	bh,bh	;car SIZE DEVICE=32
	shl	bx,5
	add	bx,OFFSET Devices
	mov	[Used_device],bx

	mov	[(DEVICE PTR ds:bx).port],ax
;	or	dl,dl
;	je	@@default
	mov	[(DEVICE PTR ds:bx).irq],dl
;@@default:
	mov	[(DEVICE PTR ds:bx).dma],dh

	or	cx,cx
	jne	@@no_default
	mov     cx,DEFAULT_FRQ
@@no_default:

	mov	ax,cx		;multiplit dx par 5.5
	shr	cx,1
	lea	ax,[eax*4+eax]
	add	ax,cx
	mov	[Play_rate],ax

	mov	dx,ax
	shl	ax,8
	shr	dx,8
	mov	cx,703
	div	cx
	inc	ax
	and	ax,0fffeh
	shl	ax,1
	mov	[Voicelen],ax

	call	[(DEVICE PTR ds:bx).init]
	jc	@@error

	mov	bx,[Used_device]
	mov	ax,ds
	mov	es,ax
	mov     di,OFFSET Voices
	mov	si,[(DEVICE PTR ds:bx).make]
	mov	cx,(LEN_VOICES) shr 2
	rep	movsd

	mov	dx,3
	mov	ax,8d1h		; 4/(2.79365e-7*frequence)
	div	[Play_rate]
	shl	ax,2
	mov	cx,ax

	mov	bx,LOW_NOTE-17
@@next_note:
	mov	dx,cx
	shr	dx,8
	mov	ax,cx
	shl	ax,8
	cmp	dx,bx
        jae	@@overflow
	div     bx		; divise 1024*(2.79365e-7*frequence)
@@put_note:
	shl	bx,1
	mov	[ds:bx+OFFSET Notes],ax
	shr	bx,1
	inc	bx
	cmp	bx,HIGH_NOTE+39
	jne	@@next_note

	mov     cl,[ds:OFFSET Nb_voice]
	mov	al,SIZE VOIX
	mul	cl
	add	ax,OFFSET Voix1
	mov	[cs:OFFSET nbvoicetest+2],ax

	mov	ah,[ds:OFFSET Nb_voice]
	xor	al,al
	mov	[word ptr ds:OFFSET Ligne],ax

	mov	di,OFFSET Volume_tab	;remplit la table de multiplication
	mov	bl,0
@@fill_tab:
	mov	bh,0
	mov	ax,880
	mul	bx
	add	ax,1024

	mov	dh,15
@@next_dec:
	shl	ax,1
	jc	@@find_dec
	dec	dh
	jne	@@next_dec
@@find_dec:
	mov	dl,ah
	shl	dx,4
	shl	bx,1
	mov	[ds:OFFSET GUS_VOLUME2+bx],dx
	shr	bx,1
@@fill_line:
	mov	al,bh
	imul	bl
	sar	ax,6
	idiv	cl
	mov	[ds:di],al
	inc	di
	inc	bh
	jne	@@fill_line
	inc     bl
	cmp	bl,64
	jbe	@@fill_tab

	call	far Makemod
	sub	[cs:Ptr_sound],BUF_LEN

	mov	ax,NO_ERROR
	clc

@@error:
	pop	di
	pop	si
	pop	es
	pop	ds

	leave

	ret	8

@@overflow:
	mov	ax,0ffffh
	jmp	@@put_note

ENDP


STRUC VOIX
	endsamp DW 33
	volume	DB 0
	finetu	DB 0
	adrvoc	DP 0
	lenrep	DW 32		; evite un bug
	play    DW 0		; note jou
	newnote	DW 0		; note d'arriv (vibrato et portamento)
	oldnote DW 0		; note prcdente (portamento)
	effet   DW 0
	note1   DW 0
	note2   DW 0
	oldport DW 0
	amplit	DW 0
	vitesse DB 0
	temp	DB 0
	tremolo DB 0
	tremvit DB 0
	oldvol	DB 0
	compte	DB 0
	inst	DB 0
	gusinf	DB 0	;bit 3 new vol,2 nul vol,1 change adr,0 new inst
	extra	DB 0
	effnb	DB 0
	looppos DW 0
ENDS

Voix1           VOIX <>
Voix2           VOIX <>
Voix3           VOIX <>
Voix4           VOIX <>
Voix5		VOIX <>
Voix6		VOIX <>
Voix7		VOIX <>
Voix8		VOIX <>

Ligne		DD 1024
Position	DW 255
Tempo           DB 06h
PatternDelay	DB 0
Time		DW 0100h
Speed		DW 256
MasterVol	DB 255

Effets          DW OFFSET set_arpeggio
		DW OFFSET set_portamento_up
		DW OFFSET set_portamento_down
		DW OFFSET set_portamento_tone
		DW OFFSET set_vibrato
		DW OFFSET set_portamento_volume
		DW OFFSET set_vibrato_volume
		DW OFFSET set_tremolo
		DW OFFSET set_nul_effect
		DW OFFSET set_play_end_part
		DW OFFSET set_volume_slide
		DW OFFSET position_jump
		DW OFFSET set_volume
		DW OFFSET pattern_break
		DW OFFSET set_extended_effect
		DW OFFSET set_speed

;***************************************************************************
;*      Change le volume globale de la musique
;*
;* Entre:
;*	AL	nouveau volume
;*

PROC	Changevol FAR

	push	bp
	mov	bp,sp

	push	ds
	mov	ax,CSEG
	mov	ds,ax
	ASSUME	ds:CSEG

	mov     al,[ss:bp+6]
	mov	[ds:MasterVol],al

	mov	cx,[ds:Nb_voice]
	mov	bx,OFFSET Voix1
@@next_voice:
	or	[(VOIX PTR ds:bx).gusinf],8h
	add	bx,SIZE VOIX
	dec	cl
	jne	@@next_voice
	pop	ds

	leave

	ret	2

ENDP

;**************************************************************************
;*      calcul les sons

PROC PMAKEMOD FAR
ENDP
PROC _Makemod FAR
ENDP

PROC Makemod FAR

start_mksnd:
	push	ds	;Attention cet octet est modifi par le programme
	push	es
	push	bp
	push	si
	push	di
	mov	ax,CSEG
	mov	ds,ax

	cli
	mov	ax,[ds:OFFSET Ptr_sound]
	mov	bx,[ds:OFFSET Page_sound]
	sti
buf_sound10:
	mov	bp,OFFSET BUF_SOUND+BUF_LEN	;ATTENTION en fait on doit avoir OFFSET BUF_SOUND+BUF_LEN shl 16
	shl	ebp,16
	mov	bp,[word ptr ds:OFFSET Voicelen]
	add	bp,bx
buf_sound1:
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	ja	@@loop
	cmp	ax,bx
	jb	@@ok
	cmp	ax,bp
	ja	@@ok
@@fin:

	pop	di
	pop	si
	pop	bp
	pop	es
	pop	ds
	ret
@@loop:
	and	bp,65535-BUF_LEN	;0fbffh
	cmp	ax,bx
	ja	@@fin
	cmp	ax,bp
	jbe	@@fin
	rol	ebp,16

@@ok:
	mov	[Page_end],ebp

	mov	ax,[ds:Speed]
	sub     [ds:Time],ax
	jg	@@no_new_note


	mov	si,OFFSET Voix1

	mov     al,[cs:OFFSET Tempo]
	mov	[ds:OFFSET Time+1],al

	cmp	[byte ptr ds:OFFSET PatternDelay],0
	je	@@no_delay
	dec	[byte ptr ds:OFFSET PatternDelay]
	jmp	@@no_new_note

@@no_delay:

	les	di,[ds:OFFSET Ligne]

	mov	ah,[ds:OFFSET Nb_voice]
	xor	al,al

        cmp	di,ax
	jb     @@same_pattern

;	dec	ax
;	and	di,ax
	xor	di,di
	mov     bx,[ds:OFFSET Position]
	inc     bl
	cmp     bl,[byte ptr ds:OFFSET Sequence]
	jb     @@not_end_seq

	 xor    bl,bl

@@not_end_seq:
	 mov    [ds:OFFSET Position],bx
	 mov	al,[byte ptr ds:OFFSET Sequence+2+bx]
	 mov	cl,[ds:OFFSET Nb_voice]
	 mul	cl
	 shl	ax,4
	 add	ax,[ds:OFFSET Partition]
	 mov	[word ptr ds:OFFSET Ligne+2],ax
	 mov	es,ax

@@same_pattern:


@@autre_voix:

	mov     edx,[dword ptr es:di]   ;charge la voix

	mov     ebx,edx
	and     ebx,100000f0h
	je      @@meme_inst

	rol	ebx,8
	shr	bh,4
	or	bl,bh
	xor	bh,bh

	cmp	bl,[(VOIX ptr ds:si).inst]
	je	@@same_inst
	mov	[(VOIX ptr ds:si).inst],bl
	mov	[(VOIX ptr ds:si).gusinf],01h
@@same_inst:
	or	[(VOIX ptr ds:si).gusinf],00ch	; nouvel instrument

	shl	bx,5
	add     bx,OFFSET Instruments-SIZE INSTRUMENT ;ATTENTION ON CONSIDERE QUE LA STRUCTURE
					  ;CONTENANT LES INSTRUMENTS A UNE TAILLE DE
					  ;32 octets

	mov	eax,[dword ptr (INSTRUMENT ptr ds:bx).adrseg]
	mov	[(dword ptr (VOIX ptr ds:si).adrvoc)+4],eax
	mov	eax,[dword ptr (INSTRUMENT PTR ds:bx).length]
	mov	[dword ptr ds:si],eax

@@meme_inst:
	mov     bx,dx
	mov     [(VOIX PTR ds:si).extra],dh
	and     bx,000fh
	mov	[(VOIX PTR ds:si).effnb],bl
	shl     bx,1
	mov     bx,[word ptr ds:OFFSET Effets+bx]
	mov	[(VOIX PTR ds:si).effet],bx

	rol     edx,16

	mov	ax,[(VOIX PTR ds:si).play]
	mov	[(VOIX PTR ds:si).oldnote],ax

	and	dx,00fffh
	je      @@no_note

	mov	[(dword ptr (VOIX ptr ds:si).adrvoc)],0
	or	[(VOIX ptr ds:si).gusinf],2

	mov	al,[(VOIX PTR ds:si).finetu]
	shl	al,1
	add	al,[(VOIX PTR ds:si).finetu]
	shl	al,1
	cbw
	sub	dx,ax
	mov	[(VOIX ptr cs:si).newnote],dx
	mov	[(VOIX ptr cs:si).play],dx

@@no_note:

	add     di,4
	add     si,SIZE VOIX

nbvoicetest:
	cmp  	si,OFFSET Voix5		; Code automodifi
	jb      @@autre_voix

	mov     [word ptr ds:OFFSET Ligne],di

	mov	al,SIZE VOIX
	mov	cl,[ds:OFFSET Nb_voice]
	mul	cl
	sub     si,ax

@@no_new_note:

LEN_VOICES	EQU	1024

Voices:
	DB LEN_VOICES DUP (?)	;zone o l'on place la routine correspondant
				; l'appareil utilis

ENDP

;***************************************************************************
;*	Procdure d'initialisation des diffrents effets

PROC	set_nul_effect

	mov	[(VOIX ptr ds:di).effnb],0eh
	mov	[(VOIX ptr ds:di).effet],OFFSET retour
	ret
ENDP


PROC	set_arpeggio
	mov	al,[(VOIX ptr ds:di).extra]

	or	al,al
	je    	set_nul_effect

	mov	cx,[(VOIX PTR ds:di).newnote]

	mov     bx,OFFSET TAB_ARPEGE-2
@@not_find:
	add     bx,2
	cmp     cx,[ds:bx]
	jb      @@not_find

	sub	cx,[ds:bx]
	neg	cx
	mov	[(VOIX ptr ds:di).note1],cx
	mov	[(VOIX ptr ds:di).note2],cx
	mov     cx,bx
	shl     eax,12
	shr	ax,11
	add     bx,ax
	mov     ax,[ds:bx]

	add     [(VOIX ptr ds:di).note1],ax
	shr     eax,15
	and	ax,001eh
	mov     bx,cx
	add     bx,ax
	mov     ax,[ds:bx]
	add     [(VOIX ptr ds:di).note2],ax
	mov     [(VOIX ptr ds:di).effet],OFFSET arpeggio

	ret

ENDP

PROC	set_portamento_up

	mov	al,[(VOIX ptr ds:di).extra]
	xor	ah,ah
	mov     [(VOIX ptr ds:di).note1],ax
	mov     [(VOIX ptr ds:di).effet],OFFSET portamento_up

	ret

ENDP

PROC	set_portamento_down

	mov	al,[(VOIX ptr ds:di).extra]
	xor	ah,ah
	mov	[(VOIX ptr ds:di).note1],ax
	mov	[(VOIX ptr ds:di).effet],OFFSET portamento_down

	ret

ENDP

PROC	set_portamento_tone

	mov	dx,[(VOIX ptr ds:di).oldnote]
	mov	[(VOIX ptr ds:di).play],dx;
	mov	al,[(VOIX ptr ds:di).extra]
	or	al,al
	je	@@same
	xor	ah,ah
	mov     [(VOIX ptr ds:di).oldport],ax		; la partie haute est toujours  0
@@same:

	cmp   	dx,[(VOIX ptr ds:di).newnote]
	jb      @@tone_down
	mov     [(VOIX ptr ds:di).effet],OFFSET portamento_tone_up
	ret

@@tone_down:
	mov     [(VOIX ptr ds:di).effet],OFFSET portamento_tone_down
	ret

ENDP

PROC	set_vibrato

	mov	al,[(VOIX ptr ds:di).extra]
	or	al,al
	je	@@same
	mov	ah,al
	and	al,0fh
	shr	ah,2
	and	ah,3ch
	mov	[(VOIX ptr ds:di).vitesse],ah
	xor	ah,ah
	mov	[(VOIX ptr ds:di).amplit],ax
	mov	[(VOIX PTR ds:di).temp],ah

@@same:
	mov	[(VOIX ptr ds:di).effet],OFFSET vibrato

	ret

ENDP

PROC	set_portamento_volume

	mov	dx,[(VOIX ptr ds:di).oldnote]
	mov	[(VOIX ptr ds:di).play],dx
	cmp   	dx,[(VOIX ptr ds:di).newnote]
	jb      @@tone_down

	mov	al,[(VOIX ptr ds:di).extra]
	test	al,0f0h
	je	@@up_vol_down
	shr	al,4
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET portamento_up_volume_up
	ret

@@up_vol_down:
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET portamento_up_volume_down
	ret

	ret

@@tone_down:
	mov	al,[(VOIX ptr ds:di).extra]
	test	al,0f0h
	je	@@down_vol_down
	shr	al,4
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET portamento_down_volume_up
	ret

@@down_vol_down:
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET portamento_down_volume_down
	ret

ENDP


PROC	set_vibrato_volume

	mov	al,[(VOIX ptr ds:di).extra]
	test	al,0f0h
	je	@@vol_down
	shr	al,4
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET vibrato_volume_up
	ret

@@vol_down:
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET vibrato_volume_down
	ret

ENDP

PROC	set_tremolo

	mov	al,[(VOIX ptr ds:di).extra]
	or	al,al
	je	@@same
	mov	ah,al
	and	al,0fh
	shr	ah,2
	and	ah,3ch
	mov	[(VOIX ptr ds:di).tremvit],ah
	xor	ah,ah
	mov	[(VOIX ptr ds:di).note1],ax
	mov	[(VOIX PTR ds:di).tremolo],ah
	mov	al,[(VOIX PTR ds:di).volume]
	mov	[(VOIX PTR ds:di).oldvol],al
@@same:
	mov	[(VOIX ptr ds:di).effet],OFFSET tremolo

	ret

ENDP

PROC	set_play_end_part

	xor	eax,eax
	mov	ah,[(VOIX ptr ds:di).extra]
	cmp	ax,[(VOIX ptr ds:di).endsamp]
	jb	@@ok
	mov	ax,[(VOIX ptr ds:di).endsamp]
@@ok:
	mov	[(dword ptr (VOIX ptr ds:di).adrvoc)],eax
	or	[(VOIX ptr ds:di).gusinf],2	; ne changer que curadr

	mov	[(VOIX ptr ds:di).effet],OFFSET retour
	ret

ENDP

PROC	set_volume_slide

	mov	al,[(VOIX ptr ds:di).extra]
	test	al,0f0h
	je	@@vol_down
	shr	al,4
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET volume_up
	ret

@@vol_down:
	mov	[(VOIX ptr ds:di).extra],al
	mov	[(VOIX ptr ds:di).effet],OFFSET volume_down
	ret

ENDP

PROC	position_jump

	mov	al,[(VOIX ptr ds:di).extra]
	dec	al
	mov	[ds:OFFSET Position],al
	mov	ah,[ds:OFFSET Nb_voice]
	xor	al,al
	mov	[word ptr ds:OFFSET Ligne],ax

	mov	[(VOIX ptr ds:di).effet],OFFSET retour

	ret

ENDP

PROC	set_volume

	mov	al,[(VOIX ptr ds:di).extra]
	cmp	al,40h
	jbe	@@volume_ok
	mov	al,40h
@@volume_ok:
	or	[(VOIX ptr ds:di).gusinf],8
	mov	[(VOIX ptr ds:di).volume],al
	mov	[(VOIX ptr ds:di).effet],OFFSET retour
	ret

ENDP


PROC	pattern_break

	mov	al,[(VOIX ptr ds:di).extra]
	add	al,64
	mov	cl,[ds:OFFSET Nb_voice]
	mul	cl
	mov	cl,2
	shl	ax,cl
	mov	[ds:OFFSET Ligne],ax

	mov     [(VOIX ptr ds:di).effet],OFFSET retour
	ret

ENDP

Effets_etendus	DW OFFSET set_nul_effect
		DW OFFSET set_fine_portamento_up
		DW OFFSET set_fine_portamento_down
		DW OFFSET set_nul_effect
		DW OFFSET set_nul_effect
		DW OFFSET set_nul_effect
		DW OFFSET set_loop
		DW OFFSET set_nul_effect
		DW OFFSET set_nul_effect
		DW OFFSET set_retrig_sample
		DW OFFSET set_fine_slide_volume_up
		DW OFFSET set_fine_slide_volume_down
		DW OFFSET set_cut_note
		DW OFFSET set_delay_note
		DW OFFSET set_pattern_delay
		DW OFFSET set_nul_effect

PROC	set_extended_effect

	mov	al,[(VOIX ptr ds:di).extra]
	mov	bl,al
	and	ax,0fh
	shr	bx,4
	and	bx,0fh
	mov 	[(VOIX ptr ds:di).effnb],bl
	add	[(VOIX ptr ds:di).effnb],10h
	shl	bx,1
	mov	bx,[ds:bx+OFFSET Effets_etendus]
	jmp	bx
ENDP

PROC	set_fine_portamento_up

	mov	bx,[(VOIX ptr ds:di).play]
	sub     bx,ax
	cmp     bx,LOW_NOTE
	jae     @@suite
	mov     bx,LOW_NOTE
@@suite:
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
	mov     [(VOIX ptr ds:di).play],bx

	ret
ENDP

PROC	set_fine_portamento_down

	mov	bx,[(VOIX PTR ds:di).play]
	add     bx,ax
	cmp     bx,HIGH_NOTE
	jbe     @@suite
	mov     bx,HIGH_NOTE
@@suite:
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
	mov     [(VOIX ptr ds:di).play],bx

	ret

ENDP

PROC set_loop

	or	al,al
	je	@@setloop

	cmp	[(VOIX ptr ds:di).compte],0
	je	@@begin_loop
	dec	[(VOIX ptr ds:di).compte]
	je	@@end_loop

@@loop:
	mov	ax,[(VOIX PTR ds:di).looppos]
	mov	[ds:OFFSET Ligne],ax

@@end_loop:
	mov	[(VOIX ptr ds:di).looppos],0
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
	ret

@@begin_loop:
	mov	[(VOIX ptr ds:di).compte],al
	jmp	@@loop

@@setloop:
	mov     ax,[ds:OFFSET Ligne]
	sub	ax,16
	mov	[(VOIX PTR ds:di).looppos],ax
	mov	[(VOIX PTR ds:di).effet],OFFSET retour
	ret

ENDP

PROC set_retrig_sample

	xor	ah,ah
	mov	[(VOIX PTR ds:di).note1],ax
	mov	[(VOIX PTR ds:di).effet],OFFSET retrig_sample

	ret

ENDP

PROC set_fine_slide_volume_up

	mov     ah,[(VOIX ptr ds:di).volume]
	add     ah,al
	cmp     ah,40h
	jbe     @@ok
	mov     ah,40h
@@ok:
	mov     [(VOIX ptr ds:di).volume],ah
        or	[(VOIX ptr ds:di).gusinf],8
	mov	[(VOIX ptr ds:di).effet],OFFSET retour

	ret

ENDP

PROC set_fine_slide_volume_down

	mov     ah,[(VOIX ptr ds:di).volume]
	sub     ah,al
	jge     @@ok
	xor     ah,ah
@@ok:
	mov     [(VOIX ptr ds:di).volume],ah
        or	[(VOIX ptr ds:di).gusinf],8
	mov	[(VOIX ptr ds:di).effet],OFFSET retour

	ret

ENDP

PROC set_cut_note

	xor	ah,ah
	mov	[(VOIX PTR ds:di).note1],ax
	mov	[(VOIX PTR ds:di).effet],OFFSET cut_note

	ret

ENDP

PROC set_delay_note

	xor	ah,ah
	mov	[(VOIX PTR ds:di).note1],ax
	xchg	ah,[(VOIX PTR ds:di).volume]
        or	[(VOIX PTR ds:di).gusinf],8
	mov	[(VOIX PTR ds:di).oldvol],ah
	mov	[(VOIX PTR ds:di).effet],OFFSET delay_note

	ret

ENDP

PROC	set_pattern_delay

	mov	[ds:PatternDelay],al
	mov	[(VOIX PTR ds:di).effet],OFFSET retour

	ret

ENDP

PROC	set_speed

	mov	al,[(VOIX ptr ds:di).extra]
	cmp	al,20h
	jae	@@change_speed

	mov     [ds:OFFSET Tempo],al
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
	ret

@@change_speed:
	shl	ax,8
	xor	dx,dx
	mov	bx,100
	div	bx
	mov	[ds:OFFSET Speed],ax
	mov	[(VOIX ptr ds:di).effet],OFFSET retour
	ret

ENDP

;***************************************************************************
;*      Procedures gerant les differents effets

PROC retour
	ret
ENDP

TAB_ARPEGE:
		DW  1AC0h,1940h,17D0h,1680h,1530h
		DW  1400h,12E0h,11D0h,10D0h,0FE0h
		DW  0F00h,0E28h,0D60h,0CA0h,0BE8h
		DW  0B40h,0A98h,0A00h,0970h,08E8h
		DW  868h,7F0h,780h,714h,6B0h,650h
		DW  5F4h,5A0h,54Ch,500h,4B8h,474h
		DW  43Ah,3F8h,3C0h,38Ah
;TAB_ARPEGE:	DW  358h,328h,2fah,2d0h,2a6h,280h
		DW  25ch,23ah,21ah,1fch,1e0h,1c5h
		DW  1ach,194h,17dh,168h,153h,140h
		DW  12eh,11dh,10dh,0feh,0f0h,0e2h
		DW  0d6h,0cah,0beh,0b4h,0aah,0a0h
		DW  097h,08fh,087h,07fh,078h,071h
		DW  06Bh,065h,05Fh,05Ah,055h,050h
		DW  04Bh,047h,043h,03Fh,03Ch,038h
		DW  035h,032h,02Fh,02Dh,02Ah,028h
		DW  025h,023h,021h,01Fh,01Eh,01Ch
		DW  000h,01Ch,01Ch,01Ch,01Ch,01Ch
		DW  01Ch,01Ch,01Ch,01Ch,01Ch,01Ch
		DW  01Ch,01Ch,01Ch,01Ch

PROC	arpeggio

	mov	ax,[(VOIX ptr ds:di).play]
	xchg	ax,[(VOIX ptr ds:di).note1]
	xchg	ax,[(VOIX ptr ds:di).note2]
	mov	[(VOIX ptr ds:di).play],ax

	ret
ENDP

PROC portamento_up

	mov	ax,[(VOIX ptr ds:di).play]
	sub     ax,[(VOIX ptr ds:di).note1]
	jc	@@bug1992
	cmp     ax,LOW_NOTE
	jae     @@suite
@@bug1992:
	mov     ax,LOW_NOTE
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	ret

ENDP

PROC portamento_down

	mov	ax,[(VOIX ptr ds:di).play]
	add     ax,[(VOIX ptr ds:di).note1]
	cmp     ax,HIGH_NOTE
	jbe     @@suite
	mov     ax,HIGH_NOTE
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	ret

ENDP

PROC portamento_tone_up

	mov     bx,[(VOIX ptr ds:di).newnote]
	mov     ax,[(VOIX ptr ds:di).play]
	sub     ax,[(VOIX ptr ds:di).oldport]
	jc	@@bug1992
	cmp     ax,bx
	jae     @@suite
@@bug1992:
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	ret

ENDP

PROC portamento_tone_down

	mov     ax,[(VOIX ptr ds:di).play]
	add     ax,[(VOIX ptr ds:di).oldport]
	mov     bx,[(VOIX ptr ds:di).newnote]
	cmp     ax,bx
	jbe     @@suite
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	ret
ENDP

SINUS           DB  000h,018h,031h,04ah,061h,078h,08dh,0a1h
		DB  0b4h,0c5h,0d4h,0e0h,0ebh,0f4h,0fah,0fdh
		DB  0ffh,0fdh,0fah,0f4h,0ebh,0e0h,0d4h,0c5h
		DB  0b4h,0a1h,08dh,078h,061h,04ah,031h,018h

PROC vibrato

	mov	al,[(VOIX ptr ds:di).temp]
	shr	al,2
	and	al,1fh
	mov	bx,OFFSET SINUS
	xlat
	xor	ah,ah
	mul	[(VOIX PTR ds:di).amplit]
	shr	ax,6
	mov	bx,[(VOIX PTR ds:di).newnote]
	cmp	[(VOIX PTR ds:di).temp],0
	jg	@@add
	neg	ax
@@add:
	add	bx,ax
	mov	[(VOIX PTR ds:di).play],bx
	mov	al,[(VOIX PTR ds:di).vitesse]
	add	[(VOIX PTR ds:di).temp],al

	ret

ENDP

PROC portamento_up_volume_up

	mov     ax,[(VOIX ptr ds:di).play]
	sub     ax,[(VOIX ptr ds:di).oldport]
	mov     bx,[(VOIX ptr ds:di).newnote]
	cmp     ax,bx
	jae     @@suite
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	jmp	volume_up

ENDP

PROC portamento_down_volume_up

	mov     ax,[(VOIX ptr ds:di).play]
	add     ax,[(VOIX ptr ds:di).oldport]
	mov     bx,[(VOIX ptr ds:di).newnote]
	cmp     ax,bx
	jbe     @@suite
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	jmp	volume_up
ENDP

PROC portamento_up_volume_down

	mov     ax,[(VOIX ptr ds:di).play]
	sub     ax,[(VOIX ptr ds:di).oldport]
	mov     bx,[(VOIX ptr ds:di).newnote]
	cmp     ax,bx
	jae     @@suite
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	jmp	volume_down

ENDP

PROC portamento_down_volume_down

	mov     ax,[(VOIX ptr ds:di).play]
	add     ax,[(VOIX ptr ds:di).oldport]
	mov     bx,[(VOIX ptr ds:di).newnote]
	cmp     ax,bx
	jbe     @@suite
	mov     ax,bx
	mov     [(VOIX ptr ds:di).effet],OFFSET retour
@@suite:
	mov     [(VOIX ptr ds:di).play],ax

	jmp	volume_down
ENDP

PROC vibrato_volume_up

	mov	al,[(VOIX ptr ds:di).temp]
	shr	al,2
	and	al,1fh
	mov	bx,OFFSET SINUS
	xlat
	xor	ah,ah
	mul	[(VOIX PTR ds:di).amplit]
	shr	ax,6
	mov	bx,[(VOIX PTR ds:di).newnote]
	cmp	[(VOIX PTR ds:di).temp],0
	jg	@@add
	neg	ax
@@add:
	add	bx,ax
	mov	[(VOIX PTR ds:di).play],bx
	mov	al,[(VOIX PTR ds:di).vitesse]
	add	[(VOIX PTR ds:di).temp],al

	jmp	volume_up

	ret

ENDP

PROC vibrato_volume_down

	mov	al,[(VOIX ptr ds:di).temp]
	shr	al,2
	and	al,1fh
	mov	bx,OFFSET SINUS
	xlat
	xor	ah,ah
	mul	[(VOIX PTR ds:di).amplit]
	shr	ax,6
	mov	bx,[(VOIX PTR ds:di).newnote]
	cmp	[(VOIX PTR ds:di).temp],0
	jg	@@add
	neg	ax
@@add:
	add	bx,ax
	mov	[(VOIX PTR ds:di).play],bx
	mov	al,[(VOIX PTR ds:di).vitesse]
	add	[(VOIX PTR ds:di).temp],al

	jmp	volume_down

	ret

ENDP

PROC tremolo

	mov	al,[(VOIX ptr ds:di).tremolo]
	shr	al,2
	and	al,1fh
	mov	bx,OFFSET SINUS
	xlat
	xor	ah,ah
	mul	[(VOIX PTR ds:di).note1]
	shr	ax,6

	mov	bl,[(VOIX PTR ds:di).oldvol]
	cmp	[(VOIX PTR ds:di).tremolo],0
	jg	@@add
	neg	ax
@@add:
	or	[(VOIX PTR ds:di).gusinf],8
	mov	bh,[(VOIX PTR ds:di).tremvit]
	add	[(VOIX PTR ds:di).tremolo],bh
	add	bx,ax
	jl	@@volume_min
	cmp	bl,40h
	ja	@@volume_max

	mov	[(VOIX PTR ds:di).volume],bl
	ret

@@volume_min:
	mov	[(VOIX PTR ds:di).volume],0
	ret

@@volume_max:
	mov	[(VOIX PTR ds:di).volume],40h
	ret
ENDP

PROC volume_up
        or	[(VOIX ptr ds:di).gusinf],8
	mov     al,[(VOIX ptr ds:di).volume]
	add     al,[(VOIX ptr ds:di).extra]
	cmp     al,40h
	jbe     @@ok
	mov     al,40h
@@ok:
	mov     [(VOIX ptr ds:di).volume],al

	ret

ENDP

PROC volume_down
        or	[(VOIX ptr ds:di).gusinf],8
	mov     al,[(VOIX ptr ds:di).volume]
	sub     al,[(VOIX ptr ds:di).extra]
	jge     @@ok
	xor     al,al
@@ok:
	mov     [(VOIX ptr ds:di).volume],al

	ret

ENDP

PROC	retrig_sample

	dec	[(VOIX PTR ds:di).note1]
	je	@@retrig
	ret

@@retrig:
	mov	[(dword ptr (VOIX PTR ds:di).adrvoc)],0
	or      [(VOIX ptr ds:di).gusinf],02h
	mov	al,[(VOIX PTR ds:di).extra]
	mov	[(byte ptr (VOIX PTR ds:di).note1)],al

	ret

ENDP

PROC	cut_note

	dec	[(VOIX PTR ds:di).note1]
	je	@@cut_note
	ret

@@cut_note:
        or	[(VOIX PTR ds:di).gusinf],8
	mov	[(VOIX PTR ds:di).volume],0
	mov	[(VOIX PTR ds:di).effet],OFFSET retour

	ret

ENDP


PROC	delay_note

	dec	[(VOIX PTR ds:di).note1]
	je	@@delay_note
	ret

@@delay_note:
        or	[(VOIX PTR ds:di).gusinf],8
	mov	al,[(VOIX PTR ds:di).oldvol]
	mov	[(VOIX PTR ds:di).volume],al
	mov	[(VOIX PTR ds:di).effet],OFFSET retour

	ret

ENDP



Old_int		DD ?
Compteur	DW 1
Timer		DD 0
Compteur0	DW ?

;**************************************************************************
;*	Remet le pc  l'heure grace  Timer et Compteur0

PROC	resettime

	mov	eax,[ds:Timer]
	xor	ebx,ebx
	mov	bx,[ds:Compteur0]
	mul	ebx
	mov	ebx,1193180
	div	ebx
	xor	edx,edx
	mov	ebx,60
	div     ebx
	push	dx
	xor	edx,edx
	div	ebx
	push	dx
	push	ax

	mov	ah,2ch
	int	21h

	pop	ax
	add	ch,al
	pop	ax
	add	cl,al
	pop	ax
	add	dh,al
	cmp	dh,60
	jb	@@ok
	inc	cl
	sub	dh,60
@@ok:
	cmp	cl,60
	jb	@@ok2
	inc	ch
	sub	cl,60
@@ok2:
	mov	ah,2dh
	int	21h


	ret

ENDP

;**************************************************************************
;*      initialise le son

PROC    Startmod FAR

	push	ds
	push	es
	push	si
	push	di

	mov	ax,CSEG
	mov	ds,ax

	mov	bx,[Used_device]

	in	al,21h			;arrte un maximum d'interruption
	mov	[ds:Int_Mask],al
	or	al,11111100b
	mov	ah,254
	mov	cl,[(DEVICE PTR ds:bx).irq]
	rol	ah,cl
	and	al,ah
        and	al,7Fh	;testgus2
	push	ax

	mov	dx,[(DEVICE ptr ds:bx).start]
	call	dx

	pop	ax
	out	21h,al

        mov	[cs:Started],1

	pop	di
	pop	si
	pop	es
	pop	ds

	ret

ENDP

;*************************************************************************
;*      termine le son

PROC    Stopmod FAR

	push	ds
	push	si
	push	di
	mov	ax,CSEG
	mov	ds,ax

	cmp	[Started],1
	jne	@@no_stop

	cli
	mov	bx,[Used_device]
	mov	dx,[(DEVICE ptr ds:bx).stop]
	call	dx

	mov	al,[cs:Int_Mask]
	out	21h,al
	sti
@@no_stop:

	pop	di
	pop	si
	pop	ds

	ret

ENDP

;***************************************************************************
;*	Routine permettant d'enlever le son

PROC	setnul

	mov	[byte ptr cs:OFFSET start_mksnd],0cbh

	ret

ENDP

PROC	soundnul

	ret

ENDP

;***************************************************************************
;*	Routines sonores pour un DAC sur le port parallle

LPT_ADR		EQU	8

;**************************************************************************
;*	Routine d'initialisation du DAC

PROC	setlpt

	mov	bx,[(DEVICE ptr ds:bx).port]
	mov	ax,40h
	mov	es,ax
	shl	bx,1
	mov	ax,[es:bx+LPT_ADR-2]
        or	ax,ax
        je	@@no_lpt
	mov	[ds:OFFSET port_dac+1],ax

	shr	[Voicelen],1
	clc

	ret

@@no_lpt:
	mov	ax,DAC_NOT_FOUND
        stc
        ret

ENDP

;***************************************************************************
;*	Passe en mode fin d'interruption automatique
;*

PROC	setautoeoi

	mov	al,11h
	out	20h,al
	jmp	$+2
	jmp	$+2
	mov	al,8h
	out	21h,al
	jmp	$+2
	jmp	$+2
	mov	al,4h
	out	21h,al
	jmp	$+2
	jmp	$+2
	mov	al,3h
	out	21h,al
	jmp	$+2
	jmp	$+2

	ret

ENDP

;***************************************************************************
;*	Revient dans le mode fin d'interruption normale

PROC	reseteoi

	mov	al,11h
	out	20h,al
	jmp	$+2
	jmp	$+2
	mov	al,8h
	out	21h,al
	jmp	$+2
	jmp	$+2
	mov	al,4h
	out	21h,al
	jmp	$+2
	jmp	$+2
	mov	al,1h
	out	21h,al
	jmp	$+2
	jmp	$+2

	ret

ENDP

;***************************************************************************
;*	Cette routine permet de commencer l'envoit du son sur un DAC
;*	il y a dans BX l'adresse de l'appareil selectionner

PROC	startlpt

	push	bx

	mov     ax,3508h
	int     21h
	mov     [word ptr cs:OFFSET Old_int],bx
	mov     [word ptr cs:OFFSET Old_int+2],es

	cli
	pop	bx

	mov	al,00110110b
	out     43h,al
	jmp	$+2
	jmp	$+2

	mov	dx,1
	xor	ax,ax
	div	[ds:Play_rate]

	mov	[ds:Compteur0],ax
	out     40h,al
	jmp	$+2
	jmp	$+2
	mov     al,ah
	out     40h,al
	jmp	$+2
	jmp	$+2

	mov	dx,[(DEVICE ptr ds:bx).sound]
	mov     ax,cs
	mov     ds,ax
	mov     ax,2508h
	int     21h

	call	setautoeoi

	sti

	ret
ENDP

;**************************************************************************
;*	cette procdure est en fait un bloc que l'on doit mettre 
;*	l'adresse Voices

PROC	makelpt FAR


	mov	cx,[Nb_voice]
        sub	cl,2
	push	cx

	mov	di,OFFSET Voix1
	mov     dx,[Voix1.effet]
	call    dx

        mov	di,[ds:OFFSET Page_sound]

	mov	bx,[Voix1.play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]

	ror	edx,10
	mov	cx,[Voix1.endsamp]
	les	esi,[Voix1.adrvoc]
	mov	bx,[Voix1.lenrep]
	cmp	si,cx
	jbe	@@ok1
@@adjust1:

	sub	si,bx
	cmp	si,cx
	ja	@@adjust1
@@ok1:

	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[Voix1.volume]
	add	bh,ah

@@voix1:
	add     esi,edx
	mov	al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	mov	[ds:di],ax
	add	di,2

	cmp	di,bp
	jne	@@voix1
	rol	ebp,16
buf_sound2:
	mov	di,OFFSET BUF_SOUND
buf_sound3:
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix1


	mov	[dword ptr OFFSET Voix1.adrvoc],esi

	pop	cx
	mov	di,OFFSET Voix2
@@next_voice:
	push	cx
	mov     dx,[(VOIX ptr ds:di).effet]
	call    dx

	mov	bx,[(VOIX ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	ror	edx,10
	mov	cx,[(VOIX ptr ds:di).endsamp]
	les	esi,[(VOIX ptr ds:di).adrvoc]
	mov	bx,[(VOIX ptr ds:di).lenrep]
	cmp	si,cx
	jbe	@@ok2
@@adjust2:
	sub	si,bx
	cmp	si,cx
	ja	@@adjust2
@@ok2:

	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[(VOIX ptr ds:di).volume]
	add	bh,ah

	push	di

	mov	ebp,[ds:OFFSET Page_end]
	mov	di,[ds:OFFSET Page_sound]
@@voix2:
	add     esi,edx
	mov	al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	add	[ds:di],ax
	add	di,2

	cmp	di,bp
	jne	@@voix2
	rol	ebp,16
buf_sound4:
	mov	di,OFFSET BUF_SOUND
buf_sound5:
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix2


        pop	di
	mov	[dword ptr ((VOIX ptr ds:di).adrvoc)],esi
        add	di,SIZE VOIX
        pop	cx
        dec	cl
        jne	@@next_voice

	mov     dx,[(VOIX ptr ds:di).effet]
	call    dx

	mov	bx,[(VOIX ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	ror	edx,10
	mov	cx,[(VOIX ptr ds:di).endsamp]
	les	esi,[(VOIX ptr ds:di).adrvoc]
	mov	bx,[(VOIX ptr ds:di).lenrep]
	cmp	si,cx
	jbe	@@ok4
@@adjust4:
	sub	si,bx
	cmp	si,cx
	ja	@@adjust4
@@ok4:

	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[(VOIX ptr ds:di).volume]
	add	bh,ah

	push	di
        mov	ebp,[ds:OFFSET Page_end]
	mov	di,[ds:OFFSET Page_sound]
@@voix4:
	add     esi,edx
	mov	al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	add	ax,[ds:di]
	sub	ah,128
	sub	al,128
	mov	[ds:di],ax
	add	di,2

	cmp	di,bp
	jne	@@voix4
	rol	ebp,16
buf_sound8:
	mov	di,OFFSET BUF_SOUND
buf_sound9:
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix4

        pop	di
	mov	[dword ptr ((VOIX ptr ds:di).adrvoc)],esi

@@fin4voice:

	shr	ebp,16
	and	bp,65535-BUF_LEN
	mov	[word ptr ds:OFFSET Page_sound],bp

@@fin:
	pop	di
	pop	si
	pop	bp
	pop	es
	pop	ds

	ret

ENDP

nop

;***************************************************************************
;*      interruption 8 permettant d'envoyer le son sur un port parallle

PROC    soundlpt FAR

      push      ax
      push      bx

      inc       [dword ptr cs:OFFSET Timer]

      mov       bx,[cs:OFFSET Ptr_sound]
      inc	bx
      and       bx,65535-BUF_LEN
      mov       [cs:OFFSET Ptr_sound],bx
      mov       al,[cs:bx]

      push	dx
port_dac:
      mov	dx,378h
      out       dx,al
      pop	dx

      pop       bx
      dec       [cs:Compteur]
      jz        @@int08

      pop       ax
      iret

@@int08:
	mov	ax,[cs:Play_rate]
        mov	[cs:Compteur],ax

      pop	ax
      jmp	[dword ptr cs:Old_int]

      mov	ax,[cs:Voicelen]
      mov       [cs:Compteur],ax
      pushad
      call	Makemod
      popad
      pop	ax
      iret

ENDP

;***************************************************************************
;*	Cette routine permet d'arreter l'envoit du son sur un DAC

PROC	stoplpt

	mov     al,00110110b
	out     43h,al
        xor	al,al
	out     40h,al
	out     40h,al

	call	reseteoi

	call	resettime

	mov     ax,2508h
	lds     dx,[dword ptr cs:OFFSET Old_int]
	int     21h

	ret

ENDP


UsedIrq	 DB 0


;***************************************************************************
;*	Cette routine remplace d'interruption 5 et est appel quand la
;*	restitution de la musique  t interromput

PROC	Sbend

	push	ax
	push	bx
	push	dx

	mov	bx,[cs:Used_device]
	mov	dx,[(DEVICE PTR cs:bx).port]
	add	dx,0eh
	in	al,dx
	sub	dx,2

	mov	ax,[cs:Sb_len]
	add	[cs:Ptr_sound],ax
	and     [cs:Ptr_sound],65535-BUF_LEN

	mov	al,20h
	out	20h,al

	pop	dx
	pop	bx
	pop	ax

	iret
ENDP

;***************************************************************************
;*	Cette routine remplace d'interruption 5

PROC	Sbint

	push	ax
	push	bx
	push	dx

	mov	bx,[cs:Used_device]
	mov	dx,[(DEVICE PTR cs:bx).port]
	add	dx,0eh
	in	al,dx
	sub	dx,2

@@wait1:
	in	al,dx
	or	al,al
	js	@@wait1
	mov	al,14h
	out	dx,al

@@wait2:
	in	al,dx
	or	al,al
	js	@@wait2
	mov	ax,[cs:Sb_len]
	add	[cs:Ptr_sound],ax
	and     [cs:Ptr_sound],65535-BUF_LEN
	dec	ax
	out 	dx,al

@@wait3:
	in	al,dx
	or	al,al
	js	@@wait3
	mov	al,ah
	out	dx,al

	mov	al,20h
	out	20h,al

	pop	dx
	pop	bx
	pop	ax

	iret
ENDP

Sb_freq	DB ?
Page_DMA DB ?
Int_Mask DB ?
Started	DB 0
Sb_len  DW ?


;***************************************************************************
;*	routine permettant d'initialiser le son sur la soundblaster

PROC	setsb

	mov	dx,[(DEVICE ptr ds:bx).port]
@@next_try:
	add	dx,6
	mov	al,1
	out	dx,al
	mov	cx,256	;compte des moutons pendant au moins 3s
@@compte:
	loop	@@compte
	dec	al
	out	dx,al
	add	dx,4
	mov	cx,64
@@test:
	in	al,dx
	cmp	al,0aah
	je	@@ok
	loop	@@test
	stc
	mov	ax,SB_NOT_FOUND
	ret
@@ok:
	sub	dx,0ah
	mov	[(DEVICE ptr ds:bx).port],dx
	push	dx

	mov	al,[(DEVICE PTR ds:bx).irq]
	add	al,8
	mov	ah,35h
	int	21h
	mov	[word ptr cs:OFFSET Old_int],bx
	mov	[word ptr cs:OFFSET Old_int+2],es
	shr	[Voicelen],1

	mov	ax,[Voicelen]

	xor	cl,cl
@@search_msb:
	inc	cl
	shr	ax,1
	jne	@@search_msb
	sub    	cl,2
	mov	ax,1
	shl	ax,cl
	mov	[Sb_len],ax

	mov	al,5  		;masque le canal 1
	out	0ah,al

	xor	dx,dx
	mov	ax,0D68Dh	;1000000*65536/1193180
	div	[Play_rate]
	neg	ax
	mov	ah,al

	pop	dx
	add	dx,0ch
@@wait2:
	in	al,dx
	or	al,al
	js	@@wait2
	mov	al,40h
	out	dx,al

@@wait3:
	in	al,dx
	or	al,al
	js	@@wait3
	mov	al,ah
	out	dx,al		; regle la frquence

@@wait4:
	in	al,dx
	or	al,al
	js	@@wait4
	mov	al,14h
	out	dx,al		; met en marche le transfert

@@wait5:
	in	al,dx
	or	al,al
	js	@@wait5
	mov	ax,[ds:Sb_len]
	dec	ax
	out	dx,al

@@wait6:
	in	al,dx
	or	al,al
	js	@@wait6
	mov	al,ah
	out	dx,al

@@wait7:			; Arrte le transfert
	in	al,dx
	or	al,al
	js	@@wait7
	mov	al,0D0h
	out	dx,al


	xor	al,al 		;efface la bascule interne
	out	0ch,al

	mov	al,59h
	out	0bh,al		;choix du mode

	mov	ax,cs
	mov     cx,ax
	shr	ch,4
	shl	ax,4
	add	ax,OFFSET BUF_SOUND
	cmp	ax,65536-BUF_LEN
	jb	@@ok1
	add	ax,BUF_LEN*2
	adc	ch,0
	add	[word ptr cs:buf_sound1+2],BUF_LEN*2
	add	[word ptr cs:buf_sound2+1],BUF_LEN*2
	add	[word ptr cs:buf_sound3+2],BUF_LEN*2
	add	[word ptr cs:buf_sound4+1],BUF_LEN*2
	add	[word ptr cs:buf_sound5+2],BUF_LEN*2
	add	[word ptr cs:buf_sound8+1],BUF_LEN*2
	add	[word ptr cs:buf_sound9+2],BUF_LEN*2
	add	[word ptr cs:buf_sound10+1],BUF_LEN*2
	add	[cs:Page_sound],BUF_LEN*2
	add	[cs:Ptr_sound],BUF_LEN*2
@@ok1:

	out	2,al		; place l'adresse de base
	mov	al,ah
	out	2,al
	mov	al,ch
	out	83h,al
	mov	ax,BUF_LEN
	dec	ax
	out	3,al		; place la longueur du bloc
	mov	al,ah
	out	3,al

	clc

	ret

ENDP

;***************************************************************************
;*	routine permettant de dmarrer l'envoit du son sur la soundblaster

PROC	startsb

	cli

	mov	dx,OFFSET Sbint
	mov	al,[(DEVICE PTR ds:bx).irq]
	add	al,8
	mov	ah,25h
	int	21h

	sti

	mov	dx,[(DEVICE PTR ds:bx).port]
	add	dx,0ch
@@wait1:
	in	al,dx
	or	al,al
	js	@@wait1
	mov	al,0d1h
	out	dx,al			; allume le haut parleur

@@wait2:
	in	al,dx
	or	al,al
	js	@@wait2
	mov	al,0d4h
	out	dx,al			; poursuit le transfert DMA

	mov	al,1
	out	0ah,al		; autorise le canal

	ret

ENDP

;***************************************************************************
;*	Cette routine permet d'arreter l'envoit du son sur une soundblaster

PROC	stopsb

	mov	dx,[(DEVICE ptr ds:bx).port]
	add	dx,0ch

@@wait1:
	in	al,dx
	or	al,al
	js	@@wait1
	mov	al,0D0h
	out	dx,al		; Stop le transfert DMA

@@wait:
	in	al,dx
	or	al,al
	js	@@wait
	mov	al,0d3h
	out	dx,al		; teint le haut parleur

	mov	al,5  		;masque le canal 1
	out	0ah,al

	mov	ah,25h
	mov	al,[(DEVICE PTR ds:bx).irq]
	add	al,8
	lds	dx,[dword ptr cs:OFFSET Old_int]
	int	21h

	ret

ENDP


;***************************************************************************
;*	routine permettant d'initialiser le speaker

PROC	setspk

	shr	[Play_rate],1
	shr	[Voicelen],1
	clc

	ret
ENDP

;***************************************************************************
;*	routine permettant de dmarrer l'envoit du son sur le speaker

PROC	startspk

	push	bx

	mov     ax,3508h
	int     21h
	mov     [word ptr cs:OFFSET Old_int],bx
	mov     [word ptr cs:OFFSET Old_int+2],es

	cli
	pop	bx

	mov	al,00110110b
	out     43h,al
	jmp	$+2
	jmp	$+2

	mov	dx,1
	xor	ax,ax
	div	[ds:Play_rate]
	shr	ax,1

	mov	[ds:Compteur0],ax
	out     40h,al
	jmp	$+2
	jmp	$+2
	mov     al,ah
	out     40h,al
	jmp	$+2
	jmp	$+2

	mov	al,10010000b  ;10010000b
	out     43h,al
	jmp	$+2
	jmp	$+2
	in      al,61h
	jmp	$+2
	jmp	$+2
	or      al,11b
	out     61h,al
	jmp	$+2
	jmp	$+2


	mov	dx,[(DEVICE ptr ds:bx).sound]
	mov     ax,cs
	mov     ds,ax
	mov     ax,2508h
	int     21h

	call	setautoeoi

	mov	al,20h
	out	20h,al

	sti

	ret

ENDP

;**************************************************************************
;*	cette procdure est en fait un bloc que l'on doit mettre 
;*	l'adresse Voices

PROC	makespk FAR

	mov	cx,[Nb_voice]
	sub	cl,2
        push	cx


	mov	di,OFFSET Voix1
	mov     dx,[Voix1.effet]
	call    dx
        mov	di,[ds:OFFSET Page_sound]

	mov	bx,[Voix1.play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	ror	edx,10
	mov	cx,[Voix1.endsamp]
	les	esi,[Voix1.adrvoc]
	mov	bx,[Voix1.lenrep]
	cmp	si,cx
	jbe	@@ok1
@@adjust1:
	sub	si,bx
	cmp	si,cx
	ja	@@adjust1
@@ok1:

	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[Voix1.volume]
;	add	al,[Voix1.volume]
	add	bh,ah

@@voix1:
	add     esi,edx
	mov	al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	mov	[ds:di],ax
	add	di,4

	cmp	di,bp
	jne	@@voix1
	rol	ebp,16
	mov	di,OFFSET BUF_SOUND
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix1

	mov	[dword ptr OFFSET Voix1.adrvoc],esi

        pop	cx
        mov	di,OFFSET Voix2
@@next_voice:
	push	cx
	mov     dx,[(VOIX ptr ds:di).effet]
	call    dx

	mov	bx,[(VOIX ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	ror	edx,10
	mov	cx,[(VOIX ptr ds:di).endsamp]
	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[(VOIX ptr ds:di).volume]
;	add	al,[(VOIX ptr ds:di).volume]
	add	bh,ah
	mov	ax,[(VOIX ptr ds:di).lenrep]
	push	di
	les	esi,[(VOIX ptr ds:di).adrvoc]
	cmp	si,cx
	jbe	@@ok2
@@adjust2:
	sub	si,ax
	cmp	si,cx
	ja	@@adjust2
@@ok2:

	mov	ebp,[ds:OFFSET Page_end]
	mov	di,[ds:OFFSET Page_sound]

@@voix2:
	add     esi,edx
	mov     al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	add     [ds:di],ax
	add	di,4

	cmp	di,bp
	jne	@@voix2
	rol	ebp,16
	mov	di,OFFSET BUF_SOUND
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix2


	pop	di
	mov	[dword ptr ((VOIX ptr ds:di).adrvoc)],esi
	add	di,SIZE VOIX

	pop	cx
	dec	cl
	jne	@@next_voice

	mov     dx,[(VOIX ptr ds:di).effet]
	call    dx

	mov	bx,[(VOIX ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	ror	edx,10
	mov	cx,[(VOIX ptr ds:di).endsamp]
	les	esi,[(VOIX ptr ds:di).adrvoc]
	mov	bx,[(VOIX ptr ds:di).lenrep]
	cmp	si,cx
	jbe	@@ok4
@@adjust4:
	sub	si,bx
	cmp	si,cx
	ja	@@adjust4
@@ok4:

	mov	bx,OFFSET Volume_tab
	mov	al,[MasterVol]
	mul	[(VOIX ptr ds:di).volume]
;	add	al,[(VOIX ptr ds:di).volume]
	add	bh,ah
	push	di
	mov	ebp,[ds:OFFSET Page_end]
	mov	di,[ds:OFFSET Page_sound]

@@voix4:
	add     esi,edx
	mov     al,[byte ptr es:si]
	adc	esi,edx
	xlat
	mov	ah,al
	mov	al,[byte ptr es:si]
	adc	si,0
	xlat
	add     ax,[ds:di]
	mov	[ds:di],ah
	mov	[ds:di+1],ah
	mov	ah,al
	mov	[ds:di+2],ax
	add	di,4

	cmp	di,bp
	jne	@@voix4
	rol	ebp,16
	mov	di,OFFSET BUF_SOUND
	cmp	bp,OFFSET BUF_SOUND+BUF_LEN
	jne	@@voix4

	pop	di
	mov	[dword ptr ((VOIX ptr ds:di).adrvoc)],esi

@@fin4voix:

	shr	ebp,16
	and	bp,65535-BUF_LEN
	mov	[word ptr ds:OFFSET Page_sound],bp

@@fin:
	pop	di
	pop	si
	pop	bp
	pop	es
	pop	ds

	ret

ENDP

;***************************************************************************
;*      interruption 8 permettant d'envoyer le son sur le speaker

PROC    soundspk FAR

      push      ax
      push      bx

      inc	[dword ptr cs:OFFSET Timer]

      mov	bx,[cs:OFFSET Ptr_sound]
      inc       bx
      and       bx,65535-BUF_LEN
      mov       [cs:OFFSET Ptr_sound],bx
      mov       al,[cs:bx]

      mov       bx,OFFSET VOLUME
      xlat      [cs:bx]

      out       42h,al

      pop	bx
      dec       [cs:Compteur]
      jz        @@int08

      pop       ax
      iret

@@int08:
	mov	ax,[cs:Play_rate]
        mov	[cs:Compteur],ax

      pop	ax
      jmp	[dword ptr cs:Old_int]

      mov	ax,[cs:Voicelen]
      mov       [cs:Compteur],ax
      pushad
      call	Makemod
      popad
      pop	ax
      iret

ENDP

Flag	DB 0

;***************************************************************************
;*	cette routine permet d'arreter l'envoit du son sur le speaker

PROC	stopspk

	in	al,61h
	and     al,11111100b
	out	61h,al

	mov     al,00110110b
	out     43h,al
        xor	al,al
	out     40h,al
	out     40h,al

	call	reseteoi

	call	resettime

	mov     ax,2508h
	lds     dx,[dword ptr cs:OFFSET Old_int]
	int     21h

	mov	al,20h
	out	20h,al

	ret

ENDP

VOLUME          DB 20h,1fh,1eh,1dh,1ch,1bh,1ah,19h
		DB 18h,17h,16h,15h,14h,13h,12h,11h
		DB 11h,10h,10h,0fh,0fh,0eh,0eh,0dh
		DB 0dh,0dh,0ch,0ch,0ch,0ch,0bh,0bh
		DB 0bh,0bh,0ah,0ah,0ah,0ah,0ah,09h
		DB 09h,09h,09h,09h,09h,09h,09h,09h
		DB 08h,08h,08h,08h,08h,08h,08h,08h
		DB 08h,08h,08h,08h,07h,07h,07h,07h
		DB 07h,07h,07h,06h,06h,06h,06h,06h
		DB 06h,06h,06h,06h,06h,06h,05h,05h
		DB 05h,05h,05h,05h,05h,05h,05h,05h
		DB 04h,04h,04h,04h,04h,04h,04h,04h
		DB 04h,04h,03h,03h,03h,03h,03h,03h
		DB 03h,03h,03h,03h,02h,02h,02h,02h
		DB 02h,02h,02h,02h,02h,01h,01h,01h
		DB 01h,01h,01h,01h,01h,01h,01h,01h
		DB 40h,40h,40h,40h,40h,40h,40h,40h
		DB 40h,40h,3fh,3fh,3fh,3fh,3fh,3fh
		DB 3fh,3fh,3fh,3fh,3fh,3fh,3eh,3eh
		DB 3eh,3eh,3eh,3eh,3eh,3eh,3eh,3eh
		DB 3dh,3dh,3dh,3dh,3dh,3dh,3dh,3dh
		DB 3dh,3ch,3ch,3ch,3ch,3ch,3ch,3ch
		DB 3ch,3ch,3ch,3bh,3bh,3bh,3bh,3bh
		DB 3bh,3bh,3bh,3bh,3bh,3ah,3ah,3ah
		DB 3ah,3ah,3ah,3ah,3ah,3ah,3ah,39h
		DB 39h,39h,39h,39h,39h,39h,39h,39h
		DB 39h,38h,38h,38h,38h,38h,38h,38h
		DB 38h,37h,37h,37h,37h,37h,36h,36h
		DB 36h,36h,35h,35h,35h,35h,34h,34h
		DB 34h,33h,33h,32h,32h,31h,31h,30h
		DB 30h,2fh,2eh,2dh,2ch,2bh,2ah,29h
		DB 28h,27h,26h,25h,24h,23h,22h,21h

;***************************************************************************
;*	Routines sonores pour la Gravis ultra sound

STRUC GUSDATA

	action		DB	?
			DW      ?
			DB      ?
	note		DW	?
	volume		DW	?
	repadr		DD	?
	endadr		DD	?
	curadr		DD	?
			DD	?
			DD	?
			DD	?

ENDS

GusMem	DD	0

GusSample DD 32 DUP (?)	; Adresse des samples dans la mmoire de la GUS

;***************************************************************************
;*	Routine permettant d'crire un octet dans la GUS
;*
;* Entre:
;*	DX	adresse de port de la GUS
;*	EBX	adresse o crire
;*	AL	donn  crire

PROC	putgus

	push	cx

	mov	cl,al
	mov	al,43h
	out	dx,al

	inc	dx
	mov	eax,ebx
	out	dx,ax

	dec	dx
	mov	al,44h
	out	dx,al

	add	dx,2
	shr	eax,16
	out	dx,al

	add	dx,2
	mov	al,cl
	out	dx,al

	sub	dx,4

	pop	cx

	ret

ENDP

;***************************************************************************
;*	Routine permettant de lire un octet de la RAM de la GUS
;*
;* Entre:
;*	DX	adresse de port de la GUS
;*	EBX	adresse  lire
;*
;* Sortie:
;*	AL	octet lus

PROC	getgus

	mov	al,43h
	out	dx,al

	inc	dx
	mov	eax,ebx
	out	dx,ax

	dec	dx
	mov	al,44h
	out	dx,al

	add	dx,2
	shr	eax,16
	out	dx,al

	add	dx,2
	in	al,dx

	sub	dx,4

	ret

ENDP

;***************************************************************************
;*	Envoit une commande  la GUS
;*
;* Entre:
;*	DX	adresse de port de la GUS
;*	AL	commande  envoyer
;*	AH	argument de la commande

PROC	putcom


	out	dx,al

	add	dx,2
	mov	al,ah
	out	dx,al

	sub	dx,2

	ret

ENDP

;***************************************************************************
;*	Routine d'initialisation de la GUS

PROC	setgus

	add	[(DEVICE ptr ds:bx).port],103h
        mov	dx,[(DEVICE ptr ds:bx).port]

	push	bx

	mov	ax,4ch		;Reset de la GUS
	call	putcom

	add	dx,4
	REPT	14
	in	al,dx
	ENDM
	sub	dx,4

	mov	ax,14ch
	call	putcom

	add	dx,4
	REPT    14
	in	al,dx
	ENDM
	sub	dx,4

	xor	ebx,ebx		; Test la mmoire de la GUS
@@test_mem:

	mov	al,0AAh		; Ecrit 55AAh en 00000h
	call	putgus
	inc	ebx
	mov	al,055h
	call	putgus

	call	getgus		; Lit 16 bits en 00000h
	mov	ch,al
	dec	ebx
	call	getgus
	mov     cl,al

        add	ebx,256*1024
	cmp	ebx,(1024+256)*1024
        je	@@enough_mem
	cmp	cx,55aah
	je	@@test_mem

@@enough_mem:
	sub	ebx,256*1024
	mov	[GusMem],ebx
	jnz	@@find_gus

	pop	bx
	mov	ax,GUS_NOT_FOUND	;Pas de gus
	stc
	ret

@@find_gus:

	pop	bx
	mov	[(DEVICE ptr ds:bx).port],dx
	mov	[ds:OFFSET port_gus1+1],dx
	mov	[ds:OFFSET port_gus2+1],dx

	mov	ax,0041h	; couche le DMA
	call	putcom

	mov	ax,0045h	; couche les timers
	call	putcom

	mov	ax,0049h	; pas de sampling
	call	putcom

	mov	ax,0cd0eh
	call	putcom

	mov	[ds:Play_rate],2422
	mov	al,SIZE GUSDATA			;32*nombre de voix
	mov	cl,[byte ptr ds:OFFSET Nb_voice]
	mul	cl
	mov	[ds:Voicelen],ax
;	sub	ax,4
;	sub	[ds:Ptr_sound],ax
;	and     [ds:Ptr_sound],65535-BUF_LEN

	mov	si,OFFSET Instruments
	mov	di,OFFSET GusSample+4
	xor	ebx,ebx
	mov	cl,[ds:Nb_instrument]
@@next_inst:
	push	cx

	mov	[ds:di],ebx
	push	di
	push	si

	mov	ax,[(INSTRUMENT ptr ds:si).adrseg]
	mov	es,ax
	xor	di,di
	mov	cx,[(INSTRUMENT ptr ds:si).length]

	or	cx,cx
	je	@@no_inst

	add	cx,SAMPLE_BORDER

	xor	si,si
@@next_byte:
	lods	[byte ptr es:si]
	call	putgus
	inc	ebx
	dec	cx
	jne	@@next_byte

@@no_inst:
	pop	si
	pop	di
	pop	cx

	add	si,SIZE INSTRUMENT
	add	di,4

	dec	cl
	jne	@@next_inst

	cmp	ebx,[GusMem]
;	ja	@@not_enough_mem

	clc

	ret

@@not_enough_mem:

	mov	ax,NOT_ENOUGH_GUS
	stc
        ret
ENDP



;***************************************************************************
;*	Commence  envoyer les donnes sur la GUS

PROC startgus

	mov	dx,[(DEVICE ptr ds:bx).port]
	push	bx

	mov	ch,31
@@next_voices:
	dec	dx
	mov	al,ch
	out	dx,al
	inc	dx

	mov	ax,0800h	; 800h loop enable
	call	putcom		; voice mode


;        mov	cl,ch
;	and	cl,1
;        mov	ax,0F0ch
;        add	ah,cl
;	and	ah,0Fh
;	call	putcom		; pan register

	mov	cl,ch
	inc	cl
	and	cl,2
	mov	ax,040ch
	jz	@@right
	mov	ah,0Bh
@@right:
	call	putcom		; pan register 4 et 11

	mov	ax,20dh		; stop les volumes ramps
	call	putcom

	mov	ax,3f06h	;changement de volume rapide
	call	putcom

	mov	al,9
	out	dx,al		; volume  0
	inc	dx
	xor	ax,ax
	out	dx,ax
	dec	dx

	dec	ch
	jge	@@next_voices

	mov	ax,34ch		;Allume le haut parleur
	call	putcom

	sub	dx,103h
	mov	al,1h
	out	dx,al
	add	dx,103h

	mov     ax,3508h
	int     21h
	mov     [word ptr cs:OFFSET Old_int],bx
	mov     [word ptr cs:OFFSET Old_int+2],es

	pop	bx
	cli

	mov	al,00110110b  ;00110110b
	out     43h,al

	mov	ax,5d37h		; interruption  50Hz
	mov	[ds:Compteur0],ax
	out     40h,al
	mov     al,ah
	out     40h,al

	mov	dx,[(DEVICE ptr ds:bx).sound]
	mov     ax,cs
	mov     ds,ax
	mov     ax,2508h
	int     21h

	call	setautoeoi

	mov	al,20h
	out	20h,al

	sti

	ret

ENDP

;***************************************************************************
;*	Procdure qui place les donnes du son dans le buffer

PROC	makegus FAR

	mov	cx,[Nb_voice]
	mov	di,OFFSET Voix1
	mov	si,[ds:OFFSET Page_sound]
@@next_voice:
	push	cx

	mov     dx,[(VOIX ptr ds:di).effet]
	call    dx

	mov	bx,[(VOIX ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	mov	[(GUSDATA ptr ds:si).note],dx
	ror	edx,10

	mov	cx,[(VOIX ptr ds:di).endsamp]
	les	ebp,[(VOIX ptr ds:di).adrvoc]
	mov	bx,[(VOIX ptr ds:di).lenrep]
	cmp	bp,cx
	jbe	@@ok1
@@adjust1:
	sub	bp,bx
	cmp	bp,cx
	ja	@@adjust1
@@ok1:

	mov  	al,[MasterVol]
	mul	[(VOIX ptr ds:di).volume]
	mov	bl,ah
	xor	bh,bh
	shl	bx,1
	mov	ax,[OFFSET GUS_VOLUME2+bx]
	mov	[(GUSDATA ptr ds:si).volume],ax

	mov	bl,[(VOIX ptr ds:di).inst]
	and	bx,1fh
	mov	[(VOIX ptr ds:di).inst],bl
	shl	bx,2
	mov	ch,[(VOIX ptr ds:di).gusinf]
	mov	[(VOIX ptr ds:di).gusinf],0
	mov	[(GUSDATA ptr ds:si).action],ch

	test	ch,01h
	jz	@@no_loadadr1

	xor	eax,eax
	mov	ax,[(VOIX ptr ds:di).endsamp]
	add	eax,[ds:bx+OFFSET GusSample]
	mov	[(GUSDATA ptr ds:si).endadr],eax

	xor	eax,eax
	mov	ax,[(VOIX ptr ds:di).endsamp]
	sub	ax,[(VOIX ptr ds:di).lenrep]
	add	eax,[ds:bx+OFFSET GusSample]
	mov	[(GUSDATA ptr ds:si).repadr],eax

@@no_loadadr1:

	test	ch,02h
	jz	@@no_loadcur1

	mov	eax,[(dword ptr (VOIX ptr ds:di).adrvoc)]
	and	eax,0ffffh
	add	eax,[ds:bx+OFFSET GusSample]
	mov	[(GUSDATA ptr ds:si).curadr],eax

@@no_loadcur1:

	mov	cx,820
@@voix1:
	add     ebp,edx
	adc	bp,0
	dec	cx
	jne	@@voix1

	mov	[dword ptr ((VOIX ptr ds:di).adrvoc)],ebp

	add	si,SIZE GUSDATA
	add	di,SIZE VOIX
	pop	cx
	dec	cl
	jne	@@next_voice

	and	si,65535-BUF_LEN
	mov	[word ptr ds:OFFSET Page_sound],si

@@fin:
	pop	di
	pop	si
	pop	bp
	pop	es
	pop	ds

	ret


ENDP


;***************************************************************************
;*      interruption 8 permettant d'envoyer le son sur la gus

PROC    soundgus1 FAR

	push	ax
	push	bx
	push	cx
	push	dx

	mov	ax,4A9h		; interruption  1kHz
	out     40h,al
	mov     al,ah
	out     40h,al

	inc       [dword ptr cs:OFFSET Timer]

	push	ds
	xor	ax,ax
	mov	ds,ax
	mov	[word ptr ds:20h],OFFSET soundgus2
	pop	ds

	mov	bx,[cs:OFFSET Ptr_sound]

port_gus1:
	mov	dx,323h

	mov	cl,[byte ptr cs:OFFSET Nb_voice]
	dec	cl
@@next_voice:
	dec	dx
	mov	al,cl
	out	dx,al

	inc	dx

	test	[(GUSDATA ptr cs:bx).action],4
	jz	@@no_voice_off

	mov	al,09h
	out	dx,al

	inc	dx
	mov	al,[cs:OFFSET GUS_VOLUME2]
	out	dx,al
	dec	dx

	mov	al,89h
	out	dx,al

	add	dx,2
	in	al,dx
	mov	ah,al
	sub	dx,2

        mov	al,7
	out	dx,al

        xor	al,al
	mov	ch,[cs:OFFSET GUS_VOLUME2+1]

	cmp	ch,ah
	ja	@@inc_vol
        mov	al,40h
	xchg	ch,ah
@@inc_vol:

	add	dx,2
        xchg	al,ah
	out	dx,al
	sub	dx,2

	mov	al,8
	out	dx,al

	add	dx,2
	mov	al,ch
	out	dx,al
	sub	dx,2

	mov	al,0dh
	out	dx,al

	add	dx,2
	mov	al,ah
	out	dx,al
	sub	dx,2

@@no_voice_off:

	add	bx,SIZE GUSDATA

	dec	cl
	jns	@@next_voice

	pop	dx
	pop	cx
	pop	bx
	pop	ax

	dec       [cs:Compteur]
        jz        @@int08

	iret

@@int08:
	push	ax
	mov	ax,3
        mov	[cs:Compteur],ax

        pop	ax
	jmp	[dword ptr cs:Old_int]


ENDP



PROC    soundgus2 FAR

	push	eax
	push	bx
	push	cx
	push	dx

	mov	ax,588Eh	; interruption  50Hz
	out     40h,al
	mov     al,ah
	out     40h,al

	push	ds
	xor	ax,ax
	mov	ds,ax
	mov	[word ptr ds:20h],OFFSET soundgus1
	pop	ds

	mov	bx,[cs:OFFSET Ptr_sound]

port_gus2:
	mov	dx,323h

	mov	cl,[byte ptr cs:OFFSET Nb_voice]
	dec	cl
@@next_voice:
	dec	dx
	mov	al,cl
	out	dx,al

	inc	dx

	mov	ch,[(GUSDATA ptr cs:bx).action]

	test	ch,1
	jz	@@no_new_inst

	mov	al,05h
	out	dx,al

	inc	dx
	mov	eax,[(GUSDATA ptr cs:bx).endadr]
	rol	eax,9
	out	dx,ax
	dec	dx

	mov	al,04h
	out	dx,al

	inc	dx
	ror	eax,16
	out	dx,ax
	dec	dx

	mov	al,03h
	out	dx,al

	inc	dx
	mov	eax,[(GUSDATA ptr cs:bx).repadr]
	rol	eax,9
	out	dx,ax
	dec	dx

	mov	al,02h
	out	dx,al

	inc	dx
	ror	eax,16
	out	dx,ax
	dec	dx

@@no_new_inst:

	test	ch,2
	jz	@@no_loadcur

	mov	al,0
	out	dx,al

	add	dx,2
	mov	al,3
	out	dx,al
	sub	dx,2

        REPT	6
        in	al,dx
        ENDM

	mov	al,0bh
	out	dx,al

	inc	dx
	mov	eax,[(GUSDATA ptr cs:bx).curadr]
	shl	eax,9
	out	dx,ax
	dec	dx

	mov	al,0ah
	out	dx,al

	inc	dx
	ror	eax,16
	out	dx,ax
	dec	dx

        mov	al,0
	out	dx,al

	add	dx,2
	mov	al,8
	out	dx,al
	sub	dx,2

        REPT	6
        in	al,dx
	ENDM

@@no_loadcur:

	test	ch,8
	jnz	@@ramp_vol

	jmp	@@ok_vol

@@ramp_vol:

	mov	al,89h
	out	dx,al

	add	dx,2
	in	al,dx
	mov	ah,al
	sub	dx,2

        mov	al,7
	out	dx,al

        xor	al,al
	mov	ch,[byte ptr ((GUSDATA ptr cs:bx).volume)+1]

        cmp	ch,ah
	ja	@@inc_vol
	mov	al,40h
        xchg	ch,ah
@@inc_vol:

	add	dx,2
        xchg	al,ah
	out	dx,al
	sub	dx,2

	mov	al,8
	out	dx,al

	add	dx,2
	mov	al,ch
	out	dx,al
	sub	dx,2

	mov	al,09h
        out	dx,al

        inc	dx
	mov	al,[byte ptr ((GUSDATA ptr cs:bx).volume)]
	out	dx,al
        dec	dx

	mov	al,0dh
	out	dx,al

	add	dx,2
        mov	al,ah
	out	dx,al
	sub	dx,2

@@ok_vol:
	mov	al,1
	out	dx,al

	inc	dx
	mov	ax,[(GUSDATA ptr cs:bx).note]
	out	dx,ax
	dec	dx

	add	bx,SIZE GUSDATA

	dec	cl
	jns	@@next_voice

	and	bx,65535-BUF_LEN
	mov	[cs:OFFSET Ptr_sound],bx

	pop	dx
	pop	cx
	pop	bx
	pop	eax

	iret

ENDP


;***************************************************************************
;*	cette routine permet d'arreter l'envoit du son sur la gus

PROC	stopgus

	mov	dx,[(DEVICE ptr ds:bx).port]

	mov	ax,14ch		;Eteint le haut parleur
	call	putcom

	sub	dx,103h
	mov	al,3
	out	dx,al
	add	dx,103h

	mov	cl,31
@@next_voices:
	dec	dx
	mov	al,cl
	out	dx,al
	inc	dx

	mov	ax,0300h	; 800h loop enable
	call	putcom		; voice mode


	mov	ax,030dh		; stop les volumes ramps
	call	putcom

	dec	cl
	jns	@@next_voices

	mov     al,00110110b
	out     43h,al
        xor	al,al
	out     40h,al
	out     40h,al

	call	reseteoi

	call	resettime

        push	ds
	mov     ax,2508h
	lds     dx,[dword ptr cs:OFFSET Old_int]
	int     21h

	mov	al,20h
	out	20h,al

	pop	ds

	ret

ENDP



GUS_VOLUME2	dw 28000,40048,43216,43856,44496,47104,47424,47696,48000,48272
		dw 48544,48832,49120,51312,51440,51584,51712,51840,51968,52096
		dw 52208,52336,52464,52592,52704,52848,52960,53072,53200,55328
		dw 55392,55456,55504,55568,55648,55696,55744,55824,55872,55920
		dw 55984,56032,56096,56144,56208,56272,56320,56384,56448,56512
		dw 56544,56608,56688,56720,56784,56832,56896,56928,57008,57040
		dw 57120,57168,57232,57280,57280

CutVoice	DB 00h

AMPLI:
	DB	080h,07ch,079h,076h,073h,070h,06dh,06ah,068h,066h,063h,061h,05fh,05dh,05bh,059h
	DB	057h,056h,054h,052h,051h,04fh,04dh,04ch,04ah,049h,048h,046h,045h,044h,042h,041h
	DB	040h,03fh,03eh,03ch,03bh,03ah,039h,038h,037h,036h,035h,034h,033h,032h,031h,030h
	DB	02fh,02eh,02dh,02dh,02ch,02bh,02ah,029h,028h,028h,027h,026h,025h,025h,024h,023h
	DB	022h,022h,021h,020h,01fh,01fh,01eh,01dh,01dh,01ch,01bh,01bh,01ah,01ah,019h,018h
	DB	018h,017h,017h,016h,015h,015h,014h,014h,013h,013h,012h,011h,011h,010h,010h,0fh
	DB	0fh,0eh,0eh,0dh,0dh,0ch,0ch,0bh,0bh,0ah,0ah,09h,09h,08h,08h,08h
	DB	07h,07h,06h,06h,05h,05h,04h,04h,04h,03h,03h,02h,02h,01h,01h,01h
	DB	0feh,0feh,0feh,0fdh,0fdh,0fch,0fch,0fbh,0fbh,0fbh,0fah,0fah,0f9h,0f9h,0f8h,0f8h
	DB	0f7h,0f7h,0f7h,0f6h,0f6h,0f5h,0f5h,0f4h,0f4h,0f3h,0f3h,0f2h,0f2h,0f1h,0f1h,0f0h
	DB	0f0h,0efh,0efh,0eeh,0eeh,0edh,0ech,0ech,0ebh,0ebh,0eah,0eah,0e9h,0e8h,0e8h,0e7h
	DB	0e7h,0e6h,0e5h,0e5h,0e4h,0e4h,0e3h,0e2h,0e2h,0e1h,0e0h,0e0h,0dfh,0deh,0ddh,0ddh
	DB	0dch,0dbh,0dah,0dah,0d9h,0d8h,0d7h,0d7h,0d6h,0d5h,0d4h,0d3h,0d2h,0d2h,0d1h,0d0h
	DB	0cfh,0ceh,0cdh,0cch,0cbh,0cah,0c9h,0c8h,0c7h,0c6h,0c5h,0c4h,0c3h,0c1h,0c0h,0bfh
	DB	0beh,0bdh,0bbh,0bah,0b9h,0b7h,0b6h,0b5h,0b3h,0b2h,0b0h,0aeh,0adh,0abh,0a9h,0a8h
	DB	0a6h,0a4h,0a2h,0a0h,09eh,09ch,099h,097h,095h,092h,08fh,08ch,089h,086h,083h,080h


SCREEN_POS	DW 640+640+640

;***************************************************************************
;*	Ecrit un nombre en EAX sur 32 bits en chaine de caractre
;*	correspondant  se reprsentation hexadcimal
;*
;* Entre:
;*	EDX	nombre  convertir

PROC	writelong

	push	es
	mov	ax,0b800h
	mov	es,ax
	mov	di,[cs:SCREEN_POS]
	add	di,16

	mov	ax,'h'
	std
	stosw
        inc	di

	mov	cl,4
@@next_digit:
	movzx	ax,dl
	shr	edx,8
	shl	ax,4
	shr	al,4
	xchg	al,ah
	and	ax,0f0fh
	add	ax,3030h
	cmp	al,3Ah
	jb	@@al_ok
	add	al,7
@@al_ok:
	cmp	ah,3Ah
	jb	@@ah_ok
	add	ah,7
@@ah_ok:
	xchg	al,ah
	dec	di
	stosb
	dec	di
	mov	al,ah
	stosb
	dec	cl
	jne	@@next_digit

	cld

	add	di,19
	mov	al,' '
	stosb
	inc	di

	pop	es

	cmp	di,4000
	jb	@@ok
	mov	di,0
@@ok:
	mov	[cs:SCREEN_POS],di


	ret

ENDP

;************************************************************
;*	Ecrit un caractre  l'cran AL=caractre  crire

PROC	writechar

	push	es
	push	di
	mov	di,0B800h
	mov	es,di
	mov	di,[cs:SCREEN_POS]
	stosb
	inc	di
	cmp	di,40000
	jb	@@ok
	xor	di,di
@@ok:
	mov	[cs:SCREEN_POS],di
	pop	di
	pop	es

	ret

ENDP

ENDS

END

