// sample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#define DI __declspec(dllimport)
#include "../buzzplay.h"

static FILE *g_fp;

int __stdcall SongRead(void *pbuf, int nbytes)
{
	return fread(pbuf, nbytes, 1, g_fp);
}


int __stdcall SongSeek(int pos)
{
	return !fseek(g_fp, pos, SEEK_SET);
}

BP_FileReader BPFR = { &SongRead, &SongSeek };

void OpenSong(char const *filename)
{
	g_fp = fopen(filename, "rb");
	BP_OpenSong(&BPFR);
	fclose(g_fp);
}

static void LoadDir(char const *dir, int type)
{
	B2String mask = (B2String)dir + "*.dll";
	_finddata_t fd;
	
	long h = _findfirst(mask, &fd);

	bool done = h == 0;

	while(!done)
	{
		char name[256];
		_splitpath(fd.name, NULL, NULL, name, NULL);
	
		B2String fn = (B2String)dir + fd.name;
		HINSTANCE hinst = LoadLibrary(fn);
		if (hinst != NULL)
		{
			BP_MachineFuncs mf;
			mf.CreateMachine = (void *(__stdcall *)())GetProcAddress(hinst, "CreateMachine");
			mf.GetInfo = (void *(__stdcall *)())GetProcAddress(hinst, "GetInfo");

			BP_AddMachineLib(name, type, &mf);
		
		}



		done = _findnext(h, &fd) != 0;
	}



}

static void LoadLibs(char const *path)
{
	B2String s;
	
	s = (B2String)path + "generators/";
	LoadDir(s, MT_GENERATOR);

	s = (B2String)path + "effects/";
	LoadDir(s, MT_EFFECT);
}

void Init(char const *buzzdir)
{
	printf("Initializing...\n");
	BP_Init(44100);
	
	B2String bgd = (B2String)buzzdir + "/gear/";

	LoadLibs(bgd);
}

extern void StartPlayer();
extern void StopPlayer();

float *AudioCallback(int &n)
{
	return BP_Generate(&n);
}

int __cdecl main(int argc, char* argv[])
{
	printf("BuzzPlay.DLL sample v0.00001 by Oskari Tammelin\n");
	if (argc < 3)
	{
		printf("Usage: buzzplay <song.bmx> <buzzpath>\nexample: buzzplay sample.bmx c:\\buzz\n");
		return 1;
	}

	Init(argv[2]);

	printf("Loading song...\n");
	OpenSong(argv[1]);

	printf("Playing... <+> forward <-> backward <i> songinfo <q> quit\n");
	StartPlayer();

	while(1)
	{
		Sleep(200);

		BP_SongInfo const *psi = BP_GetSongInfo();
		printf("\b\b\b\b\b\b\b\b\b\b\b%05d/%05d", psi->CurrentTick, psi->LastTick+1);
	
		if (kbhit())
		{
			char ch = getch();

			if (ch == 'q')
				break;

			if (ch == 'i')
				printf("%s\n\n", psi->Text);

			if (ch == '+')
				BP_SetPlayPosition(min(psi->LastTick, psi->CurrentTick+64));

			if (ch == '-')
				BP_SetPlayPosition(max(0, psi->CurrentTick-64));
		}


	}

	StopPlayer();
	BP_CloseSong();

	
	return 0;
}
 