;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  Some minimalistic low-level X11 code for Linux/i386.
;  By viznut (vheikkil@hytti.uku.fi)
;  Version 2000-08-28
;  If you use this, send credits to me.
;
;  * Connects an X11 server (localhost:6000)
;  * Opens a 256x256 window (8bpp)
;  * Sends frames from a memory buffer using XPutImage
;  * All this in about 300 bytes.
;
;  TODO:
;     * Fix colormap definition (PSEUDO=1)
;     * Code a small intro (512 or 1024 bytes)

%include "macros.inc"
%include "elf32.inc"

CODE: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

%assign BPP 8
%assign PSEUDO 0

ENTRY:

;;;;;;;;;; connect to X server

; sockargs: dd 2,1            ; AF_INET,SOCK_STREAM,IPPROTO_TCP (6)
; connargs: dd 6,sockaddr,16  ; sock(fillit)

	omov eax,16
	push eax
	push dword sockaddr
	mov al,6
	push eax
	mov al,1
	mov ebx,eax		; ebx=1 (socket)
	push eax
	inc eax
	push eax
	mov al,102		; eax=102 (socketcall)
	mov edx,eax		; -> save
	mov ecx,esp
	int 0x80		; assume: ecx kept; ebx<0x100

	lea ecx,[ecx+8]		; connargs
	mov [ecx],eax

	push eax		; -> save socket#

	dec eax
	jnz .o1
	   mov dl,1		; on error (-1): exit
	.o1:

	mov eax,edx		; eax=102 (socketcall) <-
	mov bl,3		; ebx=3   (connect)
				; ecx  ->  connargs
	int 0x80

;;;;;;;;;;; shake hands with X server

	;;; getscreensaver

	pop ebx			; socket fd <-

	lea eax,[edx-98]	; eax=4 (write)
	
	xor ecx,ecx
	mov cl,progheader
	mov [ecx],dword	0xb006c	; getscreensaver, reqnum 0xb

	mov dl,12		; request size
	int 0x80

	;;; get reply

	lea eax,[edx-9]		; eax=3 (read)
	omov ecx,xbuffer
	mov dh,0xff		; edx=0xff0b (enough)
	int 0x80

	;;; read reply

	mov edi,putimage	; also prepare putimage

	mov eax,0x40060248	; request type, length, data type etc
	stosd

	mov eax,[ecx+12]	; ridbase
	stosd			; winid = ridbase+0
	inc eax
	stosd			; gc    = ridbase+1

	push eax
	mov eax,0x01000100	; size	    (256,256)
	stosd			;
	xor eax,eax		; dstX/dstY (0,0)
	stosd			;
	mov ah,BPP		;
	stosd			; depth     (8) ; pad
	pop eax	

	movzx ebp,word [ecx+24]	; skip vendorname
;	lea esi,[ecx+ebp+56]

	mov edi,[ecx+ebp+56]	; rootwin
	mov ecx,[ecx+ebp+56+32]	; visual

;	mov edi,[esi]		; rootwin
;	mov ecx,[esi+32]	; visual
;	; mov colormap,[esi+4]
;	; mov depth,[esi+38]	cmp byte .. , 8  => send error "bpp\n"

;;;;;;;;;;; create window, map window, create gc

	xor edx,edx

	;;; create gc

	push edx		; pad (0)
	push edi		; rootwin
	push eax		; gcid (ridbase+1)
	push dword 0x00040037

	;;; mapwindow

	dec eax
	push eax		; winid (ridbase+0)
	push dword 0x00020008

	; createcolormap somewhere
	; also write the storecolors stuff

	;;; createwindow

%if PSEUDO=1
	lea ebp,[eax+2]
	push ebp		; colormap (ridbase+2)
%endif
	push dword 0x00000100	; etc
	push edx		; 0
%if PSEUDO=1
	push dword 0x00000260	; flags | colormap
%else
	push dword 0x00000240	; flags
%endif
	push ecx		; visual
	push dword 0x00010000	; etc
	push dword 0x01000100	; window size
	push edx		; 0
	push edi		; rootwin (parent)
	push eax		; winid
%if PSEUDO=1
	push dword 0x000b0001|(BPP*256)
%else
	push dword 0x000a0001|(BPP*256)	; type, depth, length
%endif

%if PSEUDO=1
	;;; createcolormap

	push ecx		; visual
	push edi		; rootwin
	push ebp		; colormap (ridbase+2)
	push dword 0x0004014e	; type, alloc, length
%endif
	;;; send to the socket

	omov eax,4
	mov ecx,esp
%if PSEUDO=1
	mov dl,21*4
%else
	mov dl,16*4
%endif
	int 0x80

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

stuck:

	pushad
	omov edi,xbuffer
	omov ecx,65536

	mov edx,ebp

.l0	mov eax,edx
	add al,ch
	xor al,cl
	stosb
	loop .l0
	popad
	lea ebp,[ebp+9]

	omov eax,4
	omov ecx,putimage
	omov edx,0x4006*4
	int 0x80

	jmp stuck

;:;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sockaddr: 
   dw 2                  ; family=AF_INET
   db 6000/256,6000&255  ; port
   db 127,0,0,1          ; address

CODE_END:
 
putimage:
xbuffer equ putimage+24

DATA_END equ CODE_END+65536+24
