;   various macros for nasm

;   omov = (size-)Optimized (constant) MOVe
;          mostly ripped from asmutils headers.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

%macro __setreg32_08_lo 3
%ifnidn	%3,EMPTY
    xor	%2,%2
    mov	%1,%3
%endif
%endmacro

%macro __setreg32_08_hi 3
%ifnidn	%3,EMPTY
    xor	%2,%2
    mov	%1,(%3 / 0x100)
%endif
%endmacro

%macro __setreg32_16 3
%ifnidn	%3,EMPTY
    %if %3=0xFFFF
        xor	%2,%2
	dec	%1
    %else
	mov	%2,%3
    %endif
%endif
%endmacro

%macro omov 2-3
%ifnidn	%2,EMPTY
    %ifid %2
	mov	%1,%2
    %elifstr %2
	mov	%1,%2
    %elifnum %2
     %if %2=0x00000000
	xor	%1,%1
     %elif %2=0x00000001
    	xor	%1,%1
	inc	%1
     %elif %2=0x00000002
    	xor	%1,%1
	inc	%1
	inc	%1
     %elif %2=0xFFFFFFFF
	xor	%1,%1
	dec	%1
     %elif %2=0xFFFFFFFE
	xor	%1,%1
	dec	%1
	dec	%1
     %elif %2<0
        %ifidn %1,edx
           %if %2>=0xffffff00
               cdq
               dec edx
               mov dl,(%2 % 0x100)
           %else
               mov %1,%2
           %endif
        %else
	    mov %1,%2
	%endif
     %elif %2<0x00000100
	%ifidn %1,eax
	    __setreg32_08_lo al,%1,%2
	%elifidn %1,ebx
	    __setreg32_08_lo bl,%1,%2
	%elifidn %1,ecx
	    __setreg32_08_lo cl,%1,%2
	%elifidn %1,edx
	    __setreg32_08_lo dl,%1,%2
	%else
	    mov	%1,%2
	%endif
     %elif %2<0x00010000 
	%if (%2 % 0x100) = 0
	    %ifidn %1,eax
		__setreg32_08_hi ah,%1,%2
	    %elifidn %1,ebx
	        __setreg32_08_hi bh,%1,%2
	    %elifidn %1,ecx
		__setreg32_08_hi ch,%1,%2
	    %elifidn %1,edx
		__setreg32_08_hi dh,%1,%2
	    %else
		mov	%1,%2
	    %endif
	%else
		mov	%1,%2
	%endif
     %else
	mov	%1,%2
     %endif
    %else
	mov	%1,%2
    %endif
%endif
%endmacro

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; oadd
;		-2		dec eax; dec eax		2
;		-1		dec eax				1
;		0		no code				0
;		1		inc eax				1
;		2		inc eax; inc eax		2
;		3..127		lea eax,[eax+n]			3
;		128		lea eax,[eax+127]; inc eax	4
;		129		add eax,129			5
