;  Viznut's 76-byte ELF32 header for Linux/i386

bits 32
org 0

elfheader: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	db 0x7f,"ELF"	; magic signature
	db 1		; class = 32-bit
	db 1		; data type = little-endian
	db 1		; version = current
	db 0		; os abi = System V
	db 0		; abi version = 0
	db 0		; padding = none
	align 16,db 0	; fill to 16 bytes

	dw 2		; type = executable
	dw 3		; machine = i386
	dd 1		; version = current
	dd ENTRY        ; program start address
	dd progheader	; progheader offset
	dd 0		; sectheader offset (irrelevant)
	dd 0		; flags
	dw 0x34		; elfheader size
	dw 0x28		; program header entry size
;--	dw 1		; number of progheader entries (merged)
;--	dw 0		; section header entry size (irrelevant)
;--	dw 0		; number of sections (merged)
;--	dw 0		; which one is the string table? (irrelevant)

progheader: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.seg0:
	dd 1		; segment type = loadable
	dd 0		; file offset of the segment
	dd 0		; memory address of the segment
	dd 0		; physical address (irrelevant)
	dd CODE_END     ; filesize
	dd DATA_END     ; memsize (allocated memory)
	dd 7		; flags = read+execute+write
	dd 1		; alignment
