; ------------------------------------------------------
; Vertex Array And WaveFront Obj
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotY                    real4   0.0
RotZ                    real4   0.0
Pos_Z                   real4   0.0

pmodel                  LPGLMmaterial 0
Array                   GLMArray <>

Light_Position          real4   -2.0, 2.0, -2.0, 1.0
Light_Diffuse           real4   1.0, 1.0, 1.0, 1.0
Light_Ambient           real4   0.2, 0.5, 0.7, 1.0

Mat_Specular            real4   1.0, 1.0, 1.0, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Load the object
                        invoke  glmReadOBJ, CSTR("..\..\Media\fish.obj")
                        mov     pmodel, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load model file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        ; Prepare it for rendering
                        invoke  glmUnitize, pmodel
                        invoke  glmFacetNormals, pmodel
                        invoke  glmVertexNormals, pmodel, CFLT(90.0)
                        invoke  glmCreateVertexArray, pmodel, GLM_SMOOTH or GLM_MATERIAL, addr Array

                        invoke  glEnable, GL_LIGHTING
                        invoke  glLightModeli, GL_LIGHT_MODEL_COLOR_CONTROL_EXT, GL_SEPARATE_SPECULAR_COLOR_EXT

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  glmDestroyVertexArray, addr Array
                        invoke  glmDelete, pmodel
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fild    Mouse_X
                        fadd    RotX
                        fstp    RotX

                        fild    Mouse_Y
                        fadd    RotY
                        fstp    RotY
                
                        fild    Mouse_Z
                        fmul    CFLT(0.001)
                        fadd    Pos_Z
                        fstp    Pos_Z
                        
                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.02)
                        invoke  glEnable, GL_LIGHT0
                        
                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-3.0)
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), Pos_Z
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                ; ------------------

                                invoke  glTranslatef, CFLT(-1.0), CFLT(0.0), CFLT(0.0)
                                ; Draw it with the builtin immediate mode (slower but handles ambient/specular & shininess)
                                ;invoke glmDraw, pmodel, GLM_SMOOTH or GLM_MATERIAL

                                ; ------------------

                                invoke  glTranslatef, CFLT(2.0), CFLT(0.0), CFLT(0.0)
                                ; Draw it with a vertex array (faster but doesn't handle ambient/specular & shininess)
                                
                                ; We have to make some specular/shininess for the whole object instead of each triangle
                                invoke  glMaterialf, GL_FRONT, GL_SHININESS, CFLT(110.0)
                                invoke  glMaterialfv, GL_FRONT, GL_SPECULAR, addr Mat_Specular

                                lea     esi, Array

                                invoke  glEnable, GL_COLOR_MATERIAL
                                invoke  glEnable, GL_VERTEX_ARRAY
                                ;invoke glEnable, GL_TEXTURE_COORD_ARRAY
                                invoke  glEnable, GL_NORMAL_ARRAY
                                invoke  glEnable, GL_COLOR_ARRAY

                                invoke  glVertexPointer, 3, GL_FLOAT, 0, [esi + GLMArray.Triangles]
                                invoke  glColorPointer, 3, GL_FLOAT, 0, [esi + GLMArray.Colors]
                                ;invoke glTexCoordPointer, 2, GL_FLOAT, 0, [esi + GLMArray.Textures]
                                invoke  glNormalPointer, GL_FLOAT, 0, [esi + GLMArray.Normals]
                                invoke  glDrawArrays, GL_TRIANGLES, 0, [esi + GLMArray.Nbr_Triangles]

                                invoke  glDisable, GL_COLOR_ARRAY
                                invoke  glDisable, GL_NORMAL_ARRAY
                                ;invoke glDisable, GL_TEXTURE_COORD_ARRAY
                                invoke  glDisable, GL_VERTEX_ARRAY
                                invoke  glDisable, GL_COLOR_MATERIAL

                        invoke  glPopMatrix

                        ret
Draw                    endp

end start
