; ------------------------------------------------------
; Texture Matrix
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Picture.asm
                        include ..\Common_Src\Textures.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

Texture1                PICTURE <>
Texture1_Id             dd      0

Zoom_Texture            real4   1.0
Pos_Texture             real4   0.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_PICTURE, CSTR("..\..\Media\floor.jpg"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_PICTURE, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ
                        
                        fld     CFLT(0.5)
                        fmul    FrameRate
                        fadd    Zoom_Texture
                        fstp    Zoom_Texture

                        fld     CFLT(0.001)
                        fmul    FrameRate
                        fadd    Pos_Texture
                        fstp    Pos_Texture

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        local   Temp_Zoom:real4

                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture1_Id
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR
                                
                                invoke  Enter_Tx_Matrix_Mode

                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                fld     Zoom_Texture
                                fsin
                                fadd    CFLT(1.0)
                                fadd    st(0), st(0)
                                fstp    Temp_Zoom
                                invoke  glScalef, Temp_Zoom, Temp_Zoom, CFLT(1.0)
                                invoke  glTranslatef, Pos_Texture, CFLT(-0.5), CFLT(0.0)
                                
                                invoke  Leave_Tx_Matrix_Mode

                                invoke  glBegin, GL_QUADS
                                        invoke  glColor3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                        invoke  glColor3f, CFLT(0.5), CFLT(0.5), CFLT(0.5)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0f)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0f)

                                        invoke  glColor3f, CFLT(0.7), CFLT(0.7), CFLT(0.7)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glEnd

                                invoke  glDisable, GL_TEXTURE_2D
                        invoke  glPopMatrix
                        ret
Draw                    endp

end start
