; ------------------------------------------------------
; Text 2D
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Fonts.asm

; ------------------------------------------------------
; Variables
lFont                   dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Create the fonts
                        invoke  Create_Font_Bitmap, CSTR("Times New Roman"), 72, FW_NORMAL
                        mov     lFont,eax
                        .if     eax == 0
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        invoke  Destroy_Font, lFont
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                invoke  glColor3f, CFLT(0.2), CFLT(0.5), CFLT(0.6)
                                lea     ebx, CSTR("MASM32")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(72), lFont, ebx, eax
                        invoke  Leave_2d_Mode

                        ret
Draw                    endp

end start
