; ------------------------------------------------------
; Sprites Collisions
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

MAX_SIZE                equ     128                     ; Size of the textures holding the sprites

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Textures.asm
                        include ..\Common_Src\Sprites.asm
                        include ..\Common_Src\Fonts.asm

; ------------------------------------------------------
; Variables
lFont                   dd      0

Picture1                BMP     <>
Picture1_Id             dd      0
Picture2                BMP     <>
Picture2_Id             dd      0

Sprite1_Datas           SPRITE_DATAS <>
Sprite2_Datas           SPRITE_DATAS <>
Sprite1                 SPRITE <>
Sprite2                 SPRITE <>

My_Mouse_X              dd      0
My_Mouse_Y              dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, CFLT(0.2), CFLT(0.25), CFLT(0.3), CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_BMP, CSTR("..\..\Media\sprite1.bmp"), addr Picture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Load_BMP, CSTR("..\..\Media\sprite2.bmp"), addr Picture2, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context

                        ; Create the visual datas for the sprites
                        mov     Sprite1_Datas.Sprite_Width, CMEM(Picture1.Orig_Width)
                        mov     Sprite1_Datas.Sprite_Height, CMEM(Picture1.Orig_Height)
                        mov     Sprite1_Datas.Sprite_Datas, CMEM(Picture1.Datas)
                        mov     Sprite1_Datas.Texture_Size, MAX_SIZE                    ; Must be a standard texture size
                        mov     Sprite1_Datas.Color_Key, 0ff00ffh                       ; Background color
                        mov     Sprite1_Datas.Sprite_Pic_Width, CMEM(Picture1.Orig_Width)
                        mov     Sprite1_Datas.Sprite_Pic_Height, CMEM(Picture1.Orig_Height)
                        invoke  Create_Sprite_Datas, addr Sprite1_Datas
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create sprite")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     Sprite2_Datas.Sprite_Width, CMEM(Picture2.Orig_Width)
                        mov     Sprite2_Datas.Sprite_Height, CMEM(Picture2.Orig_Height)
                        mov     Sprite2_Datas.Sprite_Datas, CMEM(Picture2.Datas)
                        mov     Sprite2_Datas.Texture_Size, MAX_SIZE                    ; Must be a standard texture size
                        mov     Sprite2_Datas.Color_Key, 0ff00ffh                       ; Background color
                        mov     Sprite2_Datas.Sprite_Pic_Width, CMEM(Picture2.Orig_Width)
                        mov     Sprite2_Datas.Sprite_Pic_Height, CMEM(Picture2.Orig_Height)
                        invoke  Create_Sprite_Datas, addr Sprite2_Datas
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create sprite")
                                mov     eax, FALSE
                                ret
                        .endif

                        ; Assign them to our sprites
                        invoke  Create_Sprite, addr Sprite1, addr Sprite1_Datas
                        invoke  Create_Sprite, addr Sprite2, addr Sprite2_Datas

                        ; Create the fonts
                        invoke  Create_Font_Bitmap, CSTR("Courier New"), 12, FW_NORMAL
                        mov     lFont, eax
                        .if     eax == 0
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax,TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Sprite_Datas, addr Sprite1_Datas
                        invoke  Destroy_Sprite_Datas, addr Sprite2_Datas

                        invoke  Destroy_Font, lFont
                        invoke  Unload_BMP, addr Picture2
                        invoke  Unload_BMP, addr Picture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        invoke  DInput_Clamp_Mouse, Mouse_X, addr My_Mouse_X, 0, SCREEN_WIDTH - 1
                        invoke  DInput_Clamp_Mouse, Mouse_Y, addr My_Mouse_Y, 0, SCREEN_HEIGHT - 1

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        local   Collide:dword

                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT


                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glEnable, GL_BLEND
                                invoke  glBlendFunc, GL_DST_ALPHA, GL_ONE_MINUS_SRC_ALPHA

                                invoke  glColor3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                ; Sprite 1 controlled by the mouse
                                mov     eax, My_Mouse_X
                                mov     ebx, My_Mouse_Y
                                mov     Sprite1.X, eax
                                mov     Sprite1.Y, ebx
                                invoke  Display_Sprite, addr Sprite1

                                ; Sprite 2 centered on screen
                                mov     eax, SCREEN_WIDTH
                                sub     eax, Picture1._Width
                                shr     eax, 1
                                mov     ebx, SCREEN_HEIGHT
                                sub     ebx, Picture1.Height
                                shr     ebx, 1
                                mov     Sprite2.X, eax
                                mov     Sprite2.Y, ebx
                                invoke  Display_Sprite, addr Sprite2

                                invoke  glDisable, GL_BLEND

                                invoke  Check_Collision, addr Sprite1, addr Sprite2
                                .if     eax == TRUE
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                        invoke  glColor4f, CFLT(1.0), CFLT(0.4), CFLT(0.2), CFLT(0.0)
                                        invoke  Display_2D_Text, INT2FLT(10), INT2FLT(502), lFont, CSTR("*COLLISION*"), 11
                                .endif

                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                invoke  glColor4f, CFLT(1.0), CFLT(0.8), CFLT(0.4), CFLT(0.0)
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(532), lFont, CSTR("Use mouse to move sprite."), 25

                        invoke  Leave_2d_Mode
                        ret
Draw                    endp

end start

