; ------------------------------------------------------
; Sphere Mapping Texture
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Picture.asm
                        include ..\Common_Src\Textures.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0
Texture1                PICTURE <>
Texture1_Id             dd      0

lst_Cylinder2           dd      0
Quadric_Cylinder1       dd      0
Quadric_Cylinder2       dd      0
Quadric_Cyl2_Disk1      dd      0
Quadric_Cyl2_Disk2      dd      0

; The w param set the infinite/local type
Light_Position          real4   -2.0, 2.0, 2.0, 1.0
Light_Diffuse           real4   1.0, 1.0, 1.0, 1.0
Light_Ambient           real4   0.5, 0.5, 0.5, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_PICTURE, CSTR("..\..\Media\floor.jpg"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        ; Create a cylinder with a hole
                        invoke  glGenLists, 1
                        mov     lst_Cylinder2, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cylinder1, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cylinder1, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cylinder1, GLU_SMOOTH
                                        invoke  gluCylinder, Quadric_Cylinder1, CDBL(0.21), CDBL(0.21), CDBL(1.0), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl2_Disk1, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl2_Disk1, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl2_Disk1, GLU_SMOOTH
                                        invoke  gluDisk, Quadric_Cyl2_Disk1, CDBL(0.10), CDBL(0.21), 40, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl2_Disk2, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl2_Disk2, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl2_Disk2, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cyl2_Disk2, GLU_INSIDE
                                        invoke  gluDisk, Quadric_Cyl2_Disk2, CDBL(0.10), CDBL(0.21), 40, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cylinder2, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cylinder2, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cylinder2, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cylinder2, GLU_INSIDE
                                        invoke  gluCylinder, Quadric_Cylinder2, CDBL(0.10), CDBL(0.10), CDBL(1.0), 40, 1
                                invoke  glPopMatrix
                        invoke  glEndList

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        invoke  glDeleteLists, lst_Cylinder2, 1
                        invoke  gluDeleteQuadric, Quadric_Cylinder1
                        invoke  gluDeleteQuadric, Quadric_Cylinder2
                        invoke  gluDeleteQuadric, Quadric_Cyl2_Disk1
                        invoke  gluDeleteQuadric, Quadric_Cyl2_Disk2

                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_PICTURE, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                
                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.01)
                        invoke  glEnable, GL_LIGHT0

                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.4)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture1_Id

                                ; enable stock texture generator
                                invoke  glEnable, GL_TEXTURE_GEN_S
                                invoke  glEnable, GL_TEXTURE_GEN_T
                                ; Select the generation mode
                                invoke  glTexGeni, GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP
                                invoke  glTexGeni, GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP

                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR

                                invoke  glCallList, lst_Cylinder2

                                invoke  glDisable, GL_TEXTURE_GEN_S
                                invoke  glDisable, GL_TEXTURE_GEN_T
                                invoke  glDisable, GL_TEXTURE_2D
                        invoke  glPopMatrix

                        ret
Draw                    endp

end start
