; ------------------------------------------------------
; Scissor
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Functions
Display_Cube            proto

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

; The w param set the infinite/local type
Light_Position          real4   -2.0, 2.0, 2.0, 1.0
Light_Diffuse           real4   1.0, 1.0, 1.0, 1.0
Light_Ambient           real4   0.2, 0.2, 0.2, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.02)
                        invoke  glEnable, GL_LIGHT0

                        ; Render 4 time the scene on four part of the screen
                        ; changing the rotation & the colors

                        invoke  glEnable, GL_COLOR_MATERIAL

                        invoke  glEnable, GL_SCISSOR_TEST

                        ; Left/Bottom
                        invoke  glScissor, 0, 0, SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2
                        invoke  glColor3f, CFLT(0.4), CFLT(0.6), CFLT(0.8)
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  Display_Cube
                        invoke  glPopMatrix

                        ; Right/Bottom
                        invoke  glScissor, SCREEN_WIDTH / 2, 0, SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2
                        invoke  glColor3f, CFLT(0.8), CFLT(0.6), CFLT(0.4)
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  Display_Cube
                        invoke  glPopMatrix

                        ; Right/Top
                        invoke  glScissor, SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2
                        invoke  glColor3f, CFLT(0.4), CFLT(0.8), CFLT(0.6)
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotZ, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  Display_Cube
                        invoke  glPopMatrix

                        ; Left/Top
                        invoke  glScissor, 0, SCREEN_HEIGHT / 2, SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2
                        invoke  glColor3f, CFLT(0.6), CFLT(0.8), CFLT(0.4)
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotZ, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  Display_Cube
                        invoke  glPopMatrix

                        invoke  glDisable, GL_SCISSOR_TEST
                        invoke  glDisable, GL_COLOR_MATERIAL
                        ret
Draw                    endp

; ------------------------------------------------------
; Name: Display_Cube()
; Desc: Display a simple cube
Display_Cube            proc
                        invoke  glBegin, GL_QUADS
                                invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                invoke  glNormal3f, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                invoke  glNormal3f, CFLT(0.0), CFLT(-1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0f)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0f)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0f)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0f)

                                invoke  glNormal3f, CFLT(1.0), CFLT(0.0), CFLT(0.0)     
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                invoke  glNormal3f, CFLT(-1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                        invoke  glEnd
                        ret
Display_Cube            endp

end start
