; ------------------------------------------------------
; Play Sounds
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Wav.asm
                        include ..\Common_Src\SoundMixer.asm
                        include ..\Common_Src\Fonts.asm

; ------------------------------------------------------
; Constants

; Mix at 44khz / Stereo (2) / 16 bits
SAMPLING_RATE           equ     44100
SAMPLING_CHANNELS       equ     2
SAMPLING_RESOLUTION     equ     16

SAMPLE_NOTE             equ     (12 * 4) + 9

; ------------------------------------------------------
; Variables
lFont                   dd      0

Wav1                    WAV     <>
Wav2                    WAV     <>
Panning2                real4   0.0
PingPong                dd      0
Wav_Slot                dd      -1

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Load the wav file and set it's base frequency to 440khz (A4) & not looping
                        invoke  Load_WAV, CSTR("..\..\Media\sound1.wav"), addr Wav1, CFLT(440.0), FALSE
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load .wav file")
                                mov     eax, FALSE
                                ret
                        .endif
                
                        invoke  Load_WAV, CSTR("..\..\Media\sound2.wav"), addr Wav2, CFLT(220.0), TRUE
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load .wav file")
                                mov     eax, FALSE
                                ret
                        .endif
                
                        ; If the mixing routine is not specified (NULL here) we only need to fill the last argument (Max_Polyphony)
                        invoke  DSound_Mixer_Create, g_window.hWnd, NULL, 0, 0, 0, 32
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create sound mixer")
                                mov     eax, FALSE
                                ret
                        .endif

                        ; Create the fonts
                        invoke  Create_Font_Bitmap, CSTR("Courier New"), 12, FW_NORMAL
                        mov     lFont,eax
                        .if     eax == 0
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        invoke  Destroy_Font, lFont
                        invoke  Unload_WAV, addr Wav2
                        invoke  Unload_WAV, addr Wav1
                        invoke  DSound_Mixer_Destroy
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4
                        local   Volume_Temp:dword
                        local   Cur_Panning:dword

                        ; Update scene here
                        invoke  DInput_Get_Key_NoRepeat, DIK_F1
                        .if     eax == TRUE
                                ; Address of the WAV structure
                                ; Volume (0.0 - 1.0)
                                ; Panning (0.0 - 1.0) (-1.0 = surround)
                                ; Note (0 - 127)
                                ; Slot to play (-1 to let the mixer allocate one from the Max_Polyphony)
                                invoke  Play_Wav, addr Wav1, CFLT(1.0), CFLT(0.5), SAMPLE_NOTE, -1
                        .endif

                        invoke  DInput_Get_Key_NoRepeat, DIK_F2
                        .if     eax == TRUE
                                invoke  Play_Wav, addr Wav1, CFLT(1.0), CFLT(0.0), SAMPLE_NOTE, -1
                        .endif
                        
                        invoke  DInput_Get_Key_NoRepeat, DIK_F3
                        .if     eax == TRUE
                                invoke  Play_Wav, addr Wav1, CFLT(1.0), CFLT(1.0), SAMPLE_NOTE, -1
                        .endif
                        
                        invoke  DInput_Get_Key_NoRepeat, DIK_F4
                        .if     eax == TRUE
                                invoke  Play_Wav, addr Wav1, CFLT(1.0), CFLT(-1.0), SAMPLE_NOTE, -1
                        .endif
                        
                        ; ----
                        invoke  DInput_Get_Key_NoRepeat, DIK_F5
                        .if     eax == TRUE
                                .if     Wav_Slot == -1
                                        mov     Panning2, 0
                                        invoke  Play_Wav, addr Wav2, CFLT(1.0), Panning2, SAMPLE_NOTE, -1
                                        mov     Wav_Slot, eax
                                .endif
                        .endif

                        invoke  DInput_Get_Key_NoRepeat, DIK_F6
                        .if     eax == TRUE
                                .if     Wav_Slot != -1
                                        invoke  Stop_Wav, Wav_Slot
                                        mov     Wav_Slot, -1
                                .endif
                        .endif

                        .if     Wav_Slot != -1
                                invoke  Is_Wav_Playing, Wav_Slot
                                .if     eax == TRUE
                                        fld     Panning2
                                        fsin
                                        fadd    CFLT(1.0)
                                        fmul    CFLT(0.5)
                                        fstp    Cur_Panning
                                        invoke  Set_Wav_Panning, Wav_Slot, Cur_Panning
                                        ; From left to right
                                        fld     CFLT(1.0)
                                        fmul    FrameRate
                                        fadd    Panning2
                                        fstp    Panning2
                                .else
                                        mov     Wav_Slot, -1
                                .endif
                        .endif

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                invoke  glColor3f, CFLT(0.4), CFLT(0.8), CFLT(0.3)
                                lea     ebx, CSTR("Press:")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32), lFont, ebx, eax
                                lea     ebx, CSTR("F1 - To play sound 1 in the front channel")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 2)), lFont, ebx, eax
                                lea     ebx, CSTR("F2 - To play sound 1 in the left channel")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 3)), lFont, ebx, eax
                                lea     ebx, CSTR("F3 - To play sound 1 in the right channel")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 4)), lFont, ebx, eax
                                lea     ebx, CSTR("F4 - To play sound 1 in the surround channel")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 5)), lFont, ebx, eax
                                lea     ebx, CSTR("F5 - To play sound 2 with dynamic panning")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 7)), lFont, ebx, eax
                                lea     ebx, CSTR("F6 - To stop sound 2")
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(10), INT2FLT(32 + (12 * 8)), lFont, ebx, eax
                        invoke  Leave_2d_Mode

                        ret
Draw                    endp

end start
