; ------------------------------------------------------
; Structures
QUAT                    struct
w                       real4   ?
x                       real4   ?
y                       real4   ?
z                       real4   ?
QUAT                    ends
LPQUAT                  typedef ptr QUAT

MATRIX                  struct
union           
        struct
        _11             real4   ?
        _12             real4   ?
        _13             real4   ?
        _14             real4   ?
        _21             real4   ?
        _22             real4   ?
        _23             real4   ?
        _24             real4   ?
        _31             real4   ?
        _32             real4   ?
        _33             real4   ?
        _34             real4   ?
        _41             real4   ?
        _42             real4   ?
        _43             real4   ?
        _44             real4   ?
        ends
        m               real4   [4 * 4] dup (?)
ends
MATRIX                  ends
LPMATRIX                typedef ptr MATRIX

; ------------------------------------------------------
; Functions
QuatToMat               proto   :LPQUAT, :LPMATRIX
MatToQuat               proto   :LPMATRIX, :LPQUAT
EulerToQuat             proto   :real4, :real4, :real4, :LPQUAT
QuatSlerp               proto   :LPQUAT, :LPQUAT, :real4, :LPQUAT
QuatLerp                proto   :LPQUAT, :LPQUAT, :real4, :LPQUAT
QuatNormalize           proto   :LPQUAT
QuatGetValue            proto   :LPQUAT, :ptr real4, :ptr real4, :ptr real4, :ptr real4
QuatSetValue            proto   :LPQUAT, :real4, :real4, :real4, :real4
QuatScaleAngle          proto   :LPQUAT, :real4
QuatInverse             proto   :LPQUAT
QuatSetFromAx           proto   :real4, :real4, :real4, :real4, :real4, :real4, :LPQUAT
QuatMul                 proto   :LPQUAT, :LPQUAT, :LPQUAT
QuatAdd                 proto   :LPQUAT, :LPQUAT, :LPQUAT
QuatSub                 proto   :LPQUAT, :LPQUAT, :LPQUAT
QuatDiv                 proto   :LPQUAT, :LPQUAT, :LPQUAT
QuatCopy                proto   :LPQUAT, :LPQUAT
QuatSquare              proto   :LPQUAT, :LPQUAT
QuatSqrt                proto   :LPQUAT, :LPQUAT
QuatDot                 proto   :LPQUAT, :LPQUAT
QuatLength              proto   :LPQUAT
QuatNegate              proto   :LPQUAT, :LPQUAT
QuatConjugate           proto   :LPQUAT, :LPQUAT
QuatExp                 proto   :LPQUAT, :LPQUAT
QuatLog                 proto   :LPQUAT, :LPQUAT
