GLM_NONE     equ (0)            ; render with only vertices
GLM_FLAT     equ (1 shl 0)      ; render with facet normals
GLM_SMOOTH   equ (1 shl 1)      ; render with vertex normals
GLM_TEXTURE  equ (1 shl 2)      ; render with texture coords
GLM_COLOR    equ (1 shl 3)      ; render with colors
GLM_MATERIAL equ (1 shl 4)      ; render with materials

; GLMmaterial: Structure that defines a material in a model. 
GLMmaterial struct 
_name dword ?                   ; name of material
diffuse real4 4 dup (?)         ; diffuse component
ambient real4 4 dup (?)         ; ambient component
specular real4 4 dup (?)        ; specular component
emissive real4 4 dup (?)        ; emissive component
shininess real4 ?               ; specular exponent
GLMmaterial ends
LPGLMmaterial typedef ptr GLMmaterial

; GLMtriangle: Structure that defines a triangle in a model.
GLMtriangle struct
vindices dword 3 dup (?)        ; array of triangle vertex indices
nindices dword 3 dup (?)        ; array of triangle normal indices
tindices dword 3 dup (?)        ; array of triangle texcoord indices
findex dword ?                  ; index of triangle facet normal
GLMtriangle ends
LPGLMtriangle typedef ptr GLMtriangle

GLMArray struct
Nbr_Triangles dword ?
Triangles dword ?
Normals dword ?
Colors dword ?
Textures dword ?
GLMArray ends
LPGLMArray typedef ptr GLMArray

; GLMgroup: Structure that defines a group in a model.
GLMgroup struct
_name dword ?           ; name of this group
numtriangles dword ?    ; number of triangles in this group
triangles dword ?       ; array of triangle indices
materials dword ?       ; index to material for group
usematerial dword ?
next dword ?            ; pointer to next group in model
GLMgroup ends
LPGLMgroup typedef ptr GLMgroup

; GLMmodel: Structure that defines a model.
GLMmodel struct
pathname dword ?             ; path to this model
mtllibname dword ?           ; name of the material library

numvertices dword ?          ; number of vertices in model
vertices dword ?             ; array of vertices

numnormals dword ?           ; number of normals in model
normals dword ?              ; array of normals

numtexcoords dword ?         ; number of texcoords in model
texcoords dword ?            ; array of texture coordinates

numfacetnorms dword ?        ; number of facetnorms in model
facetnorms dword ?           ; array of facetnorms

numtriangles dword ?         ; number of triangles in model
triangles dword ?            ; array of triangles

nummaterials dword ?         ; number of materials in model
materials dword ?            ; array of materials

numgroups dword ?            ; number of groups in model
groups dword ?               ; linked list of groups

position  real4 3 dup (?)    ; position of the model
GLMmodel ends
LPGLMmodel typedef ptr GLMmodel

; glmUnitize: "unitize" a model by translating it to the origin and
; scaling it to fit in a unit cube around the origin.  Returns the
; scalefactor used.
;
; model - properly initialized GLMmodel structure 
;
glmUnitize proto :dword

; glmDimensions: Calculates the dimensions (width, height, depth) of
; a model.
;
; model      - initialized GLMmodel structure
; dimensions - array of 3 GLfloats (GLfloat dimensions[3])
;
glmDimensions proto :dword,:dword

; glmScale: Scales a model by a given amount.
; 
; model - properly initialized GLMmodel structure
; scale - scalefactor (0.5 = half as large, 2.0 = twice as large)
;
glmScale proto :dword, :dword

; glmReverseWinding: Reverse the polygon winding for all polygons in
; this model.  Default winding is counter-clockwise.  Also changes
; the direction of the normals.
;
; model - properly initialized GLMmodel structure 
;
glmReverseWinding proto :dword

; glmFacetNormals: Generates facet normals for a model (by taking the
; cross product of the two vectors derived from the sides of each
; triangle).  Assumes a counter-clockwise winding.
;
; model - initialized GLMmodel structure
;
glmFacetNormals proto :dword

; glmVertexNormals: Generates smooth vertex normals for a model.
; First builds a list of all the triangles each vertex is in.  Then
; loops through each vertex in the the list averaging all the facet
; normals of the triangles each vertex is in.  Finally, sets the
; normal index in the triangle for the vertex to the generated smooth
; normal.  If the dot product of a facet normal and the facet normal
; associated with the first triangle in the list of triangles the
; current vertex is in is greater than the cosine of the angle
; parameter to the function, that facet normal is not added into the
; average normal calculation and the corresponding vertex is given
; the facet normal.  This tends to preserve hard edges.  The angle to
; use depends on the model, but 90 degrees is usually a good start.
;
; model - initialized GLMmodel structure
; angle - maximum angle (in degrees) to smooth across
;
glmVertexNormals proto :dword, :dword

; glmLinearTexture: Generates texture coordinates according to a
; linear projection of the texture map.  It generates these by
; linearly mapping the vertices onto a square.
;
; model - pointer to initialized GLMmodel structure
;
glmLinearTexture proto :dword

; glmSpheremapTexture: Generates texture coordinates according to a
; spherical projection of the texture map.  Sometimes referred to as
; spheremap, or reflection map texture coordinates.  It generates
; these by using the normal to calculate where that vertex would map
; onto a sphere.  Since it is impossible to map something flat
; perfectly onto something spherical, there is distortion at the
; poles.  This particular implementation causes the poles along the X
; axis to be distorted.
;
; model - pointer to initialized GLMmodel structure
;
glmSpheremapTexture proto :dword

; glmDelete: Deletes a GLMmodel structure.
;
; model - initialized GLMmodel structure
;
glmDelete proto :dword

; glmReadOBJ: Reads a model description from a Wavefront .OBJ file.
; Returns a pointer to the created object which should be free'd with
; glmDelete().
;
; filename - name of the file containing the Wavefront .OBJ format data.  
;
glmReadOBJ proto :dword

; glmDraw: Renders the model to the current OpenGL context using the
; mode specified.
;
; model    - initialized GLMmodel structure
; mode     - a bitwise OR of values describing what is to be rendered.
;            GLM_NONE    -  render with only vertices
;            GLM_FLAT    -  render with facet normals
;            GLM_SMOOTH  -  render with vertex normals
;            GLM_TEXTURE -  render with texture coords
;            GLM_FLAT and GLM_SMOOTH should not both be specified.
;
glmDraw proto :dword, :dword

; glmList: Generates and returns a display list for the model using
; the mode specified.
;
; model    - initialized GLMmodel structure
; mode     - a bitwise OR of values describing what is to be rendered.
;            GLM_NONE    -  render with only vertices
;            GLM_FLAT    -  render with facet normals
;            GLM_SMOOTH  -  render with vertex normals
;            GLM_TEXTURE -  render with texture coords
;            GLM_FLAT and GLM_SMOOTH should not both be specified.  
;
glmList proto :dword, :dword

; glmWeld: eliminate (weld) vectors that are within an epsilon of
; each other.
;
; model      - initialized GLMmodel structure
; epsilon    - maximum difference between vertices
;              ( 0.00001 is a good start for a unitized model)
;
;
glmWeld proto :dword, :dword

; glmReadPPM: read a PPM raw (type P6) file.  The PPM file has a header
; that should look something like:
;
;    P6
;    # comment
;    width height max_value
;    rgbrgbrgb...
;
; where "P6" is the magic cookie which identifies the file type and
; should be the only characters on the first line followed by a
; carriage return.  Any line starting with a # mark will be treated
; as a comment and discarded.   After the magic cookie, three integer
; values are expected: width, height of the image and the maximum
; value for a pixel (max_value must be < 256 for PPM raw files).  The
; data section consists of width*height rgb triplets (one byte each)
; in binary format (i.e., such as that written with fwrite() or
; equivalent).
;
; The rgb data is returned as an array of unsigned chars (packed
; rgb).  The malloc()'d memory should be free()'d by the caller.  If
; an error occurs, an error message is sent to stderr and NULL is
; returned.
;
; filename   - name of the .ppm file.
; width      - will contain the width of the image on return.
; height     - will contain the height of the image on return.
;
;
glmReadPPM proto :dword, :dword, :dword

; Prepare a vertex array with the model datas
glmCreateVertexArray proto :dword, :dword, :dword

; Prepare a vertex array with the model datas
glmDestroyVertexArray proto :dword
