;*==========================================================================;
;*
;*  Copyright (C) 1995-2001 Microsoft Corporation.  All Rights Reserved.
;*
;*  File:       dsound.h
;*  Content:    DirectSound include file
;*
;*************************************************************************
;
; Converted to asm by Franck Charlet.

ifndef DIRECTSOUND_VERSION
DIRECTSOUND_VERSION	equ	00800h  ; Version 8.0
endif

; Type definitions shared with Direct3D

ifndef DX_SHARED_DEFINES

D3DVALUE typedef real4
LPD3DVALUE typedef ptr real4

ifndef D3DVALUE_DEFINED
D3DVALUE typedef real4
D3DVALUE_DEFINED equ 1
endif

ifndef LPD3DVALUE_DEFINED
LPD3DVALUE typedef ptr D3DVALUE
endif

ifndef D3DCOLOR_DEFINED
D3DCOLOR typedef dword
D3DCOLOR_DEFINED equ 1
endif

ifndef LPD3DCOLOR_DEFINED
LPD3DCOLOR typedef ptr D3DCOLOR
LPD3DCOLOR_DEFINED equ 1
endif

ifndef D3DVECTOR_DEFINED
D3DVECTOR struct
x real4 ?
y real4 ?
z real4 ?
D3DVECTOR ends
D3DVECTOR_DEFINED equ 1
endif

ifndef LPD3DVECTOR_DEFINED
LPD3DVECTOR typedef ptr D3DVECTOR
LPD3DVECTOR_DEFINED equ 1
endif

DX_SHARED_DEFINES equ 1
endif ; DX_SHARED_DEFINES

_FACDS  equ 0878h   ; DirectSound's facility code

; DirectSound Component GUID {47D4D946-62E8-11CF-93BC-444553540000}
CLSID_DirectSound	equ     {047d4d946h, 062e8h, 011cfh, {093h, 0bch, 044h, 045h, 053h, 054h, 00h, 00h}}

; DirectSound 8.0 Component GUID {3901CC3F-84B5-4FA4-BA35-AA8172B8A09B}
CLSID_DirectSound8	equ     {03901cc3fh, 084b5h, 04fa4h, {0bah, 035h, 0aah, 081h, 072h, 0b8h, 0a0h, 09bh}}

; DirectSound Capture Component GUID {B0210780-89CD-11D0-AF08-00A0C925CD16}
CLSID_DirectSoundCapture	equ   {0b0210780h, 089cdh, 011d0h, {0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h}}

; DirectSound 8.0 Capture Component GUID {E4BCAC13-7F99-4908-9A8E-74E3BF24B6E1}
CLSID_DirectSoundCapture8	equ   {0e4bcac13h, 07f99h, 04908h, {09ah, 08eh, 074h, 0e3h, 0bfh, 024h, 0b6h, 0e1h}}

; DirectSound Full Duplex Component GUID {FEA4300C-7959-4147-B26A-2377B9E7A91D}
CLSID_DirectSoundFullDuplex	equ   {0fea4300ch, 07959h, 04147h, {0b2h, 06ah, 023h, 077h, 0b9h, 0e7h, 0a9h, 01dh}}

; DirectSound default playback device GUID {DEF00000-9C6D-47ED-AAF1-4DDA8F2B5C03}
DSDEVID_DefaultPlayback	equ   {0def00000h, 09c6dh, 047edh, {0aah, 0f1h, 04dh, 0dah, 08fh, 02bh, 05ch, 003h}}

; DirectSound default capture device GUID {DEF00001-9C6D-47ED-AAF1-4DDA8F2B5C03}
DSDEVID_DefaultCapture	equ   {0def00001h, 09c6dh, 047edh, {0aah, 0f1h, 04dh, 0dah, 08fh, 02bh, 05ch, 003h}}

; DirectSound default device for voice playback {DEF00002-9C6D-47ED-AAF1-4DDA8F2B5C03}
DSDEVID_DefaultVoicePlayback	equ   {0def00002h, 09c6dh, 047edh, {0aah, 0f1h, 04dh, 0dah, 08fh, 02bh, 05ch, 003h}}

; DirectSound default device for voice capture {DEF00003-9C6D-47ED-AAF1-4DDA8F2B5C03}
DSDEVID_DefaultVoiceCapture	equ   {0def00003h, 09c6dh, 047edh, {0aah, 0f1h, 04dh, 0dah, 08fh, 02bh, 05ch, 003h}}

;
; Forward declarations for interfaces.
; 'struct' not 'class' per the way DECLARE_INTERFACE_ is defined
;

;
; DirectSound 8.0 interfaces.
;

if DIRECTSOUND_VERSION ge 00800h

; IDirectSound8, IDirectSoundBuffer8 and IDirectSoundCaptureBuffer8 are the
; only DirectSound 7.0 interfaces with changed functionality in version 8.0.
; The other level 8 interfaces as equivalent to their level 7 counterparts:

IDirectSoundCapture8            equ	<IDirectSoundCapture>
IDirectSound3DListener8         equ	<IDirectSound3DListener>
IDirectSound3DBuffer8           equ	<IDirectSound3DBuffer>
IDirectSoundNotify8             equ	<IDirectSoundNotify>
IDirectSoundFXGargle8           equ	<IDirectSoundFXGargle>
IDirectSoundFXChorus8           equ	<IDirectSoundFXChorus>
IDirectSoundFXFlanger8          equ	<IDirectSoundFXFlanger>
IDirectSoundFXEcho8             equ	<IDirectSoundFXEcho>
IDirectSoundFXDistortion8       equ	<IDirectSoundFXDistortion>
IDirectSoundFXCompressor8       equ	<IDirectSoundFXCompressor>
IDirectSoundFXParamEq8          equ	<IDirectSoundFXParamEq>
IDirectSoundFXWavesReverb8      equ	<IDirectSoundFXWavesReverb>
IDirectSoundFXI3DL2Reverb8      equ	<IDirectSoundFXI3DL2Reverb>
IDirectSoundCaptureFXAec8       equ	<IDirectSoundCaptureFXAec>
IDirectSoundCaptureFXNoiseSuppress8 equ	<IDirectSoundCaptureFXNoiseSuppress>
IDirectSoundFullDuplex8         equ	<IDirectSoundFullDuplex>

endif ; DIRECTSOUND_VERSION ge 00800h

LPDIRECTSOUND typedef ptr IDirectSound
LPDIRECTSOUNDBUFFER typedef ptr IDirectSoundBuffer
LPDIRECTSOUND3DLISTENER typedef ptr IDirectSound3DListener
LPDIRECTSOUND3DBUFFER typedef ptr IDirectSound3DBuffer
LPDIRECTSOUNDCAPTURE typedef ptr IDirectSoundCapture
LPDIRECTSOUNDCAPTUREBUFFER typedef ptr IDirectSoundCaptureBuffer
LPDIRECTSOUNDNOTIFY typedef ptr IDirectSoundNotify

if DIRECTSOUND_VERSION ge 00800h
LPDIRECTSOUNDFXGARGLE typedef ptr IDirectSoundFXGargle
LPDIRECTSOUNDFXCHORUS typedef ptr IDirectSoundFXChorus
LPDIRECTSOUNDFXFLANGER typedef ptr IDirectSoundFXFlanger
LPDIRECTSOUNDFXECHO typedef ptr IDirectSoundFXEcho
LPDIRECTSOUNDFXDISTORTION typedef ptr IDirectSoundFXDistortion
LPDIRECTSOUNDFXCOMPRESSOR typedef ptr IDirectSoundFXCompressor
LPDIRECTSOUNDFXPARAMEQ typedef ptr IDirectSoundFXParamEq 
LPDIRECTSOUNDFXWAVESREVERB typedef ptr IDirectSoundFXWavesReverb
LPDIRECTSOUNDFXI3DL2REVERB typedef ptr IDirectSoundFXI3DL2Reverb
LPDIRECTSOUNDCAPTUREFXAEC typedef ptr IDirectSoundCaptureFXAec
LPDIRECTSOUNDCAPTUREFXNOISESUPPRESS typedef ptr IDirectSoundCaptureFXNoiseSuppress
LPDIRECTSOUNDFULLDUPLEX typedef ptr IDirectSoundFullDuplex

LPDIRECTSOUND8 typedef ptr IDirectSound8
LPDIRECTSOUNDBUFFER8 typedef ptr IDirectSoundBuffer8
LPDIRECTSOUND3DLISTENER8 typedef ptr IDirectSound3DListener8
LPDIRECTSOUND3DBUFFER8 typedef ptr IDirectSound3DBuffer8
LPDIRECTSOUNDCAPTURE8 typedef ptr IDirectSoundCapture8
LPDIRECTSOUNDCAPTUREBUFFER8 typedef ptr IDirectSoundCaptureBuffer8
LPDIRECTSOUNDNOTIFY8 typedef ptr IDirectSoundNotify8
LPDIRECTSOUNDFXGARGLE8 typedef ptr IDirectSoundFXGargle8
LPDIRECTSOUNDFXCHORUS8 typedef ptr IDirectSoundFXChorus8
LPDIRECTSOUNDFXFLANGER8 typedef ptr IDirectSoundFXFlanger8
LPDIRECTSOUNDFXECHO8 typedef ptr IDirectSoundFXEcho8
LPDIRECTSOUNDFXDISTORTION8 typedef ptr IDirectSoundFXDistortion8
LPDIRECTSOUNDFXCOMPRESSOR8 typedef ptr IDirectSoundFXCompressor8
LPDIRECTSOUNDFXPARAMEQ8 typedef ptr IDirectSoundFXParamEq8
LPDIRECTSOUNDFXWAVESREVERB8 typedef ptr IDirectSoundFXWavesReverb8
LPDIRECTSOUNDFXI3DL2REVERB8 typedef ptr IDirectSoundFXI3DL2Reverb8
LPDIRECTSOUNDCAPTUREFXAEC8 typedef ptr IDirectSoundCaptureFXAec8
LPDIRECTSOUNDCAPTUREFXNOISESUPPRESS8 typedef ptr IDirectSoundCaptureFXNoiseSuppress8
LPDIRECTSOUNDFULLDUPLEX8 typedef ptr IDirectSoundFullDuplex8

endif ; DIRECTSOUND_VERSION ge 00800h

;
; IID definitions for the unchanged DirectSound 8.0 interfaces
;

if DIRECTSOUND_VERSION ge 00800h
IID_IDirectSoundCapture8            equ	<IID_IDirectSoundCapture>
IID_IDirectSound3DListener8         equ	<IID_IDirectSound3DListener>
IID_IDirectSound3DBuffer8           equ	<IID_IDirectSound3DBuffer>
IID_IDirectSoundNotify8             equ	<IID_IDirectSoundNotify>
IID_IDirectSoundFXGargle8           equ	<IID_IDirectSoundFXGargle>
IID_IDirectSoundFXChorus8           equ	<IID_IDirectSoundFXChorus>
IID_IDirectSoundFXFlanger8          equ	<IID_IDirectSoundFXFlanger>
IID_IDirectSoundFXEcho8             equ	<IID_IDirectSoundFXEcho>
IID_IDirectSoundFXDistortion8       equ	<IID_IDirectSoundFXDistortion>
IID_IDirectSoundFXCompressor8       equ	<IID_IDirectSoundFXCompressor>
IID_IDirectSoundFXParamEq8          equ	<IID_IDirectSoundFXParamEq>
IID_IDirectSoundFXWavesReverb8      equ	<IID_IDirectSoundFXWavesReverb>
IID_IDirectSoundFXI3DL2Reverb8      equ	<IID_IDirectSoundFXI3DL2Reverb>
IID_IDirectSoundCaptureFXAec8       equ	<IID_IDirectSoundCaptureFXAec>
IID_IDirectSoundCaptureFXNoiseSuppress8 equ	<IID_IDirectSoundCaptureFXNoiseSuppress>
IID_IDirectSoundFullDuplex8         equ	<IID_IDirectSoundFullDuplex>
endif ; DIRECTSOUND_VERSION ge 00800h

;
; Compatibility typedefs
;

ifndef _LPCWAVEFORMATEX_DEFINED
_LPCWAVEFORMATEX_DEFINED equ 1
LPCWAVEFORMATEX typedef ptr WAVEFORMATEX
endif ; _LPCWAVEFORMATEX_DEFINED

ifndef __LPCGUID_DEFINED__
__LPCGUID_DEFINED__ equ 1
LPCGUID typedef ptr GUID
endif ; __LPCGUID_DEFINED__

LPLPDIRECTSOUND typedef ptr LPDIRECTSOUND
LPLPDIRECTSOUNDBUFFER typedef ptr LPDIRECTSOUNDBUFFER
LPLPDIRECTSOUND3DLISTENER typedef ptr LPDIRECTSOUND3DLISTENER
LPLPDIRECTSOUND3DBUFFER typedef ptr LPDIRECTSOUND3DBUFFER
LPLPDIRECTSOUNDCAPTURE typedef ptr LPDIRECTSOUNDCAPTURE
LPLPDIRECTSOUNDCAPTUREBUFFER typedef ptr LPDIRECTSOUNDCAPTUREBUFFER
LPLPDIRECTSOUNDNOTIFY typedef ptr LPDIRECTSOUNDNOTIFY

if DIRECTSOUND_VERSION ge 00800h
LPLPDIRECTSOUND8 typedef ptr LPDIRECTSOUND8
LPLPDIRECTSOUNDBUFFER8 typedef ptr LPDIRECTSOUNDBUFFER8
LPLPDIRECTSOUNDCAPTURE8 typedef ptr LPDIRECTSOUNDCAPTURE8
LPLPDIRECTSOUNDCAPTUREBUFFER8 typedef ptr LPDIRECTSOUNDCAPTUREBUFFER8
endif ; DIRECTSOUND_VERSION ge 00800h

;
; Structures
;

DSCAPS struct
dwSize dword ?
dwFlags dword ?
dwMinSecondarySampleRate dword ?
dwMaxSecondarySampleRate dword ?
dwPrimaryBuffers dword ?
dwMaxHwMixingAllBuffers dword ?
dwMaxHwMixingStaticBuffers dword ?
dwMaxHwMixingStreamingBuffers dword ?
dwFreeHwMixingAllBuffers dword ?
dwFreeHwMixingStaticBuffers dword ?
dwFreeHwMixingStreamingBuffers dword ?
dwMaxHw3DAllBuffers dword ?
dwMaxHw3DStaticBuffers dword ?
dwMaxHw3DStreamingBuffers dword ?
dwFreeHw3DAllBuffers dword ?
dwFreeHw3DStaticBuffers dword ?
dwFreeHw3DStreamingBuffers dword ?
dwTotalHwMemBytes dword ?
dwFreeHwMemBytes dword ?
dwMaxContigFreeHwMemBytes dword ?
dwUnlockTransferRateHwBuffers dword ?
dwPlayCpuOverheadSwBuffers dword ?
dwReserved1 dword ?
dwReserved2 dword ?
DSCAPS ends
LPDSCAPS typedef ptr DSCAPS
LPCDSCAPS typedef ptr DSCAPS

DSBCAPS struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwUnlockTransferRate dword ?
dwPlayCpuOverhead dword ?
DSBCAPS ends
LPDSBCAPS typedef ptr DSCAPS
LPCDSBCAPS typedef ptr DSCAPS

if DIRECTSOUND_VERSION ge 00800h

DSEFFECTDESC struct
dwSize dword ?
dwFlags dword ?
guidDSFXClass GUID <?>
dwReserved1 dword ?
dwReserved2 dword ?
DSEFFECTDESC ends
LPDSEFFECTDESC typedef ptr DSEFFECTDESC
LPCDSEFFECTDESC typedef ptr DSEFFECTDESC

DSFX_LOCHARDWARE    equ 000000001h
DSFX_LOCSOFTWARE    equ 000000002h

DSFXR_PRESENT equ 0
DSFXR_LOCHARDWARE equ 1
DSFXR_LOCSOFTWARE equ 2
DSFXR_UNALLOCATED equ 3
DSFXR_FAILED equ 4
DSFXR_UNKNOWN equ 5
DSFXR_SENDLOOP equ 6

DSCEFFECTDESC struct
dwSize dword ?
dwFlags dword ?
guidDSCFXClass GUID <?>
guidDSCFXInstance GUID <?>
dwReserved1 dword ?
dwReserved2 dword ?
DSCEFFECTDESC ends
LPDSCEFFECTDESC typedef ptr DSCEFFECTDESC
LPCDSCEFFECTDESC typedef ptr DSCEFFECTDESC

DSCFX_LOCHARDWARE   equ 000000001h
DSCFX_LOCSOFTWARE   equ 000000002h

DSCFXR_LOCHARDWARE  equ 000000010h
DSCFXR_LOCSOFTWARE  equ 000000020h

endif ; DIRECTSOUND_VERSION ge 00800h

DSBUFFERDESC struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwReserved dword ?
lpwfxFormat dword ?
if DIRECTSOUND_VERSION ge 00700h
    guid3DAlgorithm GUID <?>
endif
DSBUFFERDESC ends
LPDSBUFFERDESC typedef ptr DSBUFFERDESC
LPCDSBUFFERDESC typedef ptr DSBUFFERDESC

; Older version of this structure:

DSBUFFERDESC1 struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwReserved dword ?
lpwfxFormat dword ?
DSBUFFERDESC1 ends
LPDSBUFFERDESC1 typedef ptr LPDSBUFFERDESC1
LPCDSBUFFERDESC1 typedef ptr DSBUFFERDESC1

DS3DBUFFER struct
dwSize dword ?
vPosition D3DVECTOR <>
vVelocity D3DVECTOR <>
dwInsideConeAngle dword ?
dwOutsideConeAngle dword ?
vConeOrientation D3DVECTOR <>
lConeOutsideVolume dword ?
flMinDistance D3DVALUE ?
flMaxDistance D3DVALUE ?
dwMode dword ?
DS3DBUFFER ends
LPDS3DBUFFER typedef ptr DS3DBUFFER
LPCDS3DBUFFER typedef ptr DS3DBUFFER

DS3DLISTENER struct
dwSize dword ?
vPosition D3DVECTOR <>
vVelocity D3DVECTOR <>
vOrientFront D3DVECTOR <>
vOrientTop D3DVECTOR <>
flDistanceFactor D3DVALUE ?
flRolloffFactor D3DVALUE ?
flDopplerFactor D3DVALUE ?
DS3DLISTENER ends
LPDS3DLISTENER typedef ptr DS3DLISTENER
LPCDS3DLISTENER typedef ptr DS3DLISTENER

DSCCAPS struct
dwSize dword ?
dwFlags dword ?
dwFormats dword ?
dwChannels dword ?
DSCCAPS ends
LPDSCCAPS typedef ptr DSCCAPS
LPCDSCCAPS typedef ptr DSCCAPS

DSCBUFFERDESC1 struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwReserved dword ?
lpwfxFormat dword ?
DSCBUFFERDESC1 ends
LPDSCBUFFERDESC1 typedef ptr DSCBUFFERDESC1

DSCBUFFERDESC struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwReserved dword ?
lpwfxFormat dword ?
if DIRECTSOUND_VERSION ge 00800h
dwFXCount dword ?
lpDSCFXDesc LPDSCEFFECTDESC ?
endif
DSCBUFFERDESC ends
LPDSCBUFFERDESC typedef ptr DSCBUFFERDESC
LPCDSCBUFFERDESC typedef ptr DSCBUFFERDESC

DSCBCAPS struct
dwSize dword ?
dwFlags dword ?
dwBufferBytes dword ?
dwReserved dword ?
DSCBCAPS ends
LPDSCBCAPS typedef ptr DSCBCAPS
LPCDSCBCAPS typedef ptr DSCBCAPS

DSBPOSITIONNOTIFY struct
dwOffset dword ?
hEventNotify dword ?
DSBPOSITIONNOTIFY ends
LPDSBPOSITIONNOTIFY typedef ptr DSBPOSITIONNOTIFY
LPCDSBPOSITIONNOTIFY typedef ptr DSBPOSITIONNOTIFY

;
; DirectSound API
;

LPDSENUMCALLBACKA_proto typedef proto :dword ,:dword ,:dword, :dword
LPDSENUMCALLBACKA typedef ptr LPDSENUMCALLBACKA_proto

DirectSoundCreate	proto :dword, :dword, :dword
DirectSoundEnumerateA	proto :dword, :dword

DirectSoundCaptureCreate proto :dword, :dword, :dword
DirectSoundCaptureEnumerateA proto :dword, :dword

if DIRECTSOUND_VERSION ge 00800h
DirectSoundCreate8	proto :dword, :dword, :dword
DirectSoundCaptureCreate8	proto :dword, :dword, :dword
DirectSoundFullDuplexCreate	proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
DirectSoundFullDuplexCreate8 equ <DirectSoundFullDuplexCreate>

GetDeviceID	proto :dword, :dword
endif ; DIRECTSOUND_VERSION ge 00800h

LPDSENUMCALLBACK            textequ <LPDSENUMCALLBACKA>
DirectSoundEnumerate        textequ <DirectSoundEnumerateA>
DirectSoundCaptureEnumerate textequ <DirectSoundCaptureEnumerateA>

;
; IUnknown
;

ifndef __IReferenceClock_INTERFACE_DEFINED__
__IReferenceClock_INTERFACE_DEFINED__ equ 1

REFERENCE_TIME typedef LONGLONG
LPREFERENCE_TIME typedef ptr REFERENCE_TIME

IID_IReferenceClock equ {056a86897h, 00ad4h, 011ceh, {0b0h, 03ah, 000h, 020h, 0afh, 00bh, 0a7h, 070h}}

IReferenceClock struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IReferenceClock methods
STDMETHOD GetTime,:ptr ,:dword
STDMETHOD AdviseTime,:ptr ,:REFERENCE_TIME ,:REFERENCE_TIME ,:dword ,:dword
STDMETHOD AdvisePeriodic,:ptr ,:REFERENCE_TIME ,:REFERENCE_TIME ,:dword ,:dword
STDMETHOD Unadvise,:ptr ,:dword
IReferenceClock ends

endif ; __IReferenceClock_INTERFACE_DEFINED__

;
; IDirectSound
;

IID_IDirectSound equ {0279AFA83h, 04981h, 011CEh, {0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h}}

IDirectSound struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSound methods
STDMETHOD CreateSoundBuffer,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD DuplicateSoundBuffer,:PTR ,:dword ,:dword
STDMETHOD SetCooperativeLevel,:PTR ,:dword ,:dword
STDMETHOD _Compact,:PTR
STDMETHOD GetSpeakerConfig,:PTR, :dword
STDMETHOD SetSpeakerConfig,:PTR, :dword
STDMETHOD Initialize,:PTR, :dword
IDirectSound ends

if DIRECTSOUND_VERSION ge 00800h

;
; IDirectSound8
;

IID_IDirectSound8 equ {0C50A7E93h, 0F395h, 04834h, {09Eh, 0F6h, 07Fh, 0A9h, 09Dh, 0E5h, 009h, 066h}}

IDirectSound8 struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSound methods
STDMETHOD CreateSoundBuffer,:PTR, :dword, :dword, :dword
STDMETHOD GetCaps,:PTR, :dword
STDMETHOD DuplicateSoundBuffer,:PTR, :dword, :dword
STDMETHOD SetCooperativeLevel,:PTR, :dword, :dword
STDMETHOD _Compact,:PTR
STDMETHOD GetSpeakerConfig,:PTR, :dword
STDMETHOD SetSpeakerConfig,:PTR, :dword
STDMETHOD Initialize,:PTR, :dword

; IDirectSound8 methods
STDMETHOD VerifyCertification,:PTR, :dword
IDirectSound8 ends

endif ; DIRECTSOUND_VERSION >= 0x0800

;
; IDirectSoundBuffer
;

IID_IDirectSoundBuffer equ {0279AFA85h, 04981h, 011CEh, {0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h}}

IDirectSoundBuffer struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundBuffer methods
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD GetCurrentPosition,:PTR ,:dword ,:dword
STDMETHOD GetFormat,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetVolume,:PTR ,:dword
STDMETHOD GetPan,:PTR ,:dword
STDMETHOD GetFrequency,:PTR ,:dword
STDMETHOD GetStatus,:PTR ,:dword
STDMETHOD Initialize,:PTR ,:dword ,:dword
STDMETHOD _Lock,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD Play,:PTR ,:dword ,:dword ,:dword
STDMETHOD SetCurrentPosition,:PTR ,:dword
STDMETHOD SetFormat,:PTR ,:dword
STDMETHOD SetVolume,:PTR ,:dword
STDMETHOD SetPan,:PTR ,:dword
STDMETHOD SetFrequency,:PTR ,:dword
STDMETHOD Stop,:PTR
STDMETHOD Unlock,:PTR ,:dword ,:dword ,:dword ,:dword
STDMETHOD Restore,:PTR
IDirectSoundBuffer ends

if DIRECTSOUND_VERSION ge 00800h

;
; IDirectSoundBuffer8
;

IID_IDirectSoundBuffer8 equ {06825a449h, 07524h, 04d82h, {092h, 00fh, 050h, 0e3h, 06ah, 0b3h, 0abh, 01eh}}

IDirectSoundBuffer8 struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundBuffer methods
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD GetCurrentPosition,:PTR ,:dword ,:dword
STDMETHOD GetFormat,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetVolume,:PTR ,:dword
STDMETHOD GetPan,:PTR ,:dword
STDMETHOD GetFrequency,:PTR ,:dword
STDMETHOD GetStatus,:PTR ,:dword
STDMETHOD Initialize,:PTR ,:dword ,:dword
STDMETHOD _Lock,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD Play,:PTR ,:dword ,:dword ,:dword
STDMETHOD SetCurrentPosition,:PTR ,:dword
STDMETHOD SetFormat,:PTR ,:dword
STDMETHOD SetVolume,:PTR ,:dword
STDMETHOD SetPan,:PTR ,:dword
STDMETHOD SetFrequency,:PTR ,:dword
STDMETHOD Stop,:PTR
STDMETHOD Unlock,:PTR ,:dword ,:dword ,:dword ,:dword
STDMETHOD Restore,:PTR

; IDirectSoundBuffer8 methods
STDMETHOD SetFX,:PTR, :dword, :dword, :dword
STDMETHOD AcquireResources,:PTR, :dword, :dword, :dword
STDMETHOD GetObjectInPath,:PTR, :dword, :dword, :dword, :dword
IDirectSoundBuffer8 ends

; Special GUID meaning "select all objects" for use in GetObjectInPath()
GUID_All_Objects equ {0aa114de5h, 0c262h, 04169h, {0a1h, 0c8h, 023h, 0d6h, 098h, 0cch, 073h, 0b5h}}

endif ; DIRECTSOUND_VERSION >= 0x0800

;
; IDirectSound3DListener
;

IID_IDirectSound3DListener equ {0279AFA84h, 04981h, 011CEh, {0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h}}

IDirectSound3DListener struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSound3DListener methods
STDMETHOD GetAllParameters,:PTR, :dword
STDMETHOD GetDistanceFactor,:PTR, :dword
STDMETHOD GetDopplerFactor,:PTR, :dword
STDMETHOD GetOrientation,:PTR, :dword, :dword
STDMETHOD GetPosition,:PTR, :dword
STDMETHOD GetRolloffFactor,:PTR, :dword
STDMETHOD GetVelocity,:PTR, :dword
STDMETHOD SetAllParameters,:PTR, :dword, :dword
STDMETHOD SetDistanceFactor,:PTR, :dword, :dword
STDMETHOD SetDopplerFactor,:PTR, :dword, :dword
STDMETHOD SetOrientation,:PTR, :dword, :dword, :dword, :dword, :dword, :dword, :dword
STDMETHOD SetPosition,:PTR, :dword, :dword, :dword, :dword
STDMETHOD SetRolloffFactor,:PTR, :dword, :dword
STDMETHOD SetVelocity,:PTR, :dword, :dword, :dword, :dword
STDMETHOD CommitDeferredSettings,:PTR
IDirectSound3DListener ends

;
; IDirectSound3DBuffer
;

IID_IDirectSound3DBuffer equ {0279AFA86h, 04981h, 011CEh, {0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h}}

IDirectSound3DBuffer struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSound3DBuffer methods
STDMETHOD GetAllParameters,:PTR, :dword
STDMETHOD GetConeAngles,:PTR, :dword, :dword
STDMETHOD GetConeOrientation,:PTR, :dword
STDMETHOD GetConeOutsideVolume,:PTR, :dword
STDMETHOD GetMaxDistance,:PTR, :dword
STDMETHOD GetMinDistance,:PTR, :dword
STDMETHOD GetMode,:PTR, :dword
STDMETHOD GetPosition,:PTR, :dword
STDMETHOD GetVelocity,:PTR, :dword
STDMETHOD SetAllParameters,:PTR, :dword, :dword
STDMETHOD SetConeAngles,:PTR, :dword, :dword, :dword
STDMETHOD SetConeOrientation,:PTR, :dword, :dword, :dword, :dword
STDMETHOD SetConeOutsideVolume,:PTR, :dword, :dword
STDMETHOD SetMaxDistance,:PTR, :dword, :dword
STDMETHOD SetMinDistance,:PTR, :dword, :dword
STDMETHOD SetMode,:PTR, :dword, :dword
STDMETHOD SetPosition,:PTR, :dword, :dword, :dword, :dword
STDMETHOD SetVelocity,:PTR, :dword, :dword, :dword, :dword
IDirectSound3DBuffer ends

;
; IDirectSoundCapture
;

IID_IDirectSoundCapture equ {0b0210781h, 089cdh, 011d0h, {0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h}}

IDirectSoundCapture struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundCapture methods
STDMETHOD CreateCaptureBuffer,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD Initialize,:PTR ,:dword
IDirectSoundCapture ends

;
; IDirectSoundCaptureBuffer
;

IID_IDirectSoundCaptureBuffer equ {0b0210782h, 089cdh, 011d0h, {0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h}}

IDirectSoundCaptureBuffer struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundCaptureBuffer methods
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD GetCurrentPosition,:PTR ,:dword ,:dword
STDMETHOD GetFormat,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetStatus,:PTR ,:dword
STDMETHOD Initialize,:PTR ,:dword ,:dword
STDMETHOD _Lock,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD Start,:PTR ,:dword
STDMETHOD Stop,:PTR
STDMETHOD Unlock,:PTR, :dword, :dword, :dword, :dword
IDirectSoundCaptureBuffer ends

if DIRECTSOUND_VERSION ge 00800h

;
; IDirectSoundCaptureBuffer8
;

IID_IDirectSoundCaptureBuffer8 equ {0990df4h, 0dbbh, 04872h, {083h, 03eh, 06dh, 030h, 03eh, 080h, 0aeh, 0b6h}}

IDirectSoundCaptureBuffer8 struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundCaptureBuffer methods
STDMETHOD GetCaps,:PTR ,:dword
STDMETHOD GetCurrentPosition,:PTR ,:dword ,:dword
STDMETHOD GetFormat,:PTR ,:dword ,:dword ,:dword
STDMETHOD GetStatus,:PTR ,:dword
STDMETHOD Initialize,:PTR ,:dword ,:dword
STDMETHOD _Lock,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD Start,:PTR ,:dword
STDMETHOD Stop,:PTR
STDMETHOD Unlock,:PTR, :dword, :dword, :dword, :dword

; IDirectSoundCaptureBuffer8 methods
STDMETHOD GetObjectInPath,:PTR ,:dword ,:dword ,:dword ,:dword
STDMETHOD GetFXStatus,:PTR ,:dword ,:dword
IDirectSoundCaptureBuffer8 ends

endif ; DIRECTSOUND_VERSION ge 00800h

;
; IDirectSoundNotify
;

IID_IDirectSoundNotify equ {0b0210783h, 089cdh, 011d0h, {0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h}}

IDirectSoundNotify struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundNotify methods
STDMETHOD SetNotificationPositions,:PTR ,:dword ,:dword
IDirectSoundNotify ends

;
; IKsPropertySet
;

ifndef _IKsPropertySet_
_IKsPropertySet_ equ 1

KSPROPERTY_SUPPORT_GET  equ 000000001h
KSPROPERTY_SUPPORT_SET  equ 000000002h

IID_IKsPropertySet equ {031efac30h, 0515ch, 011d0h, {0a9h, 0aah, 000h, 0aah, 000h, 061h, 0beh, 093h}}

IKsPropertySet struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

    ; IKsPropertySet methods
STDMETHOD Get,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD Set,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
STDMETHOD QuerySupport,:PTR ,:dword ,:dword ,:dword
IKsPropertySet ends

LPKSPROPERTYSET typedef ptr IKsPropertySet
endif ; _IKsPropertySet_


if DIRECTSOUND_VERSION ge 00800h

;
; IDirectSoundFXGargle
;

IID_IDirectSoundFXGargle equ {0d616f352h, 0d622h, 011ceh, {0aah, 0c5h, 000h, 020h, 0afh, 00bh, 099h, 0a3h}}

DSFXGargle struct
dwRateHz dword ?               ; Rate of modulation in hz
dwWaveShape dword ?            ; DSFXGARGLE_WAVE_xxx
DSFXGargle ends
LPCDSFXGargle typedef ptr DSFXGargle

DSFXGARGLE_WAVE_TRIANGLE        equ 0
DSFXGARGLE_WAVE_SQUARE          equ 1

DSFXGARGLE_RATEHZ_MIN           equ 1
DSFXGARGLE_RATEHZ_MAX           equ 1000

IDirectSoundFXGargle struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXGargle methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXGargle ends

;
; IDirectSoundFXChorus
;

IID_IDirectSoundFXChorus equ {0880842e3h, 0145fh, 043e6h, {0a9h, 034h, 0a7h, 018h, 006h, 0e5h, 005h, 047h}}

DSFXChorus struct
fWetDryMix real4 ?
fDepth real4 ?
fFeedback real4 ?
fFrequency real4 ?
lWaveform dword ?          ; LFO shape; DSFXCHORUS_WAVE_xxx
fDelay real4 ?
lPhase dword ?
DSFXChorus ends

LPCDSFXChorus typedef ptr DSFXChorus

DSFXCHORUS_WAVE_TRIANGLE        equ 0
DSFXCHORUS_WAVE_SIN             equ 1

DSFXCHORUS_WETDRYMIX_MIN        equ 0.0
DSFXCHORUS_WETDRYMIX_MAX        equ 100.0
DSFXCHORUS_DEPTH_MIN            equ 0.0
DSFXCHORUS_DEPTH_MAX            equ 100.0
DSFXCHORUS_FEEDBACK_MIN         equ -99.0
DSFXCHORUS_FEEDBACK_MAX         equ 99.0
DSFXCHORUS_FREQUENCY_MIN        equ 0.0
DSFXCHORUS_FREQUENCY_MAX        equ 10.0
DSFXCHORUS_DELAY_MIN            equ 0.0
DSFXCHORUS_DELAY_MAX            equ 20.0
DSFXCHORUS_PHASE_MIN            equ 0
DSFXCHORUS_PHASE_MAX            equ 4

DSFXCHORUS_PHASE_NEG_180        equ 0
DSFXCHORUS_PHASE_NEG_90         equ 1
DSFXCHORUS_PHASE_ZERO           equ 2
DSFXCHORUS_PHASE_90             equ 3
DSFXCHORUS_PHASE_180            equ 4

IDirectSoundFXChorus struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXChorus methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXChorus ends

;
; IDirectSoundFXFlanger
;

IID_IDirectSoundFXFlanger equ  {0903e9878h, 02c92h, 04072h, {09bh, 02ch, 0eah, 068h, 0f5h, 039h, 067h, 083h}}

DSFXFlanger struct
fWetDryMix real4 ?
fDepth real4 ?
fFeedback real4 ?
fFrequency real4 ?
lWaveform dword ?
fDelay real4 ?
lPhase dword ?
DSFXFlanger ends

LPCDSFXFlanger typedef ptr DSFXFlanger

DSFXFLANGER_WAVE_TRIANGLE       equ 0
DSFXFLANGER_WAVE_SIN            equ 1

DSFXFLANGER_WETDRYMIX_MIN       equ 0.0
DSFXFLANGER_WETDRYMIX_MAX       equ 100.0
DSFXFLANGER_FREQUENCY_MIN       equ 0.0
DSFXFLANGER_FREQUENCY_MAX       equ 10.0
DSFXFLANGER_DEPTH_MIN           equ 0.0
DSFXFLANGER_DEPTH_MAX           equ 100.0
DSFXFLANGER_PHASE_MIN           equ 0
DSFXFLANGER_PHASE_MAX           equ 4
DSFXFLANGER_FEEDBACK_MIN        equ -99.0
DSFXFLANGER_FEEDBACK_MAX        equ 99.0
DSFXFLANGER_DELAY_MIN           equ 0.0
DSFXFLANGER_DELAY_MAX           equ 4.0

DSFXFLANGER_PHASE_NEG_180       equ 0
DSFXFLANGER_PHASE_NEG_90        equ 1
DSFXFLANGER_PHASE_ZERO          equ 2
DSFXFLANGER_PHASE_90            equ 3
DSFXFLANGER_PHASE_180           equ 4

IDirectSoundFXFlanger struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXFlanger methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXFlanger ends

;
; IDirectSoundFXEcho
;

IID_IDirectSoundFXEcho equ {08bd28edfh, 050dbh, 04e92h, {0a2h, 0bdh, 044h, 054h, 088h, 0d1h, 0edh, 042h}}

DSFXEcho struct
fWetDryMix real4 ?
fFeedback real4 ?
fLeftDelay real4 ?
fRightDelay real4 ?
lPanDelay dword ?
DSFXEcho ends

LPCDSFXEcho typedef ptr DSFXEcho

DSFXECHO_WETDRYMIX_MIN      equ 0.0
DSFXECHO_WETDRYMIX_MAX      equ 100.0
DSFXECHO_FEEDBACK_MIN       equ 0.0
DSFXECHO_FEEDBACK_MAX       equ 100.0
DSFXECHO_LEFTDELAY_MIN      equ 1.0
DSFXECHO_LEFTDELAY_MAX      equ 2000.0
DSFXECHO_RIGHTDELAY_MIN     equ 1.0
DSFXECHO_RIGHTDELAY_MAX     equ 2000.0
DSFXECHO_PANDELAY_MIN       equ 0
DSFXECHO_PANDELAY_MAX       equ 1

IDirectSoundFXEcho struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXEcho methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXEcho ends

;
; IDirectSoundFXDistortion
;

IID_IDirectSoundFXDistortion equ {08ecf4326h, 0455h, 04d8bh, {0bdh, 0a9h, 08dh, 05dh, 03eh, 09eh, 03eh, 00bh}}

DSFXDistortion struct
fGain real4 ?
fEdge real4 ?
fPostEQCenterFrequency real4 ?
fPostEQBandwidth real4 ?
fPreLowpassCutoff real4 ?
DSFXDistortion ends

LPCDSFXDistortion typedef ptr DSFXDistortion

DSFXDISTORTION_GAIN_MIN                     equ -60.0
DSFXDISTORTION_GAIN_MAX                     equ 0.0
DSFXDISTORTION_EDGE_MIN                     equ 0.0
DSFXDISTORTION_EDGE_MAX                     equ 100.0
DSFXDISTORTION_POSTEQCENTERFREQUENCY_MIN    equ 100.0
DSFXDISTORTION_POSTEQCENTERFREQUENCY_MAX    equ 8000.0
DSFXDISTORTION_POSTEQBANDWIDTH_MIN          equ 100.0
DSFXDISTORTION_POSTEQBANDWIDTH_MAX          equ 8000.0
DSFXDISTORTION_PRELOWPASSCUTOFF_MIN         equ 100.0
DSFXDISTORTION_PRELOWPASSCUTOFF_MAX         equ 8000.0

IDirectSoundFXDistortion struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXDistortion methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXDistortion ends

;
; IDirectSoundFXCompressor
;

IID_IDirectSoundFXCompressor equ {04bbd1154h, 062f6h, 04e2ch, {0a1h, 05ch, 0d3h, 0b6h, 0c4h, 017h, 0f7h, 0a0h}}

DSFXCompressor struct
fGain real4 ?
fAttack real4 ?
fRelease real4 ?
fThreshold real4 ?
fRatio real4 ?
fPredelay real4 ?
DSFXCompressor ends

LPCDSFXCompressor typedef ptr DSFXCompressor

DSFXCOMPRESSOR_GAIN_MIN             equ -60.0
DSFXCOMPRESSOR_GAIN_MAX             equ 60.0
DSFXCOMPRESSOR_ATTACK_MIN           equ 0.01
DSFXCOMPRESSOR_ATTACK_MAX           equ 500.0
DSFXCOMPRESSOR_RELEASE_MIN          equ 50.0
DSFXCOMPRESSOR_RELEASE_MAX          equ 3000.0
DSFXCOMPRESSOR_THRESHOLD_MIN        equ -60.0
DSFXCOMPRESSOR_THRESHOLD_MAX        equ 0.0
DSFXCOMPRESSOR_RATIO_MIN            equ 1.0
DSFXCOMPRESSOR_RATIO_MAX            equ 100.0
DSFXCOMPRESSOR_PREDELAY_MIN         equ 0.0
DSFXCOMPRESSOR_PREDELAY_MAX         equ 4.0

IDirectSoundFXCompressor struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXCompressor methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXCompressor ends

;
; IDirectSoundFXParamEq
;

IID_IDirectSoundFXParamEq equ {0c03ca9feh, 0fe90h, 04204h, {080h, 078h, 082h, 033h, 04ch, 0d1h, 077h, 0dah}}

DSFXParamEq struct
fCenter real4 ?
fBandwidth real4 ?
fGain real4 ?
DSFXParamEq ends

LPCDSFXParamEq typedef ptr DSFXParamEq

DSFXPARAMEQ_CENTER_MIN      equ 80.0
DSFXPARAMEQ_CENTER_MAX      equ 16000.0
DSFXPARAMEQ_BANDWIDTH_MIN   equ 1.0
DSFXPARAMEQ_BANDWIDTH_MAX   equ 36.0
DSFXPARAMEQ_GAIN_MIN        equ -15.0
DSFXPARAMEQ_GAIN_MAX        equ 15.0

IDirectSoundFXParamEq struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXParamEq methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXParamEq ends

;
; IDirectSoundFXI3DL2Reverb
;

IID_IDirectSoundFXI3DL2Reverb equ {04b166a6ah, 00d66h, 043f3h, {080h, 0e3h, 0eeh, 062h, 080h, 0deh, 0e1h, 0a4h}}

DSFXI3DL2Reverb struct
lRoom dword ?                  ; [-10000, 0]      default: -1000 mB
lRoomHF dword ?                ; [-10000, 0]      default: 0 mB
flRoomRolloffFactor real4 ?    ; [0.0, 10.0]      default: 0.0
flDecayTime real4 ?            ; [0.1, 20.0]      default: 1.49s
flDecayHFRatio real4 ?         ; [0.1, 2.0]       default: 0.83
lReflections dword ?           ; [-10000, 1000]   default: -2602 mB
flReflectionsDelay real4 ?     ; [0.0, 0.3]       default: 0.007 s
lReverb dword ?                ; [-10000, 2000]   default: 200 mB
flReverbDelay real4 ?          ; [0.0, 0.1]       default: 0.011 s
flDiffusion real4 ?            ; [0.0, 100.0]     default: 100.0 %
flDensity real4 ?              ; [0.0, 100.0]     default: 100.0 %
flHFReference real4 ?          ; [20.0, 20000.0]  default: 5000.0 Hz
DSFXI3DL2Reverb ends

LPDSFXI3DL2Reverb typedef ptr DSFXI3DL2Reverb
LPCDSFXI3DL2Reverb typedef ptr DSFXI3DL2Reverb

DSFX_I3DL2REVERB_ROOM_MIN                   equ (-10000)
DSFX_I3DL2REVERB_ROOM_MAX                   equ 0
DSFX_I3DL2REVERB_ROOM_DEFAULT               equ (-1000)
                                                    
DSFX_I3DL2REVERB_ROOMHF_MIN                 equ (-10000)
DSFX_I3DL2REVERB_ROOMHF_MAX                 equ 0
DSFX_I3DL2REVERB_ROOMHF_DEFAULT             equ (-100)
                                                    
DSFX_I3DL2REVERB_ROOMROLLOFFFACTOR_MIN      equ 0.0
DSFX_I3DL2REVERB_ROOMROLLOFFFACTOR_MAX      equ 10.0
DSFX_I3DL2REVERB_ROOMROLLOFFFACTOR_DEFAULT  equ 0.0

DSFX_I3DL2REVERB_DECAYTIME_MIN              equ 0.1
DSFX_I3DL2REVERB_DECAYTIME_MAX              equ 20.0
DSFX_I3DL2REVERB_DECAYTIME_DEFAULT          equ 1.49
                                                    
DSFX_I3DL2REVERB_DECAYHFRATIO_MIN           equ 0.1
DSFX_I3DL2REVERB_DECAYHFRATIO_MAX           equ 2.0
DSFX_I3DL2REVERB_DECAYHFRATIO_DEFAULT       equ 0.83
                                                    
DSFX_I3DL2REVERB_REFLECTIONS_MIN            equ (-10000)
DSFX_I3DL2REVERB_REFLECTIONS_MAX            equ 1000
DSFX_I3DL2REVERB_REFLECTIONS_DEFAULT        equ (-2602)
                                                    
DSFX_I3DL2REVERB_REFLECTIONSDELAY_MIN       equ 0.0
DSFX_I3DL2REVERB_REFLECTIONSDELAY_MAX       equ 0.3
DSFX_I3DL2REVERB_REFLECTIONSDELAY_DEFAULT   equ 0.007

DSFX_I3DL2REVERB_REVERB_MIN                 equ (-10000)
DSFX_I3DL2REVERB_REVERB_MAX                 equ 2000
DSFX_I3DL2REVERB_REVERB_DEFAULT             equ (200)
                                                    
DSFX_I3DL2REVERB_REVERBDELAY_MIN            equ 0.0
DSFX_I3DL2REVERB_REVERBDELAY_MAX            equ 0.1
DSFX_I3DL2REVERB_REVERBDELAY_DEFAULT        equ 0.011
                                                    
DSFX_I3DL2REVERB_DIFFUSION_MIN              equ 0.0
DSFX_I3DL2REVERB_DIFFUSION_MAX              equ 100.0
DSFX_I3DL2REVERB_DIFFUSION_DEFAULT          equ 100.0
                                                    
DSFX_I3DL2REVERB_DENSITY_MIN                equ 0.0
DSFX_I3DL2REVERB_DENSITY_MAX                equ 100.0
DSFX_I3DL2REVERB_DENSITY_DEFAULT            equ 100.0
                                                    
DSFX_I3DL2REVERB_HFREFERENCE_MIN            equ 20.0
DSFX_I3DL2REVERB_HFREFERENCE_MAX            equ 20000.0
DSFX_I3DL2REVERB_HFREFERENCE_DEFAULT        equ 5000.0
                                                    
DSFX_I3DL2REVERB_QUALITY_MIN                equ 0
DSFX_I3DL2REVERB_QUALITY_MAX                equ 3
DSFX_I3DL2REVERB_QUALITY_DEFAULT            equ 2

; IUnknown methods
IDirectSoundFXI3DL2Reverb struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXI3DL2Reverb methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
STDMETHOD SetPreset,:PTR ,:dword
STDMETHOD GetPreset,:PTR ,:dword
STDMETHOD SetQuality,:PTR ,:dword
STDMETHOD GetQuality,:PTR ,:dword
IDirectSoundFXI3DL2Reverb ends

;
; IDirectSoundFXWavesReverb
;

IID_IDirectSoundFXWavesReverb equ {046858c3ah,00dc6h,045e3h,{0b7h,060h,0d4h,0eeh,0f1h,06ch,0b3h,025h}}

DSFXWavesReverb struct
fInGain real4 ?                ; [-96.0,0.0]            default: 0.0 dB
fReverbMix real4 ?             ; [-96.0,0.0]            default: 0.0 db
fReverbTime real4 ?            ; [0.001,3000.0]         default: 1000.0 ms
fHighFreqRTRatio real4 ?       ; [0.001,0.999]          default: 0.001
DSFXWavesReverb ends
LPDSFXWavesReverb typedef ptr DSFXWavesReverb 
LPCDSFXWavesReverb typedef ptr DSFXWavesReverb

DSFX_WAVESREVERB_INGAIN_MIN                 equ -96.0
DSFX_WAVESREVERB_INGAIN_MAX                 equ 0.0
DSFX_WAVESREVERB_INGAIN_DEFAULT             equ 0.0
DSFX_WAVESREVERB_REVERBMIX_MIN              equ -96.0
DSFX_WAVESREVERB_REVERBMIX_MAX              equ 0.0
DSFX_WAVESREVERB_REVERBMIX_DEFAULT          equ 0.0
DSFX_WAVESREVERB_REVERBTIME_MIN             equ 0.001
DSFX_WAVESREVERB_REVERBTIME_MAX             equ 3000.0
DSFX_WAVESREVERB_REVERBTIME_DEFAULT         equ 1000.0
DSFX_WAVESREVERB_HIGHFREQRTRATIO_MIN        equ 0.001
DSFX_WAVESREVERB_HIGHFREQRTRATIO_MAX        equ 0.999
DSFX_WAVESREVERB_HIGHFREQRTRATIO_DEFAULT    equ 0.001

IDirectSoundFXWavesReverb struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundFXWavesReverb methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
IDirectSoundFXWavesReverb ends

;
; IDirectSoundCaptureFXAec
;

IID_IDirectSoundCaptureFXAec equ {0ad74143dh, 0903dh, 04ab7h, {080h, 066h, 028h, 0d3h, 063h, 003h, 06dh, 065h}}

DSCFXAec struct
fEnable dword ?
fNoiseFill dword ?
dwMode dword ?
DSCFXAec ends
LPDSCFXAec typedef ptr DSCFXAec
LPCDSCFXAec typedef ptr DSCFXAec

; These match the AEC_MODE_* constants in the DDK's ksmedia.h file
DSCFX_AEC_MODE_PASS_THROUGH                     equ 00h
DSCFX_AEC_MODE_HALF_DUPLEX                      equ 01h
DSCFX_AEC_MODE_FULL_DUPLEX                      equ 02h

; These match the AEC_STATUS_* constants in ksmedia.h
DSCFX_AEC_STATUS_HISTORY_UNINITIALIZED          equ 00h
DSCFX_AEC_STATUS_HISTORY_CONTINUOUSLY_CONVERGED equ 01h
DSCFX_AEC_STATUS_HISTORY_PREVIOUSLY_DIVERGED    equ 02h
DSCFX_AEC_STATUS_CURRENTLY_CONVERGED            equ 08h

IDirectSoundCaptureFXAec struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundCaptureFXAec methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
STDMETHOD GetStatus,:PTR ,:dword
STDMETHOD Reset,:PTR
IDirectSoundCaptureFXAec ends

;
; IDirectSoundCaptureFXNoiseSuppress
;

IID_IDirectSoundCaptureFXNoiseSuppress equ {0ed311e41h, 0fbaeh, 04175h, {096h, 025h, 0cdh, 08h, 054h, 0f6h, 093h, 0cah}}

DSCFXNoiseSuppress struct
fEnable dword ?
DSCFXNoiseSuppress ends

LPDSCFXNoiseSuppress typedef ptr DSCFXNoiseSuppress
LPCDSCFXNoiseSuppress typedef ptr DSCFXNoiseSuppress

IDirectSoundCaptureFXNoiseSuppress struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

; IDirectSoundCaptureFXNoiseSuppress methods
STDMETHOD SetAllParameters,:PTR ,:dword
STDMETHOD GetAllParameters,:PTR ,:dword
STDMETHOD Reset,:PTR ,:dword
IDirectSoundCaptureFXNoiseSuppress ends

;
; IDirectSoundFullDuplex
;

ifndef _IDirectSoundFullDuplex_
_IDirectSoundFullDuplex_ equ 1

LPDIRECTSOUNDFULLDUPLEX typedef ptr IDirectSoundFullDuplex

IID_IDirectSoundFullDuplex equ {0edcb4c7ah, 0daabh, 04216h, {0a4h, 02eh, 06ch, 050h, 059h, 06dh, 0dch, 01dh}}

IDirectSoundFullDuplex struct
; IUnknown methods
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

    ; IDirectSoundFullDuplex methods 
STDMETHOD Initialize,:PTR ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword ,:dword
IDirectSoundFullDuplex ends

endif ; _IDirectSoundFullDuplex_

endif ; DIRECTSOUND_VERSION >= 0x0800

;
; Return Codes
;

; The function completed successfully
DS_OK                           equ S_OK

; The call succeeded, but we had to substitute the 3D algorithm
DS_NO_VIRTUALIZATION            equ (0 shl 31) or (_FACDS shl 16) or 10

; The call succeeded, but not all of the optional effects were obtained.
DS_INCOMPLETE                   equ (0 shl 31) or (_FACDS shl 16) or 20

; The call failed because resources (such as a priority level)
; were already being used by another caller
DSERR_ALLOCATED                 equ (1 shl 31) or (_FACDS shl 16) or 10

; The control (vol, pan, etc.) requested by the caller is not available
DSERR_CONTROLUNAVAIL            equ (1 shl 31) or (_FACDS shl 16) or 30

; An invalid parameter was passed to the returning function
DSERR_INVALIDPARAM              equ E_INVALIDARG

; This call is not valid for the current state of this object
DSERR_INVALIDCALL               equ (1 shl 31) or (_FACDS shl 16) or 50

; An undetermined error occurred inside the DirectSound subsystem
DSERR_GENERIC                   equ E_FAIL

; The caller does not have the priority level required for the function to
; succeed
DSERR_PRIOLEVELNEEDED           equ (1 shl 31) or (_FACDS shl 16) or 70

; Not enough free memory is available to complete the operation
DSERR_OUTOFMEMORY               equ E_OUTOFMEMORY

; The specified WAVE format is not supported
DSERR_BADFORMAT                 equ (1 shl 31) or (_FACDS shl 16) or 100

; The function called is not supported at this time
DSERR_UNSUPPORTED               equ E_NOTIMPL

; No sound driver is available for use
DSERR_NODRIVER                  equ (1 shl 31) or (_FACDS shl 16) or 120

; This object is already initialized
DSERR_ALREADYINITIALIZED        equ (1 shl 31) or (_FACDS shl 16) or 130

; This object does not support aggregation
DSERR_NOAGGREGATION             equ CLASS_E_NOAGGREGATION

; The buffer memory has been lost, and must be restored
DSERR_BUFFERLOST                equ (1 shl 31) or (_FACDS shl 16) or 150

; Another app has a higher priority level, preventing this call from
; succeeding
DSERR_OTHERAPPHASPRIO           equ (1 shl 31) or (_FACDS shl 16) or 160

; This object has not been initialized
DSERR_UNINITIALIZED             equ (1 shl 31) or (_FACDS shl 16) or 170

; The requested COM interface is not available
DSERR_NOINTERFACE               equ E_NOINTERFACE

; Access is denied
DSERR_ACCESSDENIED              equ E_ACCESSDENIED

; Tried to create a DSBCAPS_CTRLFX buffer shorter than DSBSIZE_FX_MIN milliseconds
DSERR_BUFFERTOOSMALL            equ (1 shl 31) or (_FACDS shl 16) or 180

; Attempt to use DirectSound 8 functionality on an older DirectSound object
DSERR_DS8_REQUIRED              equ (1 shl 31) or (_FACDS shl 16) or 190

; A circular loop of send effects was detected
DSERR_SENDLOOP                  equ (1 shl 31) or (_FACDS shl 16) or 200

; The GUID specified in an audiopath file does not match a valid MIXIN buffer
DSERR_BADSENDBUFFERGUID         equ (1 shl 31) or (_FACDS shl 16) or 210

; The object requested was not found (numerically equal to DMUS_E_NOT_FOUND)
DSERR_OBJECTNOTFOUND            equ (1 shl 31) or (_FACDS shl 16) or 4449

; The effects requested could not be found on the system, or they were found
; but in the wrong order, or in the wrong hardware/software locations.
DSERR_FXUNAVAILABLE             equ (1 shl 31) or (_FACDS shl 16) or 220

;
; Flags
;

DSCAPS_PRIMARYMONO          equ 000000001h
DSCAPS_PRIMARYSTEREO        equ 000000002h
DSCAPS_PRIMARY8BIT          equ 000000004h
DSCAPS_PRIMARY16BIT         equ 000000008h
DSCAPS_CONTINUOUSRATE       equ 000000010h
DSCAPS_EMULDRIVER           equ 000000020h
DSCAPS_CERTIFIED            equ 000000040h
DSCAPS_SECONDARYMONO        equ 000000100h
DSCAPS_SECONDARYSTEREO      equ 000000200h
DSCAPS_SECONDARY8BIT        equ 000000400h
DSCAPS_SECONDARY16BIT       equ 000000800h

DSSCL_NORMAL                equ 000000001h
DSSCL_PRIORITY              equ 000000002h
DSSCL_EXCLUSIVE             equ 000000003h
DSSCL_WRITEPRIMARY          equ 000000004h

DSSPEAKER_DIRECTOUT         equ 000000000h
DSSPEAKER_HEADPHONE         equ 000000001h
DSSPEAKER_MONO              equ 000000002h
DSSPEAKER_QUAD              equ 000000003h
DSSPEAKER_STEREO            equ 000000004h
DSSPEAKER_SURROUND          equ 000000005h
DSSPEAKER_5POINT1           equ 000000006h
DSSPEAKER_7POINT1           equ 000000007h

DSSPEAKER_GEOMETRY_MIN      equ 000000005h  ;   5 degrees
DSSPEAKER_GEOMETRY_NARROW   equ 00000000Ah  ;  10 degrees
DSSPEAKER_GEOMETRY_WIDE     equ 000000014h  ;  20 degrees
DSSPEAKER_GEOMETRY_MAX      equ 0000000B4h  ; 180 degrees

DSSPEAKER_COMBINED		macro	cc,g
				xor	eax,eax
				mov	al, cc
				or	al, g
				shl	eax,16
				exitm	<eax>
				endm
DSSPEAKER_CONFIG		macro	a
				xor	eax,eax
				mov	al, c
				exitm	<eax>
				endm
DSSPEAKER_GEOMETRY		macro	a
				mov	eax, a
				shr	eax, 16
				and	eax, 0ffh
				exitm	<eax>
				endm

DSBCAPS_PRIMARYBUFFER       equ 000000001h
DSBCAPS_STATIC              equ 000000002h
DSBCAPS_LOCHARDWARE         equ 000000004h
DSBCAPS_LOCSOFTWARE         equ 000000008h
DSBCAPS_CTRL3D              equ 000000010h
DSBCAPS_CTRLFREQUENCY       equ 000000020h
DSBCAPS_CTRLPAN             equ 000000040h
DSBCAPS_CTRLVOLUME          equ 000000080h
DSBCAPS_CTRLPOSITIONNOTIFY  equ 000000100h
DSBCAPS_CTRLFX              equ 000000200h
DSBCAPS_STICKYFOCUS         equ 000004000h
DSBCAPS_GLOBALFOCUS         equ 000008000h
DSBCAPS_GETCURRENTPOSITION2 equ 000010000h
DSBCAPS_MUTE3DATMAXDISTANCE equ 000020000h
DSBCAPS_LOCDEFER            equ 000040000h

DSBPLAY_LOOPING             equ 000000001h
DSBPLAY_LOCHARDWARE         equ 000000002h
DSBPLAY_LOCSOFTWARE         equ 000000004h
DSBPLAY_TERMINATEBY_TIME    equ 000000008h
DSBPLAY_TERMINATEBY_DISTANCE    equ 0000000010h
DSBPLAY_TERMINATEBY_PRIORITY    equ 0000000020h

DSBSTATUS_PLAYING           equ 000000001h
DSBSTATUS_BUFFERLOST        equ 000000002h
DSBSTATUS_LOOPING           equ 000000004h
DSBSTATUS_LOCHARDWARE       equ 000000008h
DSBSTATUS_LOCSOFTWARE       equ 000000010h
DSBSTATUS_TERMINATED        equ 000000020h

DSBLOCK_FROMWRITECURSOR     equ 000000001h
DSBLOCK_ENTIREBUFFER        equ 000000002h

DSBFREQUENCY_MIN            equ 100
DSBFREQUENCY_MAX            equ 100000
DSBFREQUENCY_ORIGINAL       equ 0

DSBPAN_LEFT                 equ -10000
DSBPAN_CENTER               equ 0
DSBPAN_RIGHT                equ 10000

DSBVOLUME_MIN               equ -10000
DSBVOLUME_MAX               equ 0

DSBSIZE_MIN                 equ 4
DSBSIZE_MAX                 equ 00FFFFFFFh
DSBSIZE_FX_MIN              equ 150  ; NOTE: Milliseconds, not bytes

DS3DMODE_NORMAL             equ 000000000h
DS3DMODE_HEADRELATIVE       equ 000000001h
DS3DMODE_DISABLE            equ 000000002h

DS3D_IMMEDIATE              equ 000000000h
DS3D_DEFERRED               equ 000000001h

DS3D_MINDISTANCEFACTOR      equ FLT_MIN
DS3D_MAXDISTANCEFACTOR      equ FLT_MAX
DS3D_DEFAULTDISTANCEFACTOR  equ 1.0

DS3D_MINROLLOFFFACTOR       equ 0.0
DS3D_MAXROLLOFFFACTOR       equ 10.0
DS3D_DEFAULTROLLOFFFACTOR   equ 1.0

DS3D_MINDOPPLERFACTOR       equ 0.0
DS3D_MAXDOPPLERFACTOR       equ 10.0
DS3D_DEFAULTDOPPLERFACTOR   equ 1.0

DS3D_DEFAULTMINDISTANCE     equ 1.0
DS3D_DEFAULTMAXDISTANCE     equ 1000000000.0

DS3D_MINCONEANGLE           equ 0
DS3D_MAXCONEANGLE           equ 360
DS3D_DEFAULTCONEANGLE       equ 360

DS3D_DEFAULTCONEOUTSIDEVOLUME equ DSBVOLUME_MAX

; IDirectSoundCapture attributes

DSCCAPS_EMULDRIVER          equ DSCAPS_EMULDRIVER
DSCCAPS_CERTIFIED           equ DSCAPS_CERTIFIED

; IDirectSoundCaptureBuffer attributes

DSCBCAPS_WAVEMAPPED         equ 080000000h

if DIRECTSOUND_VERSION ge 00800h
DSCBCAPS_CTRLFX             equ 000000200h
endif


DSCBLOCK_ENTIREBUFFER       equ 000000001h

DSCBSTATUS_CAPTURING        equ 000000001h
DSCBSTATUS_LOOPING          equ 000000002h

DSCBSTART_LOOPING           equ 000000001h

DSBPN_OFFSETSTOP            equ 0FFFFFFFFh

DS_CERTIFIED                equ 000000000h
DS_UNCERTIFIED              equ 000000001h


;
; I3DL2 Material Presets
;

DSFX_I3DL2_MATERIAL_PRESET_SINGLEWINDOW equ 0
DSFX_I3DL2_MATERIAL_PRESET_DOUBLEWINDOW equ 1
DSFX_I3DL2_MATERIAL_PRESET_THINDOOR equ 2
DSFX_I3DL2_MATERIAL_PRESET_THICKDOOR equ 3
DSFX_I3DL2_MATERIAL_PRESET_WOODWALL equ 4
DSFX_I3DL2_MATERIAL_PRESET_BRICKWALL equ 5
DSFX_I3DL2_MATERIAL_PRESET_STONEWALL equ 6
DSFX_I3DL2_MATERIAL_PRESET_CURTAIN equ 7

I3DL2_MATERIAL_PRESET_SINGLEWINDOW    equ {-2800, 0.71}
I3DL2_MATERIAL_PRESET_DOUBLEWINDOW    equ {-5000, 0.40}
I3DL2_MATERIAL_PRESET_THINDOOR        equ {-1800, 0.66}
I3DL2_MATERIAL_PRESET_THICKDOOR       equ {-4400, 0.64}
I3DL2_MATERIAL_PRESET_WOODWALL        equ {-4000, 0.50}
I3DL2_MATERIAL_PRESET_BRICKWALL       equ {-5000, 0.60}
I3DL2_MATERIAL_PRESET_STONEWALL       equ {-6000, 0.68}
I3DL2_MATERIAL_PRESET_CURTAIN         equ {-1200, 0.15}

DSFX_I3DL2_ENVIRONMENT_PRESET_DEFAULT equ 0
DSFX_I3DL2_ENVIRONMENT_PRESET_GENERIC equ 1
DSFX_I3DL2_ENVIRONMENT_PRESET_PADDEDCELL equ 2
DSFX_I3DL2_ENVIRONMENT_PRESET_ROOM equ 3
DSFX_I3DL2_ENVIRONMENT_PRESET_BATHROOM equ 4
DSFX_I3DL2_ENVIRONMENT_PRESET_LIVINGROOM equ 5
DSFX_I3DL2_ENVIRONMENT_PRESET_STONEROOM equ 6
DSFX_I3DL2_ENVIRONMENT_PRESET_AUDITORIUM equ 7
DSFX_I3DL2_ENVIRONMENT_PRESET_CONCERTHALL equ 8
DSFX_I3DL2_ENVIRONMENT_PRESET_CAVE equ 9
DSFX_I3DL2_ENVIRONMENT_PRESET_ARENA equ 10
DSFX_I3DL2_ENVIRONMENT_PRESET_HANGAR equ 11
DSFX_I3DL2_ENVIRONMENT_PRESET_CARPETEDHALLWAY equ 11
DSFX_I3DL2_ENVIRONMENT_PRESET_HALLWAY equ 12
DSFX_I3DL2_ENVIRONMENT_PRESET_STONECORRIDOR equ 13
DSFX_I3DL2_ENVIRONMENT_PRESET_ALLEY equ 14
DSFX_I3DL2_ENVIRONMENT_PRESET_FOREST equ 15
DSFX_I3DL2_ENVIRONMENT_PRESET_CITY equ 16
DSFX_I3DL2_ENVIRONMENT_PRESET_MOUNTAINS equ 17
DSFX_I3DL2_ENVIRONMENT_PRESET_QUARRY equ 18
DSFX_I3DL2_ENVIRONMENT_PRESET_PLAIN equ 19
DSFX_I3DL2_ENVIRONMENT_PRESET_PARKINGLOT equ 20
DSFX_I3DL2_ENVIRONMENT_PRESET_SEWERPIPE equ 21
DSFX_I3DL2_ENVIRONMENT_PRESET_UNDERWATER equ 22
DSFX_I3DL2_ENVIRONMENT_PRESET_SMALLROOM equ 23
DSFX_I3DL2_ENVIRONMENT_PRESET_MEDIUMROOM equ 24
DSFX_I3DL2_ENVIRONMENT_PRESET_LARGEROOM equ 25
DSFX_I3DL2_ENVIRONMENT_PRESET_MEDIUMHALL equ 26
DSFX_I3DL2_ENVIRONMENT_PRESET_LARGEHALL equ 27
DSFX_I3DL2_ENVIRONMENT_PRESET_PLATE equ 28

;
; I3DL2 Reverberation Presets Values
;

I3DL2_ENVIRONMENT_PRESET_DEFAULT         equ {-1000, -100, 0.0, 1.49, 0.83, -2602, 0.007,   200, 0.011, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_GENERIC         equ {-1000, -100, 0.0, 1.49, 0.83, -2602, 0.007,   200, 0.011, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_PADDEDCELL      equ {-1000,-6000, 0.0, 0.17, 0.10, -1204, 0.001,   207, 0.002, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_ROOM            equ {-1000, -454, 0.0, 0.40, 0.83, -1646, 0.002,    53, 0.003, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_BATHROOM        equ {-1000,-1200, 0.0, 1.49, 0.54,  -370, 0.007,  1030, 0.011, 100.0,  60.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_LIVINGROOM      equ {-1000,-6000, 0.0, 0.50, 0.10, -1376, 0.003, -1104, 0.004, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_STONEROOM       equ {-1000, -300, 0.0, 2.31, 0.64,  -711, 0.012,    83, 0.017, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_AUDITORIUM      equ {-1000, -476, 0.0, 4.32, 0.59,  -789, 0.020,  -289, 0.030, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_CONCERTHALL     equ {-1000, -500, 0.0, 3.92, 0.70, -1230, 0.020,    -2, 0.029, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_CAVE            equ {-1000,    0, 0.0, 2.91, 1.30,  -602, 0.015,  -302, 0.022, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_ARENA           equ {-1000, -698, 0.0, 7.24, 0.33, -1166, 0.020,    16, 0.030, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_HANGAR          equ {-1000,-1000, 0.0,10.05, 0.23,  -602, 0.020,   198, 0.030, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_CARPETEDHALLWAY equ {-1000,-4000, 0.0, 0.30, 0.10, -1831, 0.002, -1630, 0.030, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_HALLWAY         equ {-1000, -300, 0.0, 1.49, 0.59, -1219, 0.007,   441, 0.011, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_STONECORRIDOR   equ {-1000, -237, 0.0, 2.70, 0.79, -1214, 0.013,   395, 0.020, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_ALLEY           equ {-1000, -270, 0.0, 1.49, 0.86, -1204, 0.007,    -4, 0.011, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_FOREST          equ {-1000,-3300, 0.0, 1.49, 0.54, -2560, 0.162,  -613, 0.088,  79.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_CITY            equ {-1000, -800, 0.0, 1.49, 0.67, -2273, 0.007, -2217, 0.011,  50.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_MOUNTAINS       equ {-1000,-2500, 0.0, 1.49, 0.21, -2780, 0.300, -2014, 0.100,  27.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_QUARRY          equ {-1000,-1000, 0.0, 1.49, 0.83,-10000, 0.061,   500, 0.025, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_PLAIN           equ {-1000,-2000, 0.0, 1.49, 0.50, -2466, 0.179, -2514, 0.100,  21.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_PARKINGLOT      equ {-1000,    0, 0.0, 1.65, 1.50, -1363, 0.008, -1153, 0.012, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_SEWERPIPE       equ {-1000,-1000, 0.0, 2.81, 0.14,   429, 0.014,   648, 0.021,  80.0,  60.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_UNDERWATER      equ {-1000,-4000, 0.0, 1.49, 0.10,  -449, 0.007,  1700, 0.011, 100.0, 100.0, 5000.0}

;
; Examples simulating 'musical' reverb presets
;
; Name       Decay time   Description
; Small Room    1.1s      A small size room with a length of 5m or so.
; Medium Room   1.3s      A medium size room with a length of 10m or so.
; Large Room    1.5s      A large size room suitable for live performances.
; Medium Hall   1.8s      A medium size concert hall.
; Large Hall    1.8s      A large size concert hall suitable for a full orchestra.
; Plate         1.3s      A plate reverb simulation.
;

I3DL2_ENVIRONMENT_PRESET_SMALLROOM       equ {-1000, -600, 0.0, 1.10, 0.83,  -400, 0.005,   500, 0.010, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_MEDIUMROOM      equ {-1000, -600, 0.0, 1.30, 0.83, -1000, 0.010,  -200, 0.020, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_LARGEROOM       equ {-1000, -600, 0.0, 1.50, 0.83, -1600, 0.020, -1000, 0.040, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_MEDIUMHALL      equ {-1000, -600, 0.0, 1.80, 0.70, -1300, 0.015,  -800, 0.030, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_LARGEHALL       equ {-1000, -600, 0.0, 1.80, 0.70, -2000, 0.030, -1400, 0.060, 100.0, 100.0, 5000.0}
I3DL2_ENVIRONMENT_PRESET_PLATE           equ {-1000, -200, 0.0, 1.30, 0.90,     0, 0.002,     0, 0.010, 100.0,  75.0, 5000.0}

;
; DirectSound3D Algorithms
;

; Default DirectSound3D algorithm {00000000-0000-0000-0000-000000000000}
GUID_NULL			equ	{00000000, 0000, 0000, {00,00,00,00,00,00,00,00}}

; No virtualization (Pan3D) {C241333F-1C1B-11d2-94F5-00C04FC28ACA}
DS3DALG_NO_VIRTUALIZATION equ {0c241333fh, 01c1bh, 011d2h, {094h, 0f5h, 00h, 0c0h, 04fh, 0c2h, 08ah, 0cah}}

; High-quality HRTF algorithm {C2413340-1C1B-11d2-94F5-00C04FC28ACA}
DS3DALG_HRTF_FULL equ {0c2413340h, 01c1bh, 011d2h, {094h, 0f5h, 00h, 0c0h, 04fh, 0c2h, 08ah, 0cah}}

; Lower-quality HRTF algorithm {C2413342-1C1B-11d2-94F5-00C04FC28ACA}
DS3DALG_HRTF_LIGHT equ {0c2413342h, 01c1bh, 011d2h, {094h, 0f5h, 00h, 0c0h, 04fh, 0c2h, 08ah, 0cah}}

if DIRECTSOUND_VERSION ge 00800h

;
; DirectSound Internal Effect Algorithms
;


; Gargle {DAFD8210-5711-4B91-9FE3-F75B7AE279BF}
GUID_DSFX_STANDARD_GARGLE equ {0dafd8210h, 05711h, 04b91h, 09fh, {0e3h, 0f7h, 05bh, 07ah, 0e2h, 079h, 0bfh}}

; Chorus {EFE6629C-81F7-4281-BD91-C9D604A95AF6}
GUID_DSFX_STANDARD_CHORUS equ {0efe6629c, 081f7h, 04281h, {0bdh, 091h, 0c9h, 0d6h, 004h, 0a9h, 05ah, 0f6h}}

; Flanger {EFCA3D92-DFD8-4672-A603-7420894BAD98}
GUID_DSFX_STANDARD_FLANGER equ {0efca3d92h, 0dfd8h, 04672h, {0a6h, 003h, 074h, 020h, 089h, 04bh, 0adh, 098h}}

; Echo/Delay {EF3E932C-D40B-4F51-8CCF-3F98F1B29D5D}
GUID_DSFX_STANDARD_ECHO equ {0ef3e932ch, 0d40bh, 04f51h, {08ch, 0cfh, 03fh, 098h, 0f1h, 0b2h, 09dh, 05dh}}

; Distortion {EF114C90-CD1D-484E-96E5-09CFAF912A21}
GUID_DSFX_STANDARD_DISTORTION equ {0ef114c90h, 0cd1dh, 0484eh, {096h, 0e5, 009, 0cf, 0af, 091, 02a, 021}}

; Compressor/Limiter {EF011F79-4000-406D-87AF-BFFB3FC39D57}
GUID_DSFX_STANDARD_COMPRESSOR equ {0ef011f79h, 04000h, 0406dh, {087h, 0afh, 0bfh, 0fbh, 03fh, 0c3h, 09dh, 057}}

; Parametric Equalization {120CED89-3BF4-4173-A132-3CB406CF3231}
GUID_DSFX_STANDARD_PARAMEQ equ {0120ced89h, 03bf4h, 04173h, 0a1h, {032h, 03ch, 0b4h, 006h, 0cfh, 032h, 031h}}

; I3DL2 Environmental Reverberation: Reverb (Listener) Effect {EF985E71-D5C7-42D4-BA4D-2D073E2E96F4}
GUID_DSFX_STANDARD_I3DL2REVERB equ {0ef985e71h, 0d5c7h, 042d4h, {0bah, 04dh, 02dh, 007h, 03eh, 02eh, 096h, 0f4h}}

; Waves Reverberation {87FC0268-9A55-4360-95AA-004A1D9DE26C}
GUID_DSFX_WAVES_REVERB equ {087fc0268h, 09a55h, 04360h, {095h, 0aah, 000h, 04ah, 01dh, 09dh, 0e2h, 06ch}}

;
; DirectSound Capture Effect Algorithms
;


; Acoustic Echo Canceller {BF963D80-C559-11D0-8A2B-00A0C9255AC1}
; Matches KSNODETYPE_ACOUSTIC_ECHO_CANCEL in ksmedia.h
GUID_DSCFX_CLASS_AEC equ {0BF963D80h, 0C559h, 011D0h, {08Ah, 02Bh, 000h, 0A0h, 0C9h, 025h, 05Ah, 0C1h}}

; Microsoft AEC {CDEBB919-379A-488a-8765-F53CFD36DE40}
GUID_DSCFX_MS_AEC equ {0cdebb919h, 0379ah, 0488ah, {087h, 065h, 0f5h, 03ch, 0fdh, 036h, 0deh, 040h}}

; System AEC {1C22C56D-9879-4f5b-A389-27996DDC2810}
GUID_DSCFX_SYSTEM_AEC equ {01c22c56dh, 09879h, 04f5bh, {0a3h, 089h, 027h, 099h, 06dh, 0dch, 028h, 010h}}

; Noise Supression {E07F903F-62FD-4e60-8CDD-DEA7236665B5}
; Matches KSNODETYPE_NOISE_SUPPRESS in post Windows ME DDK's ksmedia.h
GUID_DSCFX_CLASS_NS equ {0e07f903fh, 062fdh, 04e60h, {08ch, 0ddh, 0deh, 0a7h, 023h, 066h, 065h, 0b5h}}

; Microsoft Noise Suppresion {11C5C73B-66E9-4ba1-A0BA-E814C6EED92D}
GUID_DSCFX_MS_NS equ {011c5c73bh, 066e9h, 04ba1h, {0a0h, 0bah, 0e8h, 014h, 0c6h, 0eeh, 0d9h, 02dh}}

; System Noise Suppresion {5AB0882E-7274-4516-877D-4EEE99BA4FD0}
GUID_DSCFX_SYSTEM_NS equ {05ab0882eh, 07274h, 04516h, {087h, 07dh, 04eh, 0eeh, 099h, 0bah, 04fh, 0d0h}}

endif ; DIRECTSOUND_VERSION ge 00800h
