;++ BUILD Version: 0004    // Increment this if a change has global effects
;
;Copyright (c) 1985-95, Microsoft Corporation
;
;Module Name:
;
;    glu.h
;
;Abstract:
;
;    Procedure declarations, constant definitions and macros for the OpenGL
;    Utility Library.
;
;--

;
; Copyright 1991-1993, Silicon Graphics, Inc.
; All Rights Reserved.
; 
; This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
; the contents of this file may not be disclosed to third parties, copied or
; duplicated in any form, in whole or in part, without the prior written
; permission of Silicon Graphics, Inc.
; 
; RESTRICTED RIGHTS LEGEND:
; Use, duplication or disclosure by the Government is subject to restrictions
; as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
; and Computer Software clause at DFARS 252.227-7013, and/or in similar or
; successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
; rights reserved under the Copyright Laws of the United States.
;

;
; Return the error string associated with a particular error code.
; This will return 0 for an invalid error code.
;
; The generic function prototype that can be compiled for ANSI or Unicode
; is defined as follows:
;
; LPCTSTR APIENTRY gluErrorStringWIN (GLenum errCode);
;
;
; Converted to asm by Franck Charlet

gluErrorString proto :dword
gluErrorUnicodeStringEXT proto :dword

ifdef UNICODE
gluErrorStringWIN equ <gluErrorUnicodeStringEXT>
else
gluErrorStringWIN equ <gluErrorString>
endif

gluGetString proto :dword

gluOrtho2D proto :qword, :qword, :qword, :qword
gluPerspective proto :qword, :qword, :qword, :qword
gluPickMatrix proto :qword, :qword, :qword, :qword, :dword
gluLookAt proto :qword, :qword, :qword, :qword, :qword, :qword, :qword, :qword, :qword
gluProject proto :qword, :qword, :qword, :dword, :dword, :dword, :qword, :qword, :qword
gluUnProject proto :qword, :qword, :qword, :dword, :dword, :dword, :qword, :qword, :qword
gluScaleImage proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
gluBuild1DMipmaps proto :dword, :dword, :dword, :dword, :dword, :dword
gluBuild2DMipmaps proto :dword, :dword, :dword, :dword, :dword, :dword, :dword

;typedef struct GLUnurbs GLUnurbs
;typedef struct GLUquadric GLUquadric
;typedef struct GLUtesselator GLUtesselator

; backwards compatibility:
;typedef struct GLUnurbs GLUnurbsObj
;typedef struct GLUquadric GLUquadricObj
;typedef struct GLUtesselator GLUtesselatorObj
;typedef struct GLUtesselator GLUtriangulatorObj

gluNewQuadric proto
gluDeleteQuadric proto :dword
gluQuadricNormals proto :dword, :dword
gluQuadricTexture proto :dword, :dword
gluQuadricOrientation proto :dword, :dword
gluQuadricDrawStyle proto :dword, :dword
gluCylinder proto :dword, :qword, :qword, :qword, :dword, :dword
gluDisk proto  :dword, :qword, :qword, :dword, :dword
gluPartialDisk proto :dword, :qword, :qword, :dword, :dword, :qword, :qword
gluSphere proto :dword, :qword, :dword, :dword
gluQuadricCallback proto :dword, :dword, :dword
gluNewTess proto
gluDeleteTess proto :dword
gluTessBeginPolygon proto :dword, :dword
gluTessBeginContour proto :dword
gluTessVertex proto :dword, :dword, :dword
gluTessEndContour proto :dword
gluTessEndPolygon proto 
gluTessProperty proto :dword, :dword, :qword
gluTessNormal proto :dword, :qword, :qword, :qword
gluTessCallback proto :dword, :dword, :dword
gluGetTessProperty proto :dword, :dword, :qword
gluNewNurbsRenderer proto
gluDeleteNurbsRenderer proto :dword
gluBeginSurface proto :dword
gluBeginCurve proto :dword
gluEndCurve proto :dword
gluEndSurface proto :dword
gluBeginTrim proto :dword
gluEndTrim proto :dword
gluPwlCurve proto :dword, :dword, :dword, :dword, :dword
gluNurbsCurve proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
gluNurbsSurface proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
gluLoadSamplingMatrices proto :dword, :dword, :dword, :dword
gluNurbsProperty proto :dword, :dword, :dword
gluGetNurbsProperty proto :dword, :dword, :dword
gluNurbsCallback proto :dword, :dword, :dword

;****           Callback function prototypes    ****

; gluQuadricCallback
GLUquadricErrorProc_proto typedef proto :dword
GLUquadricErrorProc typedef ptr GLUquadricErrorProc_proto

; gluTessCallback
GLUtessBeginProc_proto typedef proto :dword
GLUtessBeginProc typedef ptr GLUtessBeginProc_proto
GLUtessEdgeFlagProc_proto typedef proto :dword
GLUtessEdgeFlagProc typedef ptr GLUtessEdgeFlagProc_proto
GLUtessVertexProc_proto typedef proto :dword
GLUtessVertexProc typedef ptr GLUtessVertexProc_proto
GLUtessEndProc_proto typedef proto
GLUtessEndProc typedef ptr GLUtessEndProc_proto
GLUtessErrorProc_proto typedef proto :dword
GLUtessErrorProc typedef ptr GLUtessErrorProc_proto
GLUtessCombineProc_proto typedef proto :dword, :dword, :dword, :dword
GLUtessCombineProc typedef ptr GLUtessCombineProc_proto
GLUtessBeginDataProc_proto typedef proto :dword, :dword
GLUtessBeginDataProc typedef ptr GLUtessBeginDataProc_proto
GLUtessEdgeFlagDataProc_proto typedef proto :dword, :dword
GLUtessEdgeFlagDataProc typedef ptr GLUtessEdgeFlagDataProc_proto
GLUtessVertexDataProc_proto typedef proto :dword, :dword
GLUtessVertexDataProc typedef ptr GLUtessVertexDataProc_proto
GLUtessEndDataProc_proto typedef proto :dword
GLUtessEndDataProc typedef ptr GLUtessEndDataProc_proto
GLUtessErrorDataProc_proto typedef proto :dword, :dword
GLUtessErrorDataProc typedef ptr GLUtessErrorDataProc_proto
GLUtessCombineDataProc_proto typedef proto :dword, :dword, :dword, :dword, :dword
GLUtessCombineDataProc typedef ptr GLUtessCombineDataProc_proto

; gluNurbsCallback
GLUnurbsErrorProc_proto typedef proto :dword
GLUnurbsErrorProc typedef ptr GLUnurbsErrorProc_proto


;****           Generic constants               ****

; Version
GLU_VERSION_1_1                 equ 1
GLU_VERSION_1_2                 equ 1

; Errors: (return value 0 = no error) 
GLU_INVALID_ENUM        equ 100900
GLU_INVALID_VALUE       equ 100901
GLU_OUT_OF_MEMORY       equ 100902
GLU_INCOMPATIBLE_GL_VERSION     equ 100903

; StringName
GLU_VERSION             equ 100800
GLU_EXTENSIONS          equ 100801

; Boolean
GLU_TRUE                equ GL_TRUE
GLU_FALSE               equ GL_FALSE


;****           Quadric constants               ****

; QuadricNormal
GLU_SMOOTH              equ 100000
GLU_FLAT                equ 100001
GLU_NONE                equ 100002

; QuadricDrawStyle
GLU_POINT               equ 100010
GLU_LINE                equ 100011
GLU_FILL                equ 100012
GLU_SILHOUETTE          equ 100013

; QuadricOrientation
GLU_OUTSIDE             equ 100020
GLU_INSIDE              equ 100021

; Callback types:
;      GLU_ERROR               100103


;****           Tesselation constants           ****

GLU_TESS_MAX_COORD              equ 1.0e150

; TessProperty
GLU_TESS_WINDING_RULE           equ 100140
GLU_TESS_BOUNDARY_ONLY          equ 100141
GLU_TESS_TOLERANCE              equ 100142

; TessWinding
GLU_TESS_WINDING_ODD            equ 100130
GLU_TESS_WINDING_NONZERO        equ 100131
GLU_TESS_WINDING_POSITIVE       equ 100132
GLU_TESS_WINDING_NEGATIVE       equ 100133
GLU_TESS_WINDING_ABS_GEQ_TWO    equ 100134

; TessCallback
GLU_TESS_BEGIN          equ 100100  ; void (CALLBACK*)(GLenum    type)
GLU_TESS_VERTEX         equ 100101  ; void (CALLBACK*)(void      *data)
GLU_TESS_END            equ 100102  ; void (CALLBACK*)(void)
GLU_TESS_ERROR          equ 100103  ; void (CALLBACK*)(GLenum    errno)
GLU_TESS_EDGE_FLAG      equ 100104  ; void (CALLBACK*)(GLboolean boundaryEdge)
GLU_TESS_COMBINE        equ 100105  ; void (CALLBACK*)(GLdouble  coords[3],
                                        ;                    void      *data[4],
                                        ;                    GLfloat   weight[4],
                                        ;                    void      **dataOut)
GLU_TESS_BEGIN_DATA     equ 100106  ; void (CALLBACK*)(GLenum    type,  
                                        ;                    void      *polygon_data)
GLU_TESS_VERTEX_DATA    equ 100107  ; void (CALLBACK*)(void      *data, 
                                        ;                    void      *polygon_data)
GLU_TESS_END_DATA       equ 100108  ; void (CALLBACK*)(void      *polygon_data)
GLU_TESS_ERROR_DATA     equ 100109  ; void (CALLBACK*)(GLenum    errno, 
                                        ;                    void      *polygon_data)
GLU_TESS_EDGE_FLAG_DATA equ 100110  ; void (CALLBACK*)(GLboolean boundaryEdge,
                                        ;                    void      *polygon_data)
GLU_TESS_COMBINE_DATA   equ 100111  ; void (CALLBACK*)(GLdouble  coords[3],
                                        ;                   void      *data[4],
                                        ;                    GLfloat   weight[4],
                                        ;                    void      **dataOut,
                                        ;                    void      *polygon_data)

; TessError
GLU_TESS_ERROR1     equ 100151
GLU_TESS_ERROR2     equ 100152
GLU_TESS_ERROR3     equ 100153
GLU_TESS_ERROR4     equ 100154
GLU_TESS_ERROR5     equ 100155
GLU_TESS_ERROR6     equ 100156
GLU_TESS_ERROR7     equ 100157
GLU_TESS_ERROR8     equ 100158

GLU_TESS_MISSING_BEGIN_POLYGON  equ GLU_TESS_ERROR1
GLU_TESS_MISSING_BEGIN_CONTOUR  equ GLU_TESS_ERROR2
GLU_TESS_MISSING_END_POLYGON    equ GLU_TESS_ERROR3
GLU_TESS_MISSING_END_CONTOUR    equ GLU_TESS_ERROR4
GLU_TESS_COORD_TOO_LARGE        equ GLU_TESS_ERROR5
GLU_TESS_NEED_COMBINE_CALLBACK  equ GLU_TESS_ERROR6

;****           NURBS constants                 ****

; NurbsProperty
GLU_AUTO_LOAD_MATRIX    equ 100200
GLU_CULLING             equ 100201
GLU_SAMPLING_TOLERANCE  equ 100203
GLU_DISPLAY_MODE        equ 100204
GLU_PARAMETRIC_TOLERANCE        equ 100202
GLU_SAMPLING_METHOD             equ 100205
GLU_U_STEP                      equ 100206
GLU_V_STEP                      equ 100207

; NurbsSampling
GLU_PATH_LENGTH                 equ 100215
GLU_PARAMETRIC_ERROR            equ 100216
GLU_DOMAIN_DISTANCE             equ 100217


; NurbsTrim
GLU_MAP1_TRIM_2         equ 100210
GLU_MAP1_TRIM_3         equ 100211

; NurbsDisplay
;      GLU_FILL                100012
GLU_OUTLINE_POLYGON     equ 100240
GLU_OUTLINE_PATCH       equ 100241

; NurbsCallback
;      GLU_ERROR               100103

; NurbsErrors
GLU_NURBS_ERROR1        equ 100251
GLU_NURBS_ERROR2        equ 100252
GLU_NURBS_ERROR3        equ 100253
GLU_NURBS_ERROR4        equ 100254
GLU_NURBS_ERROR5        equ 100255
GLU_NURBS_ERROR6        equ 100256
GLU_NURBS_ERROR7        equ 100257
GLU_NURBS_ERROR8        equ 100258
GLU_NURBS_ERROR9        equ 100259
GLU_NURBS_ERROR10       equ 100260
GLU_NURBS_ERROR11       equ 100261
GLU_NURBS_ERROR12       equ 100262
GLU_NURBS_ERROR13       equ 100263
GLU_NURBS_ERROR14       equ 100264
GLU_NURBS_ERROR15       equ 100265
GLU_NURBS_ERROR16       equ 100266
GLU_NURBS_ERROR17       equ 100267
GLU_NURBS_ERROR18       equ 100268
GLU_NURBS_ERROR19       equ 100269
GLU_NURBS_ERROR20       equ 100270
GLU_NURBS_ERROR21       equ 100271
GLU_NURBS_ERROR22       equ 100272
GLU_NURBS_ERROR23       equ 100273
GLU_NURBS_ERROR24       equ 100274
GLU_NURBS_ERROR25       equ 100275
GLU_NURBS_ERROR26       equ 100276
GLU_NURBS_ERROR27       equ 100277
GLU_NURBS_ERROR28       equ 100278
GLU_NURBS_ERROR29       equ 100279
GLU_NURBS_ERROR30       equ 100280
GLU_NURBS_ERROR31       equ 100281
GLU_NURBS_ERROR32       equ 100282
GLU_NURBS_ERROR33       equ 100283
GLU_NURBS_ERROR34       equ 100284
GLU_NURBS_ERROR35       equ 100285
GLU_NURBS_ERROR36       equ 100286
GLU_NURBS_ERROR37       equ 100287

;****           Backwards compatibility for old tesselator

gluBeginPolygon proto :dword
gluNextContour proto :dword, :dword
gluEndPolygon proto :dword

; Contours types -- obsolete!
GLU_CW          equ 100120
GLU_CCW         equ 100121
GLU_INTERIOR    equ 100122
GLU_EXTERIOR    equ 100123
GLU_UNKNOWN     equ 100124

; Names without "TESS_" prefix
GLU_BEGIN       equ GLU_TESS_BEGIN
GLU_VERTEX      equ GLU_TESS_VERTEX
GLU_END         equ GLU_TESS_END
GLU_ERROR       equ GLU_TESS_ERROR
GLU_EDGE_FLAG   equ GLU_TESS_EDGE_FLAG
