; ------------------------------------------------------
; Hidden Lines
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Functions
Display_Cube            proto
Display_Big_Cube        proto

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        invoke  glEnable, GL_DEPTH_TEST

                        ; Render the lines
                        invoke  glPolygonMode, GL_FRONT, GL_LINE
                        invoke  glColor3f, CFLT(0.2), CFLT(1.0), CFLT(0.5)
                        invoke  Display_Big_Cube

                        ; Render it a second time but filled & in black
                        invoke  glColor3f, CFLT(0.0), CFLT(0.0), CFLT(0.0)
                        invoke  glPolygonMode, GL_FRONT, GL_FILL
                        invoke  glEnable, GL_POLYGON_OFFSET_FILL
                        invoke  glPolygonOffset, CFLT(1.0), CFLT(1.0)
                        invoke  Display_Big_Cube
                        invoke  glDisable, GL_POLYGON_OFFSET_FILL
                        
                        ret
Draw                    endp

; ------------------------------------------------------
; Name: Display_Big_Cube()
; Desc: Display seveal cubes
Display_Big_Cube        proc
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-8.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(-2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(-2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(0.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(2.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(0.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(-2.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(0.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(2.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(0.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(-2.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                        invoke  glPopMatrix
                        ret
Display_Big_Cube        endp

; ------------------------------------------------------
; Name: Display_Cube()
; Desc: Display a simple cube
Display_Cube            proc
                        invoke  glBegin, GL_QUADS
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)

                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)

                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                        invoke  glEnd
                        ret
Display_Cube            endp

end start
