; ------------------------------------------------------
; Fog
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Functions
Display_Cube            proto

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

Fog_Color               real4   0.0, 0.0, 0.0, 0.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Per pixel fog
                        invoke  glHint, GL_FOG_HINT, GL_NICEST

                        mov     eax,TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glFogf, GL_FOG_MODE, GL_EXP
                        ;invoke glFogf, GL_FOG_MODE, GL_EXP2
                        invoke  glFogfv, GL_FOG_COLOR, addr Fog_Color
                        invoke  glFogf, GL_FOG_DENSITY, CFLT(0.3)
                        invoke  glEnable, GL_FOG

                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-8.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(-2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(-2.0), CFLT(0.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(0.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(2.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(0.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(-2.0), CFLT(2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(2.0), CFLT(0.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(2.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(-2.0), CFLT(0.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(-2.0), CFLT(-2.0)
                                        invoke  Display_Cube
                                invoke  glPopMatrix
                        invoke  glPopMatrix

                        invoke  glDisable, GL_FOG

                        ret
Draw                    endp


; ------------------------------------------------------
; Name: Display_Cube()
; Desc: Display a simple cube
Display_Cube            proc
                        invoke  glBegin, GL_QUADS
                                invoke  glColor3f, CFLT(0.2), CFLT(0.4), CFLT(0.6)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)

                                invoke  glColor3f, CFLT(0.4), CFLT(0.6), CFLT(0.8)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)

                                invoke  glColor3f, CFLT(0.6), CFLT(0.8), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                        invoke  glEnd
                        ret
Display_Cube            endp

end start
