; ------------------------------------------------------
; Alpha Blend Texture
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Picture.asm
                        include ..\Common_Src\Textures.asm

; ------------------------------------------------------
; Functions
Display_Cube            proto

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0
Texture1                PICTURE <>
Texture1_Id             dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_PICTURE, CSTR("..\..\Media\floor.jpg"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_PICTURE, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glEnable, GL_BLEND
                                ; Use Color4f (DST) to set the alpha level
                                invoke  glBlendFunc, GL_SRC_ALPHA, GL_DST_ALPHA

                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture1_Id
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR

                                ; Render the back faces
                                invoke  glColor4f, CFLT(1.0), CFLT(1.0), CFLT(1.0), CFLT(0.2)
                                invoke  glFrontFace, GL_CW
                                invoke  Display_Cube
                                ; Render the front faces
                                invoke  glColor4f, CFLT(1.0), CFLT(1.0), CFLT(1.0), CFLT(0.8)
                                invoke  glFrontFace, GL_CCW
                                invoke  Display_Cube

                                invoke  glDisable, GL_BLEND
                                invoke  glDisable, GL_TEXTURE_2D
                        invoke  glPopMatrix

                        ret
Draw                    endp

; ------------------------------------------------------
; Name: Display_Cube()
; Desc: Display a simple cube
Display_Cube            proc
                        invoke  glBegin, GL_QUADS
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0f)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0f)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0f)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0f)

                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)

                        invoke  glEnd
                        ret
Display_Cube            endp

end start
