;  This file is part of Jeeves4k, an application framework for
;  win32 / 100% assembler intro development.
;  Copyright (c) 2001 Kuno Woudt <warp-tmt@dds.nl>.
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; see the file copying.txt; if not, write to
;  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;  Boston, MA  02111-1307  USA
;

%define BLOKJE_COUNT 		0x40
%define BLOKJE_X_INCREMENT 	0.015
%define BLOKJE_Y_INCREMENT 	0.03
%define BLOKJE_WIDTH 		0x40
%define BLOKJE_HEIGHT 		0x40
%define BLOKJE_MAX_WIDTH 	0x40
%define BLOKJE_MAX_HEIGHT 	0x40

SECTION .code

;   ___   __
;  / _/--|  |--,
; /___    _<  < __          __
; 4k. |__|  \__\\_\ blokken \_\

blokken_init
	mov	eax, [width]
        sub	eax, BLOKJE_MAX_WIDTH
        shr	eax, 1
        mov	dword [blok_screen_width_2], eax
        mov	eax, [height]
        sub	eax, BLOKJE_MAX_HEIGHT
        shr	eax, 1
        mov	dword [blok_screen_height_2], eax

	mov	ebx, blokjes
        mov	[ebx + BLOK.red],       dword 0xFFFFFFFF
        mov	[ebx + BLOK.green],     dword 0x00000000
        mov	[ebx + BLOK.blue],	dword 0xFFFFFFFF
        mov	[ebx + BLOK.alpha],	dword 0x80000000
	ret

blokken

	mov	esi, blokjes
        mov	edi, blokjes + BLOK_size
	mov	ecx, (BLOKJE_COUNT - 1) * (BLOK_size/4)
rep	movsd

        mov	ebx, blokjes

        fld	qword [blok_x_increment];
        fld	qword [blok_x_add]	;
        faddp	st1			;
        fst	qword [blok_x_add]	; x_add += x_increment
        fldpi				;
        faddp	st1			;
        fsin				; st(0) = sin(pi + x_add)
        fld1				;
        faddp	st1			; 0 to 2 (was: -1 to 1)
        fimul   dword [blok_screen_width_2]
	fist	dword [ebx + BLOK.x1]	; x1 = (sin(pi+x_add)+1)*(width>>1)
        fiadd	dword [blok_width]	;
        fistp	dword [ebx + BLOK.x2]	; x2 = x1 + blok_width

        fld	qword [blok_y_increment];
        fld	qword [blok_y_add]	;
        faddp	st1			;
        fst	qword [blok_y_add]	; y_add += y_increment
        fldpi				;
        faddp	st1			;
        fsin				; st(0) = sin(pi + y_add)
        fld1				;
        faddp	st1			; 0 to 2 (was: -1 to 1)
        fimul   dword [blok_screen_height_2]
	fist	dword [ebx + BLOK.y1]	; y1 = (sin(pi+y_add)+1)*(width>>1)
        fiadd	dword [blok_width]	;
        fistp	dword [ebx + BLOK.y2]	; y2 = y1 + blok_width

	push	ebp
	mov	ebp, blokjes + BLOK_size * BLOKJE_COUNT
.render
        sub	ebp, BLOK_size

	CALL_ID	glColor4ui, [ebp + BLOK.red], [ebp + BLOK.green], [ebp + BLOK.blue], [ebp + BLOK.alpha]
	CALL_ID	glRecti, [ebp + BLOK.x1], [ebp + BLOK.y1], [ebp + BLOK.x2], [ebp + BLOK.y2]

        cmp	ebp, blokjes
        jnz	short .render

        pop	ebp
	ret

SECTION .data

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                       __
; 4k. |__|  \__\\_\ blokjes (intro data) \_\

blok_two			dd      2
blok_screen_width_2		dd	0
blok_screen_height_2		dd	0

blok_width			dd	BLOKJE_WIDTH
blok_height			dd	BLOKJE_HEIGHT

blok_x_add			dq      0.0
blok_y_add			dq      0.0
blok_x_increment		dq      0.015
blok_y_increment		dq      0.02


	struc BLOK
.x1				resd	1
.y1				resd	1
.x2				resd	1
.y2				resd	1
.red				resd	1
.green				resd	1
.blue				resd	1
.alpha				resd	1
	endstruc


blokjes
%rep BLOKJE_COUNT
	istruc BLOK
at BLOK.x1,			dd	0
at BLOK.y1,			dd	0
at BLOK.x2,			dd	0
at BLOK.y2,			dd	0
at BLOK.red,			dd	0
at BLOK.green,			dd	0
at BLOK.blue,			dd	0
at BLOK.alpha,			dd	0
	iend
%endrep

