;  This file is part of Jeeves4k, an application framework for
;  win32 / 100% assembler intro development.
;  Copyright (c) 2001 Kuno Woudt <warp-tmt@dds.nl>.
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; see the file copying.txt; if not, write to
;  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;  Boston, MA  02111-1307  USA
;

;  this file is a dos stub which writes out the PE executable to
;  disk and executes it. (so I can use apack to compress it).

BITS 16

ORG 0x100

; %define COPYRIGHT

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                   __
; 4k. |__|  \__\\_\ stub entry point \_\

entry

;	push	cs			;
;	pop	ds			;

%ifdef COPYRIGHT
	mov	ah, 0x09		;
        mov	dx, message		;
        int	0x21			; write copyright on stdout
%endif

	mov	ah, 0x4A		;
        mov	bx, mem_size		;
        int	0x21			;

        mov	bp, filename		; used a lot.

	mov	ah, 0x3C		;
        mov	dx, bp			;
        sub	cx, cx			;
        int	0x21			; creat file, bx = file handle.
        jc	error			;

        mov	bx, ax			;

        mov	ah, 0x40		;
        mov	cx, image_size		;
        mov	dx, image		;
        int	0x21                    ; write to file
        jc	error			;

	mov	ah, 0x3E		;
        int	0x21			; close file.
        jc	error			;

	mov	ax, 0x4B00		;
	mov	bx, bp			;
        mov	dx, bp			;
        int	0x21			; exec file
	jc	error			;

	mov	ah, 0x41		;
        mov	dx, bp			;
        int	0x21			; delete file
;        jc	error			;

	ret				; quit.

error
;	mov	ah, 0x59		;
;	sub	bx, bx			;
;	int	0x21                    ;

	mov	ah, 0x09		;
        mov	dx, error_msg		;
        int	0x21			; write error on stdout
        ret				;

;   ___   __
;  / _/--|  |--,
; /___    _<  < __       __
; 4k. |__|  \__\\_\ data \_\

error_msg db	'error.','$'		; filename = end of string :)
filename db	'c:\$.exe',0		;

%ifdef COPYRIGHT
message	db	'Jeeves4k stub', 13, 10
	db	'copyright 2001 Warp^Bliss', 13, 10, '$'
%endif

image	incbin 	"jeeves.exe"		; file to write and execute.
image_size 	equ	($-image)	;

mem_size	equ	($-entry)	; total size of file (in mem)

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                               __
; 4k. |__|  \__\\_\ local variables for emacs :) \_\

; Local Variables:
; mode: asm
; tab-width: 8
; End:

END