;  This file is part of Jeeves4k, an application framework for
;  win32 / 100% assembler intro development.
;  Copyright (c) 2001 Kuno Woudt <warp-tmt@dds.nl>.
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; see the file copying.txt; if not, write to
;  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;  Boston, MA  02111-1307  USA
;
;  some macros used in jeeves.asm.

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                                  __
; 4k. |__|  \__\\_\ INVOKE and related macros intro \_\

; currently I have a total of 8 macros in this file
; for calling functions.

; local				CALL		JMP
; local, dword params		CALL_D		JMP_D
; imported			CALL_I		JMP_I
; imported, dword params	CALL_ID		JMP_ID

; as you can see in the table above the I variants are
; for imported functions, those without for local functions.
;
; The D versions push all params as a dword, without a D
; you have to supply some of the sizes yourself.
;
; JMPs are the same as the CALLs, except 'call' is replaced
; with 'jmp'. (nooo!)

;   ___   __
;  / _/--|  |--,
; /___    _<  < __         __
; 4k. |__|  \__\\_\ CALL_I \_\

%macro CALL_I 1-*
%rep %0-1
%rotate -1
	push %1				; push parameters on stack
%endrep
%rotate -1
	call near [ %1 ]		; call imported function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __        __
; 4k. |__|  \__\\_\ JMP_I \_\

%macro JMP_I 1-*
%rep %0-1
%rotate -1
	push %1				; push parameters on stack
%endrep
%rotate -1
	jmp near [ %1 ]			; jmp to imported function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __       __
; 4k. |__|  \__\\_\ CALL \_\

%macro CALL 1-*
%rep %0-1
%rotate -1
	push %1				; push parameters on stack
%endrep
%rotate -1
	call %1				; call function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __      __
; 4k. |__|  \__\\_\ JMP \_\

%macro JMP 1-*
%rep %0-1
%rotate -1
	push %1				; push parameters on stack
%endrep
%rotate -1
	jmp %1				; jmp to function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __          __
; 4k. |__|  \__\\_\ CALL_ID \_\

%macro CALL_ID 1-*
%rep %0-1
%rotate -1
	push dword %1			; push parameters on stack
%endrep
%rotate -1
	call near [ %1 ]		; call imported function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __         __
; 4k. |__|  \__\\_\ JMP_ID \_\

%macro JMP_ID 1-*
%rep %0-1
%rotate -1
	push dword %1			; push parameters on stack
%endrep
%rotate -1
	jmp near [ %1 ]			; jmp to imported function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __         __
; 4k. |__|  \__\\_\ CALL_D \_\

%macro CALL_D 1-*
%rep %0-1
%rotate -1
	push dword %1			; push parameters on stack
%endrep
%rotate -1
	call %1				; call function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __        __
; 4k. |__|  \__\\_\ JMP_D \_\

%macro JMP_D 1-*
%rep %0-1
%rotate -1
	push dword %1			; push parameters on stack
%endrep
%rotate -1
	jmp %1				; jmp to function
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __        __
; 4k. |__|  \__\\_\ ERROR \_\

; usage:  ERROR <error-condition> <errormessage>
; e.g. :
; 	  cmp eax, ebx
;	  ERROR ne, 'error: ebx != eax'

; please note that this macro requires a a companion function to
; display the error message.
; this function should be called _error. a pointer to the
; errormessage (asciiz) is in esi if DEBUG is defined, if
; DEBUG is not defined there is no error message or caption.

%macro ERROR 2
%ifdef DEBUG
SECTION .data
%%msg	db %2, 0
SECTION .code
%endif
        j%-1 %%skip
%ifdef DEBUG
        mov	esi, %%msg
%endif
        jmp	_error
%%skip
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __          __
; 4k. |__|  \__\\_\ C32.MAC \_\

; NASM macro set to make interfacing to 32-bit programs easier -*- nasm -*-
; (taken from c32.mac in the nasm distribution)

%imacro proc 1			; begin a procedure definition
%push proc
          global %1
%1:       push ebp
          mov ebp,esp
%assign %$arg 8
%define %$procname %1
%endmacro

%imacro arg 0-1 4		; used with the argument name as a label
%00	  equ %$arg
%assign %$arg %1+%$arg
%endmacro

%imacro endproc 0
%ifnctx proc
%error Mismatched `endproc'/`proc'
%else
	  leave
	  ret
__end_%$procname:		; useful for calculating function size
%pop
%endif
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __          __
; 4k. |__|  \__\\_\ stdcall \_\

; NASM macro set to make interfacing to win32 api easier
; (adapted from the proc in c32.mac in the nasm distribution)

%imacro proc_stdcall 1			; begin a procedure definition
%push proc_stdcall
          global %1
%1:       push ebp
          mov ebp,esp
%assign %$arg 8
%define %$procname %1
%endmacro

%imacro end_stdcall 0
%ifnctx proc_stdcall
%error Mismatched `end_stdcall'/`proc_stdcall'
%else
	  leave
	  ret	(%$arg - 8)
__end_%$procname:		; useful for calculating function size
%pop
%endif
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __             __
; 4k. |__|  \__\\_\ PUSHdouble \_\
;
; convert an integer to double and push this
; double precision floating point value.

%macro PUSHdouble 1
%ifndef _PUSHdouble
%define _PUSHdouble
SECTION .data
PUSHdouble_int_spot	dd 0
SECTION .code
%endif
	mov	dword [PUSHdouble_int_spot], %1
	fild	dword [PUSHdouble_int_spot]
        sub	esp, 8
        fstp	qword [esp]
%endmacro

;   ___   __
;  / _/--|  |--,
; /___    _<  < __        __
; 4k. |__|  \__\\_\ PUSHQ \_\
;
; push a qword (64bit)
; FIXME: ugly syntax, only memory thingies are allowed.
;
%macro PUSHQ 1
	push dword [%1 + 4]
	push dword [%1]
%endmacro


