;  This file is part of Jeeves4k, an application framework for
;  win32 / 100% assembler intro development.
;  Copyright (c) 2001 Kuno Woudt <warp-tmt@dds.nl>.
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; see the file copying.txt; if not, write to
;  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;  Boston, MA  02111-1307  USA
;

;		____
;	     . /    \  Jeeves4k. (c)2001 by bliss
;	   .:: \__/ /__	 ________  ______  ______
;	   _____/   __ \/ __  __ \/   __ \/_  __/
;	   \	/ /   _/\  __/_\ /  /  __/_\  \
;	    \____/ \__________/ /__/ \________/ 4k.
;
; Jeeves4k is my attempt at a skeleton for win32 4k intro
; development in 100% assembler. -- Warp <warp-tmt@dds.nl>

%include "win32n.inc"

; if this is defined, the error handler will call
; FormatMessage( ..., GetLastError(), ...) to get
; a nice error message on screen.
; NOTE: currently, it doesn't work and all you get
; is the error code.
%define	FORMAT_MESSAGE

; try to get a fullscreen mode.
; (use the current resolution of the system)
; %define FULLSCREEN_USE_SYSTEM_RES

SECTION .code USE32
SECTION .data USE32

%include "opengl.inc"
%include "import.inc"
%include "macros.inc"

; blokken effect.
%include "blokken.inc"

; window style for windowed CreateWindowExA
%assign window_style	(WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_THICKFRAME | WS_SYSMENU | WS_DLGFRAME | WS_BORDER | WS_VISIBLE)

SECTION .code

;   ___   __
;  / _/--|  |--,
; /___    _<  < __              __
; 4k. |__|  \__\\_\ entry point \_\

	..start

        sub	ebx, ebx
        CALL_ID	GetModuleHandleA, ebx
        CALL_D	WinMain, eax, ebx, ebx, ebx
        add	esp, 0x10
        ret

;   ___   __
;  / _/--|  |--,
; /___    _<  < __          __
; 4k. |__|  \__\\_\ WinMain \_\

	proc 	WinMain
%$i		arg
%$prev_i	arg
%$cmdline 	arg
%$cmdshow 	arg

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                __
; 4k. |__|  \__\\_\ win32 gl init \_\

	finit					; init FPU

	sub	edi, edi			; 0

	CALL_ID RegisterClassA, window_class    ;
        and 	eax, 0xFFFF			;
        test 	eax, eax			;
        ERROR 	z, 'RegisterClassA error.'	;

%ifdef FULLSCREEN_USE_SYSTEM_RES

	CALL_ID	GetDC, edi			; esi = device context of
        xchg	eax, esi			;       root window

        CALL_ID	GetDeviceCaps, esi, HORZRES	;
        mov	[width], eax			;
        CALL_ID	GetDeviceCaps, esi, VERTRES	;
        mov	[height], eax			;

        CALL_ID	CreateWindowExA, (WS_EX_APPWINDOW | WS_EX_TOPMOST | WS_EX_NOPARENTNOTIFY), caption, caption, WS_POPUP, edi, edi, [width], [height], edi, edi, edi, edi
        test 	eax, eax			;
	ERROR 	z, 'fullscreen CreateWindowExA error.'	;

%else

        CALL_ID	CreateWindowExA, edi, caption, caption, window_style, CW_USEDEFAULT, edi, [width], [height], edi, edi, edi, edi
        test 	eax, eax			;
	ERROR 	z, 'CreateWindowExA error.'	;

%endif

        mov	[window_handle], eax		;
        xchg	eax, edi                	; edi = window_handle

	CALL_ID	ShowWindow, edi, SW_SHOWNORMAL  ;
	CALL_ID	UpdateWindow, edi		;

%ifdef FULLSCREEN_USE_SYSTEM_RES
	CALL_ID	ShowCursor, FALSE		;
%endif

        CALL_ID	GetDC, edi			;

        ; FIXME: this can be removed when fullscreen is working.
        test 	eax, eax			;
	ERROR 	z, 'GetDC error.'		;

        mov	[device_context], eax		;
        xchg	eax, edi			; edi = device_context

        ; make sure opengl32.dll is in memory, otherwise
        ; the pixelformat stuff may fail.
        CALL_ID	glFlush				;

        CALL_ID ChoosePixelFormat, edi, pixelformat
	test 	eax, eax			;
	ERROR 	z, 'ChoosePixelFormat error.'	;

        mov	[pixelformat_index], eax	;

        CALL_ID SetPixelFormat, edi, eax, pixelformat
        test 	eax, eax			;
	ERROR 	z, 'SetPixelFormat error.'	;

        CALL_ID wglCreateContext, edi		;
        test 	eax, eax			;
	ERROR 	z, 'wglCreateContext error.'	;

        mov	[render_context], eax		;

        CALL_ID wglMakeCurrent, edi, eax	;
        test 	eax, eax			;
	ERROR 	z, 'wglMakeCurrent error.'	;

;   ___   __
;  / _/--|  |--,
; /___    _<  < __              __
; 4k. |__|  \__\\_\ opengl init \_\

gl_init
	sub	edi, edi			; edi = 0 again.

        ; yo, watch me kick the FPU!
        ; (er. this is the first asm FPU code i've ever written! :)
        fild	dword [height]			; load integer to ST(0).
        fstp	GLdouble [gl_height]		; store/pop double
        fild	dword [width]			; load integer to ST(0).
        fstp	GLdouble [gl_width]		; store/pop double

; 2d rasterization taken from MSDN ("OpenGL Correctness Tips")

	CALL_I	glViewport, GLint edi, GLint edi, GLsizei [width], GLsizei [height]
	CALL_I	glMatrixMode, GLenum GL_PROJECTION
	CALL_I	glLoadIdentity

        ; FIXME: use more registers here.

	PUSHQ	gl_one
	PUSHQ	gl_one_neg
	PUSHQ	gl_height
	PUSHQ	gl_zero
	PUSHQ	gl_width
	PUSHQ	gl_zero
	CALL_I	glOrtho			; 0, 0, width, 0, height, -1, 1

	CALL_I  glMatrixMode, GLenum GL_MODELVIEW
	CALL_I  glLoadIdentity

        PUSHQ	gl_zero			; z
        PUSHQ	gl_dot_375		; y
        PUSHQ	gl_dot_375		; x
        CALL_I	glTranslated

; setup blending.

	CALL_I	glEnable, GLenum GL_BLEND
	CALL_I	glBlendFunc, GLenum GL_SRC_ALPHA, GLenum GL_ONE_MINUS_SRC_ALPHA

;   ___   __
;  / _/--|  |--,
; /___    _<  < __              __
; 4k. |__|  \__\\_\ effect init \_\

        CALL    blokken_init

;   ___   __
;  / _/--|  |--,
; /___    _<  < __              __
; 4k. |__|  \__\\_\ render_loop \_\

render_loop

	CALL_I	glClear, GLbitfield GL_COLOR_BUFFER_BIT

        CALL    blokken

	CALL_ID	SwapBuffers, [device_context]

;   ___   __
;  / _/--|  |--,
; /___    _<  < __           __
; 4k. |__|  \__\\_\ msg_loop \_\

msg_loop

	CALL_ID	PeekMessageA, msg, NULL, 0, 0, PM_NOREMOVE
	test	eax, eax			;
        jz	render_loop			;

	CALL_ID	GetMessageA, msg, NULL, 0, 0	;
        test	eax, eax			;
        jz	quit_msg_loop			;

	CALL_ID	TranslateMessage, msg		;
	CALL_ID	DispatchMessageA, msg		;

        jmp	msg_loop			;

quit_msg_loop

	sub	edi, edi			; edi = 0
        mov	esi, [window_handle]		; esi = window_handle

        CALL_ID wglMakeCurrent, edi, edi	;
	CALL_ID wglDeleteContext, [render_context]

	CALL_ID	ReleaseDC, esi, [device_context]
	CALL_ID	DestroyWindow, esi

	endproc

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                           __
; 4k. |__|  \__\\_\ _error (for ERROR macro) \_\

_error

%ifdef	DEBUG
%ifdef	FORMAT_MESSAGE

;	push	dword	0
;	push	dword	error_message_size
;       push	dword 	error_message
;       push	dword	1
;       CALL_ID	GetLastError
;       push	eax
;	push	dword	0
;	push	dword	(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS)
;	CALL_ID	FormatMessageA

        CALL_ID	GetLastError
        CALL_ID	_itoa, eax, error_message, 0x0a
        CALL_ID  MessageBoxA, 0, error_message, esi, 0
%else
        CALL_ID  MessageBoxA, 0, esi, caption, 0
%endif
%endif

	CALL_ID	exit, 1

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                               __
; 4k. |__|  \__\\_\ WinProc (event/message loop) \_\

	proc_stdcall 	window_proc	;
%$hWnd	arg
%$uMsg	arg
%$wParam arg
%$lParam arg

	mov     ecx, [ebp + %$uMsg]	;

        cmp	ecx, WM_CREATE		;
        jz	create			;
        cmp	ecx, WM_KEYDOWN		;
        jz	keydown			;
        cmp	ecx, WM_CLOSE		;
        jz	close			;
        cmp	ecx, WM_DESTROY		;
        jz	destroy			;
        cmp	ecx, WM_PAINT		;
        jz	paint			;

	CALL_ID DefWindowProcA, [ebp + %$hWnd], [ebp + %$uMsg], [ebp + %$wParam], [ebp + %$lParam]
	jmp	return			;

keydown
;	mov	ecx, [ebp + %$wParam]	;
;	cmp	ecx, VK_ESCAPE		;
;        jnz	short ret_1		;
        mov	ecx, [ebp + %$hWnd]	;
        CALL_ID	PostMessageA, ecx, WM_CLOSE, NULL, NULL	;
        jmp	short ret_1		;

create                                  ;
        jmp	short ret_1		;

close					; WARNING!: fall-through :)
destroy CALL_ID	PostQuitMessage, 0	;
        jmp	short ret_1		;

paint	CALL_ID BeginPaint, [window_handle], paintstruct
	CALL_ID EndPaint, [window_handle], paintstruct
;        jmp	short ret_1		;

ret_1	sub	eax, eax		;
	inc	eax			;
return	end_stdcall                     ;


SECTION .data

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                    __
; 4k. |__|  \__\\_\ data (intro data) \_\

width		dd	640
height		dd	480

gl_width	dq	0.0
gl_height	dq	0.0
gl_zero         dq	0.0
gl_one          dq	1.0
gl_one_neg      dq	-1.0

gl_dot_375	dq	0.375

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                             __
; 4k. |__|  \__\\_\ data (ms windows specific) \_\

message		db	'a message in 100% assembler.',0
caption		db	'Jeeves4k',0

%ifdef	FORMAT_MESSAGE
error_message_size	equ	0x100
error_message	times 	error_message_size 	db 0
%endif

window_handle	dd	0
device_context	dd	0
render_context	dd	0
pixelformat_index dd	0

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                             __
; 4k. |__|  \__\\_\ lots of ms windows structs \_\

paintstruct
	istruc PAINTSTRUCT
at PAINTSTRUCT.hdc,		dd	0
at PAINTSTRUCT.fErase,		dd	0
at PAINTSTRUCT.rcPaint,         times 4 dd 0
at PAINTSTRUCT.fRestore,	dd	0
at PAINTSTRUCT.fIncUpdate,	dd	0
at PAINTSTRUCT.rgbReserved,	times 32 db 0
	iend

msg
	istruc MSG
at MSG.hwnd,			dd	0
at MSG.message,			dd      0
at MSG.wParam, 			dd      0
at MSG.lParam, 			dd      0
at MSG.time, 			dd      0
at MSG.pt, 			db	0
	iend

window_class
	istruc WNDCLASS
at WNDCLASS.style, 		dd	0
at WNDCLASS.lpfnWndProc, 	dd	window_proc
at WNDCLASS.cbClsExtra, 	dd	0
at WNDCLASS.cbWndExtra, 	dd	0
at WNDCLASS.hInstance, 		dd	0
at WNDCLASS.hIcon, 		dd	0
at WNDCLASS.hCursor, 		dd	0
at WNDCLASS.hbrBackground,	dd	0
at WNDCLASS.lpszMenuName, 	dd	0
at WNDCLASS.lpszClassName, 	dd	caption
	iend

pixelformat
	istruc PIXELFORMATDESCRIPTOR
at PIXELFORMATDESCRIPTOR.nSize,			dw 	pixelformat_size
at PIXELFORMATDESCRIPTOR.nVersion,		dw	1
at PIXELFORMATDESCRIPTOR.dwFlags,		dd	(PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER | PFD_DEPTH_DONTCARE)
at PIXELFORMATDESCRIPTOR.iPixelType,		db	PFD_TYPE_RGBA
at PIXELFORMATDESCRIPTOR.cColorBits,		db	0x18
at PIXELFORMATDESCRIPTOR.cRedBits,		db	0x08
at PIXELFORMATDESCRIPTOR.cRedShift,		db	0x10
at PIXELFORMATDESCRIPTOR.cGreenBits,		db	0x08
at PIXELFORMATDESCRIPTOR.cGreenShift,		db	0x08
at PIXELFORMATDESCRIPTOR.cBlueBits,		db	0x08
at PIXELFORMATDESCRIPTOR.cBlueShift,		db	0x00
at PIXELFORMATDESCRIPTOR.cAlphaBits,		db	0
at PIXELFORMATDESCRIPTOR.cAlphaShift,		db	0
at PIXELFORMATDESCRIPTOR.cAccumBits,		db	0
at PIXELFORMATDESCRIPTOR.cAccumRedBits,		db	0
at PIXELFORMATDESCRIPTOR.cAccumGreenBits,	db	0
at PIXELFORMATDESCRIPTOR.cAccumBlueBits,	db	0
at PIXELFORMATDESCRIPTOR.cAccumAlphaBits,	db	0
at PIXELFORMATDESCRIPTOR.cDepthBits,		db	0
at PIXELFORMATDESCRIPTOR.cStencilBits,		db	0
at PIXELFORMATDESCRIPTOR.cAuxBuffers,		db	0
at PIXELFORMATDESCRIPTOR.iLayerType,		db	PFD_MAIN_PLANE;
at PIXELFORMATDESCRIPTOR.bReserved,		db	0
at PIXELFORMATDESCRIPTOR.dwLayerMask,		dd	0
at PIXELFORMATDESCRIPTOR.dwVisibleMask,		dd	0
at PIXELFORMATDESCRIPTOR.dwDamageMask,		dd	0
	iend

pixelformat_size equ $ - pixelformat

;   ___   __
;  / _/--|  |--,
; /___    _<  < __                               __
; 4k. |__|  \__\\_\ local variables for emacs :) \_\

; Local Variables:
; mode: asm
; tab-width: 8
; End:

END