(** An object with a file position. *)

(*
    il4c  --  Compiler for the IL4 Lisp-ahtava langauge
    Copyright (C) 2007 Jere Sanisalo

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(** (file, line, column) -position. *)
type pos = string * int * int

(** File range. *)
type range = pos * pos

(** Positioned object. *)
type 'a t = 'a * pos


(** Creates a new position. *)
val make_pos : string -> int -> int -> pos

(** Returns the positions file. *)
val pos_file : pos -> string

(** Returns the positions line. *)
val pos_line : pos -> int

(** Returns the positions column. *)
val pos_col : pos -> int

(** Returns the position as a string. *)
val pos_desc : pos -> string


(** Creates a new range. *)
val make_range : pos -> pos -> range

(** Returns the range as a string. *)
val range_desc : range -> string


(** Creates a new positioned object. *)
val make_with_pos : 'a -> pos -> 'a t

(** Creates a new positioned object. *)
val make : 'a -> string -> int -> int -> 'a t

(** Returns the object. *)
val obj : 'a t -> 'a

(** Returns the position. *)
val pos : 'a t -> pos
