/*
    GC masher -- test your command line switches
    Use as you wish
    Marq/Fit 11.8.2005
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXLEN 1000
#define MAXROW 1000
#define MAXCHS 100

int getlen(char *fname)
{
    FILE    *f;
    int     len;

    f=fopen(fname,"rb");
    if(f==NULL)
        return(-1);
    fseek(f,0,SEEK_END);
    len=ftell(f);
    fclose(f);

    return(len);
}

int main(int argc,char *argv[])
{
    FILE    *s,*r;
    int     nc[MAXROW],cnt[MAXROW],total=0,i,smal,zeros,plus=1;
    char    row[MAXLEN],*testf,*resf,*choice[MAXROW][MAXCHS],*t,cmd[1000];

    if(argc!=2)
    {
        puts("Usage: gcmasher datafile.txt\nSee the example datafile.");
        return(EXIT_FAILURE);
    }

    /* Open datafile */
    printf("Opening %s\n",argv[1]);
    s=fopen(argv[1],"rb");
    if(s==NULL)
    {
        puts("Error opening datafile");
        return(EXIT_FAILURE);
    }

    /* Find the result filename */
    printf("Finding result filename: ");
    while(1)
    {
        fgets(row,MAXLEN,s);
        if(row[0]!='#')
        {
            row[strlen(row)-1]='\0';
            resf=strdup(row);
            r=fopen(resf,"wb");
            if(r==NULL)
            {
                printf("Cannot open result file %s\n",row);
                return(EXIT_FAILURE);
            }
            puts(resf);
            break;
        }
    }

    /* Then the tested file */
    printf("Finding tested filename: ");
    while(1)
    {
        fgets(row,MAXLEN,s);
        if(row[0]!='#')
        {
            row[strlen(row)-1]='\0';
            testf=strdup(row);
            puts(testf);
            break;
        }
    }

    /* And finally the choices */
    puts("Finding choices");
    while(1)
    {
        if(feof(s))
            break;
        if(fgets(row,MAXLEN,s)==0)
            break;

        if(row[strlen(row)-1]=='\n')
            row[strlen(row)-1]='\0';
        if(strlen(row)==0)
            break;
        if(row[0]=='#')
            continue;

        /* Find the choices */
        cnt[total]=0;
        nc[total]=0;
        if(row[0]=='*') /* Fixed row */
        {
            choice[total][0]=strdup(&row[1]);
        }
        else
        {
            i=0;
            t=strtok(row," ");
            while(t!=NULL)
            {
                choice[total][i]=strdup(t);
                i++;
                t=strtok(NULL," ");
            }
            nc[total]=i;

            if(i==1) /* Make single choice binary on/off */
            {
                nc[total]=2;
                choice[total][1]="";
            }
        }
        total++;
    }

    fclose(s);
    puts("Testing testing");

    smal=1000000000;
    while(1)
    {
        /* Build a command line */
        for(i=zeros=0,t=cmd,plus=1;i<total;i++)
        {
            if(strlen(choice[i][cnt[i]]))
                sprintf(t,"%s ",choice[i][cnt[i]]);
            t=&cmd[strlen(cmd)];

            if(nc[i])
            {
                cnt[i]=(cnt[i]+plus)%nc[i];
                if(cnt[i]==0)
                    zeros++;
                else
                    plus=0;
            }
            else
                zeros++;
        }
        system(cmd); /* Run it */

        i=getlen(testf);
        if(i>0)
        {
            fprintf(r,"%d <= %s\n",i,cmd);
            if(i<smal)
            {
                printf("(best:%d)",i);
                smal=i;
            }
        }

        printf(".");
        fflush(stdout);

        if(zeros==total)
            break;
    }
    puts("");
    fclose(r);

    /* Gather the results */
    t="Strange error!\n";
    r=fopen(resf,"rb");
    i=1000000000;
    while(1)
    {
        if(feof(r))
            break;
        fgets(row,MAXLEN,r);
        if(atoi(row)>0 && atoi(row)<i)
        {
            i=atoi(row);
            t=strdup(row);
        }
    }
    fclose(r);
    printf("%s",t);

    return(EXIT_SUCCESS);
}
