%include "include\win32n.inc"  
%include "include\d3d8.inc"
%include "include\exinc.inc"


;standard trigonomic macros
%macro sin 2 
		fld %1;
		fsin;
		fstp %2;
%endm

%macro negsin 2 
		fld %1;
		fsin;
		fchs
		fstp %2;
%endm

%macro cos 2 
		fld %1;
		fcos;
		fstp %2;
%endm


segment .data USE32
%include "include\intro.inc"

mvb dd 0
STDVERTEX dd 0
D3D dd 0
roty dd 0,0
dtime dd 1000.0

stime	dd 0
time	dd 0

view_matrix:
	dd	1.0,	0.0,	0.0,	0.0
	dd	0.0,	1.0,	0.0,	0.0
	dd	0.0,	0.0,	1.0,	0.0
	dd	0.0,	0.0,	80.0,	1.0

matProj:
	dd	1.81066,	0.0,		0.0,		0.0
	dd	0.0,		2.41421,	0.0,		0.0
	dd	0.0,		0.0,		1.00101,	1.0
	dd	0.0,		0.0,		-1.00101,	0.0

matWorld:
	dd	0.0,	0.0,	0.0,	0.0
	dd	0.0,	1.0,	0.0,	0.0
	dd	0.0,	0.0,	0.0,	0.0
	dd	0.0,	0.0,	0.0,	1.0

;segment .code USE32

..start
;
; Standard Window Routine
;
;void WinMainCRTStartup()
;{
	invoke GetModuleHandleA,dword 0
		mov [OurWindowclass+WNDCLASSEX.hInstance],eax

	invoke RegisterClassExA, dword OurWindowclass

	invoke CreateWindowExA, dword 8h,dword Windowtitle,dword Windowtitle,dword  WS_POPUP + WS_VISIBLE,dword 0,dword 0,dword 640, dword 480,dword 0,dword 0, dword [OurWindowclass+WNDCLASSEX.hInstance],dword 0
		mov [d3pp+D3DPRESENT_PARAMETERS.hDeviceWindow],eax

	invoke ShowCursor, dword 0

	; Initialising DirectX

	invoke Direct3DCreate8, dword D3D_SDK_VERSION 
	mov [D3D], eax

	cominvoke2 IDirect3D8_CreateDevice, eax, byte 0, dword 1, dword [d3pp+D3DPRESENT_PARAMETERS.hDeviceWindow], dword D3DCREATE_SOFTWARE_VERTEXPROCESSING, dword d3pp, dword lpDD

	cominvoke IDirect3DDevice8_CreateVertexBuffer, lpDD, byte 48, byte D3DUSAGE_WRITEONLY, byte D3DFVF_XYZ|D3DFVF_DIFFUSE, byte D3DPOOL_MANAGED, dword mvb

	cominvoke IDirect3DDevice8_SetRenderState, lpDD, D3DRS_LIGHTING, 0

	cominvoke IDirect3DDevice8_SetRenderState, lpDD, D3DRS_CULLMODE, D3DCULL_NONE

	cominvoke IDirect3DVertexBuffer8_Lock, mvb, dword 0, dword 3, dword STDVERTEX, dword 0 
	;vielleicht nicht superschn und schnell aber schn klein komprimiert
	mov ebx, [STDVERTEX]
	mov [ebx], dword 0
	add ebx, 4
	mov [ebx], dword 041A00000h
	add ebx, 4
	mov [ebx], dword 0
	add ebx, 4
	mov [ebx], dword 0ffff0000h

	add ebx, 4
	mov [ebx], dword 041A00000h
	add ebx, 4
	mov [ebx], dword 00C1A00000h
	add ebx, 4
	mov [ebx], dword 0
	add ebx, 4
	mov [ebx], dword 0ff00ff00h

	add ebx, 4
	mov [ebx], dword 00C1A00000h
	add ebx, 4
	mov [ebx], dword 00C1A00000h
	add ebx, 4
	mov [ebx], dword 0
	add ebx, 4
	mov [ebx], dword 0ff0000ffh
	cominvoke IDirect3DVertexBuffer8_Unlock, mvb
	; MsgProc


	cominvoke IDirect3DDevice8_SetTransform, lpDD, D3DTS_VIEW, view_matrix
	cominvoke IDirect3DDevice8_SetTransform, lpDD, D3DTS_PROJECTION, matProj

	invoke GetTickCount
	mov	[stime], eax
	MessagePumpStart:
		invoke PeekMessageA, dword MessageBuffer,dword [d3pp+D3DPRESENT_PARAMETERS.hDeviceWindow],dword 0,dword 0,dword 0
		test eax,eax
			je nothing_on

		invoke GetMessageA, dword MessageBuffer, dword 0, dword 0, dword 0
		invoke DispatchMessageA, dword MessageBuffer

		nothing_on:

			cominvoke IDirect3DDevice8_Clear, dword lpDD, byte 0, byte 0, byte 3, byte 0, dword 3F800000h, byte 0

			cominvoke IDirect3DDevice8_BeginScene, lpDD

			; MAINRender Start

			invoke GetTickCount
			sub	eax, dword [stime]
			mov dword [roty], dword eax
			mov dword [roty+4], dword 0
			fild qword [roty]
			fdiv dword [dtime]
			fstp dword [roty]
			cos dword [roty], dword [matWorld]
			negsin dword [roty], dword [matWorld+8]
			sin dword [roty], dword [matWorld+32]
			cos dword [roty], dword [matWorld+40]

			cominvoke IDirect3DDevice8_SetTransform, lpDD, D3DTS_WORLD, matWorld

			cominvoke IDirect3DDevice8_SetVertexShader, lpDD, dword D3DFVF_XYZ|D3DFVF_DIFFUSE
			cominvoke IDirect3DDevice8_SetStreamSource, lpDD, dword 0, dword [mvb], dword 16
			cominvoke IDirect3DDevice8_DrawPrimitive, lpDD, dword D3DPT_TRIANGLELIST, dword 0, dword 1

			; MAINRender End

			cominvoke IDirect3DDevice8_EndScene, lpDD

			cominvoke IDirect3DDevice8_Present, lpDD, byte 0, byte 0, byte 0, byte 0

	jmp MessagePumpStart
;}


Windowprocedure:
;LRESULT CALLBACK WindowProc(HWND hWnd, unsigned uMsg, WPARAM wParam, LPARAM lParam)
;{
	cmp dword [esp+4+MSGmsg],WM_CLOSE
		je exit

	cmp dword [esp+4+MSGmsg],WM_DESTROY
		je exit

		jmp [DefWindowProcA]

	exit:
		cominvoke IDirect3DVertexBuffer8_Release, mvb
		cominvoke IDirect3DDevice8_Release, lpDD
		cominvoke IDirect3D8_Release, D3D
		invoke ExitProcess, dword 0
;}