#
# Makefile for the 4K intro framework.
#
# Build with:
#   nmake /f build.mak debug|release|safe|clean
#
# Coded by:
#   s_tec
#

out = 4k.exe
libs = gdi32.lib kernel32.lib opengl32.lib user32.lib winmm.lib glu32.lib
cflags = /c /O1 /Oi /fp:fast /Gr /GS- /nologo

#-----------------------------------------------------------------------------
# Debug build
# Debugger-friendly build using no assembler and no compression
#-----------------------------------------------------------------------------
debug: debug/$(out)

debug/$(out): debug/main.obj debug/demo.obj debug/music.obj
	link /entry:main /subsystem:windows /incremental:no /debug /nologo /out:$@ $** $(libs)

debug/main.obj: main.c
	cl $(cflags) /Zi /FAs /Fadebug\ /Fo$@ main.c
debug/demo.obj: demo.c
	cl $(cflags) /Zi /FAs /Fadebug\ /Fo$@ demo.c
debug/music.obj: music.c
	cl $(cflags) /Zi /FAs /Fadebug\ /Fo$@ music.c

#-----------------------------------------------------------------------------
# Release build
# Compo build using assembly language and full compression
#-----------------------------------------------------------------------------
release: release/$(out)

release/$(out): release/main.obj release/demo.obj release/music.obj
	crinkler /entry:main /subsystem:windows /compmode:slow /progressgui /out:$@ $** $(libs)

release/main.obj: main.asm
	nasmw -fwin32 -Xvc -o$@ main.asm
release/demo.obj: demo.c
	cl $(cflags) /Fo$@ demo.c
release/music.obj: music.c
	cl $(cflags) /Fo$@ music.c

#-----------------------------------------------------------------------------
# Fast build
# Like release build, but with faster compression
#-----------------------------------------------------------------------------
fast: fast/$(out)

fast/$(out): release/main.obj release/demo.obj release/music.obj
	crinkler /entry:main /subsystem:windows /out:$@ $** $(libs)

#-------------------------------------------------------------------------------
# Cleanup actions
#-------------------------------------------------------------------------------
clean:
	rmdir /S /Q debug
	rmdir /S /Q release
	rmdir /S /Q fast
