#pragma once


#include <deque>

/*! \note the width of these lines is twice the real width since each character is
	followed by an attribute character */
class CLineList {

public:
	std::deque<char *>				m_list;
	std::deque<char *>::iterator	m_current;
	int								m_width;
	int								m_xsaved, m_ysaved;
	unsigned int					m_maxLines;

	CLineList();
	~CLineList();

	void		init(int);
	void		rewind();
	int			getHeight();
	int			getWidth();
	char*		forwardCat();
	char*		backwardCat();
	char*		getContents();
	void		savePosition(int);
	int			loadSavedPosition();
	void		initLine(char *);

	int			getY();

	char*		bottom();
	char*		top();
	char*		forward();
	char*		backward();
	void		reset();
};