#pragma once


struct ANSIPalette {
	unsigned int cols[16];
};


class CAnsiFont {

private:
	void generateMipMaps(const unsigned char *);

public:

	unsigned int	*m_chars[4];
	int				m_charWidth;
	int				m_charHeight;
	int				m_numChars;
	//4 is the number of different resolutions

	CAnsiFont(const int width, const int, const int, const unsigned char *);
	~CAnsiFont();
	unsigned int *getCharPointer(unsigned char, int, int);
};

 
/*! \todo include BMP */
enum FileType {

	JPEG,
	GIF,
	PNG,
	BMP,
	RIP,

	ADF,
	XBIN,
	BIN,

	ANSI,
	ANSIMATION,
	ASCII,
	NONE
};



#define ESC 0x1b
#define CTRLZ 0x1a
#define MAXCMDLEN 256
#define WRAP 80
#define TABSTOP 8


enum colors {
	BIN_BLACK = 0,
	BIN_BLUE = 4,
	BIN_GREEN = 2,
	BIN_CYAN = 6,
	BIN_RED = 1,
	BIN_MAGENTA = 5,
	BIN_YELLOW = 3, 
	BIN_WHITE = 7
};


