#include "XbinLoader.h"

struct XB_Header {
	unsigned char  ID[4];
	unsigned char  EofChar;
	unsigned short Width;
	unsigned short Height;
	unsigned char  Fontsize;
	unsigned char  Flags;
};


CXbinLoader::CXbinLoader(CImageRenderer *renderer) :
	CTextLoader(renderer)
{

}


CXbinLoader::~CXbinLoader() {


}


bool CXbinLoader::isFileType(const char *signature, const char *) {

	if (strncmp(signature,"XBIN",4)==0) {
		return true;
	}
	return false;	
}


char *g_line;
int g_height, g_maxHeight;

static const char xb_conversion_table[8] = {
	BIN_BLACK,
	BIN_BLUE,
	BIN_GREEN,
	BIN_CYAN,
	BIN_RED,
	BIN_MAGENTA,
	BIN_YELLOW,
	BIN_WHITE
};

void storeXBIN(int &x, char ch, char att, CTextData *data) {

	//This if statement should not be below the x++ or it will add an extra line at the end
	if (x==(data->m_list->getWidth()/2)) {
		g_line = data->m_list->forwardCat();
		g_height++;
		x = 0;
	}

	if (g_height<=g_maxHeight) {
		g_line[x*2]   = ch;
		g_line[x*2+1] = att;
		x++;
	}
}




void CXbinLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CTextData *textData  = (CTextData *)imageData;
	textData->m_fileType = XBIN;
	
	//load the xbin header
	XB_Header header;
	int offset = 0;
	memcpy(header.ID,		data+offset, 4);	offset+=4;
	offset++; //skip ctrlz
	memcpy(&header.Width,	data+offset, 2);	offset+=2;
	memcpy(&header.Height,	data+offset, 2);	offset+=2;
	memcpy(&header.Fontsize,data+offset, 1);	offset+=1;
	memcpy(&header.Flags,	data+offset, 1);	offset+=1;
		
	//initialize the textimage
	int width = header.Width;
	textData->m_list->init(width*2);
	
	//load palette if present
	bool bConvert = false;
	if (header.Flags&1) {
		textData->m_userPalette = new ANSIPalette;
		
		unsigned char pal[3*16];
		memcpy(pal, data+offset, 3*16);			offset+=3*16;
		memset(textData->m_userPalette->cols, 0, 16*4);
		int r,g,b;
		for (int i=0; i<16; i++) {
			r = ((int)pal[i*3+0])<<2;
			g = ((int)pal[i*3+1])<<2;
			b = ((int)pal[i*3+2])<<2;
			textData->m_userPalette->cols[i] = (r<<16) | (g<<8) | (b<<0);   
		}
	} else {
		bConvert = true;
	}
	
	//load font if present
	if (header.Flags&2) {
		int fontSize = header.Fontsize*((header.Flags&16)?512:256);
		textData->m_userFont = new CAnsiFont(8, header.Fontsize, header.Flags&16?512:256, (const unsigned char *)(data+offset));
		offset += fontSize;
	}
	
	bool compression		= (header.Flags&4)!=0;
	textData->m_iceColors	= (header.Flags&8)!=0;
	
	if (compression) {
		
		unsigned char ch, att, type, counter;
		g_line   = textData->m_list->forwardCat();
		g_height = 1;
		g_maxHeight = header.Height;
		int  x = 0;

		while(offset<length) {		
			
			ch	    = data[offset++];
			if (ch==CTRLZ)
				return;

			type    = ch&0xC0;
			counter = ch&0x3F;
			//no compresion
			if (type==0) {
				
				/*! may be <=counter */
				for (int i=0; i<=counter; i++) {
					ch  = data[offset++];
					att = data[offset++];
					if (bConvert) {
						char fg = att&0x7;
						char bg = (att>>4)&0x7;
						fg = xb_conversion_table[fg];
						bg = xb_conversion_table[bg];
						att = (att&0x88)|fg|(bg<<4);
					}
					storeXBIN(x, ch, att, textData);
				}
				//character compression
			} else if (type==0x40) {
				
				ch = data[offset++];
				for (int i=0; i<=counter; i++) {
					att = data[offset++];
					if (bConvert) {
						char fg = att&0x7;
						char bg = (att>>4)&0x7;
						fg = xb_conversion_table[fg];
						bg = xb_conversion_table[bg];
						att = (att&0x88)|fg|(bg<<4);
					}
					storeXBIN(x, ch, att, textData);
				}
				//attribute compresion
			} else if (type==0x80) {
				
				att = data[offset++];
				if (bConvert) {
					char fg = att&0x7;
					char bg = (att>>4)&0x7;
					fg = xb_conversion_table[fg];
					bg = xb_conversion_table[bg];
					att = (att&0x88)|fg|(bg<<4);
				}
				for (int i=0; i<=counter; i++) {
					ch = data[offset++];
					storeXBIN(x, ch, att, textData);
				}
				//character/attribute compression
			} else {
				
				ch  = data[offset++];
				att = data[offset++];
				if (bConvert) {
					char fg = att&0x7;
					char bg = (att>>4)&0x7;
					fg = xb_conversion_table[fg];
					bg = xb_conversion_table[bg];
					att = (att&0x88)|fg|(bg<<4);
				}
				for (int i=0; i<=counter; i++) {
					storeXBIN(x, ch, att, textData);
				}
			}
		}
		
	} else {
		
		g_maxHeight = header.Height;
		for(int i=0; i<header.Height; i++) {
			char *line = textData->m_list->forwardCat();
			memcpy(line, data+offset, textData->m_list->getWidth());

			if (bConvert) {
				for (int i=1; i<textData->m_list->getWidth(); i+=2) {
					char fg = line[i]&0x7;
					char bg = (line[i]>>4)&0x7;
					fg = xb_conversion_table[fg];
					bg = xb_conversion_table[bg];
					line[i] = (line[i]&0x88)|fg|(bg<<4);
				}
			}
		
			offset += textData->m_list->getWidth();
		}					
	}

}


int CXbinLoader::loadFont(const char *filename, CAnsiFont **font) {

	FILE *fp = fopen(filename, "rb"); 
	if (!fp) 
		return 0;

	fseek(fp, 0, SEEK_SET);

	//load the xbin header
	XB_Header header;
	fread(header.ID, 1, 4, fp);
	if (strncmp((const char *)header.ID, "XBIN", 4)!=0) {		
		fclose(fp);
		return 0;
	}

//	fseek(fp, 0, SEEK_SET);
//	fread(&header, 1, sizeof(header), fp);
	fgetc(fp);
	//fread(&header.EofChar,  1, 1, fp);
	fread(&header.Width,	1, 2, fp);
	fread(&header.Height,	1, 2, fp);
	fread(&header.Fontsize,	1, 1, fp);
	fread(&header.Flags,	1, 1, fp);

	//load palette if present
	if (header.Flags&1) {
		fseek(fp, 3*16, SEEK_CUR);
	}
	
	//load font if present
	if (header.Flags&2) {
		int fontSize = header.Fontsize*((header.Flags&16)?512:256);
		unsigned char *data = new unsigned char[fontSize];
		fread(data, fontSize, 1, fp);

		if (*font) {
			delete *font;
		}

		*font = new CAnsiFont(8, header.Fontsize, header.Flags&16?512:256, data);

		fclose(fp);
		return 1;
	} 

	fclose(fp);
	return 0;
}



int CXbinLoader::loadPalette(const char *filename, ANSIPalette **pal) {

	FILE *fp = fopen(filename, "rb"); 
	if (!fp) 
		return 0;

	fseek(fp, 0, SEEK_SET);

	//load the xbin header
	XB_Header header;
	fread(header.ID, 4, 1, fp);
	if (strncmp((const char *)header.ID, "XBIN", 4)!=0) {		
		fclose(fp);
		return 0;
	}

	fgetc(fp);
	fread(&header.Width,	2, 1, fp);
	fread(&header.Height,	2, 1, fp);
	fread(&header.Fontsize,	1, 1, fp);
	fread(&header.Flags,	1, 1, fp);

	//load palette if present
	if (header.Flags&1) {

		if (*pal) 
			delete *pal;

		*pal = new ANSIPalette;
		memset((*pal)->cols, 0, 16*4);
		
		unsigned char palraw[3*16];
		fread(palraw, 3*16, 1, fp);
		int r,g,b;
		for (int i=0; i<16; i++) {
			r = ((int)palraw[i*3+0])<<2;
			g = ((int)palraw[i*3+1])<<2;
			b = ((int)palraw[i*3+2])<<2;
			(*pal)->cols[i] = (r<<16) | (g<<8) | (b<<0);   
		}		

		fclose(fp);
		return 1;
	}
	
	fclose(fp);
	return 0;
}



