#pragma once


#include "ImageData.h"
#include "ansifont.h"
#include "linelist.h"
#include <deque>


enum AnsiCommand {
	ANSI_STORE,
	ANSI_SET_ATTRIBUTES,
	ANSI_SET_POSITION,
	ANSI_MOVE_UP,
	ANSI_MOVE_DOWN,
	ANSI_MOVE_FORWARD,
	ANSI_MOVE_BACKWARD,
	ANSI_SAVE_POSITION,
	ANSI_RESTORE_POSITION,
	ANSI_CLEAR_SCREEN,
	ANSI_CLEAR_LINE,
	ANSI_END_OF_FILE,
	ANSI_NONE
};


class AnsiCommandData {
public:
	AnsiCommand command;
	char	argbuf[256];

	AnsiCommandData() { }
	~AnsiCommandData() { }

	AnsiCommandData& operator=(AnsiCommandData &cmd) {
		command = cmd.command;
		strcpy(argbuf, cmd.argbuf);
		return *this;
	}
};

static const char color_conversion_table[8] = {
  BIN_BLACK,
  BIN_RED,
  BIN_GREEN,
  BIN_YELLOW,
  BIN_BLUE,
  BIN_MAGENTA,
  BIN_CYAN,
  BIN_WHITE
};

class CTextData : public CImageData {


private:

	//buffer of ansi characters and commands used in ansimation rendering
	std::deque<AnsiCommandData>	m_buffer;

public:

	bool			m_iceColors;
	CLineList		*m_list;

	ANSIPalette		*m_userPalette;
	CAnsiFont		*m_userFont;

	//loading variables
	int				m_x;
	char			m_attribute, m_ch, *m_line;


	CTextData();
	~CTextData();

	//used by CAnsiLoader
	void storeImp(char);
	void store(char *);
	void moveUp(char *);
	void moveDown(char *);
	void moveForward(char *);
	void moveBackward(char *);
	void savePosition();
	void restorePosition();
	void setPosition(char *);
	void clearScreen(char *);
	void clearLine(char *);
	void setAttributes(char *);
	
	void	addCommand(AnsiCommandData *);
	int		getNextCommand(AnsiCommandData &);
	void	executeCommand(AnsiCommandData *);
	bool	hasCommands();

};