#pragma once


#include <vector>


enum OP_CODES {
	END_OF_CHAR	=  0,
	DO_SCAN		=  1,
	MOVE		=  2,
	DRAW		=  3
};


typedef struct {
	char	sig;							/* SIGNATURE byte									*/
	int		nchrs;							/* number of characters in file 					*/
	char	mystery;						/* Currently Undefined								*/
	char	first;							/* first character in file							*/
	int		cdefs;							/* offset to char definitions						*/
	char	scan_flag;						/* True if set is scanable							*/
	char	org_to_cap;						/* Height from origin to top of capitol 			*/
	char	org_to_base;					/* Height from origin to baseline					*/
	char	org_to_dec;						/* Height from origin to bot of decender			*/
	char	fntname[4];						/* Four character name of font						*/
	char	unused;							/* Currently undefined								*/
} HEADER;


typedef struct {
	unsigned int	header_size;			/* Version 2.0 Header Format						*/
	unsigned char	font_name[4];			/* Font Internal Name								*/
	unsigned int	font_size;				/* Size in byte of file 							*/
	unsigned char	font_major, font_minor; /* Driver Version Information						*/
	unsigned char	min_major, min_minor;	/* BGI Revision Information							*/
} FHEADER;


enum BgiFontType {

	DEFAULT		= 0,						/* 00     Default 8x8 font            Bit-Mapped	*/
	TRIPLEX		= 1,						/* 01     Triplex Font                Scalable		*/
	SMALL		= 2,						/* 02     Small Font                  Scalable		*/
	SANS_SERIF	= 3,						/* 03     Sans Serif Font             Scalable		*/
	GOTHIC		= 4,						/* 04     Gothic [Old English] Font   Scalable		*/
	SCRIPT		= 5,						/* 05     Script Font                 Scalable		*/
	SIMPLEX		= 6,						/* 06     Simplex Font                Scalable		*/
	TRIPLEX_SCRIPT = 7,						/* 07     Triplex Script Font         Scalable		*/
	COMPLEX		= 8,						/* 08     Complex Font                Scalable		*/
	EUROPEAN	= 9,						/* 09     European Font               Scalable		*/
	BOLD		= 10						/* 0A     Bold Font                   Scalable		*/
};


class STROKE {

public:
	//Stroke opcode byte
	char	opcode;
	//Relative offset x direction	
	int		x;
	//Relative offset y direction	
	int		y;

	
	STROKE(unsigned int *buffer) :
		x(-1),
		y(-1),
		opcode(0)
	{		
		struct DECODE {
			signed   int xoff  : 7;
			unsigned int flag1 : 1;
			signed   int yoff  : 7;
			unsigned int flag2 : 1;
		} cword;
		
		cword = *(struct DECODE *)buffer;	
		x = cword.xoff;
		y = cword.yoff;
		opcode = ( (cword.flag1 << 1) + cword.flag2 );	
	}
};


class CBgiFontCharacter {

public:
	std::vector<STROKE>		m_strokes;
	char					m_width;


	CBgiFontCharacter(int width, const unsigned int *buf, int index) :
		m_width(width)
	{

		unsigned int *pb;
		pb = (unsigned int *)(buf + index);		/* Reset pointer to buffer	*/	
		while( 1 ) {							/* For each byte in buffer	*/
			STROKE s(pb++);			
			if (s.opcode==END_OF_CHAR)
				break;
			else
				m_strokes.push_back(s);
		}
	}


	~CBgiFontCharacter() {
		m_strokes.clear();
	}

};


#define Prefix_Size		0x80


class CBgiFont {

private:
	FHEADER							*m_fheader;
	HEADER							m_header;
	CBgiFontCharacter				*m_chars[256];
	char							m_prefix[Prefix_Size];

	void loadFont(BgiFontType);


public:

	CBgiFont(BgiFontType);
	~CBgiFont();

};