// AcidViewView.cpp : implementation of the CAcidViewView class
//



#include "stdafx.h"
#include "AcidView.h"
#include "SauceDlg.h"
#include "SetBinWidth.h"

#include "AcidViewDoc.h"
#include "AcidViewView.h"

#include "AcidImage.h"
#include "ImageData.h"
#include "ImageFactory.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAcidViewView

IMPLEMENT_DYNCREATE(CAcidViewView, CView)

BEGIN_MESSAGE_MAP(CAcidViewView, CView)
	//{{AFX_MSG_MAP(CAcidViewView)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEWHEEL()
	ON_WM_KEYDOWN()
	ON_WM_TIMER()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_MBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAcidViewView construction/destruction

CAcidViewView::CAcidViewView() :
	m_smoothScroll(true),
	m_enableScroll(true),
	m_lastScrollPos(0,0),
	m_fullRedraw(false),
	m_size(0,0),
	m_allocatedSize(0,0),
	m_fullScreen(false),
	m_context(0),
	m_slideShowDelay(0),
	m_fullScreenDC(0)
{
	m_oldMode.dmSize = sizeof(DEVMODE);
	m_oldMode.dmDriverExtra = 0;
	EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &m_oldMode);	
}

CAcidViewView::~CAcidViewView()
{
	m_backBuffer[0].DeleteObject();
	m_backBuffer[1].DeleteObject();
	
	if (m_fullScreen) {
		ChangeDisplaySettings(&m_oldMode, CDS_FULLSCREEN);	
	}

	if (m_fullScreenDC) {
		m_fullScreenDC->DeleteDC();
		delete m_fullScreenDC;
	}
/*
	if (m_memDC) {
		m_memDC->DeleteDC();
		delete m_memDC;
		m_memDC = 0;
	}
*/
	AfxGetApp()->WriteProfileInt(_T("Settings"),_T("smoothScroll"),	m_smoothScroll?1:0);
	AfxGetApp()->WriteProfileInt(_T("Settings"),_T("fullScreenX"),	m_fullScreenSize.cx);
	AfxGetApp()->WriteProfileInt(_T("Settings"),_T("fullScreenY"),	m_fullScreenSize.cy);
	AfxGetApp()->WriteProfileInt(_T("Settings"),_T("scrollAmt"),	m_scrollAmt);
	AfxGetApp()->WriteProfileInt(_T("Settings"),_T("scrollTimer"),	m_scrollTimer);

	m_context->setRegistryValues(AfxGetApp());
	delete m_context;
	CImageContext::staticShutdown();
}

BOOL CAcidViewView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style = WS_VSCROLL|WS_HSCROLL|WS_CHILD|WS_VISIBLE;
	return CView::PreCreateWindow(cs);
}

int CAcidViewView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_context = new CImageContext();
	m_context->loadRegistryValues(AfxGetApp());	

	//m_memDC = new CDC();
	//m_memDC->CreateCompatibleDC(GetDC());
	//m_context->m_pDC = m_memDC;
	m_context->m_pDC = GetDC();
	m_context->m_hWnd = m_hWnd;

	m_smoothScroll		= AfxGetApp()->GetProfileInt(_T("Settings"),_T("smoothScroll"), 1)==1;
	m_fullScreenSize.cx = AfxGetApp()->GetProfileInt(_T("Settings"),_T("fullScreenX"), 640);
	m_fullScreenSize.cy = AfxGetApp()->GetProfileInt(_T("Settings"),_T("fullScreenY"), 400);
	m_scrollAmt			= AfxGetApp()->GetProfileInt(_T("Settings"),_T("scrollAmt"), 2);
	m_scrollTimer		= AfxGetApp()->GetProfileInt(_T("Settings"),_T("scrollTimer"), 5);
	
	return 0;
}
/////////////////////////////////////////////////////////////////////////////
// CAcidViewView drawing

void CAcidViewView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	CAcidImage *image = GetDocument()->m_image;
	if (!image) {
		SetScrollBars(TRUE);
		return;
	} 

	AfxGetMainWnd()->PostMessage(WM_SETMESSAGESTRING, AFX_IDS_IDLEMESSAGE);
	ClearBackBuffer();

	m_delayStart		= 0;
	m_lastScrollPos.x   = 0;
	m_lastScrollPos.y   = 0;
	m_fullRedraw		= true;
	m_enableScroll		= false;

	//load up the image or start the animation
	m_context->m_hWnd = m_hWnd;
	if (m_context->m_savedDC) {
		m_context->m_pDC->RestoreDC(m_context->m_savedDC);
		m_context->m_savedDC = 0;
	}
	image->startLoad(m_context);

	//set the title bar to have the sauce title if it exists
	if (image->m_data->m_sauce) {
		char title[100];
		memcpy(title, image->m_data->m_sauce->Title, 35);
		int i = 34;
		while(isspace(title[i])) 	i--;
		title[i+1] = '\0';
		GetDocument()->SetTitle(CString(title));		
	}

	//setup the scrollbars
	SetScrollBars(TRUE);
	SetScrollPos(SB_VERT, 0, FALSE);
	SetScrollPos(SB_HORZ, 0, FALSE);

	KillTimer(1);
	if (m_context->isAnimation(image)) {

		m_enableScroll = false;
		SetTimer(1, 10, NULL);
	} else if (m_smoothScroll) {
		
		m_enableScroll = true;
		SetTimer(1, m_scrollTimer, NULL);
	}
}


void CAcidViewView::OnDraw(CDC* pDC){
	
	CAcidViewDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CRect rc;
	if (!m_fullScreen) {
		GetClientRect(&rc);		
	} else {
		rc.top		= 0;
		rc.bottom	= m_fullScreenSize.cy;
		rc.left		= 0;
		rc.right	= m_fullScreenSize.cx;
	}
	
	//if no file selected, just clear to black
	CAcidImage *image = pDoc->m_image;
	if (!image || m_context->m_recordMovie) {
		pDC->PatBlt(rc.left, rc.top, rc.Width(), rc.Height(), BLACKNESS);
		return;
	}	

	//get scroller positions
	CPoint scrollPos  = CPoint(GetScrollPos(SB_HORZ), GetScrollPos(SB_VERT));
	CPoint scrollPos2 = scrollPos;

	//scroll the currently viewed content and then draw in the blank spots
	CPoint dscroll = m_lastScrollPos - scrollPos;
	if (scrollPos!=m_lastScrollPos && !m_fullRedraw) {
	
		if (dscroll.x!=0) {			
			if (m_fullScreen) {
				//ScrollDC(::GetDC(NULL), dscroll.x, 0, &rc, &rc, NULL, NULL);
				m_fullScreenDC->ScrollDC(dscroll.x, 0, &rc, &rc, NULL, NULL);
			} else {
				pDC->ScrollDC(dscroll.x, 0, &rc, &rc, NULL, NULL);
			}
			
			if (dscroll.x<0) {
				int oldWidth = rc.Width();
				rc.left	  = rc.right+dscroll.x;
				scrollPos.x += oldWidth-rc.Width();
			} else {
				rc.right = rc.left+dscroll.x;
			}
		} else if (dscroll.y!=0) {
			if (m_fullScreen) {
				//ScrollDC(::GetDC(NULL), 0, dscroll.y, &rc, &rc, NULL, NULL);
				m_fullScreenDC->ScrollDC(0, dscroll.y, &rc, &rc, NULL, NULL);
			} else {
				pDC->ScrollDC(0, dscroll.y, &rc, &rc, NULL, NULL);
			}
			if (dscroll.y<0) {
				int oldHeight = rc.Height();
				rc.top	      = rc.bottom+dscroll.y;
				scrollPos.y   += oldHeight-rc.Height();
			} else {
				rc.bottom = rc.top+dscroll.y;
			}			
		} else {
			return;
		}
	} 

	//center the ansi	
	CSize imageSize = CSize(image->getWidth(m_context), image->getHeight(m_context));
	int left	= rc.Width()>imageSize.cx?(rc.Width()-imageSize.cx)/2:0;
	int top		= rc.Height()>imageSize.cy?(rc.Height()-imageSize.cy)/2:0;
	int h		= rc.Height()>imageSize.cy?imageSize.cy:rc.Height();

	//have the image render that rectangle
	int xoffs,yoffs;
	CRect rc2 = rc;
	rc2.top     += scrollPos2.y;
	rc2.bottom  += scrollPos2.y;
	rc2.left    += scrollPos2.x;
	rc2.right	+= scrollPos2.x;

	CDC memDC, memDC2;
	memDC2.CreateCompatibleDC(pDC);
	if (m_fullScreen) {
		memDC.CreateCompatibleDC(m_fullScreenDC);
		//imageDC.CreateCompatibleDC(m_fullScreenDC);
	} else {
		memDC.CreateCompatibleDC(pDC);
		//imageDC.CreateCompatibleDC(pDC);
	}


	//m_memDC->SelectObject(&m_backBuffer[0]);
	//m_context->m_pDC = m_memDC;
	memDC2.SelectObject(&m_backBuffer[0]);
	m_context->m_pDC = &memDC2;
	image->invalidateRect(m_context, rc2, xoffs, yoffs);

	memDC.SelectObject(&m_backBuffer[1]);
	memDC.PatBlt(0, 0, rc.Width(), rc.Height(), BLACKNESS);
	//memDC.BitBlt(left, top, imageSize.cx, h, m_memDC, xoffs, yoffs, SRCCOPY);
	memDC.BitBlt(left, top, imageSize.cx, h,&memDC2, xoffs, yoffs, SRCCOPY);
	if (m_fullScreen) {
		m_fullScreenDC->BitBlt(rc.left, rc.top, rc.Width(), rc.Height(), &memDC, 0, 0, SRCCOPY);	
	} else {
		pDC->BitBlt(rc.left, rc.top, rc.Width(), rc.Height(), &memDC, 0, 0, SRCCOPY);			
	}
	
	m_fullRedraw	= false;
	m_lastScrollPos = scrollPos2;
}


void CAcidViewView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int pos = GetScrollPos(SB_HORZ);
	int minScroll, maxScroll;
	GetScrollRange(SB_HORZ, &minScroll, &maxScroll);

	switch(nSBCode) {		
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			pos = nPos;
			break;
		case SB_LEFT:
			pos = minScroll;		
			break;
		case SB_ENDSCROLL:
		case SB_RIGHT:
			//for some reason does not work
			//pos = maxScroll;		
			break;
		case SB_LINELEFT:
			pos -= 8;				
			break;
		case SB_LINERIGHT:
			pos += 8;
			break;
		case SB_PAGELEFT:
			pos -= m_size.cx;
			break;
		case SB_PAGERIGHT:
			pos += m_size.cx;
			break;
	}

	SetScrollPos(SB_HORZ, pos);		
	Invalidate();	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CAcidViewView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) {
	m_enableScroll = false;
	int pos = GetScrollPos(SB_VERT);
	OnVScroll(SB_THUMBPOSITION, pos-zDelta, NULL);
	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CAcidViewView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int pos = GetScrollPos(SB_VERT);
	int minScroll, maxScroll;
	GetScrollRange(SB_VERT, &minScroll, &maxScroll);

	CRect rc;
	GetClientRect(&rc);

	int oldPos = pos;
	switch(nSBCode) {		
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			pos = nPos;
			break;
		case SB_BOTTOM:
			pos = maxScroll;		
			break;
		case SB_TOP:
			pos = minScroll;		
			break;
		case SB_LINEDOWN:
			pos += 16;
			break;
		case SB_LINEUP:
			pos -= 16;				
			break;
		case SB_PAGEDOWN:
			pos += m_size.cy/2;
			break;
		case SB_PAGEUP:
			pos -= m_size.cy/2;
			break;
	}

	SetScrollPos(SB_VERT, pos);			
	//InvalidateRect(&rc);
	Invalidate();
	CView::OnVScroll(nSBCode, nPos, pScrollBar);
}


/////////////////////////////////////////////////////////////////////////////
// CAcidViewView printing

BOOL CAcidViewView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CAcidViewView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CAcidViewView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CAcidViewView diagnostics

#ifdef _DEBUG
void CAcidViewView::AssertValid() const
{
	CView::AssertValid();
}

void CAcidViewView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAcidViewDoc* CAcidViewView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAcidViewDoc)));
	return (CAcidViewDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAcidViewView message handlers


/*! Enlarges the backbuffer if necessary */
BOOL CAcidViewView::RecreateBackBuffer(int cx, int cy)
{
	m_size = CSize(cx, cy);
	if (m_allocatedSize.cx<cx || m_allocatedSize.cy<cy)
	{
		cx = __max(m_allocatedSize.cx, cx);
		cy = __max(m_allocatedSize.cy, cy);
		m_allocatedSize = CSize(cx, cy);

		CDC memDC;
		memDC.CreateCompatibleDC(GetDC());
		for (int i=0; i<2; i++) {
			m_backBuffer[i].DeleteObject();
			m_backBuffer[i].CreateCompatibleBitmap(GetDC(), cx, cy);
			memDC.SelectObject(m_backBuffer);
			memDC.PatBlt(0, 0, cx, cy, BLACKNESS);
		}
		return TRUE;
	}

	return FALSE;	
}

/*! Sets the backubffer to black */ 
void CAcidViewView::ClearBackBuffer() {

	CDC imageDC;
	imageDC.CreateCompatibleDC(GetDC());
	imageDC.SelectObject(&m_backBuffer[0]);
	CRect rc;
	GetClientRect(&rc);
	imageDC.PatBlt(0, 0, m_allocatedSize.cx, m_allocatedSize.cy, BLACKNESS);
}

/////////


BOOL CAcidViewView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}




void CAcidViewView::SetScrollBars(BOOL b=TRUE) {

	CRect rc;
	if (m_fullScreen) {
		rc.top		= 0;
		rc.bottom	= m_fullScreenSize.cy;
		rc.left		= 0;
		rc.right	= m_fullScreenSize.cx;
	} else {
		GetClientRect(&rc);
	}

	CAcidImage *image = GetDocument()->m_image;

	SCROLLINFO si;
	memset(&si, 0, sizeof(SCROLLINFO));
	si.cbSize	= sizeof(SCROLLINFO);
	si.fMask	= SIF_RANGE|SIF_PAGE;
	si.nPage	= rc.Height();
	si.fMask   |= SIF_DISABLENOSCROLL;
	// \note I believe this -1 is correct
	si.nMax		= (image) ? image->getHeight(m_context)-1 : 0;
	SetScrollInfo(SB_VERT, &si, b);	

	memset(&si, 0, sizeof(SCROLLINFO));
	si.cbSize	= sizeof(SCROLLINFO);
	si.fMask	= SIF_RANGE|SIF_PAGE;
	si.nPage	= rc.Width();
	// \note I believe this -1 is correct 
	si.nMax		= (image) ? image->getWidth(m_context)-1: 0;
	SetScrollInfo(SB_HORZ, &si, b);		
}


void CAcidViewView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch(nChar) {
		case VK_NUMPAD9:
		case VK_PRIOR:
			OnVScroll(SB_PAGEUP, 0, NULL);
			break;
		case VK_NUMPAD3:
		case VK_NEXT:
			OnVScroll(SB_PAGEDOWN, 0, NULL);
			break;
		case VK_NUMPAD8:
		case VK_UP:
			OnVScroll(SB_LINEUP, 0, NULL);
			break;
		case VK_NUMPAD2:
		case VK_DOWN:
			OnVScroll(SB_LINEDOWN, 0, NULL);
			break;
		case VK_NUMPAD7:
		case VK_HOME:
			OnVScroll(SB_TOP, 0, NULL);
			break;
		case VK_NUMPAD1:
		case VK_END:
			OnVScroll(SB_BOTTOM, 0, NULL);
			break;
		case VK_NUMPAD4:
		case VK_LEFT:
			OnHScroll(SB_LINELEFT, 0, NULL);
			break;
		case VK_NUMPAD6:
		case VK_RIGHT:
			OnHScroll(SB_LINERIGHT, 0, NULL);
			break;
		case VK_MULTIPLY:
			ToggleLineMode(1);
			break;
		case VK_DIVIDE:
			ToggleLineMode(-1);
			break;
		case VK_ESCAPE:
			if (m_fullScreen) {
				CMainFrame *mf = (CMainFrame *)AfxGetMainWnd();
				mf->OnViewFullscreen();
				mf->stopSlideShow();
			}
			break;
	}
	
	//m_enableScroll = false;	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CAcidViewView::OnTimer(UINT nIDEvent) 
{

	CAcidImage *image = GetDocument()->m_image;

	if (image) {

		if (m_delayStart) {

			clock_t curTime = clock();
			clock_t wait = ((curTime-m_delayStart)*1000)/CLOCKS_PER_SEC;
			if (wait>=m_slideShowDelay) {
				KillTimer(1);
				AfxGetMainWnd()->PostMessage(WM_IMAGE_DONE);
			}

		} else if (!m_context->isAnimation(image)) {

			if (m_smoothScroll && m_enableScroll) {
				SCROLLINFO scrollInfo;
				GetScrollInfo(SB_VERT, &scrollInfo);		
				if ((int)scrollInfo.nPos>=((int)scrollInfo.nMax-(int)scrollInfo.nPage)) {
					m_delayStart = clock();
				} else {
					OnVScroll(SB_THUMBPOSITION, scrollInfo.nPos+m_scrollAmt, NULL);
				}
			} else {
				m_enableScroll = false;
				m_delayStart = clock();
			}
		} else {
			//this isn't necesarily true
			//blah... this proc needs help
			m_fullRedraw = true;
			if (image->isDoneLoading()) {
				m_delayStart = clock();
			}

			Sleep(10);
			Invalidate();	
			//Sleep(1);
		} 		
	}
	CView::OnTimer(nIDEvent);
}

void CAcidViewView::SetSpeed(int i) {

	/*! \todo ack.. using -2 as a signal to just update the bullets */
	if (i!=-2) {
		m_context->m_speed = i;
	} else {
		i = m_context->m_speed;
	}
	
	int baudID;
	switch(i) {
		case 2400:	baudID = 0;		break;
		case 4800:	baudID = 1;		break;
		case 9600:	baudID = 2;		break;
		case 14400:	baudID = 3;		break;
		case 28800:	baudID = 4;		break;
		case 38400:	baudID = 5;		break;
		case 57600:	baudID = 6;		break;
//		case -1:	baudID = 7;		break;
	}	

	//NOTE: '2' needs to change if the menu is screwed with
	if (AfxGetMainWnd()->GetMenu()) {
		CMenu *pMenu = AfxGetMainWnd()->GetMenu()->GetSubMenu(2);
	//	pMenu->CheckMenuRadioItem(0, 7, baudID, MF_BYPOSITION);
		pMenu->CheckMenuRadioItem(0, 6, baudID, MF_BYPOSITION);
	}
	AfxGetMainWnd()->PostMessage(WM_SETMESSAGESTRING, AFX_IDS_IDLEMESSAGE);
}

void CAcidViewView::SmoothScroll() {
	m_smoothScroll = !m_smoothScroll;
	if (AfxGetMainWnd()->GetMenu()) {
		CMenu *pMenu = AfxGetMainWnd()->GetMenu()->GetSubMenu(1);
		pMenu->CheckMenuItem(ID_VIEW_SMOOTHSCROLL, (m_smoothScroll)?MF_CHECKED:MF_UNCHECKED);
	}
}

void CAcidViewView::ViewSauce() {

	CSauceDlg dlg;

	CAcidImage *image = GetDocument()->m_image;
	bool oldEnableScroll = m_enableScroll;
	if (image && image->m_data->m_sauce) {

		m_enableScroll = false;
		char temp[100];

		Sauce *sauce = image->m_data->m_sauce;

		memcpy(temp, sauce->Title, 35);
		temp[35] = '\0';
		dlg.m_sauce = "Title:\t"+CString(temp)+"\r\n";

		memcpy(temp, sauce->Author, 20);
		temp[20] = '\0';
		dlg.m_sauce += "Author:\t"+CString(temp)+"\r\n";

		memcpy(temp, sauce->Group, 20);
		temp[20] = '\0';
		dlg.m_sauce += "Group:\t"+CString(temp)+"\r\n";

		
		memcpy(temp, sauce->Date, 9);
		temp[8] = '\0';
		if (temp[0]!='0') {
		dlg.m_sauce +=	CString("Date:\t") + 
						CString(temp[6])+CString(temp[7])+CString(" - ")+
						CString(temp[4])+CString(temp[5])+CString(" - ")+
						CString(temp[0])+CString(temp[1])+CString(temp[2])+CString(temp[3]);
		}
		
	} 

	dlg.DoModal();	
	m_enableScroll = oldEnableScroll;
}

void CAcidViewView::FullScreen() {

	/*! \todo work on 8bit displays? */
	m_fullScreen = !m_fullScreen;
	if (m_fullScreen) {
		DEVMODE devMode = m_oldMode;

		//If 0,0 then use the desktop resolution
		if (m_fullScreenSize.cx==0 || m_fullScreenSize.cy==0) {
			HWND hwnd = ::GetDesktopWindow();
			CRect rc;
			::GetWindowRect(hwnd, &rc);
			m_fullScreenSize = CSize(rc.Width(), rc.Height());
		}

		memset(&devMode,0,sizeof(devMode));	// Makes Sure Memory's Cleared
		devMode.dmSize=sizeof(devMode);	// Size Of The Devmode Structure
		devMode.dmPelsWidth  = m_fullScreenSize.cx;
		devMode.dmPelsHeight = m_fullScreenSize.cy;
		devMode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
		LONG l = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);	
		
		if (l!=DISP_CHANGE_SUCCESSFUL) {
			MessageBox("Error when attempting to go fullscreen\n");
			m_fullScreen = false;
		} else {

			//GetDC()->ResetDC(&devMode);
			if (m_fullScreenDC) {
				m_fullScreenDC->DeleteDC();
			} else {
				m_fullScreenDC = new CDC();
			}
			m_fullScreenDC->CreateDC("DISPLAY", NULL, NULL, NULL);
			RecreateBackBuffer(m_fullScreenSize.cx, m_fullScreenSize.cy);
			m_context->m_scaleWidth = m_fullScreenSize.cx;
			SetScrollBars();			
			ShowScrollBar(SB_BOTH, FALSE);
		}

	} else {
		m_context->m_scaleWidth = 0;
		ChangeDisplaySettings(NULL, 0);	
		SetScrollBars();
	}

	ClearBackBuffer();
	m_fullRedraw = true;
	Invalidate();	
}


void CAcidViewView::UpdateViewSauce(CCmdUI *pCmdUI) {

	CAcidImage *image = GetDocument()->m_image;
	if (image) 
		pCmdUI->Enable(image->m_data->m_sauce?TRUE:FALSE);		
	else 
		pCmdUI->Enable(FALSE);		
}

/*! \todo implement */
void CAcidViewView::SetBINWidth() {

	CAcidImage *image = GetDocument()->m_image;
	if(image && image->getFileType()==BIN) {

		CSetBINWidth dlg;		
		dlg.DoModal();
		/*! \todo implement */
		//m_context->m_binWidth = dlg.m_binWidth;
	}
}

/*! \todo this may not work */
void CAcidViewView::Refresh(bool animate) {

	if (animate) {
		m_context->m_animation = ON;
	} else {
		m_context->m_animation = DEPENDENT;
	}

	OnInitialUpdate();
}


void CAcidViewView::UpdateSpeedAlwaysOn(CCmdUI *pCmdUI) {

	pCmdUI->SetCheck(m_context->m_animation==ON);
}

void CAcidViewView::SpeedAlwaysOn() {
	
	/*! \todo there should be a three way switch, always off, always on, dependent */
	if (m_context->m_animation==ON)
		m_context->m_animation = DEPENDENT;
	else
		m_context->m_animation = ON;
}


void CAcidViewView::UpdateFonts(CCmdUI *pCmdUI) {

	int fontID=0;
	for (int i=0; i<CImageContext::m_numFonts; i++, fontID++) {
		if (m_context->m_font==CImageContext::m_fonts[i])
			break;
	} 
	
	int base = 7;
	if (AfxGetMainWnd()->GetMenu()) {
		//Get View menu
		//NOTE: '1' needs to change if the menu is screwed with
		CMenu *pMenu = AfxGetMainWnd()->GetMenu()->GetSubMenu(1);
		//Get Font popu-up
		pMenu = pMenu->GetSubMenu(1);

		//Add the loaded font to the list if there
		static bool added = false;
		if (m_context->m_numFonts==5 && !added) {
			pMenu->InsertMenu(4, MF_BYPOSITION, ID_VIEW_FONT_LOADED, _T("Loaded Font"));
			added = true;
		}

		pMenu->CheckMenuRadioItem(0, CImageContext::m_numFonts, fontID, MF_BYPOSITION);
	}
}

void CAcidViewView::ChangeFont(FontType f) {

	m_context->setFont(f);
	
	CAcidImage *image = GetDocument()->m_image;
	if (image && image->isTextType()) {
		SetScrollBars();
		m_fullRedraw = true;
		AfxGetMainWnd()->PostMessage(WM_SETMESSAGESTRING, AFX_IDS_IDLEMESSAGE);
		Invalidate();
	}
}

void CAcidViewView::ToggleLineMode(int incAmt) {

	for (int i=0; i<CImageContext::m_numFonts; i++) {
		if (m_context->m_font==CImageContext::m_fonts[i]) {
			ChangeFont((FontType)((i+incAmt+CImageContext::m_numFonts)%CImageContext::m_numFonts));
			break;
		}
	}
}

void CAcidViewView::ToggleSpeed() {

	int	i = m_context->m_speed;
	int baudID;
	switch(i) {
		case 2400:	baudID = 4800;		break;
		case 4800:	baudID = 9600;		break;
		case 9600:	baudID = 14400;		break;
		case 14400:	baudID = 28800;		break;
		case 28800:	baudID = 38400;		break;
		case 38400:	baudID = 57600;		break;
		case 57600:	baudID = 2400;		break;
	}	

	SetSpeed(baudID);
}


void CAcidViewView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	RecreateBackBuffer(cx, cy);
	SetScrollBars();
	m_fullRedraw = true;
	Invalidate();
}


void CAcidViewView::IncreaseResolution() {
	int i = m_context->m_resolution;
	i = (i+1)%CImageContext::m_numResolutions;
	SetResolution((ViewResolution)(i));
}


void CAcidViewView::DecreaseResolution() {
	int i = m_context->m_resolution;
	i = (i-1+CImageContext::m_numResolutions)%CImageContext::m_numResolutions;
	SetResolution((ViewResolution)(i));
}


void CAcidViewView::SetResolution(ViewResolution v)
{
	if (AfxGetMainWnd()->GetMenu()) {
		//Get View menu
		CMenu *pMenu = AfxGetMainWnd()->GetMenu()->GetSubMenu(1);	
		//Get Resolution menu
		pMenu = pMenu->GetSubMenu(0);
		pMenu->CheckMenuRadioItem(0, CImageContext::m_numResolutions, v, MF_BYPOSITION);
	}

	//if not just updating the bullets on the menu
	if (v!=m_context->m_resolution) {
		
		m_context->setResolution(v);
		m_fullRedraw = true;
		SetScrollBars(TRUE);
		ClearBackBuffer();
		AfxGetMainWnd()->PostMessage(WM_SETMESSAGESTRING, AFX_IDS_IDLEMESSAGE);
		Invalidate();
	}
}

void CAcidViewView::UpdateViewPalette(CCmdUI *) {

	int paletteID = 0;
	for (int i=0; i<CImageContext::m_numPalettes; i++, paletteID++) {
		if (m_context->m_palette==CImageContext::m_palettes[i])
			break;
	} 
	
	int base = 7;
	if (AfxGetMainWnd()->GetMenu()) {
		//Get View menu
		//NOTE: '1' needs to change if the menu is screwed with
		CMenu *pMenu = AfxGetMainWnd()->GetMenu()->GetSubMenu(1);
		//Get Palette popu-up
		pMenu = pMenu->GetSubMenu(2);

		//Add the loaded palette to the list if there
		static bool added=false;
		if (m_context->m_numPalettes==4 && !added) {
			pMenu->InsertMenu(3, MF_BYPOSITION, ID_VIEW_PALETTE_LOADED, _T("Loaded Palette"));
			added = true;
		}

		pMenu->CheckMenuRadioItem(0, CImageContext::m_numFonts, paletteID, MF_BYPOSITION);
	}
}

void CAcidViewView::ChangePalette(PaletteType p) {
	m_context->setPalette(p);
	AfxGetMainWnd()->PostMessage(WM_SETMESSAGESTRING, AFX_IDS_IDLEMESSAGE);
	Invalidate();
}

void CAcidViewView::OnMButtonDown(UINT nFlags, CPoint point) 
{
	CMainFrame *mf = (CMainFrame *)AfxGetMainWnd();
	mf->OnViewFullscreen();
	CView::OnMButtonDown(nFlags, point);
}


void CAcidViewView::GetStatusString(CString &s) {

	CString modem = (m_context->m_animation==ON)?"On ":"Off";
	s.Format("Modem: %s || Speed: %d || ", modem, m_context->m_speed);

	s += "Resolution: ";
	switch(m_context->m_resolution) {
		case rNormal:	s += "Normal";	break;
		case r320:		s += "MCGA";	break;
		case r160:		s += "VGA";		break;
		case r80:		s += "SVGA";	break;
	}
	s += " || ";

	/////
	int fontID=0;
	for (int i=0; i<CImageContext::m_numFonts; i++, fontID++) {
		if (m_context->m_font==CImageContext::m_fonts[i])
			break;
	} 

	s += "Font: ";
	switch(fontID) {
		case 0:			s += "Normal";	break;
		case 1:			s += "50 Lines";break;
		case 2:			s += "Amiga";	break;
		case 3:			s += "AcidView";break;
		case 4:			s += "Loaded";	break;
	}
	s += " || ";

	//////
	int paletteID = 0;
	for (i=0; i<CImageContext::m_numPalettes; i++, paletteID++) {
		if (m_context->m_palette==CImageContext::m_palettes[i])
			break;
	} 

	s += "Palette: ";
	switch(paletteID) {
		case 0:			s+="Normal";	break;
		case 1:			s+="Greyscale";	break;
		case 2:			s+="Ascii";		break;
		case 3:			s+="Loaded";	break;
	}
}
