// AcidViewDoc.cpp : implementation of the CAcidViewDoc class
//

#include "stdafx.h"
#include "AcidView.h"
#include "AcidImage.h"
#include "AcidViewDoc.h"
#include "MainFrm.h"

#include "ImageFactory.h"
#include "ImageContext.h"
#include "ImageData.h"
#include "sauce.h"

#include "CompressedFile.h"
#include "CompressedFileFactory.h"

#pragma warning(disable:4786)

#include <png.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAcidViewDoc

IMPLEMENT_DYNCREATE(CAcidViewDoc, CDocument)

BEGIN_MESSAGE_MAP(CAcidViewDoc, CDocument)
	//{{AFX_MSG_MAP(CAcidViewDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAcidViewDoc construction/destruction


/*! \todo have multiple doc templates for each filetype? */
CAcidViewDoc::CAcidViewDoc() :
	m_image(0)
{
	m_factory = new CImageFactory();
}

CAcidViewDoc::~CAcidViewDoc()
{
	delete m_image;
	delete m_factory;
	delete (CCompressedFileFactory::getFactory());
}

BOOL CAcidViewDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	LoadSplash();
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CAcidViewDoc serialization

void user_write_fn(png_structp png_ptr, png_bytep data, png_size_t s) {

	CArchive *ar = (CArchive *)png_get_io_ptr(png_ptr);
	ar->Write(data, s);
}

void user_IO_flush_function(png_structp png_ptr) {
	CArchive *ar = (CArchive *)png_get_io_ptr(png_ptr);
	ar->Flush();
}

void CAcidViewDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{

		png_structp png_ptr;
		png_infop info_ptr;


	   /* Create and initialize the png_struct with the desired error handler
		* functions.  If you want to use the default stderr and longjump method,
		* you can supply NULL for the last three parameters.  We also check that
		* the library version is compatible with the one used at compile time,
		* in case we are using dynamically linked libraries.  REQUIRED.
		*/
		png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

		if (png_ptr == NULL) {
		  AfxMessageBox("Error saving as PNG");
		  return;
		}

		/* Allocate/initialize the image information data.  REQUIRED */
		info_ptr = png_create_info_struct(png_ptr);
		if (info_ptr == NULL) {
			png_destroy_write_struct(&png_ptr,  png_infopp_NULL);
			AfxMessageBox("Error saving as PNG");
			return;
		}

		/* Set error handling.  REQUIRED if you aren't supplying your own
		* error handling functions in the png_create_write_struct() call.
		*/
		if (setjmp(png_jmpbuf(png_ptr))) {
			/* If we get here, we had a problem reading the file */
			AfxMessageBox("Error saving as PNG");
			return;
		}

		/* I/O initialization method 2 */
		/* If you are using replacement read functions, instead of calling
		/* png_init_io() here you would call */
		/* where user_io_ptr is a structure you want available to the callbacks */
		png_set_write_fn(png_ptr, (void *)&ar, user_write_fn, user_IO_flush_function);

		char title[36];
		char author[21];
		char group[21];
		char temp[9];
			png_text text_ptr[4];
	   if (m_image->m_data->m_sauce) {
		   


			Sauce *sauce = m_image->m_data->m_sauce;
			memset(title, '\0', 36);
			memcpy(title, sauce->Title, 35);
			text_ptr[0].key  = "Title";
			text_ptr[0].text = title;
			text_ptr[0].compression = PNG_TEXT_COMPRESSION_NONE;
			
			memset(author, '\0', 21);
			memcpy(author, sauce->Author, 20);
			text_ptr[1].key  = "Author";
			text_ptr[1].text = author;
			text_ptr[1].compression = PNG_TEXT_COMPRESSION_NONE;

			memset(group, '\0', 21);
			memcpy(group, sauce->Group, 20);
			text_ptr[2].key  = "Group";
			text_ptr[2].text = group;
			text_ptr[2].compression = PNG_TEXT_COMPRESSION_NONE;

			memcpy(temp, sauce->Date, 9);
			CString date =	CString(temp[6])+CString(temp[7])+CString(" - ")+
							CString(temp[4])+CString(temp[5])+CString(" - ")+
							CString(temp[0])+CString(temp[1])+CString(temp[2])+CString(temp[3]);
			text_ptr[3].key  = "Date";
			text_ptr[3].text = (char *)(LPCTSTR)date;
			text_ptr[3].compression = PNG_TEXT_COMPRESSION_NONE;


			png_set_text(png_ptr, info_ptr, text_ptr, 4);
	   }

	   
		CDC dc;
		dc.CreateCompatibleDC(NULL);
	   
		int w = m_image->getWidth(m_context);
		int h = m_image->getHeight(m_context);
		CBitmap *bitmap = new CBitmap();
		bitmap->CreateBitmap(w, h, 1, 32, NULL);
		m_context->m_pDC = &dc;
		m_context->m_pDC->SelectObject(bitmap);
		m_context->m_pDC->PatBlt(0, 0, w, h, BLACKNESS);
		int xoffs, yoffs;

		CRect rc(0, 0, w, h);	   
		m_image->invalidateRect(m_context, rc, xoffs, yoffs);
	   
		unsigned int *pixels = new unsigned int[w*h];
		bitmap->GetBitmapBits(w*h*4, pixels);

		png_set_IHDR(png_ptr, info_ptr, w, h, 8, PNG_COLOR_TYPE_RGB,
					PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

		png_write_info(png_ptr, info_ptr);

		png_set_packing(png_ptr);

		png_set_filler(png_ptr, 0, PNG_FILLER_AFTER);
		png_set_bgr(png_ptr);

		png_bytep *row_pointers = new png_bytep[h];
		for (int i=0; i<h; i++) {
			row_pointers[i] = (unsigned char *)&pixels[i*w];
		}
		
		png_write_image(png_ptr, row_pointers);
		png_write_end(png_ptr, info_ptr);
	   
		/* clean up after the write, and free any memory allocated */
		png_destroy_write_struct(&png_ptr, &info_ptr);
	   
		delete [] pixels;
		delete bitmap;
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CAcidViewDoc diagnostics

#ifdef _DEBUG
void CAcidViewDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAcidViewDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAcidViewDoc commands

BOOL CAcidViewDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	char *data = 0;
	unsigned long size;
	
	if (CCompressedFileFactory::containsCompressedFile(lpszPathName)) {
		CCompressedFileFactory *factory = CCompressedFileFactory::getFactory();
		factory->getFile(&data, &size, lpszPathName);
		if (!data && CCompressedFileFactory::isCompressedFile(lpszPathName)) {
			CString name = lpszPathName;
			if (name.Right(1)!='\\')
				name += "\\";
			factory->getFile(&data, &size, name+"file_id.diz");
		}
	}


	if (!data) {
		if (!CDocument::OnOpenDocument(lpszPathName))
			return FALSE;
	}

	delete m_image;
	m_image = 0;

	if (!data) {	
		m_image = m_factory->loadFile(lpszPathName);
	} else {
		m_image = m_factory->loadFileFromData(data, size, lpszPathName);
		delete [] data;
	}
	
	return TRUE;
}


void CAcidViewDoc::LoadSplash() {

	delete m_image;
	m_image = 0;
	srand(time(NULL));
	int i = (rand()%2)?IDR_SPLASH_JPG:IDR_SPLASH_PNG;
	m_image = m_factory->loadFileFromResource(i);
}

void CAcidViewDoc::LoadANSISplash() {

	delete m_image;
	m_image = 0;
	m_image = m_factory->loadFileFromResource(IDR_SPLASH_ANS);
}


void CAcidViewDoc::EnableRip() {
	m_factory->enableRip();
}