// AcidView.cpp : Defines the class behaviors for the application.
// 

#include "stdafx.h"
#include "AcidView.h"

#include "MainFrm.h"
#include "AcidViewDoc.h"
#include "AcidViewView.h"
#include "registerdlg.h"
#include "acidcommandlineinfo.h"

#include <conio.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAcidViewApp

BEGIN_MESSAGE_MAP(CAcidViewApp, CWinApp)
	//{{AFX_MSG_MAP(CAcidViewApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAcidViewApp construction

CAcidViewApp::CAcidViewApp() :
	m_historyMax(20),
	m_addToHistory(true),
	m_historyIndex(0)	
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CAcidViewApp object

CAcidViewApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAcidViewApp initialization

BOOL CAcidViewApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	SetRegistryKey(_T("ACiD"));

	//gz
	//if run for the first time, do the dialog and register some extensions
	int registered = GetProfileInt("Settings", "registered", 0);
	if (!registered) {
		
		WriteProfileInt("Settings", "registered", 1);

		CRegisterDlg dlg;
		dlg.m_adf = true;
		dlg.m_asc = true;
		dlg.m_bin = true;
		dlg.m_cia = true;
		dlg.m_diz = true;
		dlg.m_ice = true;
		dlg.m_lit = true;
		dlg.m_nfo = true;
		dlg.m_mem = true;
		dlg.m_xb  = true;

		dlg.DoModal();

		char key[] = "ACiDView.Document";
		if (dlg.m_adf) 	RegSetValue(HKEY_CLASSES_ROOT, ".adf", REG_SZ, key, sizeof(key));
		if (dlg.m_asc) 	RegSetValue(HKEY_CLASSES_ROOT, ".asc", REG_SZ, key, sizeof(key));
		if (dlg.m_bin) 	RegSetValue(HKEY_CLASSES_ROOT, ".bin", REG_SZ, key, sizeof(key));
		if (dlg.m_cia) 	RegSetValue(HKEY_CLASSES_ROOT, ".cia", REG_SZ, key, sizeof(key));
		if (dlg.m_diz) 	RegSetValue(HKEY_CLASSES_ROOT, ".diz", REG_SZ, key, sizeof(key));

		if (dlg.m_ice) 	RegSetValue(HKEY_CLASSES_ROOT, ".ice", REG_SZ, key, sizeof(key));
		if (dlg.m_lit) 	RegSetValue(HKEY_CLASSES_ROOT, ".lit", REG_SZ, key, sizeof(key));
		if (dlg.m_nfo) 	RegSetValue(HKEY_CLASSES_ROOT, ".nfo", REG_SZ, key, sizeof(key));
		if (dlg.m_mem) 	RegSetValue(HKEY_CLASSES_ROOT, ".mem", REG_SZ, key, sizeof(key));
		if (dlg.m_xb) 	RegSetValue(HKEY_CLASSES_ROOT, ".xb",  REG_SZ, key, sizeof(key));
	}

	LoadStdProfileSettings(5);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CAcidViewDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CAcidViewView));
	AddDocTemplate(pDocTemplate);

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	//Add slideshow context menu
	HKEY key;
	LONG ret = RegOpenKey(HKEY_CLASSES_ROOT, "ACiDView.Document\\shell", &key);
	if (ret==ERROR_SUCCESS) {

		HKEY openKey;
		RegOpenKey(HKEY_CLASSES_ROOT, "ACiDView.Document\\shell\\open\\command", &openKey);
		long len;
		RegQueryValue(openKey, NULL, NULL, &len);
		char *_appname = new char [len];
		RegQueryValue(openKey, NULL, _appname, &len);

		CString appname = _appname;
		int q = appname.Find("exe");
		CString appname2 = appname.Left(q+3);
	
		RegCloseKey(openKey);
		delete [] _appname;

		HKEY slideshowKey; 
		RegCreateKey(key, "ACiD View Slideshow", &slideshowKey);

		CString s1 = appname2+CString(" /dde");
		CString s2 = "[slideshow(\"%1\")]";
		RegSetValue(slideshowKey, "command", REG_SZ, s1, sizeof(s1));
		RegSetValue(slideshowKey, "DDEExec", REG_SZ, s2, sizeof(s2));
		RegCloseKey(key);
	}

	// Parse command line for standard shell commands, DDE, file open
	CAcidCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	UINT showCmd = GetProfileInt(_T("Settings"),_T("showCmd"),SW_SHOW);
	m_pMainWnd->ShowWindow(showCmd);

	if (cmdInfo.m_startSlideShow) {
		CMainFrame *mf = (CMainFrame *)m_pMainWnd;
		
		if (cmdInfo.m_cycle!=-1) 
			mf->m_slideShow.bCycle = (cmdInfo.m_cycle==1);
		
		if (cmdInfo.m_random!=-1) 
			mf->m_slideShow.bRandom = (cmdInfo.m_random==1);
		
		if (cmdInfo.m_startFullScreen!=-1) 
			mf->m_slideShow.bStartFullscreen = (cmdInfo.m_startFullScreen==1);
		
		if (cmdInfo.m_resolution!=-1) 
			mf->GetRightPane()->SetResolution(ViewResolution(cmdInfo.m_resolution));

		if (cmdInfo.m_font!=-1) 
			mf->GetRightPane()->ChangeFont(FontType(cmdInfo.m_font));
		
		if (cmdInfo.m_palette!=-1) 
			mf->GetRightPane()->ChangePalette(PaletteType(cmdInfo.m_palette));
		
		/*! \todo ugly */
		if (cmdInfo.m_fullScreenSize!=-1) {
			switch(cmdInfo.m_fullScreenSize) {
				case 0:		mf->GetRightPane()->m_fullScreenSize = CSize(640, 400);		break;
				case 1:		mf->GetRightPane()->m_fullScreenSize = CSize(640, 480);		break;
				case 2:		mf->GetRightPane()->m_fullScreenSize = CSize(1024, 768);	break;
				default:	mf->GetRightPane()->m_fullScreenSize = CSize(0, 0);			break;
			}
		}

		mf->startSlideShowImp();
	}

	//::MessageBox(NULL, "passed slideshow", "", MB_OK);
	m_pMainWnd->UpdateWindow();
	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();


	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CAcidViewApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CAcidViewApp message handlers

/*! \note historyIndex range = [0..m_historyIndexMax-1] <-- includes m_historyIndexMax*/
CDocument* CAcidViewApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{
	
	if (m_addToHistory) {

		if (m_historyIndex==(m_historyMax-1)) {
			m_history.pop_front();		
		}

		if (m_history.size()>0) {
			while((m_history.size()-1)>m_historyIndex)
				m_history.pop_back();
		}

		m_history.push_back(lpszFileName);
		m_historyIndex = m_history.size()-1;
	}

	m_addToHistory = true;
	return CWinApp::OpenDocumentFile(lpszFileName);
}


void CAcidViewApp::historyGoBack() {

	if (m_historyIndex>0) {
		refresh(-1);
	}
}

void CAcidViewApp::historyGoForward() {

	if (m_historyIndex<m_historyMax &&
		m_historyIndex<(m_history.size()-1) && 
		!m_history.empty()) {
		refresh(1);
	} 
}

void CAcidViewApp::refresh(int i) {

	m_historyIndex += i;
	m_addToHistory  = false;
	OpenDocumentFile(m_history[m_historyIndex]);
}

BOOL CAcidViewApp::OnDDECommand(LPTSTR lpszCommand) 
{
	//::MessageBox(NULL, lpszCommand, "", MB_OK);
	if (strnicmp(lpszCommand, "[slideshow", 10)==0) {		
		CString s = lpszCommand;
		int a = s.Find('(');
		int b = s.ReverseFind(')');
		s = s.Mid(a+1, b-a-1);

		//::MessageBox(NULL, s, lpszCommand, MB_OK);
		CMainFrame::m_fileArray.push_back(s);
		static bool start = false;
		if (!start) {
			((CMainFrame *)m_pMainWnd)->startSlideShowImp();
			start = true;
		}
		return TRUE;
	} else {
		return CWinApp::OnDDECommand(lpszCommand);
	}
}

