#pragma once


#include "ansifont.h"
#include "StdAfx.h"

class CImageLoader;
class CImageData;
class CImageContext;


class CAcidImage {
	
public:
	
	CImageLoader		*m_loader;	
	CImageData			*m_data;
	
	CAcidImage(const char *, CImageLoader *);
	CAcidImage(const char *, int, CImageLoader *);
	~CAcidImage();

	/*! return the scaled width in the passed context  */
	int				getWidth(CImageContext *);
	/*! return the scaled height in the passed context  */
	int				getHeight(CImageContext *);
	/*! return the file type enum */
	FileType		getFileType();
	/*! query the loader */
	bool			isDoneLoading();
	/*! return true if a text based image */
	bool			isTextType();
	/*! start the animated load in the given context */
	void			startLoad(CImageContext *);
	/*! kill the thread */
	void			stopLoad();
	/*! redraw the rectangle desired in the given context */
	int				invalidateRect(CImageContext *, CRect, int &, int &);
	/*! render a frame for an avi */
	bool			renderFrame(CImageContext *);
};