#include "acidimage.h"
#include "ImageLoader.h"
#include "ImageRenderer.h"
#include "ImageData.h"


CAcidImage::CAcidImage(const char *filename, CImageLoader *loader) :
	m_data(0),
	m_loader(loader)
{
	m_data = m_loader->loadFile(filename);
}


CAcidImage::CAcidImage(const char *data, int length, CImageLoader *loader) :
	m_data(0),
	m_loader(loader)
{
	m_data = m_loader->loadFileFromData(data, length);
}


CAcidImage::~CAcidImage() {

	if (!isDoneLoading()) {
		stopLoad();		
		while (!isDoneLoading()) { ; }
	}
	delete m_data;
}


int CAcidImage::invalidateRect(CImageContext *context, CRect rc, int &x, int &y) {
	return m_loader->getRenderer()->invalidateRect(context, m_data, rc, x, y);
}


bool CAcidImage::isDoneLoading() {
	return m_data->getThreadDone();
}


void CAcidImage::startLoad(CImageContext *context) {
	m_loader->startLoad(context, m_data);
}

void CAcidImage::stopLoad() {
	m_data->setThreadDone(true);
}

/*! return the scaled width in the passed context */
int CAcidImage::getWidth(CImageContext *context) {
	return m_loader->getRenderer()->getWidth(context, m_data);	
}

int CAcidImage::getHeight(CImageContext *context) {
	return m_loader->getRenderer()->getHeight(context, m_data);	
}

bool CAcidImage::isTextType() {

	ASSERT(m_data->m_fileType!=NONE);

	bool ret = false;
	switch(m_data->m_fileType) {
		case JPEG:
		case GIF:
		case PNG:
		case RIP:
			ret = false;
			break;

		case ADF:
		case XBIN:
		case BIN:
		case ANSI:
		case ANSIMATION:
		case ASCII:
			ret = true;
			break;
	}

	return ret;
}

FileType CAcidImage::getFileType() {
	return m_data->m_fileType;
}

bool CAcidImage::renderFrame(CImageContext *context) {

	if (m_data->m_animateable) {
		
		bool ret = m_loader->loadFrame(context, m_data);

		CRect rc;
		rc.top = rc.left = 0;
		rc.right = getWidth(context);
		rc.bottom = getHeight(context);

		int xoffs, yoffs;
		invalidateRect(context, rc, xoffs, yoffs);
		return ret;
	} else {
		return true;
	}
}