#pragma once


#include "StdAfx.h"
#include "MainFrm.h"


class CAcidCommandLineInfo : public CCommandLineInfo {


public:
	int		m_resolution;
	int		m_font;
	int		m_palette;
	int		m_fullScreenSize;
	int		m_startFullScreen;
	int		m_cycle;
	int		m_random;
	BOOL	m_startSlideShow, m_question;
	CString m_mask;
	CString m_files;


	CAcidCommandLineInfo() : 
		CCommandLineInfo(),
		m_resolution(-1),
		m_font(-1),
		m_palette(-1),
		m_fullScreenSize(-1),
		m_startFullScreen(-1),
		m_cycle(-1),
		m_random(-1),
		m_startSlideShow(FALSE),
		m_mask("*.*"),
		m_files(""),
		m_question(FALSE)
	{
		
	}

	void ParseParam(LPCTSTR lpszParam, BOOL bFlag, BOOL bLast) {

		if (bFlag) {
			CString s = lpszParam;
			int colon = s.Find(':');
			CString param = s.Right(s.GetLength()-colon-1);
			switch(lpszParam[0]) {
				case 'X':
				case 'x':
					m_startSlideShow = TRUE;
					break;
				case 'R':
				case 'r':
					m_resolution = atoi(param);
					break;
				case 'F':
				case 'f':
					m_font = atoi(param);
					break;
				case 'C':
				case 'c':
					m_palette = atoi(param);
					break;
				case 'D':
				case 'd':
					if (colon!=-1)
						m_fullScreenSize = atoi(param);
					else if (strnicmp(lpszParam, "dde", 3)==0) {
						m_nShellCommand = CCommandLineInfo::FileDDE;			
						m_startSlideShow = TRUE;	
					}
					break;
				case 'S':
				case 's':
					m_startFullScreen = atoi(param);
					break;
				case 'Y':
				case 'y':
					m_cycle = atoi(param);
					break;
				case 'A':
				case 'a':
					m_random = atoi(param);
					break;
				case 'M':
				case 'm':
					m_mask = param;
					break;		
				case '?':
					m_question = TRUE;
					break;
			}
		} else {
		
			m_nShellCommand = CCommandLineInfo::FileOpen;
			if (m_startSlideShow) {
				m_strFileName += lpszParam;
				m_strFileName += ";";
			} else {
				m_strFileName = lpszParam;
			}
		}

		//If doing a slideshow and on the last argument, load up the slideshow parameters
		if (bLast && m_startSlideShow) {
			
			if (m_mask=="") {
				m_mask = AfxGetApp()->GetProfileString(_T("Settings"), _T("fileMask"), _T("*.*"));
			} else {
				m_mask.Remove(' ');
				m_mask.MakeLower();
				if (m_mask.Right(1)==";")
					m_mask = m_mask.Left(m_mask.GetLength()-1);
			}

			int i = m_strFileName.Find(';');
			while(i!=-1 && m_strFileName.GetLength()>0) {
				
				CString s = m_strFileName.Left(i);
				int j = s.ReverseFind('.');
				if (strnicmp((const char *)s + j+1, "txt", 3)==0) {
					CMainFrame::loadFileList(s, m_mask, true);
				} else if (	strnicmp((const char *)s + j+1, "zip", 3)==0 || 
							strnicmp((const char *)s + j+1, "rar", 3)==0 || 
							s.Right(1)=='\\') {
					CMainFrame::loadFileList(s, m_mask, false);
				} else {
					CMainFrame::m_fileArray.push_back(s);
				}

				
				m_strFileName = m_strFileName.Right(m_strFileName.GetLength()-i-1);
				i = m_strFileName.Find(';');
			}

			if (CMainFrame::m_fileArray.size()>0) {
				m_strFileName = CMainFrame::m_fileArray[0];
				CMainFrame::m_fileArray.pop_front();
			} else {
				m_nShellCommand = CCommandLineInfo::FileNew;
			}
		}
	}
};