{*
**
** ARTWORX DATA FORMAT -- Pascal Viewer
**
** Coded April 27, 1996 by Murray Stokely (Shivan Bastard)
**
** Copyright(c) 1996 Sector Logic
**
*}

(*
The .ADF specification is a essentially a single file which contains VGA font
data, the RGB registers for the text palette (registers 0-63), and an
unlimited amount of binary screen data.  It is intended primarily for
programmers who would like to add a unique look to any textmode program.
*)

Program ADF_Viewer;
uses dos,crt;

var
  version:char;                       { version of the ADF file format }
  pallette:array[0..63,1..3] of byte; { pallete (color) information }
  old_pal:array[0..63,1..3] of byte;  { save the old pallette }
  vga_font:array[1..4096] of char;    { vga font data }
  vbuffer:array[1..4000] of char;     { video memory buffer }

  key:char;                           { used for reading the keyboard }
  ext:char;                           { used for reading extended keys }
  exit_stat:integer;                  { exit the scoller? }
  pointer:integer;                    { line number }
  max_lines:integer;                  { number of lines }

  f:file;                             { the file }
  count1,count2:byte;                 { Junk counters }
  regs:registers;                     { pascal registers }


Procedure GetPal(Color,R,G,B : Byte);
{ this get's the RGB intensities of COLOR }
Begin
   Port[$3c7] := Color;
   R := Port[$3c9];
   G := Port[$3c9];
   B := Port[$3c9];
End;

Procedure SetPal(Color,R,G,B : Byte);
{ this set's the RGB intensities of COLOR }
Begin
   Port[$3c8] := Color;
   Port[$3c9] := R;
   Port[$3c9] := G;
   Port[$3c9] := B;
End;

Procedure Set_Ice_Color;assembler;
asm
{iCE Color is a means of disabling the BLINK attribute and using the upper
8 colors (#8/Dark Grey to #15/Bright White) as background colors.  This is
the default setup for all .ADF and ANSI/2 files.}
  mov bl,0000h
  mov ax,1003h
  int 10h
end;

Procedure Remove_Ice_Color;assembler;
asm
  mov bl,0001h
  mov ax,1003h
  int 10h
end;

Procedure Set_Character_Width;assembler;
{ by default the first 32 characters have an extra vertical scanline.  This
is realy unefficient when manipulating fonts, so this procedure sets all the
characters to an even 8x16 font}
asm
  mov     dx,03c4h
  mov     ax,0100h
  out     dx,ax

  mov     dx,03c4h
  mov     ax,0301h
  out     dx,ax

  mov     dx,03c2h
  mov     al,063h
  out     dx,al

  mov     dx,03c4h
  mov     ax,0300h
  out     dx,ax

  mov     dx,03d4h
  mov     ax,4f09h
  out     dx,ax
end;

procedure Set_Vga_Font;
{font_data is a 4096 byte array that contains the entire font data to be
passed to the interrupt}
begin
  regs.bx:=(16*256);{0x1000; {16 scanline font}
  regs.es:=seg(vga_font); {segment of the font data}
  regs.bp:=ofs(vga_font); {offset of the font data}
  regs.ax:=((17*256)+16); {0x1110; {int 10h subfunction}
  regs.cx:=256; {256 characters}
  regs.dx:=0; {start with char #0}
  Intr(16, Regs); {load actual data $10}
end;

procedure Set_Textmode;assembler;
asm
  mov ax,00003h  {reset to textmode}
  int 010h
end;

procedure cursor_on;assembler;
{ turn on the cursor }
asm
  mov    cx,$0708
  mov    ah,$01
  int    $10
end;

procedure cursor_off;assembler;
{ turn off the cursor }
asm
  mov    ch,$20
  mov    ah,$01
  int    $10
end;

begin
  if paramcount<>1 then begin
  writeln;
  writeln('ADF View format :  ADFVIEW <filename.ext>');halt;end;

  assign(f,paramstr(1));
  {$I-}reset(f,1);{$I+}
  if ioresult<>0 then begin writeln(paramstr(1),' doesnt exist');halt;end;
  max_lines:=(filesize(f)-4298) div 160; {calculate number of lines in picture}
  blockread(f,version,1);
  for count1:=0 to 63 do begin
  blockread(f,pallette[count1],3);
  end;
  blockread(f,vga_font[1],4096);
  writeln;
  writeln('Pascal ADF Viewer by Shivan Bastard');
  writeln('Filename : ',paramstr(1));
  writeln('Max Lines : ',max_lines);
  writeln('ADF Version : ',ord(version));readkey;

  For count1:=0 to 63 do
    GetPal(count1,old_pal[count1,1],old_pal[count1,2],old_pal[count1,3]);

  For count1:=0 to 63 do
    SetPal(count1,pallette[count1,1],pallette[count1,2],pallette[count1,3]);

  set_ice_color;
  set_character_width;
  set_vga_font;
  cursor_off;

  reset(f,1); {reset file to read 1 byte at a time}
  while exit_stat=0 do
  begin
    seek(f,pointer*160+4289); {pointer=line, 4289=header}
    blockread(f,vbuffer,4000); {read 4000 bytes of screen data}
    move(vbuffer,mem[$b800:0],4000); {copy data to video memory}
    key:=readkey;
    if key=#0 then ext:=readkey; {read the extended keys}
    if ext=#72 then pointer:=pointer-1; {up}
    if ext=#80 then pointer:=pointer+1; {down}
    if ext=#73 then pointer:=pointer-25; {pageup}
    if ext=#81 then pointer:=pointer+25; {pagedown}
    if ext=#71 then pointer:=0; {home}
    if ext=#79 then pointer:=max_lines; {end}
    if key=#27 then exit_stat:=1; {escape}
    if pointer > (max_lines-25) then pointer:=max_lines-25;
    {make sure you cant read past the end of the file}
    if pointer < 0 then pointer:=0;
    {make sure you dont display the header as part of the picture}
  end; {while}
  For count1:=0 to 63 do
  SetPal(count1,old_pal[count1,1],old_pal[count1,2],old_pal[count1,3]);
  fillchar(mem[$b800:0],4000,7);
  set_textmode;
  cursor_on;

end. {program}