// BinVU/3 - Written by:  HOOPTiE
// (c) 1996 Sector Logic

// INCLUDED FILES
	#include <conio.h>
	#include <stdio.h>
	#include <dir.h>
	#include <dos.h>
	#include <mem.h>
	#include <process.h>

	#define PALETTE_MASK         0x3c6
	#define PALETTE_REGISTER_RD  0x3c7
	#define PALETTE_REGISTER_WR  0x3c8
	#define PALETTE_DATA         0x3c9

// GLOBAL DATA
	char byte;				// byte to copy
	char fade_in;			// Fade in type
	char fade_out;			// Fade out type
	char size;		  		// Size of font (0=8, 1=16)
	char fontd[4096];		// Font Data
	char line[80];			// Line 25 string
	unsigned char far *text_buffer = (char far *)0xB8000000UL; 				// vram byte ptr to the text screen
	struct ffblk block;

	typedef struct rgb_color_typ	// This structure holds a RGB triple in three bytes
	{
	  unsigned char red;    	// red   component of color 0-63
	  unsigned char green;  	// green component of color 0-63
	  unsigned char blue;   	// blue  component of color 0-63
	} rgb_color, *rgb_color_ptr;

	rgb_color def[64];
	rgb_color fil[64];

void set8dot(void) {
  asm {
	  mov     dx,03c4h
	  mov     ax,0100h
	  out     dx,ax

	  mov     dx,03c4h
	  mov     ax,0301h
	  out     dx,ax

	  mov     dx,03c2h
	  mov     al,063h
	  out     dx,al

	  mov     dx,03c4h
	  mov     ax,0300h
	  out     dx,ax

	  mov     dx,03d4h
	  mov     ax,4f09h
	  out     dx,ax
  }
}

	// Turn on iCE Color
	void ice_color(void) {
		asm {
			mov bl,0000h
			mov ax,1003h
			int 10h
		}
	}


// SET THE VGA FONT
	void set_font() {
		struct REGPACK r;
			r.r_bx=0x1000;
			r.r_es = FP_SEG(fontd);
			r.r_bp = FP_OFF(fontd);
			r.r_ax = 0x1110;
			r.r_cx = 256;
			r.r_dx = 0;
			intr(0x10, &r);
	}

// Set a palette register
	void set_palette(int index, rgb_color color) {
		outp(PALETTE_MASK,0xff);
		outp(PALETTE_REGISTER_WR, index);

		outp(PALETTE_DATA,color.red);
		outp(PALETTE_DATA,color.green);
		outp(PALETTE_DATA,color.blue);
	}

// Get a palette register
	void get_palette (int index, rgb_color_ptr color)	{
		outp(PALETTE_MASK,0xff);
		outp(PALETTE_REGISTER_RD, index);

		color->red   = inp(PALETTE_DATA);
		color->green = inp(PALETTE_DATA);
		color->blue  = inp(PALETTE_DATA);
	}

// PALETTE TRANSFORMATION ROUTINE
	void fade_screen(int speed, rgb_color palette[256])
	{
		rgb_color color;  					// Current palette register
		int r_dir=0, g_dir=0, b_dir=0;	// RGB direction

		for (int fade=0; fade<(63/speed); fade++) {
			for (int index=0; index<64; index++) {
			// Read the palette register data
				get_palette(index,(rgb_color_ptr)&color);
				get_palette(index,(rgb_color_ptr)&color);

			// Set RGB directions
				r_dir=0; g_dir=0; b_dir=0;									// Assume no palette adjustment is necessary
				if (color.red<palette[index].red) r_dir=1;			// Adjust red brighter
				if (color.green<palette[index].green) g_dir=1;		// Adjust green brighter
				if (color.blue<palette[index].blue) b_dir=1;			// Adjust blue brighter
				if (color.red>palette[index].red) r_dir=-1;			// Adjust red dimmer
				if (color.green>palette[index].green) g_dir=-1;		// Adjust green dimmer
				if (color.blue>palette[index].blue) b_dir=-1;		// Adjust blue dimmer

			// Make any adjustments
				color.red+=speed*r_dir;
				color.green+=speed*g_dir;
				color.blue+=speed*b_dir;

			// Ensure data is within range
				if ((r_dir<0)&&(color.red<palette[index].red)) color.red=palette[index].red;
				if ((g_dir<0)&&(color.green<palette[index].green)) color.green=palette[index].green;
				if ((b_dir<0)&&(color.blue<palette[index].blue)) color.blue=palette[index].blue;
				if ((r_dir>0)&&(color.red>palette[index].red)) color.red=palette[index].red;
				if ((g_dir>0)&&(color.green>palette[index].green)) color.green=palette[index].green;
				if ((b_dir>0)&&(color.blue>palette[index].blue)) color.blue=palette[index].blue;

			// Set the new values
				set_palette(index,color);
			}
		}
		delay(50);
	}

// MAIN PROGRAM LOOP
	void main (int argc, char * argv[]) {
		FILE *exe;						// Binvu file handle
		long fend=0;					// First EOF marker pointer
		long top_data=4289;			// Top of the ANSI data
		long end_data=0;				// End of the ANSI data

		for (int x=0; x<64; x++) {	// Grab the palette
			get_palette (x,&def[x]);
			get_palette (x,&def[x]);
		}

		set8dot();
		ice_color();

		// Open the .EXE and position the pointer
			findfirst(argv[1],&block,0);		// Find the filename so size can be extracted
			end_data=block.ff_fsize;				// end of the data

			if ((exe=fopen(argv[1], "rb"))==NULL) {
				printf("\nERROR:  Could not open input file.\n"
						 "Usage:  ADFVIEW <FILENAME>\n\n"
						 "ADFView (ArtWorx Data Format) is a simple utility to view .ADF type files\n"
						 "from the DOS prompt.  Later implimentations of the .ADF and .AN2\n"
						 "specifications will be included in BBS Software, Terminal Programs, and\n"
						 "in a TSR ANSI driver simular to DGANSI or ZANSI.  If you have any questions\n"
						 "or comments about .ADF, .AN2, or ArtWorx, please conact HOOPTiE, the Author,\n"
						 "by sending e-mail to hooptie@cibola.net or calling the Sector Logic support\n"
						 "line at (915) 534-4449.\n\n"
						 "ADFView (c) 1996 Sector Logic - Superior Solutions.\n");
						 exit(1);
				}

		// Read the header
			size=fgetc(exe);
			fread(&fil[0], 192, 1, exe);
			fread(&fontd[0], 4096, 1, exe);


			for (int q=0; q<64; q++)		// Set the palette
				set_palette(q, fil[q]);

		// Update the font information
			set_font();

		//	Scroll the ANSI
			char key=0;				// key press
			char ext=0;				// exteneded key press
			int exit_status=0;	// goes high when ESC is pressed
			unsigned char buffer[4000];	// Screen buffer
			long pointer=4289;		// pointer to the top line being displayed
			int t=0;


			while (exit_status==0) {

			// Update the screen
				if (end_data-4289<4000) {
					t=0;
					fseek(exe, 4289, 0);
					memset(&buffer[0], 4000, 0);
					fread(&buffer[t], end_data-4289, 1, exe);
				} else {
					fseek(exe, pointer, 0);
					fread(&buffer[0], 4000, 1, exe);
				}
				puttext(1,1,80,25,buffer);

			// Wait for keypress
				ext=0;			// reset extended char
				key=getch();
				if (key==0) ext=getch();
				if (key==27) exit_status=1;
				if (ext=='H') pointer-=160;
				if (ext=='P') pointer+=160;
				if (ext==73) pointer-=4000;
				if (ext==81) pointer+=4000;
				if (ext==71) pointer=top_data;
				if (ext==79) pointer=end_data;

				if (pointer<top_data) pointer=top_data;
				if (pointer>end_data-4000) pointer=end_data-4000;
			}

			fclose(exe);
			textmode(C40);
			textmode(C80);
			printf("ADFView (c) 1996 Sector Logic - Superior Solutions.\n");
		}

