#ifndef __FILELISTC_H__
#define __FILELISTC_H__

namespace Import {
	class FileListC;
};

#include "PajaTypes.h"
#include "DataBlockI.h"
#include "EditableI.h"
#include "LayerC.h"
#include "EffectI.h"
#include "GizmoI.h"
#include "UndoC.h"
#include <vector>
#include "ImportableI.h"
#include "FileHandleC.h"
#include "FileIO.h"
#include "ImportInterfaceC.h"

namespace Import {

	//! File list class.
	/*! File list class manages the imported files. It checks for duplicates
		enables to load, reload, replace, and delete importable files.
		Changes made to file list are also undoable.
		This class is used internally.

		This class is implemented by the system.
	*/
	class FileListC : public Edit::EditableI
	{
	public:
		//! Create new file list.
		static FileListC*			create_new();
		//! Create new file list.
		virtual Edit::DataBlockI*	create();
		//! Creates new file list(used internally), see Edit::EditableI::create().
		virtual Edit::DataBlockI*	create( Edit::EditableI* pOriginal );
		//! Deep copy from a data block, see Edit::DataBlockI::copy().
		virtual void				copy( Edit::DataBlockI* pBlock );
		//! Shallow copy from a editable, see Edit::EditableI::restore().
		virtual void				restore( Edit::EditableI* pEditable );

		//! Loads a file and adds it to the list.
		virtual FileHandleC*		add_file( ImportableI* pImportable );
		//! Returns number of files in the list.
		virtual PajaTypes::uint32	get_file_count();

		//! Reloads a file already in the list.
		virtual void				reload_file( PajaTypes::uint32 ui32Index, ImportInterfaceC* pIface );
		//! Replaces a file inthe list with another file .
		virtual void				replace_file( PajaTypes::uint32 ui32Index, const char* szName, ImportInterfaceC* pIface );
		//! Returns the file at given index.
		virtual FileHandleC*		get_file( PajaTypes::uint32 ui32Index );
		//! Returns the file with given name.
		virtual FileHandleC*		get_file( const char* szName );
		//! Deletes the file at given index.
		virtual void				del_file( PajaTypes::uint32 ui32Index );

		// Serialize editable to a Demopaja output stream.
		virtual PajaTypes::uint32	save( FileIO::SaveC* pSave );
		// Serialize editable from a Demopaja input stream.
		virtual PajaTypes::uint32	load( FileIO::LoadC* pLoad );

	protected:
		//! Default constructor.
		FileListC();
		//! Default constructor with reference to the original.
		FileListC( Edit::EditableI* pOriginal );
		//! Default destructor.
		virtual ~FileListC();

	private:
		std::vector<FileHandleC*>	m_rFiles;

	};

}; // namespace

#endif // __FILELISTC_H__