//-------------------------------------------------------------------------
//
// File:		PajaPlayer.cpp
// Purpose:		Moppi Demopaja Player example
// Author:		memon <memon@inside.org>
// Version:		0.7
//
//-------------------------------------------------------------------------
//	Copyright (c) 2000-2002 Moppi Productions. All Rights Reserved.
//  This file is part of Moppi Demopaja SDK.
//  For conditions of distribution and use, see the accompanying license.txt file.
//  http://moppi.inside.org/demopaja/
//-------------------------------------------------------------------------

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include "res/resource.h"
#include "DemopajaPlayerC.h"
#include "FileIO.h"

#include "OpenGLDriver\OpenGlDriver.h"


using namespace PajaTypes;
using namespace FileIO;


// Globals.
bool		g_bFullscreen = false;
int32		g_i32Resolution = 3;


// Init dialog proc.
BOOL CALLBACK
InitDlgProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch( uMsg ) {

	case WM_INITDIALOG:
		{
			// set fullscreen as checked
			::CheckDlgButton( hwndDlg, IDC_CHECK, BST_CHECKED );

			// resolution display
			char	szItems[26][64] = {
					"640 x 480",
					"800 x 600",
					"960 x 720",
					"1024 x 768",
					"1152 x 648",
					"1280 x 720",
					"1280 x 800",
					"1280 x 960",
					"1280 x 1024",
					"1360 x 768",
					"1366 x 768",
					"1400 x 1050",
					"1440 x 900",
					"1440 x 1080",
					"1600 x 900",
					"1600 x 1200",
					"1680 x 1050",
					"1856 x 1392",
					"1920 x 1080",
					"1920 x 1200",
					"1920 x 1440",
					"2048 x 1536",
					"2560 x 1440",
					"2560 x 1600",
					"3840 x 2160",
					"7680 x 4320" };
			for( int32 i = 0; i < 26; i++ )
				SendDlgItemMessage( hwndDlg, IDC_COMBORESOLUTION, CB_INSERTSTRING, i, (LPARAM)(LPCTSTR)szItems[i] );

			// set default resolution
			SendDlgItemMessage( hwndDlg, IDC_COMBORESOLUTION, CB_SETCURSEL, g_i32Resolution, 0 );


			if( g_bFullscreen )
				EnableWindow( GetDlgItem( hwndDlg, IDC_COMBORESOLUTION ), FALSE );

			return TRUE;
		}
		break;

	case WM_COMMAND:
		{
			WORD	wNotifyCode = HIWORD(wParam);	// notification code 
			WORD	wID = LOWORD(wParam);			// item, control, or accelerator identifier 
			HWND	hwndCtl = (HWND)lParam;			// handle of control 

			if( wNotifyCode == BN_CLICKED ) {
				if( wID == IDC_CHECK ) {
					if( IsDlgButtonChecked( hwndDlg, IDC_CHECK ) == BST_CHECKED )
						EnableWindow( GetDlgItem( hwndDlg, IDC_COMBORESOLUTION ), TRUE );
					else
						EnableWindow( GetDlgItem( hwndDlg, IDC_COMBORESOLUTION ), FALSE );

				}
				else if( wID == IDOK ) {
					if( IsDlgButtonChecked( hwndDlg, IDC_CHECK ) == BST_CHECKED )
						g_bFullscreen = true;
					else
						g_bFullscreen = false;

					g_i32Resolution = SendDlgItemMessage( hwndDlg, IDC_COMBORESOLUTION, CB_GETCURSEL, 0, 0 );

					EndDialog( hwndDlg, IDOK );
				}
				else if( wID == IDCANCEL )
					EndDialog( hwndDlg, IDCANCEL );
			}
		}

	default:
		return FALSE;
		break;
	}
}
 

//
// Load Callback test
//
void	load_callback( float32 f32Percent )
{
	// nothing
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	// Show init dialog.
	if( DialogBox( hInstance, MAKEINTRESOURCE( IDD_INIT ), NULL, InitDlgProc ) != IDOK ) {
		return 0;
	}


	DemopajaPlayerC	rPlayer;

	// Init build-in plugins
	rPlayer.register_plugin( &g_rOpenGLDeviceDesc );

	// Load plugins from path.
	rPlayer.load_plugins( "plugins" );


	// Init demo system
	if( !rPlayer.init( hInstance, g_bFullscreen ) ) {
		OutputDebugString( "init failed\n" );
		return -1;
	}

	// set fullscreen mode, if no mode is set, default mode
	// mased on the demo resolution will be choosed.
	switch( g_i32Resolution ) {
	case 0: rPlayer.set_fullscreen_resolution( 640, 480 ); break;
	case 1: rPlayer.set_fullscreen_resolution( 800, 600 ); break;
	case 2: rPlayer.set_fullscreen_resolution( 960, 720 ); break;
	case 3: rPlayer.set_fullscreen_resolution( 1024, 768 ); break;
	case 4: rPlayer.set_fullscreen_resolution( 1152, 648 ); break;
	case 5: rPlayer.set_fullscreen_resolution( 1280, 720 ); break;
	case 6: rPlayer.set_fullscreen_resolution( 1280, 800 ); break;
	case 7: rPlayer.set_fullscreen_resolution( 1280, 960 ); break;
	case 8: rPlayer.set_fullscreen_resolution( 1280, 1024 ); break;
	case 9: rPlayer.set_fullscreen_resolution( 1360, 768 ); break;
	case 10: rPlayer.set_fullscreen_resolution( 1366, 768 ); break;
	case 11: rPlayer.set_fullscreen_resolution( 1400, 1050 ); break;
	case 12: rPlayer.set_fullscreen_resolution( 1440, 900 ); break;
	case 13: rPlayer.set_fullscreen_resolution( 1440, 1080 ); break;
	case 14: rPlayer.set_fullscreen_resolution( 1600, 900 ); break;
	case 15: rPlayer.set_fullscreen_resolution( 1600, 1200 ); break;
	case 16: rPlayer.set_fullscreen_resolution( 1680, 1050 ); break;
	case 17: rPlayer.set_fullscreen_resolution( 1856, 1392 ); break;
	case 18: rPlayer.set_fullscreen_resolution( 1920, 1080 ); break;
	case 19: rPlayer.set_fullscreen_resolution( 1920, 1200 ); break;
	case 20: rPlayer.set_fullscreen_resolution( 1920, 1440 ); break;
	case 21: rPlayer.set_fullscreen_resolution( 2048, 1536 ); break;
	case 22: rPlayer.set_fullscreen_resolution( 2560, 1440 ); break;
	case 23: rPlayer.set_fullscreen_resolution( 2560, 1600 ); break;
	case 24: rPlayer.set_fullscreen_resolution( 3840, 2160 ); break;
	case 25: rPlayer.set_fullscreen_resolution( 7680, 4320 ); break;
	}

/*

	Example to how to load demo data from resource.

	// Load the music from resource
	HRSRC	hMusicRes;
	HGLOBAL	hMusicMem;
	hMusicRes = FindResource( NULL, "music", "MP3" );
	hMusicMem = LoadResource( NULL, hMusicRes );
	uint8*	pMusicData = (uint8*)LockResource( hMusicMem );
	uint32	ui32MusicDataSize = SizeofResource( NULL, hMusicRes );

	rPlayer.set_music_data( pMusicData, ui32MusicDataSize );

	// Load demo from resource.
	HRSRC	hDemoRes;
	HGLOBAL	hDemoMem;
	hDemoRes = FindResource( NULL, "demo", "DMO" );
	hDemoMem = LoadResource( NULL, hDemoRes );
	uint8*	pDemoData = (uint8*)LockResource( hDemoMem );
	uint32	ui32DemoDataSize = SizeofResource( NULL, hDemoRes );

	// Load demo.
	if( rPlayer.load_demo( pDemoData, ui32DemoDataSize ) != IO_OK ) {
		MessageBox( NULL, "Failed to load file \"demo.dmo\"", "Load Error", MB_OK );
		return -1;
	}

	*/

	// Set load callback
	rPlayer.set_load_callback( load_callback );

	// Load demo
	if( rPlayer.load_demo( "demo.dmo" ) != IO_OK ) {
		MessageBox( NULL, "Failed to load file \"demo.dmo\"", "Load Error", MB_OK );
		return -1;
	}

	// hide cursor
	while( ShowCursor( FALSE ) > 0 ) {};

	// Run the demo.
	int iRes = rPlayer.run();

	// show cursor
	while( ShowCursor( TRUE ) < 0 ) {};

	return iRes;
}



