Unit Globals;

Interface

Type
  QuadrantType = Array[1..50,1..50,1..50] of byte;
  {There are going to be 8 quadrants set up in this fasion:
        ________
       |\  5 \ 6 \
       | \----\---\
       |5|\ __1\__2\
       |\|1|   |   |
       |7|\|  1|  2|            (yeah, so it sucks,
       \ | |---|---|             YOU try drawing a 3d
        \|3|   |   |             cube in ASCII characters)
          \|__3|__4|
  }
  ShipRec = Record     {The ships will have a table that sets all the non
    configurable info (such as weapons and speed), each ship will have
    two weapons (slightly like star control) where one is a set characteristic
    of each ship, and the other is a weapon that can be "bought" by the
    character when he is given a new ship or requests one.  Some ship ideas
    are: Scout, Cruiser, Destroyer, Dreadnought... BTW: EFT means "extracted
    from table"}
   ShipName,           {Name of the ship that the character has christened}
   ShipClass : String; {Ship class type, the basic name of the shiptype EFT}
   Weapon1,            {"Main" Weapon - never changes with each ship EFT}
   Weapon2 : WType;    {This weapon exhausts some of the MUs from the character}
   Speed,              {Varies on the ship, this is forward velocity EFT}
   Turning : Byte;     {This is turning thruster power (turning speed) EFT}
   Cargo,              {Maximum cargo capacity.  It is feasable that a scout
                        cannot possibly hold as much as, say, a colony ship.}
   Armor : Longint;    {Cargo and armor points can be modified w/ the use of
                        MUs, the Armor is, like, 5 mus per extra level and the
                        Cargo is more like 15 for every 50 extra cubic meters
                        of space EFT, but changable}
  end;

  CrewRec = Record     {The player selects from pregenerated crew, giving
   them an assignment in the ranks of the bridge crew of their vessel at
   the beginning, and uses them (barring that they don't get them killed)
   until the last mission.}
  Name : String;       {Name of the crew member}
  Rank : Byte;         {Always equal to or 2 less than the main character}
  Tech,                {these are the attributes that the crew holds,    }
  Weap,                {Tech for "scanning" planets, weapons for firing/ }
  Nav,                 {reloading weapon speeds (w/i ship restraints),   }
  Eng,                 {Nav for detecting nearby ships and figuring fuel }
  Comm : Word;         {requirements w/ accuracy, engineering for repair
                        speed and comm for (maybe) deciphering the alien
                        communications coming to the ship}
  end;
  UserRec = Record     {The player record will hold the saved position,
    items, ship information, crew information and statistics.  It will be
    the basic saved game format for the game.  This is what will be saved
    when the character selects "save a game" from whatever menu.  The first
    part of the file will be the user record, the last part of the file
    will be cargo information (using CargoRec)}
   Name : String[20];  {Name of "main" character}
   Rank : Byte;    {Rank, also denotes the "chapter" or "mission" that
    the player is on, the following are the ranks (in order):  Cadet, Ensign,
    Leiutenant, LtCommander, Commodore, Commander, Captain, Admiral,
    Commanding Admiral)}
   Exp,                {This is sort of the allotment of kills a player gets}
   MU : Longint;       {Monetary units, money - increases due to rank}
   Ship : ShipRec;     {Ship Record (See Above)}
   X, Y, Z : Byte;     {Location in the quadrants}
   Crew : Array[1..6] of CrewRec;
  end;
  CType = (Mineral, Artifact);
  CargoRec = Record
   Name : String;      {name for the item(s)}
   Amount : Real;      {Amount in cubic meters}
   Code : CType;       {This denotes what it is (artifact, mineral, ect)}
   Value : Longint;    {Value if "hawked"}
  end;


Implementation

End.
