;****************************************************************************;
;*                                                                          *;
;*   VRServer - Vertical Retrace Interrupt Server, v1.00                    *;
;*   ---------------------------------------------------                    *;
;*                                                                          *;
;* File:        VRSERVER.ASM                                                *;
;*                                                                          *;
;* Description: Main file                                                   *;
;*                                                                          *;
;* Compiler(s): TASM 3.1                                                    *;
;*                                                                          *;
;* by Petteri Kangaslampi 1993. NOT COPYRIGHTED, PUBLIC DOMAIN.             *;
;*                                                                          *;
;****************************************************************************;


IDEAL



IFDEF	_BC_

	MODEL	LARGE,C
	LANG	EQU	C

ELSE
IFDEF	_TP_

	MODEL	TPASCAL
	LANG	EQU	PASCAL

ELSE
	ERR	"You must define a language (/d_BC_ or /d_TP_)"
ENDIF
ENDIF





MACRO	WaitNextVR		; wait for NEXT Vertical Retrace
LOCAL	w1, w2

	mov	dx,03DAh
w1:	in	al,dx
	test	al,8
	jnz	w1

w2:	in	al,dx
	test	al,8
	jz	w2
ENDM





DATASEG



OldTmr	DD	?		; pointer to old timer interrupt
TmrVal	DW	?		; count to the timer chip
DOSTmrCnt DW	?		; count used in calling the old timer

PreVRFunct DD	?		; pointer to the routine to be called
				;  BEFORE the Vertical Retrace
VRFunct	DD	?		; routine to be called IN the VR




CODESEG



PUBLIC	InitVRServer, SyncVRServer, RemoveVRServer



PROC NOLANGUAGE	Timer		; the real timer routine

	sti				; enable ints

	push	ax
	push	bx
	push	cx
	push	dx
	push	si			; save normal 8086 registers
	push	di
	push	bp
	push	ds
	push	es

	mov	al,20h			; send End Of Interrupt signal
	out	20h,al


	mov	dx,@data		; point DS to proper data segment
	mov	ds,dx


	mov	dx,03DAh
@@wnvr:	in	al,dx
	test	al,8
	jnz	@@wnvr

	call	[dword PreVRFunct]


	mov	bx,[TmrVal]		; timer count

	mov	dx,03DAh
@@wvr:	in	al,dx
	test	al,8
	jz	@@wvr

	mov	al,36h
	out	43h,al
	mov	al,bl
	out	40h,al			; set timer count and restart timer
	mov	al,bh
	out	40h,al


	call	[dword VRFunct]


	clc

	mov	ax,[TmrVal]
	add	[DOSTmrCnt],ax		; add
	jnc	@@noDOSTmr

	pushf
	call	[dword OldTmr]		; call old timer

@@noDOSTmr:
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si			; restore saved registers
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	iret
ENDP




PROC	InitVRServer	FAR	PPreVRFunct : DWORD, PVRFunct : DWORD
USES	ds,si,di

	push	ds

	mov	ax,3508h		; get old interrupt 8 vector
	int	21h

	mov	[word OldTmr],bx	; and save it
	mov	[word OldTmr+2],es

	mov	ax,seg Timer
	mov	ds,ax
	mov	dx,offset Timer		; set new timer int
	mov	ax,2508h
	int	21h

	pop	ds

	mov	ax,[word PPreVRFunct]
	mov	[word PreVRFunct],ax
	mov	ax,[word PPreVRFunct+2]
	mov	[word PreVRFunct+2],ax

	mov	ax,[word PVRFunct]
	mov	[word VRFunct],ax
	mov	ax,[word PVRFunct+2]
	mov	[word VRFunct+2],ax

	call	SyncVRServer LANG

	ret
ENDP




PROC	SyncVRServer	FAR


	cli

@@read:
	WaitNextVR			; wait for next Vertical Retrace

	mov	al,36h
	out	43h,al
	xor	al,al			; reset timer
	out	40h,al
	out	40h,al


	WaitNextVR

	xor	al,al
	out	43h,al
	in	al,40h
	mov	ah,al
	in	al,40h			; read timer count - time between
	xchg	al,ah			;  two VRs
	neg	ax
	mov	[TmrVal],ax


	WaitNextVR

	mov	al,36h
	out	43h,al
	xor	al,al			; reset timer again
	out	40h,al
	out	40h,al


	WaitNextVR


	xor	al,al
	out	43h,al
	in	al,40h
	mov	ah,al
	in	al,40h			; and read the timer count
	xchg	al,ah
	neg	ax

	mov	dx,ax

	sub	dx,[TmrVal]
	cmp	dx,2			; if there was too big difference
	jg	@@read			;  between the two values read,
	cmp	dx,-2			;  read again
	jl	@@read

	mov	bx,975			; the delay between two timer ints
	mul	bx			;  is 97.5% of the time between two
	mov	bx,1000			;  VRs
	div	bx

	shr	ax,1
	mov	[TmrVal],ax

	mov	bx,[TmrVal]

	WaitNextVR

	mov	al,36h
	out	43h,al
	mov	al,bl			; restart timer with the new speed
	out	40h,al
	mov	al,bh
	out	40h,al

	mov	[DOSTmrCnt],0		; count used in calling the old timer

	mov	al,20h			; send EOI
	out	20h,al

	sti				; enable ints


	ret
ENDP



PROC	RemoveVRServer	FAR
USES	ds,si,di

	cli				; disable ints

	mov	al,36h
	out	43h,al
	mov	al,0FFh			; set timer frequency to about 18.2Hz
	out	40h,al			;  (DOS default)
	out	40h,al

	mov	ax,2508h
	mov	dx,[word OldTmr]	; restore old timer int
	mov	ds,[word OldTmr+2]
	int	21h

	mov	al,20h			; send EOI
	out	20h,al

	mov	al,36h
	out	43h,al
	mov	al,0FFh			; set timer frequency to about 18.2Hz
	out	40h,al			;  (DOS default)
	out	40h,al

	sti				; enable ints

	ret
ENDP




END