;Tube DEMO.  btf
;Compiled with spASM
;Linking takes an eternity...
;REMEMBER TO EPATCH DATA!

		.model small
		.386
		.dosseg
		.stack  256

		.data
pal             db      "pal"
		db      (786-3) dup (1)
screen2         db      64000 dup (0)
txt             db      "btf 20.1.1995                   Texture Tube, copyright (c) by Alex Allmont 1995"
		db      "If you found this demo really boring then try using the cursor keys :)",10,10,13
		db      "aallmont@plym.ac.uk",10,10,13,"$"
off             dw      0

		.fardata f1
image           db      "calvin"
		db      (65535-6) dup (0)

		.fardata f2
tube_x          db      "tubex"
		db      (64000-5) dup (0)

		.fardata f3
tube_y          db      "tubey"
		db      (64000-5) dup (0)

		.code
		.startup

;Enable keyboard
		in   al, 21h
		or   al, 2
		out  21h,al

;VGA
		mov  ax, 13h
		int  10h

;SEG for pal
		mov  ax, SEG pal
		mov  ds, ax
			 
;Do palette
		call waitv
		xor  si, si
		xor  al, al
		mov  dx, 3c8h
		out  dx, al
		inc  dx  
		mov  cx, 768
lpal:           mov  al, pal[si]
		out  dx, al
		inc  si
		loop lpal

;Do segments
		mov  ax, SEG screen2
		mov  ds, ax
		mov  ax, SEG tube_x
		mov  fs, ax
		mov  ax, SEG tube_y
		mov  gs, ax


;****** Main loop

		xor  dx, dx
main:           mov  ax, SEG image
		mov  es, ax
		mov  cx, 320*120
		mov  si, 320*40
@@:             mov  bh, fs:tube_x[si]
		mov  bl, gs:tube_y[si]

		.if  (bl == 0) && (bh == 0)
			xor  al, al
		.else   
			add  bx, dx
			mov  al, es:image[bx]
			sub  bx, dx
;get fade with distance
			mov  bl, al
			and  al, 11110000b
			.if  al != 0
				and  bl, 15
				shr  bh, 4
				sub  bl, bh
				.if  bl > 128
					xor  bl, bl
				.endif
				add  al, bl
			.else
				xor  al, al
			.endif
		.endif

		mov  screen2[si], al
		inc  si
		loop @b

;Video SEG
		call waitv
		mov  ax, 0a000h
		mov  es, ax

;Fast video copy (dword)
		mov  cx, 320*40
		mov  di, 320*10
		lea  si, screen2
		add  si, 320*10
rep             movsd

;Scroll
		add  dx, off
		     
;Get keypress-es
		in   al, 60h

		cmp  al, 48h
		jne  @f
		add  off, 256
@@:             cmp  al, 50h
		jne  @f
		sub  off, 256
@@:             cmp  al, 4bh
		jne  @f
		inc  off
@@:             cmp  al, 4dh
		jne  @f
		dec  off
@@:             cmp  al, 1
		jne  main

;DOS mode
		mov  ax, 03h
		int  10h

;End drivel
		mov  ax, SEG txt
		mov  ds, ax
		mov  ah, 09h
		lea  dx, txt
		int  21h

;Disable keyboard
		in   al, 21h
		and  al, NOT 2
		out  21h,al

		.exit           


;wait for vertical sync
waitv           PROC      NEAR
		push ax
		push dx
		mov  dx, 3dah
wv1:            in   al, dx
		test al, 8
		jnz  wv1
wv2:            in   al, dx
		test al, 8
		jz   wv2
		pop  dx
		pop  ax
		ret
waitv           ENDP

		END
