/**************************************

	Split by Unknown Productions 2001
	
	Using SceneFactory 0.3

 **************************************/

#include <windows.h>
#include <stdio.h>


#include "SceneFactory/Demo.h"

#include "scenes/scnHelix.h"
#include "scenes/scnFlares.h"
#include "scenes/scnTunnel.h"
#include "scenes/scnLightball.h"
#include "scenes/scnCredits.h"
#include "scenes/scnDeformMesh.h"

#include "resource.h"


#define NEW_SCENE(t, n) t *n=new t


int WINAPI WinMain(	HINSTANCE	hInstance,
					HINSTANCE	hPrevInstance,
					LPSTR		lpCmdLine,
					int			nCmdShow)
{
  
  // Declare new scenes
  TScnHelix      *scnHelix=new TScnHelix;
  TScnFlares     *scnFlares=new TScnFlares;
  TScnTunnel     *scnTunnel=new TScnTunnel;
  TScnLightball  *scnLightball=new TScnLightball;
  TScnCredits    *scnCredits=new TScnCredits;
  TScnDeformMesh *scnDeformMesh=new TScnDeformMesh;
  

  // Create a Demo
  TDemo demo("Split - Xplanada 2001", 640, 480, 32, false);
  
	// Add music
  /******* You can use either ways to include music, either via datafile or via resources ***/
	//demo.setMusic("data/music/jaz.mo3", TMODTYPE_MODULE);
  //demo.setMusic((char *)MUSIC, TMODTYPE_MODULE); // We use this one in Split, make a Resource in RCData and you're done

  // Adds scenes to it   

  // scenes/scnTunnel.cpp - First tunnel
  demo.addScene(scnTunnel,     0,     65000);    
  // scenes/scnHelix.cpp - The "Unknown Productions Logo"
  demo.addScene(scnHelix,      13000, 45000);  
  // scenes/scnLightball.cpp - The 4 rotating balls
  demo.addScene(scnLightball,  65000, 134000);  
  // scenes/scnCredits.cpp - The credits over the LightBalls
  demo.addScene(scnCredits,    65000, 120000);  
  // scenes/scnFlares.cpp - The flares over the tunnel
  demo.addScene(scnFlares,     39500, 70000);
  // scenes/scnDeformMesh.cpp - Greetings and stuff
  demo.addScene(scnDeformMesh, 134000, 155000);  

  // Run the demo from millisecond 0 - you can change the value
  int result = demo.run(0);

  // Finish up
  demo.free();
  
  return result;

}
